/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.spark.job;

import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.cube.CubeInstance;
import org.apache.kylin.engine.spark.job.FilterRecommendCuboidJob;
import org.apache.kylin.engine.spark.job.JobStepType;
import org.apache.kylin.engine.spark.job.NResourceDetectStep;
import org.apache.kylin.engine.spark.job.NSparkCubingStep;
import org.apache.kylin.engine.spark.job.NSparkExecutable;
import org.apache.kylin.engine.spark.job.NSparkLocalStep;
import org.apache.kylin.engine.spark.job.NSparkMergeStatisticsStep;
import org.apache.kylin.engine.spark.job.NSparkMergingStep;
import org.apache.kylin.engine.spark.job.NSparkOptimizingStep;
import org.apache.kylin.engine.spark.job.NSparkUpdateMetaAndCleanupAfterMergeStep;
import org.apache.kylin.engine.spark.job.OptimizeBuildJob;
import org.apache.kylin.job.execution.DefaultChainedExecutable;

public class JobStepFactory {
    private JobStepFactory() {
    }

    public static NSparkExecutable addStep(DefaultChainedExecutable parent, JobStepType type, CubeInstance cube) {
        NSparkExecutable step;
        KylinConfig config = cube.getConfig();
        switch (type) {
            case RESOURCE_DETECT: {
                step = new NResourceDetectStep(parent);
                break;
            }
            case CUBING: {
                step = new NSparkCubingStep(config.getSparkBuildClassName());
                break;
            }
            case MERGING: {
                step = new NSparkMergingStep(config.getSparkMergeClassName());
                break;
            }
            case OPTIMIZING: {
                step = new NSparkOptimizingStep(OptimizeBuildJob.class.getName());
                break;
            }
            case MERGE_STATISTICS: {
                step = new NSparkMergeStatisticsStep();
                break;
            }
            case CLEAN_UP_AFTER_MERGE: {
                step = new NSparkUpdateMetaAndCleanupAfterMergeStep();
                break;
            }
            case FILTER_RECOMMEND_CUBOID: {
                step = new NSparkLocalStep();
                step.setSparkSubmitClassName(FilterRecommendCuboidJob.class.getName());
                step.setName("Filter Recommend Cuboid Data for Optimization");
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        step.setParams(parent.getParams());
        step.setProject(parent.getProject());
        step.setTargetSubject(parent.getTargetSubject());
        parent.addTask(step);
        step.setDistMetaUrl(config.getJobTmpMetaStoreUrl(parent.getProject(), step.getId()));
        return step;
    }
}

