/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.spark.job;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.yarn.api.records.ApplicationReport;
import org.apache.hadoop.yarn.api.records.YarnApplicationState;
import org.apache.hadoop.yarn.client.api.YarnClient;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.KylinConfigExt;
import org.apache.kylin.common.StorageURL;
import org.apache.kylin.common.util.ClassUtil;
import org.apache.kylin.common.util.CliCommandExecutor;
import org.apache.kylin.common.util.HadoopUtil;
import org.apache.kylin.common.util.JsonUtil;
import org.apache.kylin.common.util.ParameterFilter;
import org.apache.kylin.cube.CubeInstance;
import org.apache.kylin.cube.CubeManager;
import org.apache.kylin.engine.spark.job.NSparkLocalStep;
import org.apache.kylin.engine.spark.utils.MetaDumpUtil;
import org.apache.kylin.job.common.PatternedLogger;
import org.apache.kylin.job.exception.ExecuteException;
import org.apache.kylin.job.execution.AbstractExecutable;
import org.apache.kylin.job.execution.ExecutableContext;
import org.apache.kylin.job.execution.ExecuteResult;
import org.apache.kylin.shaded.com.google.common.base.Preconditions;
import org.apache.kylin.shaded.com.google.common.collect.Maps;
import org.apache.kylin.shaded.com.google.common.collect.Sets;
import org.apache.kylin.tool.shaded.org.apache.commons.lang.StringUtils;
import org.apache.spark.deploy.SparkApplicationClient;
import org.apache.spark.utils.SparkVersionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NSparkExecutable
extends AbstractExecutable {
    private static final Logger logger = LoggerFactory.getLogger(NSparkExecutable.class);
    protected static final String SPARK_MASTER = "spark.master";
    protected static final String DEPLOY_MODE = "spark.submit.deployMode";
    private static final String APP_JAR_NAME = "__app__.jar";
    private volatile boolean isYarnCluster = false;
    private volatile boolean isStandaloneCluster = false;

    protected void setSparkSubmitClassName(String className) {
        this.setParam("className", className);
    }

    public String getSparkSubmitClassName() {
        return this.getParam("className");
    }

    public String getJars() {
        return this.getParam("jars");
    }

    protected void setDistMetaUrl(StorageURL storageURL) {
        HashMap<String, String> stringStringHashMap = Maps.newHashMap(storageURL.getAllParameters());
        StorageURL copy = storageURL.copy(stringStringHashMap);
        this.setParam("distMetaUrl", copy.toString());
    }

    public String getDistMetaUrl() {
        return this.getParam("distMetaUrl");
    }

    @Override
    protected ExecuteResult doWork(ExecutableContext context) throws ExecuteException {
        String sparkHome;
        KylinConfig config = context.getConfig();
        this.setLogPath(this.getSparkDriverLogHdfsPath(config));
        if (this.getCubeName() != null) {
            CubeManager cubeMgr = CubeManager.getInstance(KylinConfig.getInstanceFromEnv());
            CubeInstance cube = cubeMgr.getCube(this.getCubeName());
            config = cube.getConfig();
            HashMap<String, String> overrideKylinProps = new HashMap<String, String>();
            LinkedHashMap<String, String> cubeConfig = cube.getDescriptor().getOverrideKylinProps();
            LinkedHashMap<String, String> projectConfig = cube.getProjectInstance().getOverrideKylinProps();
            overrideKylinProps.putAll(projectConfig);
            overrideKylinProps.putAll(cubeConfig);
            for (Map.Entry configEntry : overrideKylinProps.entrySet()) {
                ParameterFilter.checkSparkConf((String)configEntry.getKey());
                ParameterFilter.checkSparkConf((String)configEntry.getValue());
            }
            config = this.wrapConfig(config);
        }
        if (StringUtils.isEmpty(sparkHome = KylinConfig.getSparkHome()) && !config.isUTEnv()) {
            throw new RuntimeException("Missing spark home");
        }
        String kylinJobJar = config.getKylinParquetJobJarPath();
        if (!config.isUTEnv() && StringUtils.isEmpty(kylinJobJar) && !config.isUTEnv()) {
            throw new RuntimeException("Missing kylin parquet job jar");
        }
        String hadoopConf = System.getProperty("kylin.hadoop.conf.dir");
        logger.info("write hadoop conf is {} ", (Object)config.getBuildConf());
        if (!config.getBuildConf().isEmpty()) {
            logger.info("write hadoop conf is {} ", (Object)config.getBuildConf());
            hadoopConf = config.getBuildConf();
        }
        if (StringUtils.isEmpty(hadoopConf) && !config.isUTEnv() && !config.isZKLocal()) {
            throw new RuntimeException("kylin_hadoop_conf_dir is empty, check if there's error in the output of 'kylin.sh start'");
        }
        File hiveConfFile = new File(hadoopConf, "hive-site.xml");
        if (!(hiveConfFile.exists() || config.isUTEnv() || config.isZKLocal())) {
            throw new RuntimeException("Cannot find hive-site.xml in kylin_hadoop_conf_dir: " + hadoopConf + ". In order to enable spark cubing, you must set kylin.env.hadoop-conf-dir to a dir which contains at least core-site.xml, hdfs-site.xml, hive-site.xml, mapred-site.xml, yarn-site.xml");
        }
        String jars = this.getJars();
        if (StringUtils.isEmpty(jars)) {
            jars = kylinJobJar;
        }
        this.deleteJobTmpDirectoryOnExists();
        this.onExecuteStart(context);
        try {
            this.attachMetadataAndKylinProps(config);
        }
        catch (IOException e) {
            throw new ExecuteException("meta dump failed", e);
        }
        String filePath = this.dumpArgs();
        if (config.isUTEnv() || config.isLocalEnv() || config.isZKLocal()) {
            return this.runLocalMode(filePath, config);
        }
        logger.info("Task id: {}", (Object)this.getId());
        if ("yarn".equals(config.getSparkEngineConfigOverrideWithSpecificName(SPARK_MASTER))) {
            logger.info("Try to kill orphan application on yarn.");
            this.killOrphanApplicationIfExists(config, this.getId());
        }
        return this.runSparkSubmit(config, hadoopConf, jars, kylinJobJar, "-className " + this.getSparkSubmitClassName() + " " + filePath, this.getParent().getId());
    }

    void attachMetadataAndKylinProps(KylinConfig config) throws IOException {
        Set<String> dumpList = this.getMetadataDumpList(config);
        MetaDumpUtil.dumpAndUploadKylinPropsAndMetadata(dumpList, config, this.getDistMetaUrl());
    }

    String dumpArgs() throws ExecuteException {
        File tmpDir = null;
        try {
            String pathName = this.getId() + "_" + "jobId";
            Path tgtPath = new Path(this.getConfig().getJobTmpDir(this.getParams().get("project")), pathName);
            FileSystem fileSystem = FileSystem.get((URI)tgtPath.toUri(), (Configuration)HadoopUtil.getCurrentConfiguration());
            try (BufferedOutputStream outputStream = new BufferedOutputStream((OutputStream)fileSystem.create(tgtPath));){
                outputStream.write(JsonUtil.writeValueAsBytes(this.getParams()));
            }
            logger.info("Spark job args json is : {}.", (Object)JsonUtil.writeValueAsString(this.getParams()));
            return tgtPath.toUri().toString();
        }
        catch (IOException e) {
            if (tmpDir != null && tmpDir.exists()) {
                try {
                    Files.delete(tmpDir.toPath());
                }
                catch (IOException e1) {
                    throw new ExecuteException("Write cuboidLayoutIds failed: Error for delete file " + tmpDir.getPath(), e1);
                }
            }
            throw new ExecuteException("Write cuboidLayoutIds failed: ", e);
        }
    }

    public String getSparkDriverLogHdfsPath(KylinConfig config) {
        return String.format(Locale.ROOT, "%s.%s.log", config.getJobOutputStorePath(this.getParam("project"), this.getId()), System.currentTimeMillis());
    }

    protected KylinConfig wrapConfig(ExecutableContext context) {
        return this.wrapConfig(context.getConfig());
    }

    protected KylinConfig wrapConfig(KylinConfig originalConfig) {
        String project = this.getParam("project");
        Preconditions.checkState(StringUtils.isNotBlank(project), "job " + this.getId() + " project info is empty");
        HashMap<String, String> jobOverrides = new HashMap<String, String>();
        String parentId = this.getParentId();
        jobOverrides.put("job.id", StringUtils.defaultIfBlank(parentId, this.getId()));
        jobOverrides.put("job.project", project);
        if (StringUtils.isNotBlank(parentId)) {
            jobOverrides.put("job.stepId", this.getId());
        }
        jobOverrides.put("user.timezone", KylinConfig.getInstanceFromEnv().getTimeZone());
        jobOverrides.put("hdfs.working.dir", KylinConfig.getInstanceFromEnv().getHdfsWorkingDirectory());
        jobOverrides.put("spark.driver.log4j.appender.hdfs.File", Objects.isNull(this.getLogPath()) ? "null" : this.getLogPath());
        return KylinConfigExt.createInstance(originalConfig, jobOverrides);
    }

    private void killOrphanApplicationIfExists(KylinConfig config, String jobId) {
        PatternedLogger patternedLogger = new PatternedLogger(logger);
        String orphanApplicationId = null;
        try (YarnClient yarnClient = YarnClient.createYarnClient();){
            YarnConfiguration yarnConfiguration = new YarnConfiguration();
            yarnConfiguration.set("yarn.timeline-service.enabled", "false");
            yarnClient.init((Configuration)yarnConfiguration);
            yarnClient.start();
            HashSet<String> types = Sets.newHashSet("SPARK");
            EnumSet<YarnApplicationState> states = EnumSet.of(YarnApplicationState.NEW, YarnApplicationState.NEW_SAVING, YarnApplicationState.SUBMITTED, YarnApplicationState.ACCEPTED, YarnApplicationState.RUNNING);
            List applicationReports = yarnClient.getApplications(types, states);
            if (CollectionUtils.isEmpty((Collection)applicationReports)) {
                return;
            }
            for (ApplicationReport report : applicationReports) {
                if (!report.getName().equalsIgnoreCase("job_step_" + this.getId())) continue;
                orphanApplicationId = report.getApplicationId().toString();
                String killApplicationCmd = "yarn application -kill " + orphanApplicationId;
                config.getCliCommandExecutor().execute(killApplicationCmd, patternedLogger, jobId);
            }
        }
        catch (IOException | YarnException ex2) {
            logger.error("get yarn application failed");
        }
    }

    private ExecuteResult runSparkSubmit(KylinConfig config, String hadoopConf, String jars, String kylinJobJar, String appArgs, String jobId) {
        PatternedLogger patternedLogger = config.isJobLogPrintEnabled() ? new PatternedLogger(logger) : new PatternedLogger(null);
        try {
            String cmd = this.generateSparkCmd(config, hadoopConf, jars, kylinJobJar, appArgs);
            CliCommandExecutor exec = new CliCommandExecutor();
            exec.execute(cmd, patternedLogger, jobId);
            if (this.isStandaloneCluster) {
                SparkApplicationClient.awaitAndCheckAppState(SparkApplicationClient.STANDALONE_CLUSTER(), jobId);
            }
            this.updateMetaAfterOperation(config);
            this.getManager().addJobInfo(this.getId(), this.getJobMetricsInfo(config));
            Map<String, String> extraInfo = this.makeExtraInfo(patternedLogger.getInfo());
            ExecuteResult ret = ExecuteResult.createSucceed(patternedLogger.getBufferedLog());
            ret.getExtraInfo().putAll(extraInfo);
            return ret;
        }
        catch (Exception e) {
            return ExecuteResult.createError(e);
        }
    }

    protected void updateMetaAfterOperation(KylinConfig config) throws IOException {
    }

    protected Map<String, String> getJobMetricsInfo(KylinConfig config) {
        return Maps.newHashMap();
    }

    protected Map<String, String> getSparkConfigOverride(KylinConfig config) {
        Map<String, String> sparkConfigOverride = config.getSparkConfigOverride();
        if ("yarn".equals(sparkConfigOverride.get(SPARK_MASTER)) && "cluster".equals(sparkConfigOverride.get(DEPLOY_MODE)) && !(this instanceof NSparkLocalStep)) {
            this.isYarnCluster = true;
        }
        if (sparkConfigOverride.get(SPARK_MASTER).toLowerCase(Locale.ROOT).startsWith("spark") && "cluster".equals(sparkConfigOverride.get(DEPLOY_MODE)) && !(this instanceof NSparkLocalStep)) {
            this.isStandaloneCluster = true;
        }
        if (!sparkConfigOverride.containsKey("spark.driver.memory")) {
            sparkConfigOverride.put("spark.driver.memory", this.computeStepDriverMemory() + "m");
        }
        if (UserGroupInformation.isSecurityEnabled()) {
            sparkConfigOverride.put("spark.hadoop.hive.metastore.sasl.enabled", "true");
        }
        if (SparkVersionUtils.isLessThanSparkVersion("2.4", true)) {
            sparkConfigOverride.put("spark.sql.adaptive.enabled", "false");
        }
        this.replaceSparkNodeJavaOpsConfIfNeeded(config, sparkConfigOverride);
        return sparkConfigOverride;
    }

    private void replaceSparkNodeJavaOpsConfIfNeeded(KylinConfig config, Map<String, String> sparkConfigOverride) {
        Map<String, String> extendedOverrides;
        String sparkDriverExtraJavaOptionsKey = "spark.driver.extraJavaOptions";
        StringBuilder sb = new StringBuilder();
        if (sparkConfigOverride.containsKey(sparkDriverExtraJavaOptionsKey)) {
            sb.append(sparkConfigOverride.get(sparkDriverExtraJavaOptionsKey));
        }
        String serverAddress = config.getServerRestAddress();
        String hdfsWorkingDir = config.getHdfsWorkingDirectory();
        String sparkDriverHdfsLogPath = null;
        if (config instanceof KylinConfigExt && Objects.nonNull(extendedOverrides = ((KylinConfigExt)config).getExtendedOverrides())) {
            sparkDriverHdfsLogPath = extendedOverrides.get("spark.driver.log4j.appender.hdfs.File");
        }
        this.wrapLog4jConf(sb, config);
        sb.append(String.format(Locale.ROOT, " -Dkylin.kerberos.enabled=%s ", config.isKerberosEnabled()));
        if (config.isKerberosEnabled().booleanValue()) {
            sb.append(String.format(Locale.ROOT, " -Dkylin.kerberos.principal=%s ", config.getKerberosPrincipal()));
            sb.append(String.format(Locale.ROOT, " -Dkylin.kerberos.keytab=%s", config.getKerberosKeytabPath()));
            if (config.getPlatformZKEnable().booleanValue()) {
                sb.append(String.format(Locale.ROOT, " -Djava.security.auth.login.config=%s", config.getKerberosJaasConfPath()));
                sb.append(String.format(Locale.ROOT, " -Djava.security.krb5.conf=%s", config.getKerberosKrb5ConfPath()));
            }
        }
        sb.append(String.format(Locale.ROOT, " -Dkylin.hdfs.working.dir=%s ", hdfsWorkingDir));
        sb.append(String.format(Locale.ROOT, " -Dspark.driver.log4j.appender.hdfs.File=%s ", sparkDriverHdfsLogPath));
        sb.append(String.format(Locale.ROOT, " -Dlog4j.debug=%s ", "true"));
        sb.append(String.format(Locale.ROOT, " -Dspark.driver.rest.server.address=%s ", serverAddress));
        sb.append(String.format(Locale.ROOT, " -Dspark.driver.param.taskId=%s ", this.getId()));
        sb.append(String.format(Locale.ROOT, " -Dspark.driver.local.logDir=%s ", config.getKylinLogDir() + "/spark"));
        sparkConfigOverride.put(sparkDriverExtraJavaOptionsKey, sb.toString());
    }

    protected String generateSparkCmd(KylinConfig config, String hadoopConf, String jars, String kylinJobJar, String appArgs) {
        StringBuilder sb = new StringBuilder();
        String sparkSubmitCmd = KylinConfig.getSparkHome() + "/bin/spark-submit";
        sb.append("export HADOOP_CONF_DIR=%s && %s --class org.apache.kylin.engine.spark.application.SparkEntry ");
        Map<String, String> sparkConfs = this.getSparkConfigOverride(config);
        for (Map.Entry<String, String> entry : sparkConfs.entrySet()) {
            this.appendSparkConf(sb, entry.getKey(), entry.getValue());
        }
        if (!this.isLocalMaster(sparkConfs)) {
            this.appendSparkConf(sb, "spark.executor.extraClassPath", Paths.get(kylinJobJar, new String[0]).getFileName().toString());
        }
        String extraClassPath = sparkConfs.getOrDefault("spark.driver.extraClassPath", "");
        String parquetJarPath = this.isYarnCluster ? String.format(Locale.ROOT, "%s:%s", APP_JAR_NAME, Paths.get(kylinJobJar, new String[0]).getFileName().toString()) : kylinJobJar;
        extraClassPath = extraClassPath.equals("") ? parquetJarPath : String.format(Locale.ROOT, "%s:%s", parquetJarPath, extraClassPath);
        this.appendSparkConf(sb, "spark.driver.extraClassPath", extraClassPath);
        String sparkUploadFiles = config.sparkUploadFiles(this.isLocalMaster(sparkConfs), this.isYarnCluster);
        if (StringUtils.isNotBlank(sparkUploadFiles)) {
            sb.append("--files ").append(sparkUploadFiles).append(" ");
        }
        if (config.isKerberosEnabled().booleanValue()) {
            sb.append("--principal ").append(config.getKerberosPrincipal()).append(" ");
            sb.append("--keytab ").append(config.getKerberosKeytabPath()).append(" ");
        }
        if (this.isYarnCluster) {
            String aliasedJar = String.format(Locale.ROOT, "%s#%s", kylinJobJar, Paths.get(kylinJobJar, new String[0]).getFileName().toString());
            jars = StringUtils.isBlank(jars) || jars.equals(kylinJobJar) ? aliasedJar : (jars.contains(kylinJobJar) ? jars.replace(kylinJobJar, aliasedJar) : String.format(Locale.ROOT, "%s,%s", jars, aliasedJar));
        }
        sb.append("--name job_step_%s ");
        sb.append("--jars %s %s %s");
        String cmd = String.format(Locale.ROOT, sb.toString(), hadoopConf, sparkSubmitCmd, this.getId(), jars, kylinJobJar, appArgs);
        logger.info("spark submit cmd: {}", (Object)cmd);
        return cmd;
    }

    private void wrapLog4jConf(StringBuilder sb, KylinConfig config) {
        if (config.isDefaultLogSparkDriverProperties()) {
            logger.info("Current using default log4j properties for spark driver in using `ConsoleAppender`.Please modify `kylin.spark.driver.log4j.properties` to be `spark-driver-log4j.properties`for uploading log file to hdfs.");
        }
        if (config.isDefaultLogSparkExecutorProperties()) {
            logger.info("Current using default log4j properties for spark executor in using `ConsoleAppender`.Please modify `kylin.spark.executor.log4j.properties` to be `spark-executor-log4j.properties`for uploading log file to hdfs.");
        }
        String localLog4j = config.getLogSparkDriverPropertiesFile();
        String log4jName = Paths.get(localLog4j, new String[0]).getFileName().toString();
        if (this.isYarnCluster) {
            sb.append(String.format(Locale.ROOT, " -Dlog4j.configuration=%s ", log4jName));
        } else {
            sb.append(String.format(Locale.ROOT, " -Dlog4j.configuration=file:%s ", localLog4j));
        }
    }

    protected void appendSparkConf(StringBuilder sb, String key, String value) {
        sb.append(" --conf '").append(key).append("=").append(value.trim()).append("' ");
    }

    private ExecuteResult runLocalMode(String appArgs, KylinConfig config) {
        try {
            Class<Object> appClz = ClassUtil.forName(this.getSparkSubmitClassName(), Object.class);
            appClz.getMethod("main", String[].class).invoke(null, new Object[]{new String[]{appArgs}});
            this.updateMetaAfterOperation(config);
            this.getManager().addJobInfo(this.getId(), this.getJobMetricsInfo(config));
            return ExecuteResult.createSucceed();
        }
        catch (Exception e) {
            return ExecuteResult.createError(e);
        }
    }

    protected Set<String> getMetadataDumpList(KylinConfig config) {
        return Collections.emptySet();
    }

    private void deleteJobTmpDirectoryOnExists() {
        StorageURL storageURL = StorageURL.valueOf(this.getDistMetaUrl());
        String metaPath = storageURL.getParameter("path");
        String[] directories = metaPath.split("/");
        String lastDirectory = directories[directories.length - 1];
        String taskPath = metaPath.substring(0, metaPath.length() - 1 - lastDirectory.length());
        try {
            Path path = new Path(taskPath);
            HadoopUtil.deletePath(HadoopUtil.getCurrentConfiguration(), path);
        }
        catch (Exception e) {
            logger.error("delete job tmp in path {} failed.", (Object)taskPath, (Object)e);
        }
    }

    protected boolean isLocalMaster(Map<String, String> sparkConfs) {
        String master = sparkConfs.getOrDefault(SPARK_MASTER, "yarn");
        return master.equalsIgnoreCase("local") || master.toLowerCase(Locale.ROOT).startsWith("local[");
    }

    public boolean needMergeMetadata() {
        return false;
    }
}

