/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.spark.job;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Set;
import java.util.TimeZone;
import java.util.UUID;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.cube.CubeInstance;
import org.apache.kylin.cube.CubeManager;
import org.apache.kylin.cube.CubeSegment;
import org.apache.kylin.engine.mr.CubingJob;
import org.apache.kylin.engine.spark.job.JobStepFactory;
import org.apache.kylin.engine.spark.job.JobStepType;
import org.apache.kylin.engine.spark.utils.MetaDumpUtil;
import org.apache.kylin.shaded.com.google.common.base.Preconditions;
import org.apache.kylin.shaded.com.google.common.collect.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NSparkOptimizingJob
extends CubingJob {
    private static final Logger logger = LoggerFactory.getLogger(NSparkOptimizingJob.class);
    private static final String DEPLOY_ENV_NAME = "envName";

    public static NSparkOptimizingJob optimize(CubeSegment optimizedSegment, String submitter) {
        return NSparkOptimizingJob.optimize(optimizedSegment, submitter, CubingJob.CubingJobTypeEnum.OPTIMIZE, UUID.randomUUID().toString());
    }

    public static NSparkOptimizingJob optimize(CubeSegment optimizedSegment, String submitter, CubingJob.CubingJobTypeEnum jobType, String jobId) {
        logger.info("SPARK_V2 new job to OPTIMIZE a segment " + optimizedSegment);
        CubeSegment oldSegment = optimizedSegment.getCubeInstance().getOriginalSegmentToOptimize(optimizedSegment);
        Preconditions.checkNotNull(oldSegment, "cannot find the original segment to be optimized by " + optimizedSegment);
        CubeInstance cube = optimizedSegment.getCubeInstance();
        NSparkOptimizingJob job = new NSparkOptimizingJob();
        SimpleDateFormat format = new SimpleDateFormat("z yyyy-MM-dd HH:mm:ss", Locale.ROOT);
        format.setTimeZone(TimeZone.getTimeZone(cube.getConfig().getTimeZone()));
        StringBuilder builder = new StringBuilder();
        builder.append((Object)jobType).append(" CUBE - ");
        builder.append(optimizedSegment.getCubeInstance().getDisplayName()).append(" - ").append(optimizedSegment.getName()).append(" - ");
        builder.append(format.format(new Date(System.currentTimeMillis())));
        job.setName(builder.toString());
        job.setId(jobId);
        job.setTargetSubject(optimizedSegment.getModel().getUuid());
        job.setTargetSegments(Lists.newArrayList(String.valueOf(optimizedSegment.getUuid())));
        job.setProject(optimizedSegment.getProject());
        job.setSubmitter(submitter);
        job.setParam("jobId", jobId);
        job.setParam("project", cube.getProject());
        job.setParam("targetModel", job.getTargetSubject());
        job.setParam("cubeId", cube.getId());
        job.setParam("cubeName", cube.getName());
        job.setParam("segmentIds", String.join((CharSequence)",", job.getTargetSegments()));
        job.setParam("segmentId", optimizedSegment.getUuid());
        job.setParam("segmentName", optimizedSegment.getName());
        job.setParam("dataRangeStart", optimizedSegment.getSegRange().start.toString());
        job.setParam("dataRangeEnd", optimizedSegment.getSegRange().end.toString());
        job.setParam("outputMetaUrl", cube.getConfig().getMetadataUrl().toString());
        job.setParam("jobType", String.valueOf((Object)jobType));
        job.setParam("cuboidsNum", String.valueOf(cube.getDescriptor().getAllCuboids().size()));
        job.setDeployEnvName(KylinConfig.getInstanceFromEnv().getDeployEnv());
        job.setNotifyList(cube.getDescriptor().getNotifyList());
        JobStepFactory.addStep(job, JobStepType.FILTER_RECOMMEND_CUBOID, cube);
        JobStepFactory.addStep(job, JobStepType.RESOURCE_DETECT, cube);
        JobStepFactory.addStep(job, JobStepType.OPTIMIZING, cube);
        return job;
    }

    @Override
    public Set<String> getMetadataDumpList(KylinConfig config) {
        String cubeId = this.getParam("cubeId");
        CubeInstance cubeInstance = CubeManager.getInstance(config).getCubeByUuid(cubeId);
        return MetaDumpUtil.collectCubeMetadata(cubeInstance);
    }

    @Override
    public String getDeployEnvName() {
        return this.getParam(DEPLOY_ENV_NAME);
    }
}

