/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.job.dao;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.NavigableSet;
import java.util.Set;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.persistence.ContentReader;
import org.apache.kylin.common.persistence.JsonSerializer;
import org.apache.kylin.common.persistence.ResourceStore;
import org.apache.kylin.common.persistence.Serializer;
import org.apache.kylin.common.persistence.WriteConflictException;
import org.apache.kylin.common.util.AutoReadWriteLock;
import org.apache.kylin.job.dao.ExecutableOutputPO;
import org.apache.kylin.job.dao.ExecutablePO;
import org.apache.kylin.job.exception.PersistentException;
import org.apache.kylin.job.execution.ExecutableState;
import org.apache.kylin.metadata.cachesync.Broadcaster;
import org.apache.kylin.metadata.cachesync.CachedCrudAssist;
import org.apache.kylin.metadata.cachesync.CaseInsensitiveStringCache;
import org.apache.kylin.shaded.com.google.common.collect.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecutableDao {
    private static final Serializer<ExecutablePO> JOB_SERIALIZER = new JsonSerializer<ExecutablePO>(ExecutablePO.class);
    private static final Serializer<ExecutableOutputPO> JOB_OUTPUT_SERIALIZER = new JsonSerializer<ExecutableOutputPO>(ExecutableOutputPO.class);
    private static final Logger logger = LoggerFactory.getLogger(ExecutableDao.class);
    private ResourceStore store;
    private CaseInsensitiveStringCache<ExecutablePO> executableDigestMap;
    private CaseInsensitiveStringCache<ExecutableOutputPO> executableOutputDigestMap;
    private CachedCrudAssist<ExecutablePO> executableDigestCrud;
    private CachedCrudAssist<ExecutableOutputPO> executableOutputDigestCrud;
    private AutoReadWriteLock executableDigestMapLock = new AutoReadWriteLock();
    private AutoReadWriteLock executableOutputDigestMapLock = new AutoReadWriteLock();
    private static final int UUID_STRING_REPRESENTATION_LENGTH = 36;

    public static ExecutableDao getInstance(KylinConfig config) {
        return config.getManager(ExecutableDao.class);
    }

    static ExecutableDao newInstance(KylinConfig config) throws IOException {
        return new ExecutableDao(config);
    }

    private ExecutableDao(KylinConfig config) throws IOException {
        logger.info("Using metadata url: {}", (Object)config);
        this.store = ResourceStore.getStore(config);
        this.executableDigestMap = new CaseInsensitiveStringCache(config, "execute");
        this.executableDigestCrud = new CachedCrudAssist<ExecutablePO>(this.store, "/execute", "", ExecutablePO.class, this.executableDigestMap, false){

            @Override
            public ExecutablePO reloadAt(String path) {
                try {
                    ExecutablePO executablePO = ExecutableDao.this.readJobResource(path);
                    if (executablePO == null) {
                        logger.warn("No job found at {}, returning null", (Object)path);
                        ExecutableDao.this.executableDigestMap.removeLocal(this.resourceName(path));
                        return null;
                    }
                    ExecutablePO digestExecutablePO = new ExecutablePO();
                    digestExecutablePO.setUuid(executablePO.getUuid());
                    digestExecutablePO.setName(executablePO.getName());
                    digestExecutablePO.setLastModified(executablePO.getLastModified());
                    digestExecutablePO.setType(executablePO.getType());
                    digestExecutablePO.setParams(executablePO.getParams());
                    ExecutableDao.this.executableDigestMap.putLocal(this.resourceName(path), digestExecutablePO);
                    return digestExecutablePO;
                }
                catch (Exception e) {
                    throw new IllegalStateException("Error loading execute at " + path, e);
                }
            }

            @Override
            protected ExecutablePO initEntityAfterReload(ExecutablePO entity, String resourceName) {
                return entity;
            }
        };
        this.executableDigestCrud.setCheckCopyOnWrite(true);
        this.executableDigestCrud.reloadAll();
        this.executableOutputDigestMap = new CaseInsensitiveStringCache(config, "execute_output");
        this.executableOutputDigestCrud = new CachedCrudAssist<ExecutableOutputPO>(this.store, "/execute_output", "", ExecutableOutputPO.class, this.executableOutputDigestMap, false){

            @Override
            public void reloadAll() throws IOException {
                logger.debug("Reloading execute_output from /execute_output");
                ExecutableDao.this.executableOutputDigestMap.clear();
                NavigableSet<String> paths = ExecutableDao.this.store.listResources("/execute_output");
                if (paths != null) {
                    for (String path : paths) {
                        if (ExecutableDao.this.isTaskExecutableOutput(this.resourceName(path))) continue;
                        this.reloadAt(path);
                    }
                    logger.debug("Loaded {} execute_output digest(s) out of {} resource", (Object)ExecutableDao.this.executableOutputDigestMap.size(), (Object)paths.size());
                }
            }

            @Override
            public ExecutableOutputPO reloadAt(String path) {
                try {
                    ExecutableOutputPO executableOutputPO = ExecutableDao.this.readJobOutputResource(path);
                    if (executableOutputPO == null) {
                        logger.warn("No job output found at {}, returning null", (Object)path);
                        ExecutableDao.this.executableOutputDigestMap.removeLocal(this.resourceName(path));
                        return null;
                    }
                    ExecutableOutputPO digestExecutableOutputPO = new ExecutableOutputPO();
                    digestExecutableOutputPO.setUuid(executableOutputPO.getUuid());
                    digestExecutableOutputPO.setLastModified(executableOutputPO.getLastModified());
                    digestExecutableOutputPO.setStatus(executableOutputPO.getStatus());
                    ExecutableDao.this.executableOutputDigestMap.putLocal(this.resourceName(path), digestExecutableOutputPO);
                    return digestExecutableOutputPO;
                }
                catch (Exception e) {
                    throw new IllegalStateException("Error loading execute at " + path, e);
                }
            }

            @Override
            protected ExecutableOutputPO initEntityAfterReload(ExecutableOutputPO entity, String resourceName) {
                return entity;
            }
        };
        this.executableOutputDigestCrud.setCheckCopyOnWrite(true);
        this.executableOutputDigestCrud.reloadAll();
        Broadcaster.getInstance(config).registerListener(new JobSyncListener(), "execute");
        Broadcaster.getInstance(config).registerListener(new JobOutputSyncListener(), "execute_output");
    }

    private boolean isTaskExecutableOutput(String id) {
        return id.length() > 36;
    }

    private String pathOfJob(ExecutablePO job) {
        return ExecutableDao.pathOfJob(job.getUuid());
    }

    public static String pathOfJob(String uuid) {
        return "/execute/" + uuid;
    }

    public static String pathOfJobOutput(String uuid) {
        return "/execute_output/" + uuid;
    }

    private ExecutablePO readJobResource(String path) throws IOException {
        return this.store.getResource(path, JOB_SERIALIZER);
    }

    private void writeJobResource(String path, ExecutablePO job) throws IOException {
        this.store.checkAndPutResource(path, job, JOB_SERIALIZER);
    }

    private ExecutableOutputPO readJobOutputResource(String path) throws IOException {
        return this.store.getResource(path, JOB_OUTPUT_SERIALIZER);
    }

    private void writeJobOutputResource(String path, ExecutableOutputPO output) throws IOException {
        this.store.checkAndPutResource(path, output, JOB_OUTPUT_SERIALIZER);
    }

    public List<ExecutableOutputPO> getJobOutputs() throws PersistentException {
        try {
            return this.store.getAllResources("/execute_output", JOB_OUTPUT_SERIALIZER);
        }
        catch (IOException e) {
            logger.error("error get all Jobs:", e);
            throw new PersistentException(e);
        }
    }

    public List<ExecutableOutputPO> getJobOutputs(long timeStart, long timeEndExclusive) throws PersistentException {
        try {
            return this.store.getAllResources("/execute_output", false, new ResourceStore.VisitFilter(timeStart, timeEndExclusive), new ContentReader<ExecutableOutputPO>(JOB_OUTPUT_SERIALIZER));
        }
        catch (IOException e) {
            logger.error("error get all Jobs:", e);
            throw new PersistentException(e);
        }
    }

    public ExecutableOutputPO getJobOutputDigest(String uuid) {
        return (ExecutableOutputPO)this.executableOutputDigestMap.get(uuid);
    }

    public List<ExecutableOutputPO> getJobOutputDigests(long timeStart, long timeEndExclusive) {
        ArrayList<ExecutableOutputPO> jobOutputDigests = Lists.newArrayList();
        for (ExecutableOutputPO po : this.executableOutputDigestMap.values()) {
            if (po.getLastModified() < timeStart || po.getLastModified() >= timeEndExclusive) continue;
            jobOutputDigests.add(po);
        }
        return jobOutputDigests;
    }

    public List<ExecutablePO> getJobs() throws PersistentException {
        try {
            return this.store.getAllResources("/execute", JOB_SERIALIZER);
        }
        catch (IOException e) {
            logger.error("error get all Jobs:", e);
            throw new PersistentException(e);
        }
    }

    public List<ExecutablePO> getJobs(long timeStart, long timeEndExclusive) throws PersistentException {
        try {
            return this.store.getAllResources("/execute", false, new ResourceStore.VisitFilter(timeStart, timeEndExclusive), new ContentReader<ExecutablePO>(JOB_SERIALIZER));
        }
        catch (IOException e) {
            logger.error("error get all Jobs:", e);
            throw new PersistentException(e);
        }
    }

    public ExecutablePO getJobDigest(String uuid) {
        return (ExecutablePO)this.executableDigestMap.get(uuid);
    }

    public List<ExecutablePO> getJobDigests(long timeStart, long timeEndExclusive) {
        ArrayList<ExecutablePO> jobDigests = Lists.newArrayList();
        for (ExecutablePO po : this.executableDigestMap.values()) {
            if (po.getLastModified() < timeStart || po.getLastModified() >= timeEndExclusive) continue;
            jobDigests.add(po);
        }
        return jobDigests;
    }

    public List<String> getJobIdsInCache() {
        Set idSet = this.executableDigestMap.keySet();
        return Lists.newArrayList(idSet);
    }

    public List<String> getJobIds() throws PersistentException {
        try {
            NavigableSet<String> resources = this.store.listResources("/execute");
            if (resources == null) {
                return Collections.emptyList();
            }
            ArrayList<String> result = Lists.newArrayListWithExpectedSize(resources.size());
            for (String path : resources) {
                result.add(path.substring(path.lastIndexOf("/") + 1));
            }
            return result;
        }
        catch (IOException e) {
            logger.error("error get all Jobs:", e);
            throw new PersistentException(e);
        }
    }

    public ExecutablePO getJob(String uuid) throws PersistentException {
        try {
            return this.readJobResource(ExecutableDao.pathOfJob(uuid));
        }
        catch (IOException e) {
            logger.error("error get job:" + uuid, e);
            throw new PersistentException(e);
        }
    }

    public ExecutablePO addJob(ExecutablePO job) throws PersistentException {
        try {
            if (this.getJob(job.getUuid()) != null) {
                throw new IllegalArgumentException("job id:" + job.getUuid() + " already exists");
            }
            this.writeJobResource(this.pathOfJob(job), job);
            this.executableDigestMap.put(job.getId(), job);
            return job;
        }
        catch (IOException e) {
            logger.error("error save job:" + job.getUuid(), e);
            throw new PersistentException(e);
        }
    }

    public ExecutablePO updateJob(ExecutablePO job) throws PersistentException {
        try {
            if (this.getJob(job.getUuid()) == null) {
                throw new IllegalArgumentException("job id:" + job.getUuid() + " does not exist");
            }
            this.writeJobResource(this.pathOfJob(job), job);
            this.executableDigestMap.put(job.getId(), job);
            return job;
        }
        catch (IOException e) {
            logger.error("error update job:" + job.getUuid(), e);
            throw new PersistentException(e);
        }
    }

    public void deleteJob(String uuid) throws PersistentException {
        try {
            ExecutablePO executablePO = this.getJob(uuid);
            this.store.deleteResource(ExecutableDao.pathOfJob(uuid));
            this.executableDigestMap.remove(uuid);
            this.removeJobOutput(executablePO);
        }
        catch (IOException e) {
            logger.error("error delete job:" + uuid, e);
            throw new PersistentException(e);
        }
    }

    private void removeJobOutput(ExecutablePO executablePO) {
        ArrayList<String> toDeletePaths = Lists.newArrayList();
        try {
            toDeletePaths.add(ExecutableDao.pathOfJobOutput(executablePO.getUuid()));
            for (ExecutablePO task : executablePO.getTasks()) {
                toDeletePaths.add(ExecutableDao.pathOfJobOutput(task.getUuid()));
            }
            for (String path : toDeletePaths) {
                this.store.deleteResource(path);
            }
        }
        catch (Exception e) {
            logger.warn("error delete job output:" + executablePO.getUuid(), e);
        }
    }

    public ExecutableOutputPO getJobOutput(String uuid) throws PersistentException {
        ExecutableOutputPO result = null;
        try {
            result = this.readJobOutputResource(ExecutableDao.pathOfJobOutput(uuid));
            if (result == null) {
                result = new ExecutableOutputPO();
                result.setUuid(uuid);
                return result;
            }
            return result;
        }
        catch (IOException e) {
            logger.error("error get job output id:" + uuid, e);
            if (e.getCause() instanceof FileNotFoundException) {
                result = new ExecutableOutputPO();
                result.setUuid(uuid);
                result.setStatus(ExecutableState.SUCCEED.name());
                return result;
            }
            throw new PersistentException(e);
        }
    }

    public void addJobOutput(ExecutableOutputPO output) throws PersistentException {
        try {
            output.setLastModified(0L);
            this.writeJobOutputResource(ExecutableDao.pathOfJobOutput(output.getUuid()), output);
            if (!this.isTaskExecutableOutput(output.getUuid())) {
                this.executableOutputDigestMap.put(output.getUuid(), output);
            }
        }
        catch (IOException e) {
            logger.error("error update job output id:" + output.getUuid(), e);
            throw new PersistentException(e);
        }
    }

    public void updateJobOutput(ExecutableOutputPO output) throws PersistentException {
        try {
            int retry = 7;
            while (retry-- > 0) {
                try {
                    this.writeJobOutputResource(ExecutableDao.pathOfJobOutput(output.getUuid()), output);
                    if (!this.isTaskExecutableOutput(output.getUuid())) {
                        this.executableOutputDigestMap.put(output.getUuid(), output);
                    }
                    return;
                }
                catch (WriteConflictException e) {
                    if (retry <= 0) {
                        logger.error("Retry is out, till got error, abandoning...", e);
                        throw e;
                    }
                    logger.warn("Write conflict to update  job output id:" + output.getUuid() + " retry remaining " + retry + ", will retry...");
                }
            }
        }
        catch (IOException e) {
            logger.error("error update job output id:" + output.getUuid(), e);
            throw new PersistentException(e);
        }
    }

    public void deleteJobOutput(String uuid) throws PersistentException {
        try {
            this.store.deleteResource(ExecutableDao.pathOfJobOutput(uuid));
            if (!this.isTaskExecutableOutput(uuid)) {
                this.executableOutputDigestMap.remove(uuid);
            }
        }
        catch (IOException e) {
            logger.error("error delete job:" + uuid, e);
            throw new PersistentException(e);
        }
    }

    public void reloadAll() throws IOException {
        try (AutoReadWriteLock.AutoLock lock = this.executableDigestMapLock.lockForWrite();){
            this.executableDigestCrud.reloadAll();
        }
        lock = this.executableOutputDigestMapLock.lockForWrite();
        var2_2 = null;
        try {
            this.executableOutputDigestCrud.reloadAll();
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
        finally {
            if (lock != null) {
                if (var2_2 != null) {
                    try {
                        lock.close();
                    }
                    catch (Throwable throwable) {
                        var2_2.addSuppressed(throwable);
                    }
                } else {
                    lock.close();
                }
            }
        }
    }

    public void syncDigestsOfJob(String uuid) throws PersistentException {
        ExecutablePO job = this.getJob(uuid);
        ExecutablePO jobDigest = this.getJobDigest(uuid);
        if (job == null && jobDigest != null) {
            this.executableDigestMap.remove(uuid);
        } else if (job != null && jobDigest == null) {
            this.executableDigestMap.put(uuid, job);
        }
        ExecutableOutputPO jobOutput = this.getJobOutput(uuid);
        ExecutableOutputPO jobOutputDigest = this.getJobOutputDigest(uuid);
        if (jobOutput == null && jobOutputDigest != null) {
            this.executableOutputDigestMap.remove(uuid);
        } else if (jobOutput != null && jobOutputDigest == null) {
            this.executableOutputDigestMap.put(uuid, jobOutput);
        }
    }

    private class JobOutputSyncListener
    extends Broadcaster.Listener {
        private JobOutputSyncListener() {
        }

        @Override
        public void onEntityChange(Broadcaster broadcaster, String entity, Broadcaster.Event event, String cacheKey) throws IOException {
            try (AutoReadWriteLock.AutoLock l = ExecutableDao.this.executableOutputDigestMapLock.lockForWrite();){
                if (!ExecutableDao.this.isTaskExecutableOutput(cacheKey)) {
                    if (event == Broadcaster.Event.DROP) {
                        ExecutableDao.this.executableOutputDigestMap.removeLocal(cacheKey);
                    } else {
                        ExecutableDao.this.executableOutputDigestCrud.reloadQuietly(cacheKey);
                    }
                }
            }
        }
    }

    private class JobSyncListener
    extends Broadcaster.Listener {
        private JobSyncListener() {
        }

        @Override
        public void onEntityChange(Broadcaster broadcaster, String entity, Broadcaster.Event event, String cacheKey) throws IOException {
            try (AutoReadWriteLock.AutoLock l = ExecutableDao.this.executableDigestMapLock.lockForWrite();){
                if (event == Broadcaster.Event.DROP) {
                    ExecutableDao.this.executableDigestMap.removeLocal(cacheKey);
                } else {
                    ExecutableDao.this.executableDigestCrud.reloadQuietly(cacheKey);
                }
            }
        }
    }
}

