/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.measure;

import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.kylin.measure.MeasureAggregator;
import org.apache.kylin.measure.MeasureIngester;
import org.apache.kylin.measure.MeasureType;
import org.apache.kylin.measure.dim.DimCountDistinctMeasureType;
import org.apache.kylin.metadata.datatype.DataType;
import org.apache.kylin.metadata.datatype.DataTypeSerializer;
import org.apache.kylin.shaded.com.google.common.collect.Lists;
import org.apache.kylin.shaded.com.google.common.collect.Maps;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MeasureTypeFactory<T> {
    private static final Logger logger = LoggerFactory.getLogger(MeasureTypeFactory.class);
    private static final Map<String, List<MeasureTypeFactory<?>>> factories = Maps.newHashMap();
    private static final Map<String, Class<?>> udafMap = Maps.newHashMap();
    private static final Map<String, MeasureTypeFactory> udafFactories = Maps.newHashMap();
    private static final List<MeasureTypeFactory<?>> defaultFactory = Lists.newArrayListWithCapacity(2);

    public abstract MeasureType<T> createMeasureType(String var1, DataType var2);

    public abstract String getAggrFunctionName();

    public abstract String getAggrDataTypeName();

    public abstract Class<? extends DataTypeSerializer<T>> getAggrDataTypeSerializer();

    /*
     * Exception decompiling
     */
    public static synchronized void init() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static void registerUDAF(MeasureTypeFactory<?> factory) {
        MeasureType<?> type = factory.createMeasureType(factory.getAggrFunctionName(), DataType.getType(factory.getAggrDataTypeName()));
        Map<String, Class<?>> udafs = type.getRewriteCalciteAggrFunctions();
        if (!type.needRewrite() || udafs == null) {
            return;
        }
        for (String udaf : udafs.keySet()) {
            if ((udaf = udaf.toUpperCase(Locale.ROOT)).equals("COUNT_DISTINCT")) continue;
            if (udafFactories.containsKey(udaf)) {
                throw new IllegalStateException("UDAF '" + udaf + "' was dup declared by " + udafFactories.get(udaf) + " and " + factory);
            }
            udafFactories.put(udaf, factory);
            udafMap.put(udaf, udafs.get(udaf));
        }
    }

    public static Map<String, Class<?>> getUDAFs() {
        return udafMap;
    }

    public static Map<String, MeasureTypeFactory> getUDAFFactories() {
        return udafFactories;
    }

    public static MeasureType<?> create(String funcName, String dataType) {
        return MeasureTypeFactory.create(funcName, DataType.getType(dataType));
    }

    public static MeasureType<?> createNoRewriteFieldsMeasureType(String funcName, DataType dataType) {
        if (funcName.equalsIgnoreCase("COUNT_DISTINCT")) {
            return new DimCountDistinctMeasureType.Factory().createMeasureType(funcName, dataType);
        }
        throw new UnsupportedOperationException("No measure type found.");
    }

    public static MeasureType<?> create(String funcName, DataType dataType) {
        List<MeasureTypeFactory<?>> factory = factories.get(funcName = funcName.toUpperCase(Locale.ROOT));
        if (factory == null) {
            factory = defaultFactory;
        }
        if (dataType == null) {
            return new NeedRewriteOnlyMeasureType(funcName, factory);
        }
        if (factory.size() == 1) {
            return factory.get(0).createMeasureType(funcName, dataType);
        }
        for (MeasureTypeFactory<?> f : factory) {
            if (!f.getAggrDataTypeName().equals(dataType.getName())) continue;
            return f.createMeasureType(funcName, dataType);
        }
        throw new IllegalStateException("failed to create MeasureType with funcName: " + funcName + ", dataType: " + dataType);
    }

    static {
        MeasureTypeFactory.init();
    }

    public static class NeedRewriteOnlyMeasureType
    extends MeasureType {
        private Boolean needRewrite;

        public NeedRewriteOnlyMeasureType(String funcName, List<MeasureTypeFactory<?>> factory) {
            for (MeasureTypeFactory<?> f : factory) {
                boolean b = f.createMeasureType(funcName, null).needRewrite();
                if (this.needRewrite == null) {
                    this.needRewrite = b;
                    continue;
                }
                if (this.needRewrite == b) continue;
                throw new IllegalStateException("needRewrite() of factorys " + factory + " does not have consensus");
            }
        }

        public MeasureIngester newIngester() {
            throw new UnsupportedOperationException();
        }

        public MeasureAggregator newAggregator() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean needRewrite() {
            return this.needRewrite;
        }

        @Override
        public Map<String, Class<?>> getRewriteCalciteAggrFunctions() {
            return null;
        }
    }
}

