/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.measure.hllc;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.kylin.measure.hllc.HLLCounter;
import org.apache.kylin.metadata.datatype.DataType;
import org.apache.kylin.metadata.datatype.DataTypeSerializer;

public class HLLCSerializer
extends DataTypeSerializer<HLLCounter> {
    private int precision;

    public HLLCSerializer(DataType type) {
        this.precision = type.getPrecision();
    }

    @Override
    public void serialize(HLLCounter value, ByteBuffer out) {
        try {
            value.writeRegisters(out);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private HLLCounter current() {
        HLLCounter hllc = (HLLCounter)this.current.get();
        if (hllc == null) {
            hllc = new HLLCounter(this.precision);
            this.current.set(hllc);
        }
        return hllc;
    }

    @Override
    public HLLCounter deserialize(ByteBuffer in) {
        HLLCounter hllc = new HLLCounter(this.precision);
        try {
            hllc.readRegisters(in);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return hllc;
    }

    @Override
    public int peekLength(ByteBuffer in) {
        return this.current().peekLength(in);
    }

    @Override
    public int maxLength() {
        return this.current().maxLength();
    }

    @Override
    public int getStorageBytesEstimate() {
        return this.current().maxLength();
    }

    @Override
    protected double getStorageBytesEstimate(double averageNumOfElementsInCounter) {
        int registerIndexSize = this.current().getRegisterIndexSize();
        int m = 1 << this.precision;
        if (!this.current().isDense((int)averageNumOfElementsInCounter) || averageNumOfElementsInCounter < ((double)m - 5.0) / (1.0 + (double)registerIndexSize)) {
            return 5.0 + averageNumOfElementsInCounter * (double)(registerIndexSize + 1);
        }
        return this.getStorageBytesEstimate();
    }
}

