/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.datatype;

import java.nio.ByteBuffer;
import org.apache.kylin.common.util.BytesUtil;
import org.apache.kylin.metadata.datatype.DataType;
import org.apache.kylin.metadata.datatype.DataTypeSerializer;

public class Int4Serializer
extends DataTypeSerializer<Integer> {
    public Int4Serializer(DataType type) {
    }

    @Override
    public void serialize(Integer value, ByteBuffer out) {
        BytesUtil.writeUnsigned(value, 4, out);
    }

    @Override
    public Integer deserialize(ByteBuffer in) {
        return BytesUtil.readUnsigned(in, 4);
    }

    @Override
    public int peekLength(ByteBuffer in) {
        return 4;
    }

    @Override
    public int maxLength() {
        return 4;
    }

    @Override
    public int getStorageBytesEstimate() {
        return 4;
    }

    @Override
    public Integer valueOf(String str) {
        return Integer.parseInt(str);
    }
}

