/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.filter;

import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Collections;
import org.apache.kylin.common.util.BytesUtil;
import org.apache.kylin.metadata.filter.IFilterCodeSystem;
import org.apache.kylin.metadata.filter.TupleFilter;
import org.apache.kylin.metadata.tuple.IEvaluatableTuple;
import org.apache.kylin.shaded.com.google.common.collect.Lists;

public class ConstantTupleFilter
extends TupleFilter {
    public static final ConstantTupleFilter FALSE = new ConstantTupleFilter();
    public static final ConstantTupleFilter TRUE = new ConstantTupleFilter((Object)null);
    private Collection<Object> constantValues = Lists.newArrayList();

    public ConstantTupleFilter() {
        super(Collections.emptyList(), TupleFilter.FilterOperatorEnum.CONSTANT);
    }

    public ConstantTupleFilter(Object value) {
        this();
        this.constantValues.add(value);
    }

    public ConstantTupleFilter(Collection<?> values) {
        this();
        this.constantValues.addAll(values);
    }

    @Override
    public TupleFilter reverse() {
        if (this.evaluate(null, null)) {
            return FALSE;
        }
        return TRUE;
    }

    @Override
    public void addChild(TupleFilter child) {
        throw new UnsupportedOperationException("This is " + this + " and child is " + child);
    }

    public String toString() {
        return "" + this.constantValues;
    }

    @Override
    public boolean evaluate(IEvaluatableTuple tuple, IFilterCodeSystem<?> cs) {
        return this.constantValues.size() > 0;
    }

    @Override
    public boolean isEvaluable() {
        return true;
    }

    @Override
    public Collection<?> getValues() {
        return this.constantValues;
    }

    public void serialize(IFilterCodeSystem cs, ByteBuffer buffer) {
        int size = this.constantValues.size();
        BytesUtil.writeVInt(size, buffer);
        for (Object val : this.constantValues) {
            cs.serialize(val, buffer);
        }
    }

    @Override
    public void deserialize(IFilterCodeSystem<?> cs, ByteBuffer buffer) {
        this.constantValues.clear();
        int size = BytesUtil.readVInt(buffer);
        for (int i = 0; i < size; ++i) {
            this.constantValues.add(cs.deserialize(buffer));
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConstantTupleFilter that = (ConstantTupleFilter)o;
        return this.constantValues.equals(that.constantValues);
    }

    public int hashCode() {
        return this.constantValues.hashCode();
    }
}

