/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.query.relnode.visitor;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexLocalRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexVisitor;
import org.apache.calcite.rex.RexVisitorImpl;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlCastFunction;
import org.apache.calcite.sql.validate.SqlUserDefinedFunction;
import org.apache.calcite.util.NlsString;
import org.apache.kylin.common.util.Pair;
import org.apache.kylin.metadata.expression.BinaryTupleExpression;
import org.apache.kylin.metadata.expression.CaseTupleExpression;
import org.apache.kylin.metadata.expression.ColumnTupleExpression;
import org.apache.kylin.metadata.expression.NumberTupleExpression;
import org.apache.kylin.metadata.expression.RexCallTupleExpression;
import org.apache.kylin.metadata.expression.StringTupleExpression;
import org.apache.kylin.metadata.expression.TupleExpression;
import org.apache.kylin.metadata.filter.CompareTupleFilter;
import org.apache.kylin.metadata.filter.FilterOptimizeTransformer;
import org.apache.kylin.metadata.filter.TupleFilter;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.kylin.query.relnode.ColumnRowType;
import org.apache.kylin.query.relnode.visitor.TupleFilterVisitor;
import org.apache.kylin.query.util.RexUtil;

public class TupleExpressionVisitor
extends RexVisitorImpl<TupleExpression> {
    final ColumnRowType inputRowType;
    final boolean ifVerify;

    public TupleExpressionVisitor(ColumnRowType inputRowType, boolean ifVerify) {
        super(true);
        this.inputRowType = inputRowType;
        this.ifVerify = ifVerify;
    }

    public TupleExpression visitCall(RexCall call) {
        TupleExpression tupleExpression;
        SqlOperator op = call.getOperator();
        if (op instanceof SqlCastFunction) {
            return (TupleExpression)((RexNode)call.getOperands().get(0)).accept((RexVisitor)this);
        }
        if (op instanceof SqlUserDefinedFunction && op.getName().equals("QUARTER")) {
            return this.visitFirstRexInputRef(call);
        }
        switch (op.getKind()) {
            case PLUS: {
                tupleExpression = this.getBinaryTupleExpression(call, TupleExpression.ExpressionOperatorEnum.PLUS);
                break;
            }
            case MINUS: {
                tupleExpression = this.getBinaryTupleExpression(call, TupleExpression.ExpressionOperatorEnum.MINUS);
                break;
            }
            case TIMES: {
                tupleExpression = this.getBinaryTupleExpression(call, TupleExpression.ExpressionOperatorEnum.MULTIPLE);
                break;
            }
            case DIVIDE: {
                tupleExpression = this.getBinaryTupleExpression(call, TupleExpression.ExpressionOperatorEnum.DIVIDE);
                break;
            }
            case CASE: {
                tupleExpression = this.getCaseTupleExpression(call);
                break;
            }
            default: {
                tupleExpression = this.getRexCallTupleExpression(call);
            }
        }
        if (this.ifVerify) {
            tupleExpression.verify();
        }
        return tupleExpression;
    }

    private BinaryTupleExpression getBinaryTupleExpression(RexCall call, TupleExpression.ExpressionOperatorEnum op) {
        assert (call.operands.size() == 2);
        TupleExpression left = (TupleExpression)((RexNode)call.operands.get(0)).accept((RexVisitor)this);
        TupleExpression right = (TupleExpression)((RexNode)call.operands.get(1)).accept((RexVisitor)this);
        BinaryTupleExpression tuple = new BinaryTupleExpression(op, Lists.newArrayList((Object[])new TupleExpression[]{left, right}));
        tuple.setDigest(call.toString());
        return tuple;
    }

    private CaseTupleExpression getCaseTupleExpression(RexCall call) {
        RexNode elseNode;
        ArrayList whenList = Lists.newArrayListWithExpectedSize((int)(call.operands.size() / 2));
        TupleExpression elseExpr = null;
        TupleFilterVisitor filterVistor = new TupleFilterVisitor(this.inputRowType);
        for (int i = 0; i < call.operands.size() - 1; i += 2) {
            if (!(call.operands.get(i) instanceof RexCall)) continue;
            RexCall whenCall = (RexCall)call.operands.get(i);
            CompareTupleFilter.CompareResultType compareResultType = RexUtil.getCompareResultType(whenCall);
            if (compareResultType == CompareTupleFilter.CompareResultType.AlwaysTrue) {
                elseExpr = (TupleExpression)((RexNode)call.operands.get(i + 1)).accept((RexVisitor)this);
                break;
            }
            if (compareResultType == CompareTupleFilter.CompareResultType.AlwaysFalse) continue;
            TupleFilter whenFilter = (TupleFilter)whenCall.accept((RexVisitor)filterVistor);
            whenFilter = new FilterOptimizeTransformer().transform(whenFilter);
            TupleExpression thenExpr = (TupleExpression)((RexNode)call.operands.get(i + 1)).accept((RexVisitor)this);
            whenList.add(new Pair<TupleFilter, TupleExpression>(whenFilter, thenExpr));
        }
        if (!(elseExpr != null || call.operands.size() % 2 != 1 || (elseNode = (RexNode)call.operands.get(call.operands.size() - 1)) instanceof RexLiteral && ((RexLiteral)elseNode).getValue() == null)) {
            elseExpr = (TupleExpression)elseNode.accept((RexVisitor)this);
        }
        CaseTupleExpression tuple = new CaseTupleExpression(whenList, elseExpr);
        tuple.setDigest(call.toString());
        return tuple;
    }

    private RexCallTupleExpression getRexCallTupleExpression(RexCall call) {
        ArrayList children = Lists.newArrayListWithExpectedSize((int)call.getOperands().size());
        for (RexNode rexNode : call.operands) {
            children.add(rexNode.accept((RexVisitor)this));
        }
        RexCallTupleExpression tuple = new RexCallTupleExpression(children);
        tuple.setDigest(call.toString());
        return tuple;
    }

    public TupleExpression visitLocalRef(RexLocalRef localRef) {
        throw new UnsupportedOperationException("local ref:" + localRef);
    }

    public TupleExpression visitInputRef(RexInputRef inputRef) {
        int index = inputRef.getIndex();
        if (index < this.inputRowType.size()) {
            TblColRef column = this.inputRowType.getColumnByIndex(index);
            TupleExpression tuple = column.getSubTupleExps() != null ? new RexCallTupleExpression(column.getSubTupleExps()) : new ColumnTupleExpression(column);
            tuple.setDigest(inputRef.toString());
            return tuple;
        }
        throw new IllegalStateException("Can't find " + inputRef + " from child columnrowtype");
    }

    public TupleExpression visitFirstRexInputRef(RexCall call) {
        for (RexNode operand : call.getOperands()) {
            TupleExpression r;
            if (operand instanceof RexInputRef) {
                return this.visitInputRef((RexInputRef)operand);
            }
            if (!(operand instanceof RexCall) || (r = this.visitFirstRexInputRef((RexCall)operand)) == null) continue;
            return r;
        }
        return null;
    }

    public TupleExpression visitLiteral(RexLiteral literal) {
        Comparable value = literal.getValue();
        TupleExpression tuple = value instanceof Number ? new NumberTupleExpression(value) : (value == null ? new StringTupleExpression(null) : (value instanceof NlsString ? new StringTupleExpression(((NlsString)value).getValue()) : new StringTupleExpression(value.toString())));
        tuple.setDigest(literal.toString());
        return tuple;
    }
}

