/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.signature;

import java.security.MessageDigest;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.codec.binary.Base64;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.Pair;
import org.apache.kylin.common.util.StringUtil;
import org.apache.kylin.metadata.project.ProjectInstance;
import org.apache.kylin.rest.response.SQLResponse;
import org.apache.kylin.rest.signature.RealizationSignature;
import org.apache.kylin.rest.signature.SignatureCalculator;
import org.apache.kylin.shaded.com.google.common.base.CharMatcher;
import org.apache.kylin.shaded.com.google.common.base.Splitter;
import org.apache.kylin.shaded.com.google.common.base.Strings;
import org.apache.kylin.shaded.com.google.common.collect.Iterables;
import org.apache.kylin.shaded.com.google.common.collect.Sets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RealizationSetCalculator
implements SignatureCalculator {
    public static final Logger logger = LoggerFactory.getLogger(RealizationSetCalculator.class);

    @Override
    public String calculateSignature(KylinConfig config, SQLResponse sqlResponse, ProjectInstance project) {
        Set<String> realizations = this.getRealizations(config, sqlResponse.getCube(), project);
        if (realizations == null) {
            return null;
        }
        TreeSet<RealizationSignature> signatureSet = Sets.newTreeSet();
        for (String realization : realizations) {
            RealizationSignature realizationSignature = RealizationSetCalculator.getRealizationSignature(config, realization);
            if (realizationSignature == null) continue;
            signatureSet.add(realizationSignature);
        }
        if (signatureSet.isEmpty()) {
            return null;
        }
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            byte[] signature = md.digest(((Object)signatureSet).toString().getBytes("UTF-8"));
            return new String(Base64.encodeBase64((byte[])signature), "UTF-8");
        }
        catch (Exception e) {
            logger.warn("Failed to calculate signature due to " + e);
            return null;
        }
    }

    protected Set<String> getRealizations(KylinConfig config, String cubes, ProjectInstance project) {
        if (Strings.isNullOrEmpty(cubes)) {
            return null;
        }
        String[] realizations = RealizationSetCalculator.parseNamesFromCanonicalNames(StringUtil.splitByComma(cubes));
        return Sets.newHashSet(realizations);
    }

    protected static RealizationSignature getRealizationSignature(KylinConfig config, String realizationName) {
        RealizationSignature result = RealizationSignature.HybridSignature.getHybridSignature(config, realizationName);
        if (result == null) {
            result = RealizationSignature.CubeSignature.getCubeSignature(config, realizationName);
        }
        return result;
    }

    private static String[] parseNamesFromCanonicalNames(String[] canonicalNames) {
        String[] result = new String[canonicalNames.length];
        for (int i = 0; i < canonicalNames.length; ++i) {
            result[i] = RealizationSetCalculator.parseCanonicalName(canonicalNames[i]).getSecond();
        }
        return result;
    }

    private static Pair<String, String> parseCanonicalName(String canonicalName) {
        Iterable<String> parts = Splitter.on(CharMatcher.anyOf("[]=,")).split(canonicalName);
        String[] partsStr = Iterables.toArray(parts, String.class);
        return new Pair<String, String>(partsStr[0], partsStr[2]);
    }
}

