/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.storage.translate;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.Array;
import org.apache.kylin.common.util.DateFormat;
import org.apache.kylin.common.util.Pair;
import org.apache.kylin.cube.model.CubeDesc;
import org.apache.kylin.metadata.datatype.DataType;
import org.apache.kylin.metadata.datatype.DataTypeOrder;
import org.apache.kylin.metadata.filter.ColumnTupleFilter;
import org.apache.kylin.metadata.filter.CompareTupleFilter;
import org.apache.kylin.metadata.filter.ConstantTupleFilter;
import org.apache.kylin.metadata.filter.LogicalTupleFilter;
import org.apache.kylin.metadata.filter.TupleFilter;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.kylin.metadata.tuple.IEvaluatableTuple;
import org.apache.kylin.shaded.com.google.common.collect.Lists;
import org.apache.kylin.shaded.com.google.common.collect.Sets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DerivedFilterTranslator {
    private static final Logger logger = LoggerFactory.getLogger(DerivedFilterTranslator.class);

    /*
     * WARNING - void declaration
     */
    public static Pair<TupleFilter, Boolean> translate(CubeDesc.DeriveInfo hostInfo, CompareTupleFilter compf) {
        void var11_22;
        TupleFilter translated;
        TblColRef derivedCol = compf.getColumn();
        TblColRef[] hostCols = hostInfo.columns;
        TblColRef[] pkCols = hostInfo.join.getPrimaryKeyColumns();
        if (hostInfo.type == CubeDesc.DeriveType.PK_FK) {
            assert (hostCols.length == 1);
            CompareTupleFilter newComp = new CompareTupleFilter(compf.getOperator());
            newComp.addChild(new ColumnTupleFilter(hostCols[0]));
            Collection values = compf.getValues();
            DataType pkDataType = compf.getColumn().getType();
            if (pkDataType.isDateTimeFamily() && hostCols[0].getType().isStringFamily()) {
                HashSet<String> newValues = Sets.newHashSetWithExpectedSize(values.size());
                for (Object entry : values) {
                    long l = DateFormat.stringToMillis((String)entry);
                    String newEntry = pkDataType.isDate() ? DateFormat.formatToDateStr(l) : DateFormat.formatToTimeWithoutMilliStr(l);
                    newValues.add(newEntry);
                }
                newComp.addChild(new ConstantTupleFilter(newValues));
            } else {
                newComp.addChild(new ConstantTupleFilter(values));
            }
            return new Pair<TupleFilter, Boolean>(newComp, false);
        }
        assert (hostInfo.type == CubeDesc.DeriveType.LOOKUP);
        assert (hostCols.length == pkCols.length);
        int di = derivedCol.getColumnDesc().getZeroBasedIndex();
        int[] pi = new int[pkCols.length];
        int hn = hostCols.length;
        for (int i = 0; i < hn; ++i) {
            pi[i] = pkCols[i].getColumnDesc().getZeroBasedIndex();
        }
        HashSet<Array<String>> satisfyingHostRecords = Sets.newHashSet();
        SingleColumnTuple tuple = new SingleColumnTuple(derivedCol);
        for (Array array : satisfyingHostRecords) {
            for (int i = 0; i < pkCols.length; ++i) {
                if (!pkCols[i].getType().isDateTimeFamily() || !hostCols[i].getType().isStringFamily()) continue;
                long ts = DateFormat.stringToMillis(((String[])array.data)[i]);
                ((String[])array.data)[i] = pkCols[i].getType().isDate() ? DateFormat.formatToDateStr(ts) : DateFormat.formatToTimeWithoutMilliStr(ts);
            }
        }
        if (satisfyingHostRecords.size() > KylinConfig.getInstanceFromEnv().getDerivedInThreshold()) {
            logger.info("Deciding to loosen filter on derived filter as host candidates number {} exceeds threshold {}", (Object)satisfyingHostRecords.size(), (Object)KylinConfig.getInstanceFromEnv().getDerivedInThreshold());
            translated = DerivedFilterTranslator.buildRangeFilter(hostCols, satisfyingHostRecords);
            boolean bl = true;
        } else {
            translated = DerivedFilterTranslator.buildInFilter(hostCols, satisfyingHostRecords);
            boolean bl = false;
        }
        return new Pair<TupleFilter, Boolean>(translated, (boolean)var11_22);
    }

    private static void collect(String[] row, int[] pi, Set<Array<String>> satisfyingHostRecords) {
        String[] rec = new String[pi.length];
        for (int i = 0; i < pi.length; ++i) {
            rec[i] = row[pi[i]];
        }
        satisfyingHostRecords.add(new Array<String>(rec));
    }

    private static TupleFilter buildInFilter(TblColRef[] hostCols, Set<Array<String>> satisfyingHostRecords) {
        if (satisfyingHostRecords.size() == 0) {
            return ConstantTupleFilter.FALSE;
        }
        int hn = hostCols.length;
        if (hn == 1) {
            CompareTupleFilter in = new CompareTupleFilter(TupleFilter.FilterOperatorEnum.IN);
            in.addChild(new ColumnTupleFilter(hostCols[0]));
            in.addChild(new ConstantTupleFilter(DerivedFilterTranslator.asValues(satisfyingHostRecords)));
            return in;
        }
        LogicalTupleFilter or = new LogicalTupleFilter(TupleFilter.FilterOperatorEnum.OR);
        for (Array<String> rec : satisfyingHostRecords) {
            LogicalTupleFilter and = new LogicalTupleFilter(TupleFilter.FilterOperatorEnum.AND);
            for (int i = 0; i < hn; ++i) {
                CompareTupleFilter eq = new CompareTupleFilter(TupleFilter.FilterOperatorEnum.EQ);
                eq.addChild(new ColumnTupleFilter(hostCols[i]));
                eq.addChild(new ConstantTupleFilter(((String[])rec.data)[i]));
                and.addChild(eq);
            }
            or.addChild(and);
        }
        return or;
    }

    private static List<String> asValues(Set<Array<String>> satisfyingHostRecords) {
        ArrayList<String> values = Lists.newArrayListWithCapacity(satisfyingHostRecords.size());
        for (Array<String> rec : satisfyingHostRecords) {
            values.add(((String[])rec.data)[0]);
        }
        return values;
    }

    private static LogicalTupleFilter buildRangeFilter(TblColRef[] hostCols, Set<Array<String>> satisfyingHostRecords) {
        int hn = hostCols.length;
        String[] min = new String[hn];
        String[] max = new String[hn];
        DerivedFilterTranslator.findMinMax(satisfyingHostRecords, hostCols, min, max);
        LogicalTupleFilter and = new LogicalTupleFilter(TupleFilter.FilterOperatorEnum.AND);
        for (int i = 0; i < hn; ++i) {
            CompareTupleFilter compMin = new CompareTupleFilter(TupleFilter.FilterOperatorEnum.GTE);
            compMin.addChild(new ColumnTupleFilter(hostCols[i]));
            compMin.addChild(new ConstantTupleFilter(min[i]));
            and.addChild(compMin);
            CompareTupleFilter compMax = new CompareTupleFilter(TupleFilter.FilterOperatorEnum.LTE);
            compMax.addChild(new ColumnTupleFilter(hostCols[i]));
            compMax.addChild(new ConstantTupleFilter(max[i]));
            and.addChild(compMax);
        }
        return and;
    }

    private static void findMinMax(Set<Array<String>> satisfyingHostRecords, TblColRef[] hostCols, String[] min, String[] max) {
        DataTypeOrder[] orders = new DataTypeOrder[hostCols.length];
        for (int i = 0; i < hostCols.length; ++i) {
            orders[i] = hostCols[i].getType().getOrder();
        }
        for (Array<String> rec : satisfyingHostRecords) {
            String[] row = (String[])rec.data;
            for (int i = 0; i < row.length; ++i) {
                min[i] = orders[i].min(min[i], row[i]);
                max[i] = orders[i].max(max[i], row[i]);
            }
        }
    }

    private static class SingleColumnTuple
    implements IEvaluatableTuple {
        private TblColRef col;
        private String value;

        SingleColumnTuple(TblColRef col) {
            this.col = col;
        }

        @Override
        public Object getValue(TblColRef col) {
            if (this.col.equals(col)) {
                return this.value;
            }
            throw new IllegalArgumentException("unexpected column " + col);
        }
    }
}

