/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.tool;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.KylinVersion;
import org.apache.kylin.common.StorageURL;
import org.apache.kylin.common.persistence.ContentReader;
import org.apache.kylin.common.persistence.JsonSerializer;
import org.apache.kylin.common.persistence.RawResource;
import org.apache.kylin.common.persistence.ResourceStore;
import org.apache.kylin.common.restclient.RestClient;
import org.apache.kylin.common.util.AbstractApplication;
import org.apache.kylin.common.util.HadoopUtil;
import org.apache.kylin.common.util.OptionsHelper;
import org.apache.kylin.cube.CubeInstance;
import org.apache.kylin.cube.CubeManager;
import org.apache.kylin.cube.CubeSegment;
import org.apache.kylin.cube.model.CubeDesc;
import org.apache.kylin.cube.model.DictionaryDesc;
import org.apache.kylin.engine.spark.metadata.cube.PathManager;
import org.apache.kylin.metadata.model.DataModelDesc;
import org.apache.kylin.metadata.model.DataModelManager;
import org.apache.kylin.metadata.model.SegmentStatusEnum;
import org.apache.kylin.metadata.model.TableDesc;
import org.apache.kylin.metadata.model.TableExtDesc;
import org.apache.kylin.metadata.model.TableRef;
import org.apache.kylin.metadata.project.ProjectInstance;
import org.apache.kylin.metadata.project.ProjectManager;
import org.apache.kylin.metadata.realization.RealizationStatusEnum;
import org.apache.kylin.metadata.realization.RealizationType;
import org.apache.kylin.tool.shaded.org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CubeMigrationCLI
extends AbstractApplication {
    private static final Logger logger = LoggerFactory.getLogger(CubeMigrationCLI.class);
    protected List<Opt> operations;
    protected KylinConfig srcConfig;
    protected KylinConfig dstConfig;
    protected ResourceStore srcStore;
    protected ResourceStore dstStore;
    protected FileSystem hdfsFs;
    protected Configuration conf;
    protected boolean doAclCopy = false;
    protected boolean doOverwrite = false;
    protected boolean doMigrateSegment = false;
    protected String dstProject;
    protected String srcHdfsWorkDir;
    protected String dstHdfsWorkDir;
    private boolean realExecute;
    private boolean purgeAndDisable;
    private OptionsHelper optHelper;
    private static final String ACL_PREFIX = "/acl/";
    private static final String GLOBAL_DICT_PREFIX = "/dict/global_dict/";
    private static final Option OPTION_SRC_CONFIG;
    private static final Option OPTION_DST_CONFIG;
    private static final Option OPTION_ALL_CUBES;
    private static final Option OPTION_CUBE;
    private static final Option OPTION_DST_PROJECT;
    private static final Option OPTION_SRC_PROJECT;
    private static final Option OPTION_COPY_ACL;
    private static final Option OPTION_PURGE_AND_DISABLE;
    private static final Option OPTION_OVERWRITE;
    private static final Option OPTION_EXECUTE;
    private static final Option OPTION_MIGRATE_SEGMENTS;

    public static void main(String[] args) throws Exception {
        CubeMigrationCLI cli = new CubeMigrationCLI();
        cli.init(args);
        cli.moveCube();
    }

    public void init(String[] args) {
        this.optHelper = new OptionsHelper();
        CubeMigrationCLI cli = new CubeMigrationCLI();
        try {
            this.optHelper.parseOptions(cli.getOptions(), args);
        }
        catch (Exception e) {
            logger.error("failed to parse arguments", e);
            this.optHelper.printUsage("CubeMigrationCLI", cli.getOptions());
            System.exit(1);
        }
        this.doAclCopy = this.optHelper.hasOption(OPTION_COPY_ACL);
        this.doOverwrite = this.optHelper.hasOption(OPTION_OVERWRITE);
        this.doMigrateSegment = this.optHelper.hasOption(OPTION_MIGRATE_SEGMENTS);
        this.purgeAndDisable = this.optHelper.hasOption(OPTION_PURGE_AND_DISABLE);
        this.srcConfig = KylinConfig.createInstanceFromUri(this.optHelper.getOptionValue(OPTION_SRC_CONFIG));
        this.srcStore = ResourceStore.getStore(this.srcConfig);
        this.dstConfig = KylinConfig.createInstanceFromUri(this.optHelper.getOptionValue(OPTION_DST_CONFIG));
        this.dstStore = ResourceStore.getStore(this.dstConfig);
        this.realExecute = this.optHelper.hasOption(OPTION_EXECUTE) ? Boolean.valueOf(this.optHelper.getOptionValue(OPTION_EXECUTE)) : true;
        this.dstProject = this.optHelper.getOptionValue(OPTION_DST_PROJECT);
        this.conf = HadoopUtil.getCurrentConfiguration();
    }

    public void moveCube() throws Exception {
        this.conf = HadoopUtil.getCurrentConfiguration();
        if (this.optHelper.hasOption(OPTION_CUBE)) {
            CubeManager cubeManager = CubeManager.getInstance(this.srcConfig);
            this.moveSingleCube(this.optHelper.getOptionValue(OPTION_CUBE), this.dstProject, cubeManager);
        } else if (this.optHelper.hasOption(OPTION_SRC_PROJECT)) {
            this.moveAllCubesUnderProject(this.optHelper.getOptionValue(OPTION_SRC_PROJECT), ProjectManager.getInstance(this.srcConfig), ProjectManager.getInstance(this.dstConfig));
        } else if (this.optHelper.hasOption(OPTION_ALL_CUBES)) {
            this.moveAllProjectAndCubes();
        }
    }

    private void moveAllCubesUnderProject(String srcProject, ProjectManager srcProjectManager, ProjectManager dstProjectManager) throws Exception {
        ProjectInstance srcProjectInstance = srcProjectManager.getProject(srcProject);
        if (StringUtils.isEmpty(this.dstProject) && null == dstProjectManager.getProject(srcProject)) {
            dstProjectManager.createProject(srcProjectInstance.getName(), srcProjectInstance.getOwner(), srcProjectInstance.getDescription(), srcProjectInstance.getOverrideKylinProps());
        }
        CubeManager cubeManager = CubeManager.getInstance(this.srcConfig);
        srcProjectInstance.getRealizationEntries(RealizationType.CUBE).forEach(cube -> {
            try {
                if (StringUtils.isEmpty(this.dstProject)) {
                    this.moveSingleCube(cube.getRealization(), srcProject, cubeManager);
                } else {
                    this.moveSingleCube(cube.getRealization(), this.dstProject, cubeManager);
                }
            }
            catch (Exception e) {
                logger.error("failed to move cube: {}", (Object)cube.getRealization(), (Object)e);
            }
        });
    }

    private void moveAllProjectAndCubes() throws Exception {
        ProjectManager srcProjectManager = ProjectManager.getInstance(this.srcConfig);
        List<ProjectInstance> projects = srcProjectManager.listAllProjects();
        for (ProjectInstance project : projects) {
            this.moveAllCubesUnderProject(project.getName(), srcProjectManager, ProjectManager.getInstance(this.dstConfig));
        }
    }

    private void moveSingleCube(String cubeName, String dstProject, CubeManager cubeManager) throws IOException, InterruptedException {
        ProjectManager dstProjectManager;
        ProjectInstance instance;
        CubeInstance cube = cubeManager.getCube(cubeName);
        if (StringUtils.isEmpty(dstProject)) {
            dstProject = cube.getProject();
        }
        if (null == (instance = (dstProjectManager = ProjectManager.getInstance(this.dstConfig)).getProject(dstProject))) {
            ProjectManager scrProjectManager = ProjectManager.getInstance(this.srcConfig);
            ProjectInstance originProject = scrProjectManager.getProject(cube.getProject());
            dstProjectManager.createProject(dstProject, originProject.getOwner(), originProject.getDescription(), originProject.getOverrideKylinProps());
        }
        if (null == cube) {
            logger.warn("source cube: {} not exists", (Object)cubeName);
            return;
        }
        this.srcHdfsWorkDir = this.srcConfig.getHdfsWorkingDirectory(dstProject);
        this.dstHdfsWorkDir = this.dstConfig.getHdfsWorkingDirectory(dstProject);
        logger.info("cube to be moved is : " + cubeName);
        if (this.doMigrateSegment) {
            this.checkCubeState(cube);
            KylinVersion srcVersion = new KylinVersion(cube.getVersion());
            if (srcVersion.major != KylinVersion.getCurrentVersion().major) {
                throw new IllegalArgumentException(String.format(Locale.ROOT, "can not migrate segment data from version: %s  to version: %s", srcVersion.toString(), KylinVersion.getCurrentVersion().toString()));
            }
        }
        this.checkAndGetMetadataUrl();
        this.hdfsFs = HadoopUtil.getWorkingFileSystem();
        this.operations = new ArrayList<Opt>();
        this.copyFilesInMetaStore(cube, dstProject);
        if (!this.doMigrateSegment) {
            this.clearSegments(cubeName);
        }
        this.addCubeAndModelIntoProject(cube, cubeName, dstProject);
        if (this.doMigrateSegment && this.purgeAndDisable) {
            this.purgeAndDisable(cubeName);
        }
        if (this.realExecute) {
            this.doOpts();
            this.updateMeta(this.dstConfig, dstProject, cubeName, cube.getModel());
        } else {
            this.showOpts();
        }
    }

    protected void checkCubeState(CubeInstance cube) {
        if (cube.getStatus() != RealizationStatusEnum.READY) {
            throw new IllegalStateException("Cannot migrate cube that is not in READY state.");
        }
        for (CubeSegment segment : cube.getSegments()) {
            if (segment.getStatus() == SegmentStatusEnum.READY) continue;
            throw new IllegalStateException("At least one segment is not in READY state");
        }
    }

    protected void checkAndGetMetadataUrl() {
        StorageURL srcMetadataUrl = this.srcConfig.getMetadataUrl();
        StorageURL dstMetadataUrl = this.dstConfig.getMetadataUrl();
        logger.info("src metadata url is " + srcMetadataUrl);
        logger.info("dst metadata url is " + dstMetadataUrl);
    }

    protected void clearSegments(String cubeName) throws IOException {
        this.operations.add(new Opt(OptType.CLEAR_SEGMENTS, new Object[]{cubeName}, null));
    }

    protected void copyFilesInMetaStore(CubeInstance cube, String dstProject) throws IOException {
        if (this.dstStore.exists(cube.getResourcePath()) && !this.doOverwrite) {
            throw new IllegalStateException("The cube named " + cube.getName() + " already exists on target metadata store. Use overwriteIfExists to overwrite it");
        }
        ArrayList<String> metaItems = new ArrayList<String>();
        ArrayList<String> srcParquetFiles = new ArrayList<String>();
        ArrayList<String> dstParquetFiles = new ArrayList<String>();
        HashSet<String> dictAndSnapshot = new HashSet<String>();
        this.listCubeRelatedResources(cube, metaItems, dictAndSnapshot, srcParquetFiles, dstParquetFiles);
        for (String item : metaItems) {
            this.operations.add(new Opt(OptType.COPY_FILE_IN_META, new Object[]{item}, dstProject));
        }
        if (this.doMigrateSegment) {
            for (String item : dictAndSnapshot) {
                this.operations.add(new Opt(OptType.COPY_DICT_OR_SNAPSHOT, new Object[]{item, cube.getName()}, dstProject));
            }
            for (int i = 0; i < srcParquetFiles.size(); ++i) {
                this.operations.add(new Opt(OptType.COPY_PARQUET_FILE, new Object[]{srcParquetFiles.get(i), dstParquetFiles.get(i)}, dstProject));
            }
        }
    }

    protected void addCubeAndModelIntoProject(CubeInstance srcCube, String cubeName, String dstProject) throws IOException {
        String projectResPath = ProjectInstance.concatResourcePath(dstProject);
        if (!this.dstStore.exists(projectResPath)) {
            throw new IllegalStateException("The target project " + dstProject + " does not exist");
        }
        this.operations.add(new Opt(OptType.ADD_INTO_PROJECT, new Object[]{srcCube, cubeName}, dstProject));
    }

    private void purgeAndDisable(String cubeName) throws IOException {
        this.operations.add(new Opt(OptType.PURGE_AND_DISABLE, new Object[]{cubeName}, null));
    }

    private List<String> getCompatibleTablePath(Set<TableRef> tableRefs, String project, String rootPath) throws IOException {
        ArrayList<String> toResource = new ArrayList<String>();
        List<String> paths = this.srcStore.collectResourceRecursively(rootPath, ".json");
        HashMap<String, String> tableMap = new HashMap<String, String>();
        for (String string : paths) {
            for (TableRef tableRef : tableRefs) {
                String tableId = tableRef.getTableIdentity();
                if (!string.contains(tableId)) continue;
                String prj = TableDesc.parseResourcePath(string).getProject();
                if (prj == null && tableMap.get(tableId) == null) {
                    tableMap.put(tableRef.getTableIdentity(), string);
                }
                if (prj == null || !prj.contains(project)) continue;
                tableMap.put(tableRef.getTableIdentity(), string);
            }
        }
        for (Map.Entry entry : tableMap.entrySet()) {
            toResource.add((String)entry.getValue());
        }
        return toResource;
    }

    protected void listCubeRelatedResources(CubeInstance cube, List<String> metaResource, Set<String> dictAndSnapshot, List<String> srcParquetFiles, List<String> dstParquetFiles) throws IOException {
        CubeDesc cubeDesc = cube.getDescriptor();
        String prj = cubeDesc.getProject();
        metaResource.add(cube.getResourcePath());
        metaResource.add(cubeDesc.getResourcePath());
        metaResource.add(DataModelDesc.concatResourcePath(cubeDesc.getModelName()));
        Set<TableRef> tblRefs = cubeDesc.getModel().getAllTables();
        metaResource.addAll(this.getCompatibleTablePath(tblRefs, prj, "/table"));
        metaResource.addAll(this.getCompatibleTablePath(tblRefs, prj, "/table_exd"));
        if (this.doMigrateSegment) {
            for (DictionaryDesc dictionaryDesc : cubeDesc.getDictionaries()) {
                String[] columnInfo = dictionaryDesc.getColumnRef().getColumnWithTable().split("\\.");
                String globalDictPath = columnInfo.length == 3 ? cube.getProject() + GLOBAL_DICT_PREFIX + columnInfo[1] + File.separator + columnInfo[2] : cube.getProject() + GLOBAL_DICT_PREFIX + columnInfo[0] + File.separator + columnInfo[1];
                if (globalDictPath == null) continue;
                logger.info("Add " + globalDictPath + " to migrate dict list");
                dictAndSnapshot.add(globalDictPath);
            }
            for (CubeSegment segment : cube.getSegments()) {
                metaResource.add(segment.getStatisticsResourcePath());
                dictAndSnapshot.addAll(segment.getSnapshotPaths());
                srcParquetFiles.add(PathManager.getSegmentParquetStoragePath(this.srcHdfsWorkDir, cube.getName(), segment));
                dstParquetFiles.add(PathManager.getSegmentParquetStoragePath(this.dstHdfsWorkDir, cube.getName(), segment));
                logger.info("Add " + PathManager.getSegmentParquetStoragePath(cube, segment.getName(), segment.getStorageLocationIdentifier()) + " to migrate parquet file list");
            }
        }
        if (this.doAclCopy) {
            metaResource.add(ACL_PREFIX + cube.getUuid());
            metaResource.add(ACL_PREFIX + cube.getModel().getUuid());
        }
    }

    @Override
    protected Options getOptions() {
        Options options = new Options();
        options.addOption(OPTION_SRC_CONFIG);
        options.addOption(OPTION_DST_CONFIG);
        OptionGroup srcGroup = new OptionGroup();
        srcGroup.addOption(OPTION_ALL_CUBES);
        srcGroup.addOption(OPTION_CUBE);
        srcGroup.addOption(OPTION_SRC_PROJECT);
        srcGroup.setRequired(true);
        options.addOptionGroup(srcGroup);
        options.addOption(OPTION_DST_PROJECT);
        options.addOption(OPTION_OVERWRITE);
        options.addOption(OPTION_COPY_ACL);
        options.addOption(OPTION_PURGE_AND_DISABLE);
        options.addOption(OPTION_EXECUTE);
        options.addOption(OPTION_MIGRATE_SEGMENTS);
        return options;
    }

    @Override
    protected void execute(OptionsHelper optionsHelper) throws Exception {
    }

    protected void addOpt(OptType type, Object[] params, String dstProject) {
        this.operations.add(new Opt(type, params, dstProject));
    }

    private void showOpts() {
        for (int i = 0; i < this.operations.size(); ++i) {
            this.showOpt(this.operations.get(i));
        }
    }

    private void showOpt(Opt opt) {
        logger.info("Operation: " + opt.toString());
    }

    protected void doOpts() throws IOException, InterruptedException {
        try {
            for (int index = 0; index < this.operations.size(); ++index) {
                logger.info("Operation index :" + index);
                this.doOpt(this.operations.get(index));
            }
        }
        catch (Exception e) {
            logger.error("error met", e);
            logger.info("Try undoing previous changes");
            for (int i = index; i >= 0; --i) {
                try {
                    this.undo(this.operations.get(i));
                    continue;
                }
                catch (Exception ee) {
                    logger.error("error met ", e);
                    logger.info("Continue undoing...");
                }
            }
            throw new RuntimeException("Cube moving failed");
        }
    }

    private void doOpt(Opt opt) throws IOException, InterruptedException {
        logger.info("Executing operation: " + opt.toString());
        switch (opt.type) {
            case COPY_FILE_IN_META: {
                String item = (String)opt.params[0];
                RawResource res = this.srcStore.getResource(item);
                if (res == null) {
                    logger.info("Item: {} doesn't exist, ignore it.", (Object)item);
                    break;
                }
                if (item.startsWith("/model_desc")) {
                    DataModelDesc dataModelDesc = this.srcStore.getResource(item, DataModelManager.getInstance(this.srcConfig).getDataModelSerializer());
                    List<ProjectInstance> projectContainsModel = ProjectManager.getInstance(this.dstConfig).findProjectsByModel(dataModelDesc.getName());
                    if (projectContainsModel.size() > 1) {
                        throw new RuntimeException(String.format(Locale.ROOT, "model: %s belongs to several projects: %s", dataModelDesc.getName(), Arrays.toString(projectContainsModel.toArray())));
                    }
                    if (projectContainsModel.size() == 1 && !opt.dstProject.equals(projectContainsModel.get(0).getName())) {
                        throw new IllegalArgumentException(String.format(Locale.ROOT, "there already exists model: %s in project: %s, can't create model with the same name in dest project: %s", dataModelDesc.getName(), projectContainsModel.get(0).getName(), opt.dstProject));
                    }
                    if (dataModelDesc != null && dataModelDesc.getProjectName() != null && !dataModelDesc.getProjectName().equals(opt.dstProject)) {
                        dataModelDesc.setProjectName(opt.dstProject);
                        this.dstStore.putResource(item, dataModelDesc, res.lastModified(), DataModelManager.getInstance(this.srcConfig).getDataModelSerializer());
                        logger.info("Item " + item + " is copied.");
                        res.close();
                        break;
                    }
                }
                if (item.startsWith("/cube_desc")) {
                    JsonSerializer<CubeDesc> serializer = new JsonSerializer<CubeDesc>(CubeDesc.class, false);
                    ContentReader<CubeDesc> reader = new ContentReader<CubeDesc>(serializer);
                    CubeDesc cubeDesc = reader.readContent(res);
                    cubeDesc.setStorageType(4);
                    cubeDesc.setEngineType(6);
                    cubeDesc.setVersion(KylinVersion.getCurrentVersion().toString());
                    cubeDesc.setSignature(cubeDesc.calculateSignature());
                    ByteArrayOutputStream buf = new ByteArrayOutputStream();
                    DataOutputStream dout = new DataOutputStream(buf);
                    serializer.serialize(cubeDesc, dout);
                    this.dstStore.putResource(item, new ByteArrayInputStream(buf.toByteArray()), res.lastModified());
                    dout.close();
                    buf.close();
                    res.close();
                    break;
                }
                this.dstStore.putResource(this.renameTableWithinProject(item), res.content(), res.lastModified());
                res.close();
                logger.info("Item " + item + " is copied");
                break;
            }
            case COPY_DICT_OR_SNAPSHOT: {
                String item = (String)opt.params[0];
                String itemPath = item.substring(item.substring(0, item.indexOf("/")).length() + 1);
                Path srcPath = new Path(this.srcHdfsWorkDir + itemPath);
                Path dstPath = new Path(this.dstHdfsWorkDir + itemPath);
                if (this.hdfsFs.exists(srcPath)) {
                    FileUtil.copy((FileSystem)this.hdfsFs, (Path)srcPath, (FileSystem)this.hdfsFs, (Path)dstPath, (boolean)false, (boolean)true, (Configuration)this.conf);
                    logger.info("Copy " + srcPath + " to " + dstPath);
                    break;
                }
                logger.info("Dict or snapshot " + srcPath + " is not exists, ignore it");
                break;
            }
            case COPY_PARQUET_FILE: {
                Path srcPath = new Path((String)opt.params[0]);
                Path dstPath = new Path((String)opt.params[1]);
                if (this.hdfsFs.exists(srcPath)) {
                    FileUtil.copy((FileSystem)this.hdfsFs, (Path)srcPath, (FileSystem)this.hdfsFs, (Path)dstPath, (boolean)false, (boolean)true, (Configuration)this.conf);
                    logger.info("Copy " + srcPath + " to " + dstPath);
                    break;
                }
                logger.info("Parquet file " + srcPath + " is not exists, ignore it");
                break;
            }
            case ADD_INTO_PROJECT: {
                CubeInstance srcCube = (CubeInstance)opt.params[0];
                String cubeName = (String)opt.params[1];
                String projectName = opt.dstProject;
                String modelName = srcCube.getDescriptor().getModelName();
                String projectResPath = ProjectInstance.concatResourcePath(projectName);
                JsonSerializer<ProjectInstance> projectSerializer = new JsonSerializer<ProjectInstance>(ProjectInstance.class);
                ProjectInstance project = this.dstStore.getResource(projectResPath, projectSerializer);
                for (TableRef tableRef : srcCube.getModel().getAllTables()) {
                    project.addTable(tableRef.getTableIdentity());
                }
                if (!project.getModels().contains(modelName)) {
                    project.addModel(modelName);
                }
                project.removeRealization(RealizationType.CUBE, cubeName);
                project.addRealizationEntry(RealizationType.CUBE, cubeName);
                this.dstStore.checkAndPutResource(projectResPath, project, projectSerializer);
                logger.info("Project instance for " + projectName + " is corrected");
                break;
            }
            case CLEAR_SEGMENTS: {
                String cubeName = (String)opt.params[0];
                String cubeInstancePath = CubeInstance.concatResourcePath(cubeName);
                JsonSerializer<CubeInstance> cubeInstanceSerializer = new JsonSerializer<CubeInstance>(CubeInstance.class);
                CubeInstance cubeInstance = this.dstStore.getResource(cubeInstancePath, cubeInstanceSerializer);
                cubeInstance.getSegments().clear();
                cubeInstance.clearCuboids();
                cubeInstance.setCreateTimeUTC(System.currentTimeMillis());
                cubeInstance.setStatus(RealizationStatusEnum.DISABLED);
                this.dstStore.checkAndPutResource(cubeInstancePath, cubeInstance, cubeInstanceSerializer);
                logger.info("Cleared segments for " + cubeName + ", since segments has not been copied");
                break;
            }
            case PURGE_AND_DISABLE: {
                String cubeName = (String)opt.params[0];
                String cubeResPath = CubeInstance.concatResourcePath(cubeName);
                JsonSerializer<CubeInstance> cubeSerializer = new JsonSerializer<CubeInstance>(CubeInstance.class);
                CubeInstance cube = this.srcStore.getResource(cubeResPath, cubeSerializer);
                cube.getSegments().clear();
                cube.setStatus(RealizationStatusEnum.DISABLED);
                this.srcStore.checkAndPutResource(cubeResPath, cube, cubeSerializer);
                logger.info("Cube " + cubeName + " is purged and disabled in " + this.srcConfig.getMetadataUrl());
                break;
            }
        }
    }

    private void undo(Opt opt) throws IOException, InterruptedException {
        logger.info("Undo operation: " + opt.toString());
        switch (opt.type) {
            case COPY_FILE_IN_META: {
                logger.info("Undo for COPY_FILE_IN_META is ignored");
                String item = (String)opt.params[0];
                if (!item.startsWith(ACL_PREFIX) || !this.doAclCopy) break;
                logger.info("Remove acl record");
                this.dstStore.deleteResource(item);
                break;
            }
            case COPY_DICT_OR_SNAPSHOT: {
                logger.info("Undo for COPY_DICT_OR_SNAPSHOT is ignored");
                break;
            }
            case ADD_INTO_PROJECT: {
                logger.info("Undo for ADD_INTO_PROJECT is ignored");
                break;
            }
            case PURGE_AND_DISABLE: {
                logger.info("Undo for PURGE_AND_DISABLE is not supported");
                break;
            }
            case COPY_PARQUET_FILE: {
                logger.info("Undo for COPY_PARQUET_FILE is ignored");
                break;
            }
        }
    }

    private String renameTableWithinProject(String srcItem) {
        if (this.dstProject != null && srcItem.startsWith("/table")) {
            String tableIdentity = TableDesc.parseResourcePath(srcItem).getTable();
            if (srcItem.contains("/table_exd")) {
                return TableExtDesc.concatResourcePath(tableIdentity, this.dstProject);
            }
            return "/table/" + tableIdentity + "--" + this.dstProject + ".json";
        }
        return srcItem;
    }

    private void updateMeta(KylinConfig config, String projectName, String cubeName, DataModelDesc model) {
        String[] nodes = config.getRestServers();
        HashMap<String, String> tableToProjects = new HashMap<String, String>();
        for (TableRef tableRef : model.getAllTables()) {
            tableToProjects.put(tableRef.getTableIdentity(), tableRef.getTableDesc().getProject());
        }
        for (String node : nodes) {
            RestClient restClient = new RestClient(node);
            try {
                logger.info("update meta cache for " + node);
                restClient.clearCacheForCubeMigration(cubeName, projectName, model.getName(), tableToProjects);
            }
            catch (IOException e) {
                logger.error(e.getMessage());
            }
        }
    }

    static {
        OptionBuilder.isRequired((boolean)true);
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"The KylinConfig of the cube\u2019s source");
        OPTION_SRC_CONFIG = OptionBuilder.create((String)"srcConfig");
        OptionBuilder.isRequired((boolean)true);
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"The KylinConfig of the cube\u2019s new home");
        OPTION_DST_CONFIG = OptionBuilder.create((String)"dstConfig");
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.withDescription((String)"migrate all cubes meta from source cluster");
        OPTION_ALL_CUBES = OptionBuilder.create((String)"allCubes");
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Cube name to migrate");
        OPTION_CUBE = OptionBuilder.create((String)"cube");
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"cube's new project home, if not set, keep the same as source cluster");
        OPTION_DST_PROJECT = OptionBuilder.create((String)"dstProject");
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"source project to migrate");
        OPTION_SRC_PROJECT = OptionBuilder.create((String)"srcProject");
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"copy ACL");
        OPTION_COPY_ACL = OptionBuilder.create((String)"copyAcl");
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.withDescription((String)"purge source cluster data");
        OPTION_PURGE_AND_DISABLE = OptionBuilder.create((String)"purgeAndDisable");
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.withDescription((String)"overwrite target cluster's meta if exists");
        OPTION_OVERWRITE = OptionBuilder.create((String)"overwriteIfExists");
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"execute migration");
        OPTION_EXECUTE = OptionBuilder.create((String)"realMigrate");
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.withDescription((String)"migrate segment data");
        OPTION_MIGRATE_SEGMENTS = OptionBuilder.create((String)"migrateSegment");
    }

    private class Opt {
        private OptType type;
        private Object[] params;
        private String dstProject;

        private Opt(OptType type, Object[] params, String dstProject) {
            this.type = type;
            this.params = params;
            this.dstProject = dstProject;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append((Object)this.type).append(":");
            for (Object s : this.params) {
                sb.append(s).append(", ");
            }
            sb.append(this.dstProject);
            return sb.toString();
        }
    }

    protected static enum OptType {
        COPY_FILE_IN_META,
        COPY_DICT_OR_SNAPSHOT,
        COPY_PARQUET_FILE,
        ADD_INTO_PROJECT,
        PURGE_AND_DISABLE,
        CLEAR_SEGMENTS;

    }
}

