/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.tool.extractor;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.CliCommandExecutor;
import org.apache.kylin.common.util.OptionsHelper;
import org.apache.kylin.common.util.Pair;
import org.apache.kylin.shaded.com.google.common.io.Files;
import org.apache.kylin.tool.extractor.AbstractInfoExtractor;
import org.apache.kylin.tool.extractor.NamedThreadFactory;
import org.apache.kylin.tool.shaded.org.apache.commons.io.FileUtils;
import org.apache.kylin.tool.shaded.org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientEnvExtractor
extends AbstractInfoExtractor {
    private static final Logger logger = LoggerFactory.getLogger(ClientEnvExtractor.class);
    private KylinConfig kylinConfig;
    private CliCommandExecutor cmdExecutor;
    private ExecutorService executorService = Executors.newFixedThreadPool(3, new NamedThreadFactory("ClientEnv"));
    public int maxWaitSeconds = 150;

    public ClientEnvExtractor() {
        this.packageType = "client";
        this.kylinConfig = KylinConfig.getInstanceFromEnv();
        this.cmdExecutor = this.kylinConfig.getCliCommandExecutor();
    }

    @Override
    protected void executeExtract(OptionsHelper optionsHelper, File exportDir) throws Exception {
        this.addLocalFile("/sys/kernel/mm/transparent_hugepage/defrag", "linux/transparent_hugepage");
        this.addLocalFile("/proc/sys/vm/swappiness", "linux/swappiness");
        this.addLocalFile("/proc/cpuinfo", "linux");
        this.addShellOutput("lsb_release -a", "linux", "lsb_release");
        this.addShellOutput("df -h", "linux", "disk_usage");
        this.addShellOutput("free -m", "linux", "mem_usage_mb");
        this.addShellOutput("top -b -n 1 | head -n 30", "linux", "top");
        this.addShellOutput("ps aux|grep kylin", "linux", "kylin_processes");
        this.addShellOutput("hadoop version", "hadoop", "version");
        this.addShellOutput("hbase version", "hbase", "version");
        this.addShellOutput("hive --version", "hive", "version");
        this.addShellOutput("klist", "kerberos", "klist");
        this.addShellOutput("beeline --version", "hive", "beeline_version");
        logger.info("ClientEnvExtractor is shutting downing. ");
        this.executorService.awaitTermination(this.maxWaitSeconds, TimeUnit.SECONDS);
    }

    private void addLocalFile(String src, String destDir) {
        try {
            File srcFile = new File(src);
            File destDirFile = null;
            if (!StringUtils.isEmpty(destDir)) {
                destDirFile = new File(this.exportDir, destDir);
                FileUtils.forceMkdir(destDirFile);
            } else {
                destDirFile = this.exportDir;
            }
            FileUtils.forceMkdir(destDirFile);
            Files.copy(srcFile, new File(destDirFile, srcFile.getName()));
        }
        catch (Exception e) {
            logger.warn("Failed to copy " + src + ".", e);
        }
    }

    public void addShellOutput(String cmd, String destDir, String filename) {
        Future<?> f = this.executorService.submit(() -> {
            try {
                File destDirFile = null;
                if (!StringUtils.isEmpty(destDir)) {
                    destDirFile = new File(this.exportDir, destDir);
                    FileUtils.forceMkdir(destDirFile);
                } else {
                    destDirFile = this.exportDir;
                }
                logger.debug("Will execute {}", (Object)cmd);
                Pair<Integer, String> result = this.cmdExecutor.execute(cmd);
                String output = result.getSecond();
                logger.debug("Execute command {} return {}", (Object)cmd, (Object)result.getFirst());
                FileUtils.writeStringToFile(new File(destDirFile, filename), output, Charset.defaultCharset());
            }
            catch (IOException e) {
                logger.warn("Failed to run command: " + cmd + ".", e);
            }
        });
        try {
            f.get(this.maxWaitSeconds, TimeUnit.SECONDS);
        }
        catch (InterruptedException | TimeoutException timeoutException) {
            logger.error("Timeout for \"{}\" in {} seconds.", (Object)cmd, (Object)this.maxWaitSeconds);
            f.cancel(true);
            this.executorService.shutdownNow();
        }
        catch (ExecutionException runtimeException) {
            logger.error("Runtime error: {}", (Object)runtimeException.getLocalizedMessage());
            this.executorService.shutdownNow();
        }
    }

    public static void main(String[] args) {
        ClientEnvExtractor extractor = new ClientEnvExtractor();
        extractor.execute(args);
    }
}

