/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.tool.extractor;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.OptionGroup;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.persistence.ResourceStore;
import org.apache.kylin.common.persistence.ResourceTool;
import org.apache.kylin.common.util.OptionsHelper;
import org.apache.kylin.common.util.StringUtil;
import org.apache.kylin.cube.CubeDescManager;
import org.apache.kylin.cube.CubeInstance;
import org.apache.kylin.cube.CubeManager;
import org.apache.kylin.cube.CubeSegment;
import org.apache.kylin.cube.model.CubeDesc;
import org.apache.kylin.job.dao.ExecutableDao;
import org.apache.kylin.job.dao.ExecutablePO;
import org.apache.kylin.job.exception.PersistentException;
import org.apache.kylin.metadata.TableMetadataManager;
import org.apache.kylin.metadata.badquery.BadQueryHistoryManager;
import org.apache.kylin.metadata.model.DataModelDesc;
import org.apache.kylin.metadata.model.DataModelManager;
import org.apache.kylin.metadata.model.SegmentStatusEnum;
import org.apache.kylin.metadata.model.TableRef;
import org.apache.kylin.metadata.project.ProjectInstance;
import org.apache.kylin.metadata.project.ProjectManager;
import org.apache.kylin.metadata.project.RealizationEntry;
import org.apache.kylin.metadata.realization.IRealization;
import org.apache.kylin.metadata.realization.RealizationRegistry;
import org.apache.kylin.metadata.realization.RealizationStatusEnum;
import org.apache.kylin.metadata.realization.RealizationType;
import org.apache.kylin.metadata.streaming.StreamingManager;
import org.apache.kylin.shaded.com.google.common.base.Preconditions;
import org.apache.kylin.shaded.com.google.common.collect.Lists;
import org.apache.kylin.shaded.com.google.common.collect.Sets;
import org.apache.kylin.storage.hybrid.HybridInstance;
import org.apache.kylin.storage.hybrid.HybridManager;
import org.apache.kylin.tool.extractor.AbstractInfoExtractor;
import org.apache.kylin.tool.shaded.com.fasterxml.jackson.core.JsonProcessingException;
import org.apache.kylin.tool.shaded.com.fasterxml.jackson.databind.JsonNode;
import org.apache.kylin.tool.shaded.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.kylin.tool.shaded.com.fasterxml.jackson.databind.SerializationFeature;
import org.apache.kylin.tool.shaded.com.fasterxml.jackson.databind.node.ObjectNode;
import org.apache.kylin.tool.shaded.org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CubeMetaExtractor
extends AbstractInfoExtractor {
    private static final Logger logger = LoggerFactory.getLogger(CubeMetaExtractor.class);
    private static final Option OPTION_CUBE;
    private static final Option OPTION_HYBRID;
    private static final Option OPTION_PROJECT;
    private static final Option OPTION_All_PROJECT;
    private static final Option OPTION_STORAGE_TYPE;
    private static final Option OPTION_ENGINE_TYPE;
    private static final Option OPTION_INCLUDE_SEGMENTS;
    private static final Option OPTION_INCLUDE_JOB;
    private static final Option OPTION_INCLUDE_ONLY_JOB_OUTPUT;
    private static final Option OPTION_INCLUDE_SEGMENT_DETAILS;
    private KylinConfig kylinConfig;
    private DataModelManager metadataManager;
    private ProjectManager projectManager;
    private HybridManager hybridManager;
    private CubeManager cubeManager;
    private StreamingManager streamingManager;
    private CubeDescManager cubeDescManager;
    private ExecutableDao executableDao;
    private RealizationRegistry realizationRegistry;
    private BadQueryHistoryManager badQueryHistoryManager;
    private String exportPath;
    private boolean includeSegments;
    private boolean includeJobs;
    private boolean includeSegmentDetails;
    private boolean onlyJobOutput;
    private String storageType = null;
    private String engineType = null;
    private Set<String> requiredResources = Sets.newLinkedHashSet();
    private Set<String> optionalResources = Sets.newLinkedHashSet();
    private Set<CubeInstance> cubesToTrimAndSave = Sets.newLinkedHashSet();

    public CubeMetaExtractor() {
        OptionGroup realizationOrProject = new OptionGroup();
        realizationOrProject.addOption(OPTION_CUBE);
        realizationOrProject.addOption(OPTION_PROJECT);
        realizationOrProject.addOption(OPTION_HYBRID);
        realizationOrProject.addOption(OPTION_All_PROJECT);
        realizationOrProject.setRequired(true);
        this.options.addOptionGroup(realizationOrProject);
        this.options.addOption(OPTION_INCLUDE_SEGMENTS);
        this.options.addOption(OPTION_INCLUDE_JOB);
        this.options.addOption(OPTION_INCLUDE_SEGMENT_DETAILS);
        this.options.addOption(OPTION_INCLUDE_ONLY_JOB_OUTPUT);
        this.options.addOption(OPTION_STORAGE_TYPE);
        this.options.addOption(OPTION_ENGINE_TYPE);
    }

    @Override
    protected void executeExtract(OptionsHelper optionsHelper, File exportDir) throws Exception {
        this.includeSegments = optionsHelper.hasOption(OPTION_INCLUDE_SEGMENTS) ? Boolean.parseBoolean(optionsHelper.getOptionValue(OPTION_INCLUDE_SEGMENTS)) : true;
        this.includeJobs = optionsHelper.hasOption(OPTION_INCLUDE_JOB) ? Boolean.parseBoolean(optionsHelper.getOptionValue(OPTION_INCLUDE_JOB)) : false;
        this.includeSegmentDetails = optionsHelper.hasOption(OPTION_INCLUDE_SEGMENT_DETAILS) ? Boolean.parseBoolean(optionsHelper.getOptionValue(OPTION_INCLUDE_SEGMENT_DETAILS)) : false;
        this.onlyJobOutput = optionsHelper.hasOption(OPTION_INCLUDE_ONLY_JOB_OUTPUT) ? Boolean.parseBoolean(optionsHelper.getOptionValue(OPTION_INCLUDE_ONLY_JOB_OUTPUT)) : true;
        this.storageType = optionsHelper.hasOption(OPTION_STORAGE_TYPE) ? optionsHelper.getOptionValue(OPTION_STORAGE_TYPE) : null;
        this.engineType = optionsHelper.hasOption(OPTION_ENGINE_TYPE) ? optionsHelper.getOptionValue(OPTION_ENGINE_TYPE) : null;
        this.exportPath = exportDir.getAbsolutePath();
        this.kylinConfig = KylinConfig.getInstanceFromEnv();
        this.metadataManager = DataModelManager.getInstance(this.kylinConfig);
        this.projectManager = ProjectManager.getInstance(this.kylinConfig);
        this.hybridManager = HybridManager.getInstance(this.kylinConfig);
        this.cubeManager = CubeManager.getInstance(this.kylinConfig);
        this.cubeDescManager = CubeDescManager.getInstance(this.kylinConfig);
        this.executableDao = ExecutableDao.getInstance(this.kylinConfig);
        this.realizationRegistry = RealizationRegistry.getInstance(this.kylinConfig);
        this.badQueryHistoryManager = BadQueryHistoryManager.getInstance(this.kylinConfig);
        this.addRequired("/UUID");
        if (optionsHelper.hasOption(OPTION_All_PROJECT)) {
            for (ProjectInstance projectInstance : this.projectManager.listAllProjects()) {
                this.requireProject(projectInstance);
            }
        } else if (optionsHelper.hasOption(OPTION_PROJECT)) {
            String projectNames = optionsHelper.getOptionValue(OPTION_PROJECT);
            for (String projectName : StringUtil.splitByComma(projectNames)) {
                ProjectInstance projectInstance = this.projectManager.getProject(projectName);
                Preconditions.checkNotNull(projectInstance, "Project " + projectName + " does not exist.");
                this.requireProject(projectInstance);
            }
        } else if (optionsHelper.hasOption(OPTION_CUBE)) {
            String cubeNames = optionsHelper.getOptionValue(OPTION_CUBE);
            for (String cubeName : StringUtil.splitByComma(cubeNames)) {
                IRealization realization = this.cubeManager.getRealization(cubeName);
                if (realization == null) {
                    throw new IllegalArgumentException("No cube found with name of " + cubeName);
                }
                this.retrieveResourcePath(realization);
            }
        } else if (optionsHelper.hasOption(OPTION_HYBRID)) {
            String hybridNames = optionsHelper.getOptionValue(OPTION_HYBRID);
            for (String hybridName : StringUtil.splitByComma(hybridNames)) {
                IRealization realization = this.hybridManager.getRealization(hybridName);
                if (realization == null) {
                    throw new IllegalArgumentException("No hybrid found with name of" + hybridName);
                }
                this.retrieveResourcePath(realization);
            }
        }
        this.executeExtraction(exportDir.getAbsolutePath());
        this.engineOverwrite(new File(exportDir.getAbsolutePath()));
    }

    public String getExportPath() {
        return this.exportPath;
    }

    private void requireProject(ProjectInstance projectInstance) throws IOException {
        this.addRequired(projectInstance.getResourcePath());
        List<RealizationEntry> realizationEntries = projectInstance.getRealizationEntries();
        for (RealizationEntry realizationEntry : realizationEntries) {
            this.retrieveResourcePath(this.getRealization(realizationEntry));
        }
        List<DataModelDesc> modelDescs = this.metadataManager.getModels(projectInstance.getName());
        for (DataModelDesc modelDesc : modelDescs) {
            this.addRequired(DataModelDesc.concatResourcePath(modelDesc.getName()));
        }
        this.addOptional(this.badQueryHistoryManager.getBadQueriesForProject(projectInstance.getName()).getResourcePath());
    }

    private void executeExtraction(String dest) {
        logger.info("The resource paths going to be extracted:");
        for (String s : this.requiredResources) {
            logger.info("{} is required resources.", (Object)s);
        }
        for (String s : this.optionalResources) {
            logger.info("{} is optional resources.", (Object)s);
        }
        for (CubeInstance cube : this.cubesToTrimAndSave) {
            logger.info("Cube {} will be trimmed and extracted", (Object)cube);
        }
        try {
            KylinConfig srcConfig = KylinConfig.getInstanceFromEnv();
            KylinConfig dstConfig = KylinConfig.createInstanceFromUri(dest);
            new ResourceTool().copy(srcConfig, dstConfig, Lists.newArrayList(this.requiredResources), true);
            for (String r : this.optionalResources) {
                try {
                    new ResourceTool().copy(srcConfig, dstConfig, Lists.newArrayList(r), true);
                }
                catch (Exception e) {
                    logger.warn("Exception when copying optional resource {}. May be caused by resource missing. skip it.", (Object)r);
                }
            }
            ResourceStore dstStore = ResourceStore.getStore(dstConfig);
            for (CubeInstance cube : this.cubesToTrimAndSave) {
                CubeInstance trimmedCube = CubeInstance.getCopyOf(cube);
                trimmedCube.getSegments().clear();
                trimmedCube.setUuid(cube.getUuid());
                dstStore.checkAndPutResource(trimmedCube.getResourcePath(), trimmedCube, CubeManager.CUBE_SERIALIZER);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Exception", e);
        }
    }

    private void engineOverwrite(File dest) throws IOException {
        if (this.engineType != null || this.storageType != null) {
            for (File f : Objects.requireNonNull(dest.listFiles())) {
                if (f.isDirectory()) {
                    this.engineOverwrite(f);
                    continue;
                }
                this.engineOverwriteInternal(f);
            }
        }
    }

    private void engineOverwriteInternal(File f) throws IOException {
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            JsonNode rootNode = objectMapper.readTree(f);
            boolean replaced = false;
            if (this.engineType != null && rootNode.get("engine_type") != null) {
                ((ObjectNode)rootNode).put("engine_type", Integer.parseInt(this.engineType));
                replaced = true;
            }
            if (this.storageType != null && rootNode.get("storage_type") != null) {
                ((ObjectNode)rootNode).put("storage_type", Integer.parseInt(this.storageType));
                replaced = true;
            }
            if (replaced) {
                objectMapper.enable(SerializationFeature.INDENT_OUTPUT);
                objectMapper.writeValue(f, (Object)rootNode);
            }
        }
        catch (JsonProcessingException ex) {
            logger.warn("cannot parse file {}", (Object)f);
        }
    }

    private IRealization getRealization(RealizationEntry realizationEntry) {
        return this.realizationRegistry.getRealization(realizationEntry.getType(), realizationEntry.getRealization());
    }

    private void retrieveResourcePath(IRealization realization) throws IOException {
        if (realization == null) {
            return;
        }
        logger.info("Deal with realization {} of type {}", (Object)realization.getName(), (Object)realization.getType());
        if (realization instanceof CubeInstance) {
            CubeInstance cube = (CubeInstance)realization;
            CubeDesc cubeDesc = this.cubeDescManager.getCubeDesc(cube.getDescName());
            DataModelDesc modelDesc = this.metadataManager.getDataModelDesc(cubeDesc.getModelName());
            this.addTables(modelDesc);
            this.addRequired(CubeDesc.concatResourcePath(cubeDesc.getName()));
            this.addRequired(ProjectInstance.concatResourcePath(cube.getProject()));
            this.addSegAndJob(cube);
        } else if (realization instanceof HybridInstance) {
            HybridInstance hybridInstance = (HybridInstance)realization;
            this.addRequired(HybridInstance.concatResourcePath(hybridInstance.getName()));
            for (IRealization iRealization : hybridInstance.getRealizations()) {
                if (iRealization.getType() != RealizationType.CUBE) {
                    throw new RuntimeException("Hybrid " + iRealization.getName() + " contains non cube child " + iRealization.getName() + " with type " + (Object)((Object)iRealization.getType()));
                }
                this.retrieveResourcePath(iRealization);
            }
        } else {
            logger.warn("Unknown realization type: " + (Object)((Object)realization.getType()));
        }
    }

    private void addTables(DataModelDesc modelDesc) {
        if (modelDesc != null) {
            for (TableRef tableRef : modelDesc.getAllTables()) {
                this.addRequired(tableRef.getTableDesc().getResourcePath());
                this.addOptional(TableMetadataManager.getInstance(KylinConfig.getInstanceFromEnv()).getTableExt(tableRef.getTableDesc()).getResourcePath());
            }
            this.addRequired(DataModelDesc.concatResourcePath(modelDesc.getName()));
        }
    }

    private void addSegAndJob(CubeInstance cube) {
        if (this.includeSegments) {
            this.addRequired(CubeInstance.concatResourcePath(cube.getName()));
            for (CubeSegment segment : cube.getSegments(SegmentStatusEnum.READY)) {
                this.addRequired(CubeSegment.getStatisticsResourcePath(cube.getName(), segment.getUuid()));
                if (this.includeSegmentDetails) {
                    for (String dictPat : segment.getDictionaryPaths()) {
                        this.addRequired(dictPat);
                    }
                    for (String snapshotPath : segment.getSnapshotPaths()) {
                        this.addRequired(snapshotPath);
                    }
                }
                if (!this.includeJobs) continue;
                String lastJobId = segment.getLastBuildJobID();
                if (StringUtils.isEmpty(lastJobId)) {
                    throw new RuntimeException("No job exist for segment :" + segment);
                }
                try {
                    if (this.onlyJobOutput) {
                        this.addRequired("/execute_output/" + lastJobId);
                        continue;
                    }
                    ExecutablePO executablePO = this.executableDao.getJob(lastJobId);
                    this.addRequired("/execute/" + lastJobId);
                    this.addRequired("/execute_output/" + lastJobId);
                    for (ExecutablePO task : executablePO.getTasks()) {
                        this.addRequired("/execute/" + task.getUuid());
                        this.addRequired("/execute_output/" + task.getUuid());
                    }
                }
                catch (PersistentException e) {
                    throw new RuntimeException("PersistentException", e);
                }
            }
        } else {
            if (this.includeJobs) {
                logger.warn("It's useless to set includeJobs to true when includeSegments is set to false");
            }
            cube.setStatus(RealizationStatusEnum.DISABLED);
            this.cubesToTrimAndSave.add(cube);
        }
    }

    private void addRequired(String record) {
        logger.info("adding required resource {}", (Object)record);
        this.requiredResources.add(record);
    }

    private void addOptional(String record) {
        logger.info("adding optional resource {}", (Object)record);
        this.optionalResources.add(record);
    }

    public static void main(String[] args) {
        CubeMetaExtractor extractor = new CubeMetaExtractor();
        extractor.execute(args);
    }

    static {
        OptionBuilder.withArgName((String)"cube");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.withDescription((String)"Specify which cube to extract");
        OPTION_CUBE = OptionBuilder.create((String)"cube");
        OptionBuilder.withArgName((String)"hybrid");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.withDescription((String)"Specify which hybrid to extract");
        OPTION_HYBRID = OptionBuilder.create((String)"hybrid");
        OptionBuilder.withArgName((String)"project");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.withDescription((String)"Specify realizations in which project to extract, project names can be connected by comma.");
        OPTION_PROJECT = OptionBuilder.create((String)"project");
        OptionBuilder.withArgName((String)"allProjects");
        OptionBuilder.hasArg((boolean)false);
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.withDescription((String)"Specify realizations in all projects to extract");
        OPTION_All_PROJECT = OptionBuilder.create((String)"allProjects");
        OptionBuilder.withArgName((String)"storageType");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.withDescription((String)"Specify the storage type to overwrite. Default is empty, keep origin.");
        OPTION_STORAGE_TYPE = OptionBuilder.create((String)"storageType");
        OptionBuilder.withArgName((String)"engineType");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.withDescription((String)"Specify the engine type to overwrite. Default is empty, keep origin.");
        OPTION_ENGINE_TYPE = OptionBuilder.create((String)"engineType");
        OptionBuilder.withArgName((String)"includeSegments");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.withDescription((String)"set this to true if want extract the segments info. Default true");
        OPTION_INCLUDE_SEGMENTS = OptionBuilder.create((String)"includeSegments");
        OptionBuilder.withArgName((String)"includeJobs");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.withDescription((String)"set this to true if want to extract job info/outputs too. Default false");
        OPTION_INCLUDE_JOB = OptionBuilder.create((String)"includeJobs");
        OptionBuilder.withArgName((String)"onlyOutput");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.withDescription((String)"when include jobs, only extract output of job. Default true");
        OPTION_INCLUDE_ONLY_JOB_OUTPUT = OptionBuilder.create((String)"onlyOutput");
        OptionBuilder.withArgName((String)"includeSegmentDetails");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.withDescription((String)"set this to true if want to extract segment details too, such as dict, table snapshot. Default false");
        OPTION_INCLUDE_SEGMENT_DETAILS = OptionBuilder.create((String)"includeSegmentDetails");
    }
}

