/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.utils;

import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Timestamp;
import java.time.ZoneId;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.calcite.avatica.util.TimeUnitRange;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.util.NlsString;
import org.apache.kylin.common.util.DateFormat;
import org.apache.kylin.engine.spark.cross.CrossDateTimeUtils$;
import org.apache.kylin.engine.spark.metadata.ColumnDesc;
import org.apache.kylin.engine.spark.metadata.FunctionDesc;
import org.apache.kylin.engine.spark.metadata.cube.StructField;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.catalyst.expressions.Cast$;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DecimalType$;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.sql.types.TimestampType$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class SparkTypeUtil$
implements Logging {
    public static SparkTypeUtil$ MODULE$;
    private final List<String> DATETIME_FAMILY;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new SparkTypeUtil$();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private ZoneId defaultZoneId() {
        return ZoneId.systemDefault();
    }

    private ZoneId UTC() {
        return ZoneId.of("UTC");
    }

    public List<String> DATETIME_FAMILY() {
        return this.DATETIME_FAMILY;
    }

    public boolean isDateTimeFamilyType(String dataType) {
        return this.DATETIME_FAMILY().contains((Object)dataType.toLowerCase(Locale.ROOT));
    }

    public boolean isDateType(String dataType) {
        return "date".equalsIgnoreCase(dataType);
    }

    public boolean isDateTime(SqlTypeName sqlTypeName) {
        return SqlTypeName.DATETIME_TYPES.contains(sqlTypeName);
    }

    public DataType kylinTypeToSparkResultType(org.apache.kylin.metadata.datatype.DataType dataTp) {
        LongType$ longType$;
        String string = dataTp.getName();
        if (string.startsWith("hllc")) {
            longType$ = LongType$.MODULE$;
        } else if (string.startsWith("percentile")) {
            longType$ = DoubleType$.MODULE$;
        } else if (string.startsWith("bitmap")) {
            longType$ = LongType$.MODULE$;
        } else if ("decimal".equals(string)) {
            longType$ = new DecimalType(dataTp.getPrecision(), dataTp.getScale());
        } else if ("date".equals(string)) {
            longType$ = IntegerType$.MODULE$;
        } else if ("time".equals(string)) {
            longType$ = LongType$.MODULE$;
        } else if ("timestamp".equals(string)) {
            longType$ = LongType$.MODULE$;
        } else if ("datetime".equals(string)) {
            longType$ = LongType$.MODULE$;
        } else if ("tinyint".equals(string)) {
            longType$ = ByteType$.MODULE$;
        } else if ("smallint".equals(string)) {
            longType$ = ShortType$.MODULE$;
        } else if ("integer".equals(string)) {
            longType$ = IntegerType$.MODULE$;
        } else if ("int4".equals(string)) {
            longType$ = IntegerType$.MODULE$;
        } else if ("bigint".equals(string)) {
            longType$ = LongType$.MODULE$;
        } else if ("long8".equals(string)) {
            longType$ = LongType$.MODULE$;
        } else if ("float".equals(string)) {
            longType$ = FloatType$.MODULE$;
        } else if ("double".equals(string)) {
            longType$ = DoubleType$.MODULE$;
        } else if (string.startsWith("varchar")) {
            longType$ = StringType$.MODULE$;
        } else if (string.startsWith("char")) {
            longType$ = StringType$.MODULE$;
        } else if ("bitmap".equals(string)) {
            longType$ = LongType$.MODULE$;
        } else if ("dim_dc".equals(string)) {
            longType$ = LongType$.MODULE$;
        } else if ("boolean".equals(string)) {
            longType$ = BooleanType$.MODULE$;
        } else {
            throw new IllegalArgumentException();
        }
        return longType$;
    }

    public DataType toSparkType(org.apache.kylin.metadata.datatype.DataType dataTp, boolean isSum) {
        DateType$ dateType$;
        String string = dataTp.getName();
        if ("decimal".equals(string)) {
            DecimalType decimalType;
            if (isSum) {
                int i = dataTp.getPrecision() + 10;
                decimalType = new DecimalType(Math.min(DecimalType$.MODULE$.MAX_PRECISION(), i), dataTp.getScale());
            } else {
                decimalType = new DecimalType(dataTp.getPrecision(), dataTp.getScale());
            }
            dateType$ = decimalType;
        } else if ("date".equals(string)) {
            dateType$ = DateType$.MODULE$;
        } else if ("time".equals(string)) {
            dateType$ = DateType$.MODULE$;
        } else if ("timestamp".equals(string)) {
            dateType$ = TimestampType$.MODULE$;
        } else if ("datetime".equals(string)) {
            dateType$ = DateType$.MODULE$;
        } else if ("tinyint".equals(string)) {
            dateType$ = isSum ? LongType$.MODULE$ : ByteType$.MODULE$;
        } else if ("smallint".equals(string)) {
            dateType$ = isSum ? LongType$.MODULE$ : ShortType$.MODULE$;
        } else if ("integer".equals(string)) {
            dateType$ = isSum ? LongType$.MODULE$ : IntegerType$.MODULE$;
        } else if ("int4".equals(string)) {
            dateType$ = isSum ? LongType$.MODULE$ : IntegerType$.MODULE$;
        } else if ("bigint".equals(string)) {
            dateType$ = LongType$.MODULE$;
        } else if ("long8".equals(string)) {
            dateType$ = LongType$.MODULE$;
        } else if ("float".equals(string)) {
            dateType$ = isSum ? DoubleType$.MODULE$ : FloatType$.MODULE$;
        } else if ("double".equals(string)) {
            dateType$ = DoubleType$.MODULE$;
        } else if (string.startsWith("varchar")) {
            dateType$ = StringType$.MODULE$;
        } else if (string.startsWith("char")) {
            dateType$ = StringType$.MODULE$;
        } else if ("dim_dc".equals(string)) {
            dateType$ = LongType$.MODULE$;
        } else if ("boolean".equals(string)) {
            dateType$ = BooleanType$.MODULE$;
        } else if (string.startsWith("hllc")) {
            dateType$ = BinaryType$.MODULE$;
        } else if (string.startsWith("bitmap")) {
            dateType$ = BinaryType$.MODULE$;
        } else if (string.startsWith("extendedcolumn")) {
            dateType$ = BinaryType$.MODULE$;
        } else if (string.startsWith("percentile")) {
            dateType$ = BinaryType$.MODULE$;
        } else if (string.startsWith("raw")) {
            dateType$ = BinaryType$.MODULE$;
        } else {
            throw new IllegalArgumentException(dataTp.toString());
        }
        return dateType$;
    }

    public boolean toSparkType$default$2() {
        return false;
    }

    public DataType convertSqlTypeToSparkType(RelDataType dt) {
        StringType$ stringType$;
        SqlTypeName sqlTypeName = dt.getSqlTypeName();
        if (SqlTypeName.DECIMAL.equals(sqlTypeName)) {
            stringType$ = new DecimalType(dt.getPrecision(), dt.getScale());
        } else if (SqlTypeName.CHAR.equals(sqlTypeName)) {
            stringType$ = StringType$.MODULE$;
        } else if (SqlTypeName.VARCHAR.equals(sqlTypeName)) {
            stringType$ = StringType$.MODULE$;
        } else if (SqlTypeName.INTEGER.equals(sqlTypeName)) {
            stringType$ = IntegerType$.MODULE$;
        } else if (SqlTypeName.TINYINT.equals(sqlTypeName)) {
            stringType$ = ByteType$.MODULE$;
        } else if (SqlTypeName.SMALLINT.equals(sqlTypeName)) {
            stringType$ = ShortType$.MODULE$;
        } else if (SqlTypeName.BIGINT.equals(sqlTypeName)) {
            stringType$ = LongType$.MODULE$;
        } else if (SqlTypeName.FLOAT.equals(sqlTypeName)) {
            stringType$ = FloatType$.MODULE$;
        } else if (SqlTypeName.DOUBLE.equals(sqlTypeName)) {
            stringType$ = DoubleType$.MODULE$;
        } else if (SqlTypeName.DATE.equals(sqlTypeName)) {
            stringType$ = DateType$.MODULE$;
        } else if (SqlTypeName.TIMESTAMP.equals(sqlTypeName)) {
            stringType$ = TimestampType$.MODULE$;
        } else if (SqlTypeName.BOOLEAN.equals(sqlTypeName)) {
            stringType$ = BooleanType$.MODULE$;
        } else if (SqlTypeName.ANY.equals(sqlTypeName)) {
            stringType$ = StringType$.MODULE$;
        } else {
            throw new IllegalArgumentException(new StringBuilder(24).append("unsupported SqlTypeName ").append(dt).toString());
        }
        return stringType$;
    }

    public String convertSparkTypeToSqlType(DataType dt) {
        String string;
        DataType dataType = dt;
        if (StringType$.MODULE$.equals(dataType)) {
            string = SqlTypeName.VARCHAR.getName();
        } else if (IntegerType$.MODULE$.equals(dataType)) {
            string = SqlTypeName.INTEGER.getName();
        } else if (ByteType$.MODULE$.equals(dataType)) {
            string = SqlTypeName.TINYINT.getName();
        } else if (ShortType$.MODULE$.equals(dataType)) {
            string = SqlTypeName.SMALLINT.getName();
        } else if (LongType$.MODULE$.equals(dataType)) {
            string = SqlTypeName.BIGINT.getName();
        } else if (FloatType$.MODULE$.equals(dataType)) {
            string = SqlTypeName.FLOAT.getName();
        } else if (DoubleType$.MODULE$.equals(dataType)) {
            string = SqlTypeName.DOUBLE.getName();
        } else if (DateType$.MODULE$.equals(dataType)) {
            string = SqlTypeName.DATE.getName();
        } else if (TimestampType$.MODULE$.equals(dataType)) {
            string = SqlTypeName.TIMESTAMP.getName();
        } else if (BooleanType$.MODULE$.equals(dataType)) {
            string = SqlTypeName.BOOLEAN.getName();
        } else {
            if (!(dt instanceof DecimalType)) {
                throw new IllegalArgumentException(new StringBuilder(24).append("unsupported SqlTypeName ").append(dt).toString());
            }
            DecimalType decimalType = (DecimalType)dt;
            string = new StringBuilder(3).append(SqlTypeName.DECIMAL.getName()).append("(").append(decimalType.precision()).append(",").append(decimalType.scale()).append(")").toString();
        }
        return string;
    }

    public Object getValueFromRexLit(RexLiteral literal) {
        Object object;
        Comparable comparable = literal.getValue();
        if (comparable instanceof NlsString) {
            NlsString nlsString = (NlsString)comparable;
            object = nlsString.getValue();
        } else if (comparable instanceof GregorianCalendar) {
            object = literal.getTypeName().getName().equals("DATE") ? new Date(BoxesRunTime.unboxToLong((Object)CrossDateTimeUtils$.MODULE$.stringToTimestamp(literal).get()) / 1000L) : new Timestamp(BoxesRunTime.unboxToLong((Object)CrossDateTimeUtils$.MODULE$.stringToTimestamp(literal).get()) / 1000L);
        } else if (comparable instanceof TimeUnitRange) {
            TimeUnitRange timeUnitRange = (TimeUnitRange)comparable;
            object = timeUnitRange.name();
        } else if (comparable instanceof Boolean) {
            Boolean bl = (Boolean)comparable;
            object = bl;
        } else if (comparable instanceof BigDecimal) {
            BigDecimal bigDecimal = (BigDecimal)comparable;
            SqlTypeName sqlTypeName = literal.getType().getSqlTypeName();
            Number number = SqlTypeName.BIGINT.equals(sqlTypeName) ? (Number)BoxesRunTime.boxToLong((long)bigDecimal.longValue()) : (Number)(SqlTypeName.INTEGER.equals(sqlTypeName) ? (Number)BoxesRunTime.boxToInteger((int)bigDecimal.intValue()) : (Number)(SqlTypeName.DOUBLE.equals(sqlTypeName) ? (Number)BoxesRunTime.boxToDouble((double)bigDecimal.doubleValue()) : (Number)(SqlTypeName.FLOAT.equals(sqlTypeName) ? (Number)BoxesRunTime.boxToFloat((float)bigDecimal.floatValue()) : (Number)(SqlTypeName.SMALLINT.equals(sqlTypeName) ? BoxesRunTime.boxToShort((short)bigDecimal.shortValue()) : bigDecimal))));
            object = number;
        } else if (comparable instanceof Float) {
            Float f = (Float)comparable;
            object = f;
        } else if (comparable instanceof Double) {
            Double d = (Double)comparable;
            object = d;
        } else if (comparable instanceof Integer) {
            Integer n = (Integer)comparable;
            object = n;
        } else if (comparable instanceof Byte) {
            Byte by = (Byte)comparable;
            object = by;
        } else if (comparable instanceof Short) {
            Short s = (Short)comparable;
            object = s;
        } else if (comparable instanceof Long) {
            Long l = (Long)comparable;
            object = l;
        } else {
            object = literal.getValue().toString();
        }
        String ret = object;
        return ret;
    }

    public Object convertStringToValue(Object s, RelDataType rowType, boolean toCalcite) {
        Object object;
        SqlTypeName sqlTypeName = rowType.getSqlTypeName();
        if (s == null) {
            object = null;
        } else if (s.toString().isEmpty()) {
            SqlTypeName sqlTypeName2 = sqlTypeName;
            Object object2 = SqlTypeName.DECIMAL.equals(sqlTypeName2) ? new BigDecimal(0) : (SqlTypeName.CHAR.equals(sqlTypeName2) ? s.toString() : (SqlTypeName.VARCHAR.equals(sqlTypeName2) ? s.toString() : (SqlTypeName.INTEGER.equals(sqlTypeName2) ? (Number)BoxesRunTime.boxToInteger((int)0) : (Number)(SqlTypeName.TINYINT.equals(sqlTypeName2) ? (Number)BoxesRunTime.boxToByte((byte)((byte)0)) : (Number)(SqlTypeName.SMALLINT.equals(sqlTypeName2) ? (Number)BoxesRunTime.boxToShort((short)((short)0)) : (Number)(SqlTypeName.BIGINT.equals(sqlTypeName2) ? (Number)BoxesRunTime.boxToLong((long)0L) : (Number)(SqlTypeName.FLOAT.equals(sqlTypeName2) ? (Number)BoxesRunTime.boxToFloat((float)0.0f) : (Number)(SqlTypeName.REAL.equals(sqlTypeName2) ? (Number)BoxesRunTime.boxToFloat((float)0.0f) : (Number)(SqlTypeName.DOUBLE.equals(sqlTypeName2) ? (Number)BoxesRunTime.boxToDouble((double)0.0) : (Number)(SqlTypeName.DATE.equals(sqlTypeName2) ? (Number)BoxesRunTime.boxToInteger((int)0) : (Number)(SqlTypeName.TIMESTAMP.equals(sqlTypeName2) ? BoxesRunTime.boxToLong((long)0L) : (SqlTypeName.TIME.equals(sqlTypeName2) ? BoxesRunTime.boxToLong((long)0L) : (SqlTypeName.BOOLEAN.equals(sqlTypeName2) ? null : (sqlTypeName2 == null ? null : null))))))))))))));
            object = object2;
        } else {
            try {
                Object object3;
                SqlTypeName sqlTypeName3 = sqlTypeName;
                if (SqlTypeName.DECIMAL.equals(sqlTypeName3)) {
                    object3 = s instanceof Double || s instanceof Float || s.toString().contains(".") ? new BigDecimal(s.toString()).setScale(rowType.getScale(), 6) : new BigDecimal(s.toString());
                } else if (SqlTypeName.CHAR.equals(sqlTypeName3)) {
                    object3 = s.toString();
                } else if (SqlTypeName.VARCHAR.equals(sqlTypeName3)) {
                    object3 = s.toString();
                } else if (SqlTypeName.INTEGER.equals(sqlTypeName3)) {
                    object3 = BoxesRunTime.boxToInteger((int)new StringOps(Predef$.MODULE$.augmentString(s.toString())).toInt());
                } else if (SqlTypeName.TINYINT.equals(sqlTypeName3)) {
                    object3 = BoxesRunTime.boxToByte((byte)new StringOps(Predef$.MODULE$.augmentString(s.toString())).toByte());
                } else if (SqlTypeName.SMALLINT.equals(sqlTypeName3)) {
                    object3 = BoxesRunTime.boxToShort((short)new StringOps(Predef$.MODULE$.augmentString(s.toString())).toShort());
                } else if (SqlTypeName.BIGINT.equals(sqlTypeName3)) {
                    object3 = BoxesRunTime.boxToLong((long)new StringOps(Predef$.MODULE$.augmentString(s.toString())).toLong());
                } else if (SqlTypeName.FLOAT.equals(sqlTypeName3)) {
                    object3 = BoxesRunTime.boxToDouble((double)Double.parseDouble(s.toString()));
                } else if (SqlTypeName.DOUBLE.equals(sqlTypeName3)) {
                    object3 = BoxesRunTime.boxToDouble((double)Double.parseDouble(s.toString()));
                } else if (SqlTypeName.DATE.equals(sqlTypeName3)) {
                    Object object4;
                    String string = s.toString();
                    if (string.contains("-")) {
                        long time = DateFormat.stringToDate(string).getTime();
                        object4 = toCalcite ? CrossDateTimeUtils$.MODULE$.stringToDate(string).get() : BoxesRunTime.boxToLong((long)(time / 1000L));
                    } else {
                        object4 = toCalcite ? (Number)BoxesRunTime.boxToInteger((int)((int)(this.toCalciteTimestamp(DateFormat.stringToMillis(string)) / 86400000L))) : (Number)BoxesRunTime.boxToLong((long)(DateFormat.stringToMillis(string) / 1000L));
                    }
                    object3 = object4;
                } else {
                    boolean bl = SqlTypeName.TIMESTAMP.equals(sqlTypeName3) ? true : SqlTypeName.TIME.equals(sqlTypeName3);
                    if (bl) {
                        String ts = ((Timestamp)s).toString();
                        object3 = toCalcite ? BoxesRunTime.boxToLong((long)(BoxesRunTime.unboxToLong((Object)CrossDateTimeUtils$.MODULE$.stringToTimestamp(ts, this.UTC()).get()) / 1000L)) : BoxesRunTime.boxToLong((long)(((Timestamp)s).getTime() / 1000L));
                    } else {
                        object3 = SqlTypeName.BOOLEAN.equals(sqlTypeName3) ? s : s.toString();
                    }
                }
                String a = object3;
                object = a;
            }
            catch (Throwable th) {
                this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(36).append("Error for convert value : ").append(s).append(" , class: ").append(s.getClass()).toString(), th);
                object = this.safetyConvertStringToValue(s, rowType, toCalcite);
            }
        }
        return object;
    }

    public DataType kylinRawTableSQLTypeToSparkType(org.apache.kylin.metadata.datatype.DataType dataTp) {
        DateType$ dateType$;
        String string = dataTp.getName();
        if ("decimal".equals(string)) {
            dateType$ = new DecimalType(dataTp.getPrecision(), dataTp.getScale());
        } else if ("date".equals(string)) {
            dateType$ = DateType$.MODULE$;
        } else if ("time".equals(string)) {
            dateType$ = DateType$.MODULE$;
        } else if ("timestamp".equals(string)) {
            dateType$ = TimestampType$.MODULE$;
        } else if ("datetime".equals(string)) {
            dateType$ = DateType$.MODULE$;
        } else if ("tinyint".equals(string)) {
            dateType$ = ByteType$.MODULE$;
        } else if ("smallint".equals(string)) {
            dateType$ = ShortType$.MODULE$;
        } else if ("integer".equals(string)) {
            dateType$ = IntegerType$.MODULE$;
        } else if ("int4".equals(string)) {
            dateType$ = IntegerType$.MODULE$;
        } else if ("bigint".equals(string)) {
            dateType$ = LongType$.MODULE$;
        } else if ("long8".equals(string)) {
            dateType$ = LongType$.MODULE$;
        } else if ("float".equals(string)) {
            dateType$ = FloatType$.MODULE$;
        } else if ("double".equals(string)) {
            dateType$ = DoubleType$.MODULE$;
        } else if ("real".equals(string)) {
            dateType$ = DoubleType$.MODULE$;
        } else if (string.startsWith("char")) {
            dateType$ = StringType$.MODULE$;
        } else if (string.startsWith("varchar")) {
            dateType$ = StringType$.MODULE$;
        } else if ("bitmap".equals(string)) {
            dateType$ = LongType$.MODULE$;
        } else if ("dim_dc".equals(string)) {
            dateType$ = LongType$.MODULE$;
        } else if ("boolean".equals(string)) {
            dateType$ = BooleanType$.MODULE$;
        } else {
            throw new IllegalArgumentException(new StringBuilder(24).append("No supported data type: ").append(string).toString());
        }
        return dateType$;
    }

    public Object safetyConvertStringToValue(Object s, RelDataType rowType, boolean toCalcite) {
        String string;
        try {
            Object object;
            SqlTypeName sqlTypeName = rowType.getSqlTypeName();
            if (SqlTypeName.DECIMAL.equals(sqlTypeName)) {
                object = s instanceof Double || s instanceof Float || s.toString().contains(".") ? new BigDecimal(s.toString()).setScale(rowType.getScale(), 6) : new BigDecimal(s.toString());
            } else if (SqlTypeName.CHAR.equals(sqlTypeName)) {
                object = s.toString();
            } else if (SqlTypeName.VARCHAR.equals(sqlTypeName)) {
                object = s.toString();
            } else if (SqlTypeName.INTEGER.equals(sqlTypeName)) {
                object = BoxesRunTime.boxToInteger((int)((int)new StringOps(Predef$.MODULE$.augmentString(s.toString())).toDouble()));
            } else if (SqlTypeName.TINYINT.equals(sqlTypeName)) {
                object = BoxesRunTime.boxToByte((byte)((byte)new StringOps(Predef$.MODULE$.augmentString(s.toString())).toDouble()));
            } else if (SqlTypeName.SMALLINT.equals(sqlTypeName)) {
                object = BoxesRunTime.boxToShort((short)((short)new StringOps(Predef$.MODULE$.augmentString(s.toString())).toDouble()));
            } else if (SqlTypeName.BIGINT.equals(sqlTypeName)) {
                object = BoxesRunTime.boxToLong((long)((long)new StringOps(Predef$.MODULE$.augmentString(s.toString())).toDouble()));
            } else if (SqlTypeName.FLOAT.equals(sqlTypeName)) {
                object = BoxesRunTime.boxToFloat((float)Float.parseFloat(s.toString()));
            } else if (SqlTypeName.DOUBLE.equals(sqlTypeName)) {
                object = BoxesRunTime.boxToDouble((double)Double.parseDouble(s.toString()));
            } else if (SqlTypeName.DATE.equals(sqlTypeName)) {
                Number number;
                String string2 = s.toString();
                if (string2.contains("-")) {
                    long time = DateFormat.stringToDate(string2).getTime();
                    number = toCalcite ? (Number)BoxesRunTime.boxToInteger((int)((int)(time / 86400000L))) : (Number)BoxesRunTime.boxToLong((long)(time / 1000L));
                } else {
                    number = toCalcite ? (Number)BoxesRunTime.boxToInteger((int)((int)(this.toCalciteTimestamp(DateFormat.stringToMillis(string2)) / 86400000L))) : (Number)BoxesRunTime.boxToLong((long)DateFormat.stringToMillis(string2));
                }
                object = number;
            } else {
                boolean bl = SqlTypeName.TIMESTAMP.equals(sqlTypeName) ? true : SqlTypeName.TIME.equals(sqlTypeName);
                if (bl) {
                    long ts = ((Timestamp)s).getTime();
                    object = toCalcite ? BoxesRunTime.boxToLong((long)ts) : BoxesRunTime.boxToLong((long)(ts / 1000L));
                } else {
                    object = SqlTypeName.BOOLEAN.equals(sqlTypeName) ? s : s.toString();
                }
            }
            string = object;
        }
        catch (Throwable th) {
            throw new RuntimeException(new StringBuilder(36).append("Error for convert value : ").append(s).append(" , class: ").append(s.getClass()).toString(), th);
        }
        return string;
    }

    public Long toSparkTimestamp(long calciteTimestamp) {
        return Predef$.MODULE$.long2Long(calciteTimestamp / 1000L);
    }

    public long toCalciteTimestamp(long sparkTimestamp) {
        return sparkTimestamp * 1000L;
    }

    /*
     * WARNING - void declaration
     */
    public Column[] alignDataType(StructType origin, StructType goal) {
        void var3_3;
        Column[] columns = (Column[])((TraversableOnce)((TraversableLike)origin.zip((GenIterable)goal, Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Column column;
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                DataType goalDataType;
                StructField sparkField = (StructField)tuple2._1();
                StructField goalField = (StructField)tuple2._2();
                DataType sparkDataType = sparkField.dataType();
                if (!sparkDataType.sameType(goalDataType = goalField.dataType())) {
                    if (Cast$.MODULE$.canCast(sparkDataType, goalDataType)) {
                        column = functions$.MODULE$.col(sparkField.name()).cast(goalDataType);
                    } else {
                        MODULE$.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(57).append("Error for cast datatype from  ").append(sparkDataType).append(" to ").append(goalDataType).append(" with column name is : ").append(sparkField.name()).toString());
                        column = functions$.MODULE$.col(sparkField.name());
                    }
                } else {
                    column = functions$.MODULE$.col(sparkField.name());
                }
            } else {
                throw new MatchError((Object)tuple2);
            }
            Column column2 = column;
            return column2;
        }, Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Column.class));
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(19).append("Align data type is ").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])columns)).mkString(",")).toString());
        return var3_3;
    }

    public DataType generateFunctionReturnDataType(FunctionDesc function) {
        DataType dataType;
        String string = function.expression().toUpperCase(Locale.ROOT);
        if ("SUM".equals(string)) {
            dataType = this.toSparkType(function.returnType().toKylinDataType(), true);
        } else if ("COUNT".equals(string)) {
            dataType = LongType$.MODULE$;
        } else if (string.startsWith("TOP_N")) {
            List fields = (List)function.pra().drop(1).map((Function1 & Serializable & scala.Serializable)p -> new StructField(new StringBuilder(10).append("DIMENSION_").append(p.columnName()).toString(), p.dataType(), StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), List$.MODULE$.canBuildFrom());
            dataType = DataTypes.createArrayType((DataType)StructType$.MODULE$.apply((Seq)new .colon.colon((Object)new StructField("measure", (DataType)DoubleType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField("dim", (DataType)StructType$.MODULE$.apply((Seq)fields), StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$))));
        } else {
            boolean bl = "MAX".equals(string) ? true : "MIN".equals(string);
            dataType = bl ? ((ColumnDesc)function.pra().head()).dataType() : this.toSparkType(function.returnType().toKylinDataType(), this.toSparkType$default$2());
        }
        return dataType;
    }

    public org.apache.kylin.engine.spark.metadata.cube.StructField convertSparkFieldToJavaField(StructField field) {
        int n;
        String typeName;
        StructField.StructFieldBuilder builder = new StructField.StructFieldBuilder();
        builder.setName(field.name());
        String string = typeName = field.dataType().sql().startsWith("DECIMAL") ? "DECIMAL" : field.dataType().sql();
        if ("BINARY".equals(string)) {
            n = -2;
        } else if ("BOOLEAN".equals(string)) {
            n = 16;
        } else if ("DATE".equals(string)) {
            n = 91;
        } else if ("DOUBLE".equals(string)) {
            n = 8;
        } else if ("FLOAT".equals(string)) {
            n = 6;
        } else if ("INT".equals(string)) {
            n = 4;
        } else if ("BIGINT".equals(string)) {
            n = -5;
        } else if ("NUMERIC".equals(string)) {
            n = 2;
        } else if ("SMALLINT".equals(string)) {
            n = 5;
        } else if ("TIMESTAMP".equals(string)) {
            n = 93;
        } else if ("STRING".equals(string)) {
            n = 12;
        } else if ("DECIMAL".equals(string)) {
            Object object;
            Tuple2<Object, Object> precisionAndScalePair = this.getDecimalPrecisionAndScale(typeName);
            if (precisionAndScalePair != null) {
                builder.setPrecision(precisionAndScalePair._1$mcI$sp());
                object = builder.setScale(precisionAndScalePair._2$mcI$sp());
            } else {
                object = BoxedUnit.UNIT;
            }
            n = 3;
        } else {
            n = 1111;
        }
        int javaType = n;
        builder.setDataType(javaType);
        builder.setDataTypeName(typeName);
        builder.setNullable(field.nullable());
        return builder.createStructField();
    }

    private Tuple2<Object, Object> getDecimalPrecisionAndScale(String javaType) {
        Pattern DECIMAL_PATTERN = Pattern.compile("DECIMAL\\(([0-9]+),([0-9]+)\\)", 2);
        Matcher decimalMatcher = DECIMAL_PATTERN.matcher(javaType);
        return decimalMatcher.find() ? new Tuple2.mcII.sp(Predef$.MODULE$.Integer2int(Integer.valueOf(decimalMatcher.group(1))), Predef$.MODULE$.Integer2int(Integer.valueOf(decimalMatcher.group(2)))) : null;
    }

    private SparkTypeUtil$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
        this.DATETIME_FAMILY = new .colon.colon((Object)"time", (List)new .colon.colon((Object)"date", (List)new .colon.colon((Object)"timestamp", (List)new .colon.colon((Object)"datetime", (List)Nil$.MODULE$))));
    }
}

