/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.session;

import com.codahale.metrics.MetricRegistry;
import com.google.common.annotations.VisibleForTesting;
import java.io.Serializable;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.apache.kyuubi.KyuubiSQLException$;
import org.apache.kyuubi.client.api.v1.dto.Batch;
import org.apache.kyuubi.client.api.v1.dto.BatchRequest;
import org.apache.kyuubi.client.util.BatchUtils;
import org.apache.kyuubi.config.ConfigEntry;
import org.apache.kyuubi.config.KyuubiConf;
import org.apache.kyuubi.config.KyuubiConf$;
import org.apache.kyuubi.credentials.HadoopCredentialsManager;
import org.apache.kyuubi.engine.KyuubiApplicationManager;
import org.apache.kyuubi.metrics.MetricsConstants$;
import org.apache.kyuubi.metrics.MetricsSystem;
import org.apache.kyuubi.metrics.MetricsSystem$;
import org.apache.kyuubi.operation.KyuubiOperationManager;
import org.apache.kyuubi.operation.OperationState$;
import org.apache.kyuubi.plugin.GroupProvider;
import org.apache.kyuubi.plugin.PluginLoader$;
import org.apache.kyuubi.plugin.SessionConfAdvisor;
import org.apache.kyuubi.server.metadata.MetadataManager;
import org.apache.kyuubi.server.metadata.MetadataRequestsRetryRef;
import org.apache.kyuubi.server.metadata.api.Metadata;
import org.apache.kyuubi.server.metadata.api.Metadata$;
import org.apache.kyuubi.server.metadata.api.MetadataFilter;
import org.apache.kyuubi.service.Service;
import org.apache.kyuubi.service.TempFileService;
import org.apache.kyuubi.session.KyuubiBatchSession;
import org.apache.kyuubi.session.KyuubiSessionImpl;
import org.apache.kyuubi.session.Session;
import org.apache.kyuubi.session.SessionHandle;
import org.apache.kyuubi.session.SessionLimiter;
import org.apache.kyuubi.session.SessionLimiter$;
import org.apache.kyuubi.session.SessionManager;
import org.apache.kyuubi.session.SessionType$;
import org.apache.kyuubi.session.UserIpAddress;
import org.apache.kyuubi.shaded.hive.service.rpc.thrift.TProtocolVersion;
import org.apache.kyuubi.sql.parser.server.KyuubiParser;
import org.apache.kyuubi.util.SignUtils$;
import org.apache.kyuubi.util.ThreadUtils$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\r-g\u0001\u0002!B\u0001)C\u0001b\u0014\u0001\u0003\u0002\u0003\u0006I\u0001\u0015\u0005\u0006;\u0002!IA\u0018\u0005\u0006;\u0002!\t!\u0019\u0005\bE\u0002\u0011\r\u0011\"\u0003d\u0011\u0019i\u0007\u0001)A\u0005I\"9a\u000e\u0001b\u0001\n\u0003y\u0007B\u0002<\u0001A\u0003%\u0001\u000fC\u0004x\u0001\t\u0007I\u0011\u0001=\t\r}\u0004\u0001\u0015!\u0003z\u0011%\t\t\u0001\u0001b\u0001\n\u0003\t\u0019\u0001\u0003\u0005\u0002\u0012\u0001\u0001\u000b\u0011BA\u0003\u0011)\t\u0019\u0002\u0001EC\u0002\u0013\u0005\u0011Q\u0003\u0005\u000b\u0003[\u0001\u0001R1A\u0005\u0002\u0005=\u0002BCA(\u0001!\u0015\r\u0011\"\u0001\u0002R!I\u0011\u0011\f\u0001A\u0002\u0013%\u00111\f\u0005\n\u0003K\u0002\u0001\u0019!C\u0005\u0003OB\u0001\"a\u001d\u0001A\u0003&\u0011Q\f\u0005\n\u0003k\u0002\u0001\u0019!C\u0005\u00037B\u0011\"a\u001e\u0001\u0001\u0004%I!!\u001f\t\u0011\u0005u\u0004\u0001)Q\u0005\u0003;BA\"!\u001d\u0001!\u0003E9\u0019)C\u0005\u0003\u007fB!\"!(\u0001\u0011\u000b\u0007I\u0011AAP\u0011)\t\t\u000b\u0001EC\u0002\u0013\u0005\u00111\u0015\u0005\n\u0003K\u0003\u0001\u0019!C\u0001\u0003OC\u0011\"a/\u0001\u0001\u0004%\t!!0\t\u0011\u0005\u0005\u0007\u0001)Q\u0005\u0003SC\u0011\"a1\u0001\u0005\u0004%I!!2\t\u0011\u00055\u0007\u0001)A\u0005\u0003\u000fD\u0011\"a4\u0001\u0005\u0004%\t!!5\t\u0011\u0005}\u0007\u0001)A\u0005\u0003'Dq!!9\u0001\t\u0003\n\u0019\u000fC\u0004\u0002v\u0002!\t&a>\t\u000f\tE\u0002\u0001\"\u0011\u00034!9!Q\t\u0001\u0005B\t\u001d\u0003b\u0002B'\u0001\u0011\u0005!q\n\u0005\n\u0005#\u0003\u0011\u0013!C\u0001\u0005'C\u0001B!+\u0001\t\u0003\u0019%1\u0016\u0005\b\u0005S\u0003A\u0011\u0001BY\u0011\u001d\u0011\u0019\u000e\u0001C\u0001\u0005+DqAa8\u0001\t\u0003\u0011\t\u000fC\u0004\u0003h\u0002!\tA!;\t\u000f\t5\b\u0001\"\u0001\u0003p\"9!1\u001f\u0001\u0005\u0002\tU\bbBB\u0002\u0001\u0011\u00051Q\u0001\u0005\b\u0007\u0013\u0001A\u0011AB\u0006\u0011\u001d\u0019I\u0002\u0001C\u0001\u00077A\u0011ba\u000f\u0001#\u0003%\ta!\u0010\t\u000f\r\u0005\u0003\u0001\"\u0001\u0004D!91q\t\u0001\u0005\u0002\r%\u0003bBB4\u0001\u0011\u00053\u0011\u000e\u0005\b\u0007W\u0002A\u0011AB7\u0011\u001d\u0019)\b\u0001C\u0001\u0007oBqa! \u0001\t#\u001ay\bC\u0004\u0004\u0002\u0002!Iaa!\t\u0011\r\u001d\u0005\u0001\"\u0001D\u0007\u0013C\u0001b!%\u0001\t\u0003\u001951\u0013\u0005\t\u0007/\u0003A\u0011A\"\u0004\n\"A1\u0011\u0014\u0001\u0005\u0002\r\u001bY\n\u0003\u0005\u0004 \u0002!\taQBE\u0011!\u0019\t\u000b\u0001C\u0001\u0007\u000e\r\u0006bBBT\u0001\u0011%1\u0011\u0016\u0005\b\u0007\u0007\u0004A\u0011BB5\u0011\u001d\u0019)\r\u0001C\u0005\u0007\u000f\u0014AcS=vk\nL7+Z:tS>tW*\u00198bO\u0016\u0014(B\u0001\"D\u0003\u001d\u0019Xm]:j_:T!\u0001R#\u0002\r-LX/\u001e2j\u0015\t1u)\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u0011\u0006\u0019qN]4\u0004\u0001M\u0011\u0001a\u0013\t\u0003\u00196k\u0011!Q\u0005\u0003\u001d\u0006\u0013abU3tg&|g.T1oC\u001e,'/\u0001\u0003oC6,\u0007CA)[\u001d\t\u0011\u0006\f\u0005\u0002T-6\tAK\u0003\u0002V\u0013\u00061AH]8pizR\u0011aV\u0001\u0006g\u000e\fG.Y\u0005\u00033Z\u000ba\u0001\u0015:fI\u00164\u0017BA.]\u0005\u0019\u0019FO]5oO*\u0011\u0011LV\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005}\u0003\u0007C\u0001'\u0001\u0011\u0015y%\u00011\u0001Q)\u0005y\u0016A\u00029beN,'/F\u0001e!\t)7.D\u0001g\u0015\t9\u0007.\u0001\u0004tKJ4XM\u001d\u0006\u0003E&T!A[\"\u0002\u0007M\fH.\u0003\u0002mM\na1*_;vE&\u0004\u0016M]:fe\u00069\u0001/\u0019:tKJ\u0004\u0013\u0001E8qKJ\fG/[8o\u001b\u0006t\u0017mZ3s+\u0005\u0001\bCA9u\u001b\u0005\u0011(BA:D\u0003%y\u0007/\u001a:bi&|g.\u0003\u0002ve\n12*_;vE&|\u0005/\u001a:bi&|g.T1oC\u001e,'/A\tpa\u0016\u0014\u0018\r^5p]6\u000bg.Y4fe\u0002\n!c\u0019:fI\u0016tG/[1mg6\u000bg.Y4feV\t\u0011\u0010\u0005\u0002{{6\t1P\u0003\u0002}\u0007\u0006Y1M]3eK:$\u0018.\u00197t\u0013\tq8P\u0001\rIC\u0012|w\u000e]\"sK\u0012,g\u000e^5bYNl\u0015M\\1hKJ\f1c\u0019:fI\u0016tG/[1mg6\u000bg.Y4fe\u0002\n!#\u00199qY&\u001c\u0017\r^5p]6\u000bg.Y4feV\u0011\u0011Q\u0001\t\u0005\u0003\u000f\ti!\u0004\u0002\u0002\n)\u0019\u00111B\"\u0002\r\u0015tw-\u001b8f\u0013\u0011\ty!!\u0003\u00031-KX/\u001e2j\u0003B\u0004H.[2bi&|g.T1oC\u001e,'/A\nbaBd\u0017nY1uS>tW*\u00198bO\u0016\u0014\b%A\bnKR\fG-\u0019;b\u001b\u0006t\u0017mZ3s+\t\t9\u0002\u0005\u0004\u0002\u001a\u0005m\u0011qD\u0007\u0002-&\u0019\u0011Q\u0004,\u0003\r=\u0003H/[8o!\u0011\t\t#!\u000b\u000e\u0005\u0005\r\"\u0002BA\u0013\u0003O\t\u0001\"\\3uC\u0012\fG/\u0019\u0006\u0003O\u000eKA!a\u000b\u0002$\tyQ*\u001a;bI\u0006$\u0018-T1oC\u001e,'/\u0001\ntKN\u001c\u0018n\u001c8D_:4\u0017\t\u001a<jg>\u0014XCAA\u0019!\u0019\t\u0019$!\u0010\u0002D9!\u0011QGA\u001d\u001d\r\u0019\u0016qG\u0005\u0002/&\u0019\u00111\b,\u0002\u000fA\f7m[1hK&!\u0011qHA!\u0005\r\u0019V-\u001d\u0006\u0004\u0003w1\u0006\u0003BA#\u0003\u0017j!!a\u0012\u000b\u0007\u0005%3)\u0001\u0004qYV<\u0017N\\\u0005\u0005\u0003\u001b\n9E\u0001\nTKN\u001c\u0018n\u001c8D_:4\u0017\t\u001a<jg>\u0014\u0018!D4s_V\u0004\bK]8wS\u0012,'/\u0006\u0002\u0002TA!\u0011QIA+\u0013\u0011\t9&a\u0012\u0003\u001b\u001d\u0013x.\u001e9Qe>4\u0018\u000eZ3s\u0003\u001da\u0017.\\5uKJ,\"!!\u0018\u0011\r\u0005e\u00111DA0!\ra\u0015\u0011M\u0005\u0004\u0003G\n%AD*fgNLwN\u001c'j[&$XM]\u0001\fY&l\u0017\u000e^3s?\u0012*\u0017\u000f\u0006\u0003\u0002j\u0005=\u0004\u0003BA\r\u0003WJ1!!\u001cW\u0005\u0011)f.\u001b;\t\u0013\u0005E\u0004#!AA\u0002\u0005u\u0013a\u0001=%c\u0005AA.[7ji\u0016\u0014\b%\u0001\u0007cCR\u001c\u0007\u000eT5nSR,'/\u0001\tcCR\u001c\u0007\u000eT5nSR,'o\u0018\u0013fcR!\u0011\u0011NA>\u0011%\t\thEA\u0001\u0002\u0004\ti&A\u0007cCR\u001c\u0007\u000eT5nSR,'\u000fI\u000b\u0003\u0003\u0003\u0003\u0002\"!\u0007\u0002\u0004\u0006\u001d\u0015qS\u0005\u0004\u0003\u000b3&A\u0002+va2,'\u0007\u0005\u0003\u0002\n\u0006MUBAAF\u0015\u0011\ti)a$\u0002\u0011M,7-\u001e:jifT!!!%\u0002\t)\fg/Y\u0005\u0005\u0003+\u000bYI\u0001\u0006Qe&4\u0018\r^3LKf\u0004B!!#\u0002\u001a&!\u00111TAF\u0005%\u0001VO\u00197jG.+\u00170A\ttS\u001et\u0017N\\4Qe&4\u0018\r^3LKf,\"!a\"\u0002!MLwM\\5oOB+(\r\\5d\u0017\u0016LXCAAL\u0003u)gnZ5oKN#\u0018M\u001d;vaB\u0013xnY3tgN+W.\u00199i_J,WCAAU!\u0019\tI\"a\u0007\u0002,B!\u0011QVA\\\u001b\t\tyK\u0003\u0003\u00022\u0006M\u0016AC2p]\u000e,(O]3oi*!\u0011QWAH\u0003\u0011)H/\u001b7\n\t\u0005e\u0016q\u0016\u0002\n'\u0016l\u0017\r\u001d5pe\u0016\f\u0011%\u001a8hS:,7\u000b^1siV\u0004\bK]8dKN\u001c8+Z7ba\"|'/Z0%KF$B!!\u001b\u0002@\"I\u0011\u0011O\r\u0002\u0002\u0003\u0007\u0011\u0011V\u0001\u001fK:<\u0017N\\3Ti\u0006\u0014H/\u001e9Qe>\u001cWm]:TK6\f\u0007\u000f[8sK\u0002\nA$\u001a8hS:,7i\u001c8oK\u000e$\u0018n\u001c8BY&4Xm\u00115fG.,'/\u0006\u0002\u0002HB!\u0011QVAe\u0013\u0011\tY-a,\u00031M\u001b\u0007.\u001a3vY\u0016$W\t_3dkR|'oU3sm&\u001cW-A\u000ff]\u001eLg.Z\"p]:,7\r^5p]\u0006c\u0017N^3DQ\u0016\u001c7.\u001a:!\u0003=!X-\u001c9GS2,7+\u001a:wS\u000e,WCAAj!\u0011\t).a7\u000e\u0005\u0005]'bAAm\u0007\u000691/\u001a:wS\u000e,\u0017\u0002BAo\u0003/\u0014q\u0002V3na\u001aKG.Z*feZL7-Z\u0001\u0011i\u0016l\u0007OR5mKN+'O^5dK\u0002\n!\"\u001b8ji&\fG.\u001b>f)\u0011\tI'!:\t\u000f\u0005\u001dx\u00041\u0001\u0002j\u0006!1m\u001c8g!\u0011\tY/!=\u000e\u0005\u00055(bAAx\u0007\u000611m\u001c8gS\u001eLA!a=\u0002n\nQ1*_;vE&\u001cuN\u001c4\u0002\u001b\r\u0014X-\u0019;f'\u0016\u001c8/[8o)1\tI0a@\u0003\u001e\t\u0005\"Q\u0005B\u0015!\ra\u00151`\u0005\u0004\u0003{\f%aB*fgNLwN\u001c\u0005\b\u0005\u0003\u0001\u0003\u0019\u0001B\u0002\u0003!\u0001(o\u001c;pG>d\u0007\u0003\u0002B\u0003\u00053i!Aa\u0002\u000b\t\t%!1B\u0001\u0007i\"\u0014\u0018N\u001a;\u000b\t\t5!qB\u0001\u0004eB\u001c'\u0002BAm\u0005#QAAa\u0005\u0003\u0016\u0005!\u0001.\u001b<f\u0015\r\u00119bQ\u0001\u0007g\"\fG-\u001a3\n\t\tm!q\u0001\u0002\u0011)B\u0013x\u000e^8d_24VM]:j_:DaAa\b!\u0001\u0004\u0001\u0016\u0001B;tKJDaAa\t!\u0001\u0004\u0001\u0016\u0001\u00039bgN<xN\u001d3\t\r\t\u001d\u0002\u00051\u0001Q\u0003%I\u0007/\u00113ee\u0016\u001c8\u000fC\u0004\u0002h\u0002\u0002\rAa\u000b\u0011\u000bE\u0013i\u0003\u0015)\n\u0007\t=BLA\u0002NCB\f1b\u001c9f]N+7o]5p]Ra!Q\u0007B\u001e\u0005{\u0011yD!\u0011\u0003DA\u0019AJa\u000e\n\u0007\te\u0012IA\u0007TKN\u001c\u0018n\u001c8IC:$G.\u001a\u0005\b\u0005\u0003\t\u0003\u0019\u0001B\u0002\u0011\u0019\u0011y\"\ta\u0001!\"1!1E\u0011A\u0002ACaAa\n\"\u0001\u0004\u0001\u0006bBAtC\u0001\u0007!1F\u0001\rG2|7/Z*fgNLwN\u001c\u000b\u0005\u0003S\u0012I\u0005C\u0004\u0003L\t\u0002\rA!\u000e\u0002\u001bM,7o]5p]\"\u000bg\u000e\u001a7f\u0003I\u0019'/Z1uK\n\u000bGo\u00195TKN\u001c\u0018n\u001c8\u00151\tE#q\u000bB-\u00057\u0012iFa\u0018\u0003d\t%$Q\u000eB9\u0005o\u00129\tE\u0002M\u0005'J1A!\u0016B\u0005IY\u00150^;cS\n\u000bGo\u00195TKN\u001c\u0018n\u001c8\t\r\t}1\u00051\u0001Q\u0011\u0019\u0011\u0019c\ta\u0001!\"1!qE\u0012A\u0002ACq!a:$\u0001\u0004\u0011Y\u0003\u0003\u0004\u0003b\r\u0002\r\u0001U\u0001\nE\u0006$8\r\u001b+za\u0016DqA!\u001a$\u0001\u0004\u00119'A\u0005cCR\u001c\u0007NT1nKB)\u0011\u0011DA\u000e!\"1!1N\u0012A\u0002A\u000b\u0001B]3t_V\u00148-\u001a\u0005\u0007\u0005_\u001a\u0003\u0019\u0001)\u0002\u0013\rd\u0017m]:OC6,\u0007b\u0002B:G\u0001\u0007!QO\u0001\nE\u0006$8\r[!sON\u0004R!a\r\u0002>AC\u0011\"!\n$!\u0003\u0005\rA!\u001f\u0011\r\u0005e\u00111\u0004B>!\u0011\u0011iHa!\u000e\u0005\t}$\u0002\u0002BA\u0003G\t1!\u00199j\u0013\u0011\u0011)Ia \u0003\u00115+G/\u00193bi\u0006DqA!#$\u0001\u0004\u0011Y)\u0001\u0007ge>l'+Z2pm\u0016\u0014\u0018\u0010\u0005\u0003\u0002\u001a\t5\u0015b\u0001BH-\n9!i\\8mK\u0006t\u0017!H2sK\u0006$XMQ1uG\"\u001cVm]:j_:$C-\u001a4bk2$H%\r\u0019\u0016\u0005\tU%\u0006\u0002B=\u0005/[#A!'\u0011\t\tm%QU\u0007\u0003\u0005;SAAa(\u0003\"\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0005G3\u0016AC1o]>$\u0018\r^5p]&!!q\u0015BO\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u0011_B,gNQ1uG\"\u001cVm]:j_:$BA!\u000e\u0003.\"9!qV\u0013A\u0002\tE\u0013\u0001\u00042bi\u000eD7+Z:tS>tGC\u0003B\u001b\u0005g\u0013)La.\u0003:\"1!q\u0004\u0014A\u0002ACaAa\t'\u0001\u0004\u0001\u0006B\u0002B\u0014M\u0001\u0007\u0001\u000bC\u0004\u0003<\u001a\u0002\rA!0\u0002\u0019\t\fGo\u00195SKF,Xm\u001d;\u0011\t\t}&qZ\u0007\u0003\u0005\u0003TAAa1\u0003F\u0006\u0019A\r^8\u000b\t\t\u001d'\u0011Z\u0001\u0003mFRAA!!\u0003L*\u0019!QZ\"\u0002\r\rd\u0017.\u001a8u\u0013\u0011\u0011\tN!1\u0003\u0019\t\u000bGo\u00195SKF,Xm\u001d;\u0002)%t\u0017\u000e^5bY&TXMQ1uG\"\u001cF/\u0019;f)%\u0001&q\u001bBm\u00057\u0014i\u000e\u0003\u0004\u0003 \u001d\u0002\r\u0001\u0015\u0005\u0007\u0005O9\u0003\u0019\u0001)\t\u000f\u0005\u001dx\u00051\u0001\u0003,!9!1X\u0014A\u0002\tu\u0016aD4fi\n\u000bGo\u00195TKN\u001c\u0018n\u001c8\u0015\t\t\r(Q\u001d\t\u0007\u00033\tYB!\u0015\t\u000f\t-\u0003\u00061\u0001\u00036\u0005q\u0011N\\:feRlU\r^1eCR\fG\u0003BA5\u0005WDq!!\n*\u0001\u0004\u0011Y(\u0001\bva\u0012\fG/Z'fi\u0006$\u0017\r^1\u0015\t\u0005%$\u0011\u001f\u0005\b\u0003KQ\u0003\u0019\u0001B>\u0003m9W\r^'fi\u0006$\u0017\r^1SKF,Xm\u001d;t%\u0016$(/\u001f*fMR!!q\u001fB\u0000!\u0019\tI\"a\u0007\u0003zB!\u0011\u0011\u0005B~\u0013\u0011\u0011i0a\t\u000315+G/\u00193bi\u0006\u0014V-];fgR\u001c(+\u001a;ssJ+g\r\u0003\u0004\u0004\u0002-\u0002\r\u0001U\u0001\u000bS\u0012,g\u000e^5gS\u0016\u0014\u0018A\t3f%\u0016<\u0017n\u001d;fe6+G/\u00193bi\u0006\u0014V-];fgR\u001c(+\u001a;ssJ+g\r\u0006\u0003\u0002j\r\u001d\u0001BBB\u0001Y\u0001\u0007\u0001+A\rhKR\u0014\u0015\r^2i\rJ|W.T3uC\u0012\fG/Y*u_J,G\u0003BB\u0007\u0007+\u0001b!!\u0007\u0002\u001c\r=\u0001\u0003\u0002B`\u0007#IAaa\u0005\u0003B\n)!)\u0019;dQ\"11qC\u0017A\u0002A\u000bqAY1uG\"LE-A\u000ehKR\u0014\u0015\r^2iKN4%o\\7NKR\fG-\u0019;b'R|'/\u001a\u000b\u000b\u0007;\u0019yb!\u000b\u00044\r]\u0002CBA\u001a\u0003{\u0019y\u0001C\u0004\u0004\"9\u0002\raa\t\u0002\r\u0019LG\u000e^3s!\u0011\u0011ih!\n\n\t\r\u001d\"q\u0010\u0002\u000f\u001b\u0016$\u0018\rZ1uC\u001aKG\u000e^3s\u0011\u001d\u0019YC\fa\u0001\u0007[\tAA\u001a:p[B!\u0011\u0011DB\u0018\u0013\r\u0019\tD\u0016\u0002\u0004\u0013:$\bbBB\u001b]\u0001\u00071QF\u0001\u0005g&TX\rC\u0005\u0004:9\u0002\n\u00111\u0001\u0003\f\u0006!A-Z:d\u0003\u0015:W\r\u001e\"bi\u000eDWm\u001d$s_6lU\r^1eCR\f7\u000b^8sK\u0012\"WMZ1vYR$C'\u0006\u0002\u0004@)\"!1\u0012BL\u0003A9W\r\u001e\"bi\u000eDW*\u001a;bI\u0006$\u0018\r\u0006\u0003\u0003z\r\u0015\u0003BBB\fa\u0001\u0007\u0001+A\bdY\u0016\fg.\u001e9NKR\fG-\u0019;b)\u0011\tIga\u0013\t\r\r\u0005\u0011\u00071\u0001QQ\r\t4q\n\t\u0005\u0007#\u001a\u0019'\u0004\u0002\u0004T)!1QKB,\u0003-\tgN\\8uCRLwN\\:\u000b\t\re31L\u0001\u0007G>lWn\u001c8\u000b\t\ru3qL\u0001\u0007O>|w\r\\3\u000b\u0005\r\u0005\u0014aA2p[&!1QMB*\u0005E1\u0016n]5cY\u00164uN\u001d+fgRLgnZ\u0001\u0006gR\f'\u000f\u001e\u000b\u0003\u0003S\n\u0011dZ3u\u0005\u0006$8\r[*fgNLwN\\:U_J+7m\u001c<feR!1qNB9!\u0019\t\u0019$!\u0010\u0003R!111O\u001aA\u0002A\u000bab[=vk\nL\u0017J\\:uC:\u001cW-\u0001\u0012hKR\u0004V-\u001a:J]N$\u0018M\\2f\u00072|7/\u001a3CCR\u001c\u0007nU3tg&|gn\u001d\u000b\u0005\u0007s\u001aY\b\u0005\u0004\u00024\u0005u\"1\u0010\u0005\u0007\u0007g\"\u0004\u0019\u0001)\u0002\u0011%\u001c8+\u001a:wKJ,\"Aa#\u0002%%t\u0017\u000e^*fgNLwN\u001c'j[&$XM\u001d\u000b\u0005\u0003S\u001a)\tC\u0004\u0002hZ\u0002\r!!;\u0002#\u001d,G/\u00168mS6LG/\u001a3Vg\u0016\u00148/\u0006\u0002\u0004\fB!\u0011k!$Q\u0013\r\u0019y\t\u0018\u0002\u0004'\u0016$\u0018!\u0006:fMJ,7\u000f[+oY&l\u0017\u000e^3e+N,'o\u001d\u000b\u0005\u0003S\u001a)\nC\u0004\u0002hb\u0002\r!!;\u0002\u0019\u001d,G\u000fR3osV\u001bXM]:\u0002!I,gM]3tQ\u0012+g._+tKJ\u001cH\u0003BA5\u0007;Cq!a:;\u0001\u0004\tI/\u0001\u0006hKR$UM\\=JaN\faB]3ge\u0016\u001c\b\u000eR3os&\u00038\u000f\u0006\u0003\u0002j\r\u0015\u0006bBAty\u0001\u0007\u0011\u0011^\u0001\u0014CB\u0004H._*fgNLwN\u001c'j[&$XM\u001d\u000b\u000f\u0003;\u001aYka,\u00044\u000e]61XB`\u0011\u001d\u0019i+\u0010a\u0001\u0007[\t\u0011\"^:fe2KW.\u001b;\t\u000f\rEV\b1\u0001\u0004.\u0005q\u0011\u000e]!eIJ,7o\u001d'j[&$\bbBB[{\u0001\u00071QF\u0001\u0013kN,'/\u00139BI\u0012\u0014Xm]:MS6LG\u000fC\u0004\u0004:v\u0002\raa#\u0002#U\u001cXM]+oY&l\u0017\u000e^3e\u0019&\u001cH\u000fC\u0004\u0004>v\u0002\raa#\u0002\u0019U\u001cXM\u001d#f]fd\u0015n\u001d;\t\u000f\r\u0005W\b1\u0001\u0004\f\u0006Q\u0011\u000e\u001d#f]fd\u0015n\u001d;\u0002/M$\u0018M\u001d;F]\u001eLg.Z!mSZ,7\t[3dW\u0016\u0014\u0018!I5oSR,enZ5oKN#\u0018M\u001d;vaB\u0013xnY3tgN+W.\u00199i_J,G\u0003BA5\u0007\u0013Dq!a:@\u0001\u0004\tI\u000f")
public class KyuubiSessionManager
extends SessionManager {
    private Option<MetadataManager> metadataManager;
    private Seq<SessionConfAdvisor> sessionConfAdvisor;
    private GroupProvider groupProvider;
    private Tuple2<PrivateKey, PublicKey> x$1;
    private PrivateKey signingPrivateKey;
    private PublicKey signingPublicKey;
    private final KyuubiParser parser = new KyuubiParser();
    private final KyuubiOperationManager operationManager = new KyuubiOperationManager();
    private final HadoopCredentialsManager credentialsManager = new HadoopCredentialsManager();
    private final KyuubiApplicationManager applicationManager = new KyuubiApplicationManager();
    private Option<SessionLimiter> limiter = None$.MODULE$;
    private Option<SessionLimiter> batchLimiter = None$.MODULE$;
    private Option<Semaphore> engineStartupProcessSemaphore = None$.MODULE$;
    private final ScheduledExecutorService engineConnectionAliveChecker;
    private final TempFileService tempFileService;
    private volatile byte bitmap$0;

    private KyuubiParser parser() {
        return this.parser;
    }

    public KyuubiOperationManager operationManager() {
        return this.operationManager;
    }

    public HadoopCredentialsManager credentialsManager() {
        return this.credentialsManager;
    }

    public KyuubiApplicationManager applicationManager() {
        return this.applicationManager;
    }

    private Option<MetadataManager> metadataManager$lzycompute() {
        KyuubiSessionManager kyuubiSessionManager = this;
        synchronized (kyuubiSessionManager) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.metadataManager = this.conf().isRESTEnabled() ? new Some((Object)new MetadataManager()) : None$.MODULE$;
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.metadataManager;
    }

    public Option<MetadataManager> metadataManager() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.metadataManager$lzycompute();
        }
        return this.metadataManager;
    }

    private Seq<SessionConfAdvisor> sessionConfAdvisor$lzycompute() {
        KyuubiSessionManager kyuubiSessionManager = this;
        synchronized (kyuubiSessionManager) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.sessionConfAdvisor = PluginLoader$.MODULE$.loadSessionConfAdvisor(this.conf());
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.sessionConfAdvisor;
    }

    public Seq<SessionConfAdvisor> sessionConfAdvisor() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.sessionConfAdvisor$lzycompute();
        }
        return this.sessionConfAdvisor;
    }

    private GroupProvider groupProvider$lzycompute() {
        KyuubiSessionManager kyuubiSessionManager = this;
        synchronized (kyuubiSessionManager) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.groupProvider = PluginLoader$.MODULE$.loadGroupProvider(this.conf());
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.groupProvider;
    }

    public GroupProvider groupProvider() {
        if ((byte)(this.bitmap$0 & 4) == 0) {
            return this.groupProvider$lzycompute();
        }
        return this.groupProvider;
    }

    private Option<SessionLimiter> limiter() {
        return this.limiter;
    }

    private void limiter_$eq(Option<SessionLimiter> x$1) {
        this.limiter = x$1;
    }

    private Option<SessionLimiter> batchLimiter() {
        return this.batchLimiter;
    }

    private void batchLimiter_$eq(Option<SessionLimiter> x$1) {
        this.batchLimiter = x$1;
    }

    private Tuple2<PrivateKey, PublicKey> x$1$lzycompute() {
        KyuubiSessionManager kyuubiSessionManager = this;
        synchronized (kyuubiSessionManager) {
            if ((byte)(this.bitmap$0 & 8) == 0) {
                Tuple2 tuple2 = SignUtils$.MODULE$.generateKeyPair(SignUtils$.MODULE$.generateKeyPair$default$1());
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                PrivateKey signingPrivateKey = (PrivateKey)tuple2._1();
                PublicKey signingPublicKey = (PublicKey)tuple2._2();
                this.x$1 = new Tuple2((Object)signingPrivateKey, (Object)signingPublicKey);
                this.bitmap$0 = (byte)(this.bitmap$0 | 8);
            }
        }
        return this.x$1;
    }

    private /* synthetic */ Tuple2 x$1() {
        if ((byte)(this.bitmap$0 & 8) == 0) {
            return this.x$1$lzycompute();
        }
        return this.x$1;
    }

    private PrivateKey signingPrivateKey$lzycompute() {
        KyuubiSessionManager kyuubiSessionManager = this;
        synchronized (kyuubiSessionManager) {
            if ((byte)(this.bitmap$0 & 0x10) == 0) {
                this.signingPrivateKey = (PrivateKey)this.x$1()._1();
                this.bitmap$0 = (byte)(this.bitmap$0 | 0x10);
            }
        }
        return this.signingPrivateKey;
    }

    public PrivateKey signingPrivateKey() {
        if ((byte)(this.bitmap$0 & 0x10) == 0) {
            return this.signingPrivateKey$lzycompute();
        }
        return this.signingPrivateKey;
    }

    private PublicKey signingPublicKey$lzycompute() {
        KyuubiSessionManager kyuubiSessionManager = this;
        synchronized (kyuubiSessionManager) {
            if ((byte)(this.bitmap$0 & 0x20) == 0) {
                this.signingPublicKey = (PublicKey)this.x$1()._2();
                this.bitmap$0 = (byte)(this.bitmap$0 | 0x20);
            }
        }
        return this.signingPublicKey;
    }

    public PublicKey signingPublicKey() {
        if ((byte)(this.bitmap$0 & 0x20) == 0) {
            return this.signingPublicKey$lzycompute();
        }
        return this.signingPublicKey;
    }

    public Option<Semaphore> engineStartupProcessSemaphore() {
        return this.engineStartupProcessSemaphore;
    }

    public void engineStartupProcessSemaphore_$eq(Option<Semaphore> x$1) {
        this.engineStartupProcessSemaphore = x$1;
    }

    private ScheduledExecutorService engineConnectionAliveChecker() {
        return this.engineConnectionAliveChecker;
    }

    public TempFileService tempFileService() {
        return this.tempFileService;
    }

    public void initialize(KyuubiConf conf) {
        this.conf_$eq(conf);
        this.addService((Service)this.applicationManager());
        this.addService((Service)this.credentialsManager());
        this.addService((Service)this.tempFileService());
        this.metadataManager().foreach((Function1 & Serializable & scala.Serializable)service -> {
            this.addService(service);
            return BoxedUnit.UNIT;
        });
        this.initSessionLimiter(conf);
        this.initEngineStartupProcessSemaphore(conf);
        super.initialize(conf);
    }

    public Session createSession(TProtocolVersion protocol, String user, String password, String ipAddress, Map<String, String> conf) {
        KyuubiConf userConf = this.getConf().getUserDefaults(user);
        return new KyuubiSessionImpl(protocol, user, password, ipAddress, conf, this, userConf, BoxesRunTime.unboxToBoolean((Object)userConf.get(KyuubiConf$.MODULE$.ENGINE_DO_AS_ENABLED())), this.parser());
    }

    public SessionHandle openSession(TProtocolVersion protocol, String user, String password, String ipAddress, Map<String, String> conf) {
        SessionHandle sessionHandle;
        String username = (String)Option$.MODULE$.apply((Object)user).filter((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)KyuubiSessionManager.$anonfun$openSession$1(x$2))).getOrElse((Function0 & Serializable & scala.Serializable)() -> "anonymous");
        this.limiter().foreach((Function1 & Serializable & scala.Serializable)x$3 -> {
            x$3.increment(new UserIpAddress(username, ipAddress));
            return BoxedUnit.UNIT;
        });
        try {
            sessionHandle = super.openSession(protocol, username, password, ipAddress, conf);
        }
        catch (Throwable e) {
            MetricsSystem$.MODULE$.tracing((Function1 & Serializable & scala.Serializable)ms -> {
                KyuubiSessionManager.$anonfun$openSession$4(user, ms);
                return BoxedUnit.UNIT;
            });
            throw KyuubiSQLException$.MODULE$.apply(new StringBuilder(46).append("Error opening session for ").append(username).append(" client ip ").append(ipAddress).append(", due to ").append(e.getMessage()).toString(), e, KyuubiSQLException$.MODULE$.apply$default$3(), KyuubiSQLException$.MODULE$.apply$default$4());
        }
        return sessionHandle;
    }

    public void closeSession(SessionHandle sessionHandle) {
        Session session = this.getSession(sessionHandle);
        try {
            super.closeSession(sessionHandle);
        }
        finally {
            Session session2 = session;
            if (session2 instanceof KyuubiBatchSession) {
                this.batchLimiter().foreach((Function1 & Serializable & scala.Serializable)x$4 -> {
                    x$4.decrement(new UserIpAddress(session.user(), session.ipAddress()));
                    return BoxedUnit.UNIT;
                });
            } else {
                this.limiter().foreach((Function1 & Serializable & scala.Serializable)x$5 -> {
                    x$5.decrement(new UserIpAddress(session.user(), session.ipAddress()));
                    return BoxedUnit.UNIT;
                });
            }
        }
    }

    public KyuubiBatchSession createBatchSession(String user, String password, String ipAddress, Map<String, String> conf, String batchType, Option<String> batchName, String resource, String className, Seq<String> batchArgs, Option<Metadata> metadata, boolean fromRecovery) {
        String username = (String)Option$.MODULE$.apply((Object)user).filter((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)KyuubiSessionManager.$anonfun$createBatchSession$1(x$6))).getOrElse((Function0 & Serializable & scala.Serializable)() -> "anonymous");
        KyuubiConf sessionConf = this.getConf().getUserDefaults(user);
        return new KyuubiBatchSession(username, password, ipAddress, conf, this, sessionConf, batchType, batchName, resource, className, batchArgs, metadata, fromRecovery);
    }

    public Option<Metadata> createBatchSession$default$10() {
        return None$.MODULE$;
    }

    public SessionHandle openBatchSession(KyuubiBatchSession batchSession) {
        SessionHandle sessionHandle;
        String user = batchSession.user();
        String ipAddress = batchSession.ipAddress();
        this.batchLimiter().foreach((Function1 & Serializable & scala.Serializable)x$7 -> {
            x$7.increment(new UserIpAddress(user, ipAddress));
            return BoxedUnit.UNIT;
        });
        SessionHandle handle = batchSession.handle();
        try {
            this.setSession(handle, (Session)batchSession);
            batchSession.open();
            this.logSessionCountInfo((Session)batchSession, "opened");
            sessionHandle = handle;
        }
        catch (Exception e) {
            try {
                this.closeSession(handle);
            }
            catch (Throwable t) {
                this.warn((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(46).append("Error closing batch session[").append(handle).append("] for ").append(user).append(" client ip: ").append(ipAddress).toString(), t);
            }
            MetricsSystem$.MODULE$.tracing((Function1 & Serializable & scala.Serializable)ms -> {
                KyuubiSessionManager.$anonfun$openBatchSession$3(user, ms);
                return BoxedUnit.UNIT;
            });
            throw KyuubiSQLException$.MODULE$.apply(new StringBuilder(54).append("Error opening batch session[").append(handle).append("] for ").append(user).append(" client ip ").append(ipAddress).append(",").append(" due to ").append(e.getMessage()).toString(), (Throwable)e, KyuubiSQLException$.MODULE$.apply$default$3(), KyuubiSQLException$.MODULE$.apply$default$4());
        }
        return sessionHandle;
    }

    public SessionHandle openBatchSession(String user, String password, String ipAddress, BatchRequest batchRequest) {
        KyuubiBatchSession batchSession = this.createBatchSession(user, password, ipAddress, (Map<String, String>)((TraversableOnce)JavaConverters$.MODULE$.mapAsScalaMapConverter(batchRequest.getConf()).asScala()).toMap(Predef$.MODULE$.$conforms()), batchRequest.getBatchType(), (Option<String>)Option$.MODULE$.apply((Object)batchRequest.getName()), batchRequest.getResource(), batchRequest.getClassName(), (Seq<String>)((SeqLike)JavaConverters$.MODULE$.asScalaBufferConverter(batchRequest.getArgs()).asScala()).toSeq(), (Option<Metadata>)None$.MODULE$, false);
        return this.openBatchSession(batchSession);
    }

    public String initializeBatchState(String user, String ipAddress, Map<String, String> conf, BatchRequest batchRequest) {
        String batchId;
        String realUser = (String)conf.getOrElse((Object)"kyuubi.session.real.user", (Function0 & Serializable & scala.Serializable)() -> user);
        String username = (String)Option$.MODULE$.apply((Object)user).filter((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)KyuubiSessionManager.$anonfun$initializeBatchState$2(x$8))).getOrElse((Function0 & Serializable & scala.Serializable)() -> "anonymous");
        String x$1 = batchId = (String)conf.apply((Object)BatchUtils.KYUUBI_BATCH_ID_KEY);
        Enumeration.Value x$2 = SessionType$.MODULE$.BATCH();
        String x$3 = realUser;
        String x$4 = username;
        String x$5 = ipAddress;
        String x$6 = OperationState$.MODULE$.INITIALIZED().toString();
        String x$7 = batchRequest.getResource();
        String x$82 = batchRequest.getClassName();
        String x$92 = batchRequest.getName();
        Map<String, String> x$102 = conf;
        Seq x$11 = ((SeqLike)JavaConverters$.MODULE$.asScalaBufferConverter(batchRequest.getArgs()).asScala()).toSeq();
        long x$12 = System.currentTimeMillis();
        String x$13 = batchRequest.getBatchType();
        int x$14 = BoxesRunTime.unboxToInt((Object)conf.get((Object)"kyuubi.batch.priority").map((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToInteger((int)KyuubiSessionManager.$anonfun$initializeBatchState$4(x$9))).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 10));
        String x$15 = Metadata$.MODULE$.apply$default$6();
        Option<String> x$16 = Metadata$.MODULE$.apply$default$15();
        long x$17 = Metadata$.MODULE$.apply$default$16();
        String x$18 = Metadata$.MODULE$.apply$default$17();
        String x$19 = Metadata$.MODULE$.apply$default$18();
        String x$20 = Metadata$.MODULE$.apply$default$19();
        String x$21 = Metadata$.MODULE$.apply$default$20();
        Option<String> x$22 = Metadata$.MODULE$.apply$default$21();
        long x$23 = Metadata$.MODULE$.apply$default$22();
        boolean x$24 = Metadata$.MODULE$.apply$default$24();
        Metadata metadata = new Metadata(x$1, x$2, x$3, x$4, x$5, x$15, x$6, x$7, x$82, x$92, x$102, (Seq<String>)x$11, x$12, x$13, x$16, x$17, x$18, x$19, x$20, x$21, x$22, x$23, x$14, x$24);
        this.metadataManager().foreach((Function1 & Serializable & scala.Serializable)x$10 -> {
            x$10.insertMetadata(metadata, false);
            return BoxedUnit.UNIT;
        });
        return batchId;
    }

    public Option<KyuubiBatchSession> getBatchSession(SessionHandle sessionHandle) {
        return this.getSessionOption(sessionHandle).map((Function1 & Serializable & scala.Serializable)x$11 -> (KyuubiBatchSession)((Object)x$11));
    }

    public void insertMetadata(Metadata metadata) {
        this.metadataManager().foreach((Function1 & Serializable & scala.Serializable)x$12 -> {
            x$12.insertMetadata(metadata, x$12.insertMetadata$default$2());
            return BoxedUnit.UNIT;
        });
    }

    public void updateMetadata(Metadata metadata) {
        this.metadataManager().foreach((Function1 & Serializable & scala.Serializable)x$13 -> {
            x$13.updateMetadata(metadata, x$13.updateMetadata$default$2());
            return BoxedUnit.UNIT;
        });
    }

    public Option<MetadataRequestsRetryRef> getMetadataRequestsRetryRef(String identifier) {
        return this.metadataManager().flatMap((Function1 & Serializable & scala.Serializable)mm -> Option$.MODULE$.apply((Object)mm.getMetadataRequestsRetryRef(identifier)));
    }

    public void deRegisterMetadataRequestsRetryRef(String identifier) {
        this.metadataManager().foreach((Function1 & Serializable & scala.Serializable)x$14 -> {
            x$14.deRegisterRequestsRetryRef(identifier);
            return BoxedUnit.UNIT;
        });
    }

    public Option<Batch> getBatchFromMetadataStore(String batchId) {
        return this.metadataManager().flatMap((Function1 & Serializable & scala.Serializable)mm -> mm.getBatch(batchId));
    }

    public Seq<Batch> getBatchesFromMetadataStore(MetadataFilter filter, int from, int size, boolean desc) {
        return (Seq)this.metadataManager().map((Function1 & Serializable & scala.Serializable)x$15 -> x$15.getBatches(filter, from, size, desc)).getOrElse((Function0 & Serializable & scala.Serializable)() -> (Seq)Nil$.MODULE$);
    }

    public boolean getBatchesFromMetadataStore$default$4() {
        return false;
    }

    public Option<Metadata> getBatchMetadata(String batchId) {
        return this.metadataManager().flatMap((Function1 & Serializable & scala.Serializable)x$16 -> x$16.getBatchSessionMetadata(batchId));
    }

    @VisibleForTesting
    public void cleanupMetadata(String identifier) {
        this.metadataManager().foreach((Function1 & Serializable & scala.Serializable)x$17 -> {
            x$17.cleanupMetadataById(identifier);
            return BoxedUnit.UNIT;
        });
    }

    public synchronized void start() {
        MetricsSystem$.MODULE$.tracing((Function1 & Serializable & scala.Serializable)ms -> {
            KyuubiSessionManager.$anonfun$start$1(this, ms);
            return BoxedUnit.UNIT;
        });
        super.start();
        this.startEngineAliveChecker();
    }

    public Seq<KyuubiBatchSession> getBatchSessionsToRecover(String kyuubiInstance) {
        return (Seq)((TraversableLike)new .colon.colon((Object)OperationState$.MODULE$.PENDING(), (List)new .colon.colon((Object)OperationState$.MODULE$.RUNNING(), (List)Nil$.MODULE$))).flatMap((Function1 & Serializable & scala.Serializable)stateToRecover -> (Seq)this.metadataManager().map((Function1 & Serializable & scala.Serializable)x$18 -> (Seq)x$18.getBatchesRecoveryMetadata(stateToRecover.toString(), kyuubiInstance, 0, Integer.MAX_VALUE).map((Function1 & Serializable & scala.Serializable)metadata -> this.createBatchSession(metadata.username(), "anonymous", metadata.ipAddress(), metadata.requestConf(), metadata.engineType(), (Option<String>)Option$.MODULE$.apply((Object)metadata.requestName()), metadata.resource(), metadata.className(), metadata.requestArgs(), (Option<Metadata>)new Some(metadata), true), Seq$.MODULE$.canBuildFrom())).getOrElse((Function0 & Serializable & scala.Serializable)() -> (Seq)Nil$.MODULE$), Seq$.MODULE$.canBuildFrom());
    }

    public Seq<Metadata> getPeerInstanceClosedBatchSessions(String kyuubiInstance) {
        return (Seq)((TraversableLike)new .colon.colon((Object)OperationState$.MODULE$.PENDING(), (List)new .colon.colon((Object)OperationState$.MODULE$.RUNNING(), (List)Nil$.MODULE$))).flatMap((Function1 & Serializable & scala.Serializable)stateToKill -> (Seq)this.metadataManager().map((Function1 & Serializable & scala.Serializable)x$19 -> x$19.getPeerInstanceClosedBatchesMetadata(stateToKill.toString(), kyuubiInstance, 0, Integer.MAX_VALUE)).getOrElse((Function0 & Serializable & scala.Serializable)() -> (Seq)Nil$.MODULE$), Seq$.MODULE$.canBuildFrom());
    }

    public boolean isServer() {
        return true;
    }

    private void initSessionLimiter(KyuubiConf conf) {
        int userLimit = BoxesRunTime.unboxToInt((Object)((Option)conf.get((ConfigEntry)KyuubiConf$.MODULE$.SERVER_LIMIT_CONNECTIONS_PER_USER())).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0));
        int ipAddressLimit = BoxesRunTime.unboxToInt((Object)((Option)conf.get((ConfigEntry)KyuubiConf$.MODULE$.SERVER_LIMIT_CONNECTIONS_PER_IPADDRESS())).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0));
        int userIpAddressLimit = BoxesRunTime.unboxToInt((Object)((Option)conf.get((ConfigEntry)KyuubiConf$.MODULE$.SERVER_LIMIT_CONNECTIONS_PER_USER_IPADDRESS())).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0));
        Set userUnlimitedList = (Set)((TraversableLike)conf.get(KyuubiConf$.MODULE$.SERVER_LIMIT_CONNECTIONS_USER_UNLIMITED_LIST())).filter((Function1 & Serializable & scala.Serializable)x$20 -> BoxesRunTime.boxToBoolean((boolean)KyuubiSessionManager.$anonfun$initSessionLimiter$4(x$20)));
        Set userDenyList = (Set)((TraversableLike)conf.get(KyuubiConf$.MODULE$.SERVER_LIMIT_CONNECTIONS_USER_DENY_LIST())).filter((Function1 & Serializable & scala.Serializable)x$21 -> BoxesRunTime.boxToBoolean((boolean)KyuubiSessionManager.$anonfun$initSessionLimiter$5(x$21)));
        Set ipDenyList = (Set)((TraversableLike)conf.get(KyuubiConf$.MODULE$.SERVER_LIMIT_CONNECTIONS_IP_DENY_LIST())).filter((Function1 & Serializable & scala.Serializable)x$22 -> BoxesRunTime.boxToBoolean((boolean)KyuubiSessionManager.$anonfun$initSessionLimiter$6(x$22)));
        this.limiter_$eq(this.applySessionLimiter(userLimit, ipAddressLimit, userIpAddressLimit, (Set<String>)userUnlimitedList, (Set<String>)userDenyList, (Set<String>)ipDenyList));
        int userBatchLimit = BoxesRunTime.unboxToInt((Object)((Option)conf.get((ConfigEntry)KyuubiConf$.MODULE$.SERVER_LIMIT_BATCH_CONNECTIONS_PER_USER())).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0));
        int ipAddressBatchLimit = BoxesRunTime.unboxToInt((Object)((Option)conf.get((ConfigEntry)KyuubiConf$.MODULE$.SERVER_LIMIT_BATCH_CONNECTIONS_PER_IPADDRESS())).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0));
        int userIpAddressBatchLimit = BoxesRunTime.unboxToInt((Object)((Option)conf.get((ConfigEntry)KyuubiConf$.MODULE$.SERVER_LIMIT_BATCH_CONNECTIONS_PER_USER_IPADDRESS())).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0));
        this.batchLimiter_$eq(this.applySessionLimiter(userBatchLimit, ipAddressBatchLimit, userIpAddressBatchLimit, (Set<String>)userUnlimitedList, (Set<String>)userDenyList, (Set<String>)ipDenyList));
    }

    public Set<String> getUnlimitedUsers() {
        return (Set)this.limiter().orElse((Function0 & Serializable & scala.Serializable)() -> this.batchLimiter()).map((Function1 & Serializable & scala.Serializable)limiter -> SessionLimiter$.MODULE$.getUnlimitedUsers((SessionLimiter)limiter)).getOrElse((Function0 & Serializable & scala.Serializable)() -> Predef$.MODULE$.Set().empty());
    }

    public void refreshUnlimitedUsers(KyuubiConf conf) {
        Set unlimitedUsers = (Set)((TraversableLike)conf.get(KyuubiConf$.MODULE$.SERVER_LIMIT_CONNECTIONS_USER_UNLIMITED_LIST())).filter((Function1 & Serializable & scala.Serializable)x$23 -> BoxesRunTime.boxToBoolean((boolean)KyuubiSessionManager.$anonfun$refreshUnlimitedUsers$1(x$23)));
        this.limiter().foreach((Function1 & Serializable & scala.Serializable)x$24 -> {
            SessionLimiter$.MODULE$.resetUnlimitedUsers(x$24, (Set<String>)unlimitedUsers);
            return BoxedUnit.UNIT;
        });
        this.batchLimiter().foreach((Function1 & Serializable & scala.Serializable)x$25 -> {
            SessionLimiter$.MODULE$.resetUnlimitedUsers(x$25, (Set<String>)unlimitedUsers);
            return BoxedUnit.UNIT;
        });
    }

    public Set<String> getDenyUsers() {
        return (Set)this.limiter().orElse((Function0 & Serializable & scala.Serializable)() -> this.batchLimiter()).map((Function1 & Serializable & scala.Serializable)limiter -> SessionLimiter$.MODULE$.getDenyUsers((SessionLimiter)limiter)).getOrElse((Function0 & Serializable & scala.Serializable)() -> Predef$.MODULE$.Set().empty());
    }

    public void refreshDenyUsers(KyuubiConf conf) {
        Set denyUsers = (Set)((TraversableLike)conf.get(KyuubiConf$.MODULE$.SERVER_LIMIT_CONNECTIONS_USER_DENY_LIST())).filter((Function1 & Serializable & scala.Serializable)x$26 -> BoxesRunTime.boxToBoolean((boolean)KyuubiSessionManager.$anonfun$refreshDenyUsers$1(x$26)));
        this.limiter().foreach((Function1 & Serializable & scala.Serializable)x$27 -> {
            SessionLimiter$.MODULE$.resetDenyUsers(x$27, (Set<String>)denyUsers);
            return BoxedUnit.UNIT;
        });
        this.batchLimiter().foreach((Function1 & Serializable & scala.Serializable)x$28 -> {
            SessionLimiter$.MODULE$.resetDenyUsers(x$28, (Set<String>)denyUsers);
            return BoxedUnit.UNIT;
        });
    }

    public Set<String> getDenyIps() {
        return (Set)this.limiter().orElse((Function0 & Serializable & scala.Serializable)() -> this.batchLimiter()).map((Function1 & Serializable & scala.Serializable)limiter -> SessionLimiter$.MODULE$.getDenyIps((SessionLimiter)limiter)).getOrElse((Function0 & Serializable & scala.Serializable)() -> Predef$.MODULE$.Set().empty());
    }

    public void refreshDenyIps(KyuubiConf conf) {
        Set denyIps = (Set)((TraversableLike)conf.get(KyuubiConf$.MODULE$.SERVER_LIMIT_CONNECTIONS_IP_DENY_LIST())).filter((Function1 & Serializable & scala.Serializable)x$29 -> BoxesRunTime.boxToBoolean((boolean)KyuubiSessionManager.$anonfun$refreshDenyIps$1(x$29)));
        this.limiter().foreach((Function1 & Serializable & scala.Serializable)x$30 -> {
            SessionLimiter$.MODULE$.resetDenyIps(x$30, (Set<String>)denyIps);
            return BoxedUnit.UNIT;
        });
        this.batchLimiter().foreach((Function1 & Serializable & scala.Serializable)x$31 -> {
            SessionLimiter$.MODULE$.resetDenyIps(x$31, (Set<String>)denyIps);
            return BoxedUnit.UNIT;
        });
    }

    private Option<SessionLimiter> applySessionLimiter(int userLimit, int ipAddressLimit, int userIpAddressLimit, Set<String> userUnlimitedList, Set<String> userDenyList, Set<String> ipDenyList) {
        if (((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{userLimit, ipAddressLimit, userIpAddressLimit}))).exists((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$32 -> x$32 > 0) || userDenyList.nonEmpty() || ipDenyList.nonEmpty()) {
            return new Some((Object)SessionLimiter$.MODULE$.apply(userLimit, ipAddressLimit, userIpAddressLimit, userUnlimitedList, userDenyList, ipDenyList));
        }
        return None$.MODULE$;
    }

    private void startEngineAliveChecker() {
        long interval = BoxesRunTime.unboxToLong((Object)this.conf().get(KyuubiConf$.MODULE$.ENGINE_ALIVE_PROBE_INTERVAL()));
        Runnable checkTask = () -> this.allSessions().foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            KyuubiSessionManager.$anonfun$startEngineAliveChecker$2(this, x0$1);
            return BoxedUnit.UNIT;
        });
        ThreadUtils$.MODULE$.scheduleTolerableRunnableWithFixedDelay(this.engineConnectionAliveChecker(), checkTask, interval, interval, TimeUnit.MILLISECONDS);
    }

    private void initEngineStartupProcessSemaphore(KyuubiConf conf) {
        Option engineCreationLimit = (Option)conf.get((ConfigEntry)KyuubiConf$.MODULE$.SERVER_LIMIT_ENGINE_CREATION());
        engineCreationLimit.filter((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$33 -> x$33 > 0).foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)limit -> this.engineStartupProcessSemaphore_$eq((Option<Semaphore>)new Some((Object)new Semaphore(limit))));
    }

    public static final /* synthetic */ boolean $anonfun$openSession$1(String x$2) {
        return new StringOps(Predef$.MODULE$.augmentString(x$2)).nonEmpty();
    }

    public static final /* synthetic */ void $anonfun$openSession$4(String user$1, MetricsSystem ms) {
        ms.incCount(MetricsConstants$.MODULE$.CONN_FAIL());
        ms.incCount(MetricRegistry.name((String)MetricsConstants$.MODULE$.CONN_FAIL(), (String[])new String[]{user$1}));
        ms.incCount(MetricRegistry.name((String)MetricsConstants$.MODULE$.CONN_FAIL(), (String[])new String[]{SessionType$.MODULE$.INTERACTIVE().toString()}));
    }

    public static final /* synthetic */ boolean $anonfun$createBatchSession$1(String x$6) {
        return new StringOps(Predef$.MODULE$.augmentString(x$6)).nonEmpty();
    }

    public static final /* synthetic */ void $anonfun$openBatchSession$3(String user$2, MetricsSystem ms) {
        ms.incCount(MetricsConstants$.MODULE$.CONN_FAIL());
        ms.incCount(MetricRegistry.name((String)MetricsConstants$.MODULE$.CONN_FAIL(), (String[])new String[]{user$2}));
        ms.incCount(MetricRegistry.name((String)MetricsConstants$.MODULE$.CONN_FAIL(), (String[])new String[]{SessionType$.MODULE$.BATCH().toString()}));
    }

    public static final /* synthetic */ boolean $anonfun$initializeBatchState$2(String x$8) {
        return new StringOps(Predef$.MODULE$.augmentString(x$8)).nonEmpty();
    }

    public static final /* synthetic */ int $anonfun$initializeBatchState$4(String x$9) {
        return new StringOps(Predef$.MODULE$.augmentString(x$9)).toInt();
    }

    public static final /* synthetic */ void $anonfun$start$1(KyuubiSessionManager $this, MetricsSystem ms) {
        ms.registerGauge(MetricsConstants$.MODULE$.CONN_OPEN(), (Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> $this.getActiveUserSessionCount(), (Object)BoxesRunTime.boxToInteger((int)0));
        ms.registerGauge(MetricsConstants$.MODULE$.EXEC_POOL_ALIVE(), (Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> $this.getExecPoolSize(), (Object)BoxesRunTime.boxToInteger((int)0));
        ms.registerGauge(MetricsConstants$.MODULE$.EXEC_POOL_ACTIVE(), (Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> $this.getActiveCount(), (Object)BoxesRunTime.boxToInteger((int)0));
        ms.registerGauge(MetricsConstants$.MODULE$.EXEC_POOL_WORK_QUEUE_SIZE(), (Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> $this.getWorkQueueSize(), (Object)BoxesRunTime.boxToInteger((int)0));
    }

    public static final /* synthetic */ boolean $anonfun$initSessionLimiter$4(String x$20) {
        return new StringOps(Predef$.MODULE$.augmentString(x$20)).nonEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$initSessionLimiter$5(String x$21) {
        return new StringOps(Predef$.MODULE$.augmentString(x$21)).nonEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$initSessionLimiter$6(String x$22) {
        return new StringOps(Predef$.MODULE$.augmentString(x$22)).nonEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$refreshUnlimitedUsers$1(String x$23) {
        return new StringOps(Predef$.MODULE$.augmentString(x$23)).nonEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$refreshDenyUsers$1(String x$26) {
        return new StringOps(Predef$.MODULE$.augmentString(x$26)).nonEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$refreshDenyIps$1(String x$29) {
        return new StringOps(Predef$.MODULE$.augmentString(x$29)).nonEmpty();
    }

    public static final /* synthetic */ void $anonfun$startEngineAliveChecker$2(KyuubiSessionManager $this, Session x0$1) {
        Session session = x0$1;
        if (session instanceof KyuubiSessionImpl) {
            BoxedUnit boxedUnit;
            KyuubiSessionImpl kyuubiSessionImpl = (KyuubiSessionImpl)session;
            try {
                if (!kyuubiSessionImpl.checkEngineConnectionAlive()) {
                    $this.closeSession(kyuubiSessionImpl.handle());
                    $this.logger().info(new StringBuilder(98).append("The session ").append(kyuubiSessionImpl.handle()).append(" has been closed ").append("due to engine unresponsiveness (checked by the engine alive checker).").toString());
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
            }
            catch (Throwable e) {
                $this.warn((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(22).append("Error closing session ").append(kyuubiSessionImpl.handle()).toString(), e);
                boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
    }

    private KyuubiSessionManager(String name) {
        super(name);
        this.engineConnectionAliveChecker = ThreadUtils$.MODULE$.newDaemonSingleThreadScheduledExecutor(new StringBuilder(21).append(name).append("-engine-alive-checker").toString(), ThreadUtils$.MODULE$.newDaemonSingleThreadScheduledExecutor$default$2());
        this.tempFileService = new TempFileService();
    }

    public KyuubiSessionManager() {
        this(KyuubiSessionManager.class.getSimpleName());
    }
}

