/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core;

import io.vertx.codegen.annotations.DataObject;
import io.vertx.codegen.annotations.GenIgnore;
import io.vertx.codegen.json.annotations.JsonGen;
import io.vertx.core.DeploymentOptionsConverter;
import io.vertx.core.ThreadingModel;
import io.vertx.core.VertxOptions;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
@DataObject
@JsonGen(publicConverter=false)
public class DeploymentOptions {
    public static final ThreadingModel DEFAULT_MODE = ThreadingModel.EVENT_LOOP;
    public static final boolean DEFAULT_WORKER = false;
    public static final boolean DEFAULT_HA = false;
    public static final int DEFAULT_INSTANCES = 1;
    private JsonObject config;
    private ThreadingModel threadingModel;
    private String isolationGroup;
    private boolean ha;
    private List<String> extraClasspath;
    private int instances;
    private List<String> isolatedClasses;
    private ClassLoader classLoader;
    private String workerPoolName;
    private int workerPoolSize;
    private long maxWorkerExecuteTime;
    private TimeUnit maxWorkerExecuteTimeUnit;

    public DeploymentOptions() {
        this.threadingModel = DEFAULT_MODE;
        this.config = null;
        this.isolationGroup = null;
        this.ha = false;
        this.instances = 1;
        this.workerPoolSize = 20;
        this.maxWorkerExecuteTime = VertxOptions.DEFAULT_MAX_WORKER_EXECUTE_TIME;
        this.maxWorkerExecuteTimeUnit = VertxOptions.DEFAULT_MAX_WORKER_EXECUTE_TIME_UNIT;
    }

    public DeploymentOptions(DeploymentOptions other) {
        this.config = other.getConfig() == null ? null : other.getConfig().copy();
        this.threadingModel = other.getThreadingModel();
        this.isolationGroup = other.getIsolationGroup();
        this.ha = other.isHa();
        this.extraClasspath = other.getExtraClasspath() == null ? null : new ArrayList<String>(other.getExtraClasspath());
        this.instances = other.instances;
        this.isolatedClasses = other.getIsolatedClasses() == null ? null : new ArrayList<String>(other.getIsolatedClasses());
        this.workerPoolName = other.workerPoolName;
        this.workerPoolSize = other.workerPoolSize;
        this.maxWorkerExecuteTime = other.maxWorkerExecuteTime;
        this.maxWorkerExecuteTimeUnit = other.maxWorkerExecuteTimeUnit;
    }

    public DeploymentOptions(JsonObject json) {
        this();
        JsonArray arrIsolated;
        DeploymentOptionsConverter.fromJson(json, this);
        this.isolationGroup = json.getString("isolationGroup");
        JsonArray arr = json.getJsonArray("extraClasspath");
        if (arr != null) {
            this.extraClasspath = arr.getList();
        }
        if ((arrIsolated = json.getJsonArray("isolatedClasses")) != null) {
            this.isolatedClasses = arrIsolated.getList();
        }
    }

    public JsonObject getConfig() {
        return this.config;
    }

    public DeploymentOptions setConfig(JsonObject config) {
        this.config = config;
        return this;
    }

    public ThreadingModel getThreadingModel() {
        return this.threadingModel;
    }

    public DeploymentOptions setThreadingModel(ThreadingModel threadingModel) {
        this.threadingModel = threadingModel;
        return this;
    }

    @Deprecated
    public boolean isWorker() {
        return this.threadingModel == ThreadingModel.WORKER;
    }

    @Deprecated
    public DeploymentOptions setWorker(boolean worker) {
        this.threadingModel = worker ? ThreadingModel.WORKER : ThreadingModel.EVENT_LOOP;
        return this;
    }

    @GenIgnore
    @Deprecated
    public String getIsolationGroup() {
        return this.isolationGroup;
    }

    @GenIgnore
    @Deprecated
    public DeploymentOptions setIsolationGroup(String isolationGroup) {
        this.isolationGroup = isolationGroup;
        return this;
    }

    public boolean isHa() {
        return this.ha;
    }

    public DeploymentOptions setHa(boolean ha) {
        this.ha = ha;
        return this;
    }

    @GenIgnore
    @Deprecated
    public List<String> getExtraClasspath() {
        return this.extraClasspath;
    }

    @GenIgnore
    @Deprecated
    public DeploymentOptions setExtraClasspath(List<String> extraClasspath) {
        this.extraClasspath = extraClasspath;
        return this;
    }

    public int getInstances() {
        return this.instances;
    }

    public DeploymentOptions setInstances(int instances) {
        this.instances = instances;
        return this;
    }

    @GenIgnore
    @Deprecated
    public List<String> getIsolatedClasses() {
        return this.isolatedClasses;
    }

    @GenIgnore
    @Deprecated
    public DeploymentOptions setIsolatedClasses(List<String> isolatedClasses) {
        this.isolatedClasses = isolatedClasses;
        return this;
    }

    public String getWorkerPoolName() {
        return this.workerPoolName;
    }

    public DeploymentOptions setWorkerPoolName(String workerPoolName) {
        this.workerPoolName = workerPoolName;
        return this;
    }

    public int getWorkerPoolSize() {
        return this.workerPoolSize;
    }

    public DeploymentOptions setWorkerPoolSize(int workerPoolSize) {
        if (workerPoolSize < 1) {
            throw new IllegalArgumentException("size must be > 0");
        }
        this.workerPoolSize = workerPoolSize;
        return this;
    }

    public long getMaxWorkerExecuteTime() {
        return this.maxWorkerExecuteTime;
    }

    public DeploymentOptions setMaxWorkerExecuteTime(long maxWorkerExecuteTime) {
        if (maxWorkerExecuteTime < 1L) {
            throw new IllegalArgumentException("maxExecuteTime must be > 0");
        }
        this.maxWorkerExecuteTime = maxWorkerExecuteTime;
        return this;
    }

    public TimeUnit getMaxWorkerExecuteTimeUnit() {
        return this.maxWorkerExecuteTimeUnit;
    }

    public DeploymentOptions setMaxWorkerExecuteTimeUnit(TimeUnit maxWorkerExecuteTimeUnit) {
        this.maxWorkerExecuteTimeUnit = maxWorkerExecuteTimeUnit;
        return this;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public DeploymentOptions setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
        return this;
    }

    public void checkIsolationNotDefined() {
        if (this.getExtraClasspath() != null) {
            throw new IllegalArgumentException("Can't specify extraClasspath for already created verticle");
        }
        if (this.getIsolationGroup() != null) {
            throw new IllegalArgumentException("Can't specify isolationGroup for already created verticle");
        }
        if (this.getIsolatedClasses() != null) {
            throw new IllegalArgumentException("Can't specify isolatedClasses for already created verticle");
        }
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        if (this.extraClasspath != null) {
            json.put("extraClasspath", new JsonArray(this.extraClasspath));
        }
        if (this.isolatedClasses != null) {
            json.put("isolatedClasses", new JsonArray(this.isolatedClasses));
        }
        if (this.isolationGroup != null) {
            json.put("isolationGroup", this.isolationGroup);
        }
        DeploymentOptionsConverter.toJson(this, json);
        return json;
    }
}

