/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.async.logger;

import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.async.logger.AsyncLoggerConfigDisruptor;
import org.apache.logging.log4j.async.logger.AsyncWaitStrategyFactory;
import org.apache.logging.log4j.core.AbstractLifeCycle;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.ConfigurationExtension;
import org.apache.logging.log4j.plugins.Configurable;
import org.apache.logging.log4j.plugins.Inject;
import org.apache.logging.log4j.plugins.Plugin;
import org.apache.logging.log4j.plugins.PluginAliases;
import org.apache.logging.log4j.plugins.PluginBuilderAttribute;
import org.apache.logging.log4j.plugins.PluginFactory;
import org.apache.logging.log4j.plugins.di.Key;
import org.apache.logging.log4j.status.StatusLogger;
import org.apache.logging.log4j.util.Lazy;
import org.apache.logging.log4j.util.LoaderUtil;
import org.jspecify.annotations.Nullable;

@Configurable(printObject=true)
@Plugin(value="Disruptor")
@PluginAliases(value={"AsyncWaitStrategyFactory"})
public final class DisruptorConfiguration
extends AbstractLifeCycle
implements ConfigurationExtension {
    private static final Logger LOGGER = StatusLogger.getLogger();
    private final @Nullable AsyncWaitStrategyFactory waitStrategyFactory;
    private final Lazy<AsyncLoggerConfigDisruptor> loggerConfigDisruptor;

    private DisruptorConfiguration(@Nullable AsyncWaitStrategyFactory waitStrategyFactory, Configuration configuration) {
        this.waitStrategyFactory = waitStrategyFactory;
        this.loggerConfigDisruptor = Lazy.lazy(() -> (AsyncLoggerConfigDisruptor)((Object)((Object)configuration.getComponent(Key.forClass(AsyncLoggerConfigDisruptor.class)))));
    }

    public @Nullable AsyncWaitStrategyFactory getWaitStrategyFactory() {
        return this.waitStrategyFactory;
    }

    AsyncLoggerConfigDisruptor getLoggerConfigDisruptor() {
        return (AsyncLoggerConfigDisruptor)((Object)this.loggerConfigDisruptor.get());
    }

    public void start() {
        LOGGER.info("Starting AsyncLoggerConfigDisruptor.");
        ((AsyncLoggerConfigDisruptor)((Object)this.loggerConfigDisruptor.get())).start();
        super.start();
    }

    public boolean stop(long timeout, TimeUnit timeUnit) {
        LOGGER.info("Stopping AsyncLoggerConfigDisruptor.");
        ((AsyncLoggerConfigDisruptor)((Object)this.loggerConfigDisruptor.get())).stop(timeout, timeUnit);
        return super.stop(timeout, timeUnit);
    }

    @PluginFactory
    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder
    implements org.apache.logging.log4j.plugins.util.Builder<DisruptorConfiguration> {
        @PluginBuilderAttribute(value="class")
        private @PluginBuilderAttribute(value="class") String factoryClassName;
        @PluginBuilderAttribute
        private String waitFactory;
        private Configuration configuration;

        public Builder setFactoryClassName(String factoryClassName) {
            this.factoryClassName = factoryClassName;
            return this;
        }

        public Builder setWaitFactory(String waitFactory) {
            this.waitFactory = waitFactory;
            return this;
        }

        @Inject
        public Builder setConfiguration(Configuration configuration) {
            this.configuration = configuration;
            return this;
        }

        public DisruptorConfiguration build() {
            String factoryClassName = Objects.toString(this.waitFactory, this.factoryClassName);
            if (factoryClassName != null) {
                try {
                    AsyncWaitStrategyFactory asyncWaitStrategyFactory = (AsyncWaitStrategyFactory)LoaderUtil.newCheckedInstanceOf((String)factoryClassName, AsyncWaitStrategyFactory.class);
                    LOGGER.info("Using configured AsyncWaitStrategy factory {}.", (Object)factoryClassName);
                    return new DisruptorConfiguration(asyncWaitStrategyFactory, this.configuration);
                }
                catch (ClassCastException e) {
                    LOGGER.error("Ignoring factory '{}': it is not assignable to AsyncWaitStrategyFactory", (Object)factoryClassName);
                }
                catch (LinkageError | ReflectiveOperationException e) {
                    LOGGER.warn("Invalid implementation class name value: error creating AsyncWaitStrategyFactory {}: {}", (Object)factoryClassName, (Object)e.getMessage(), (Object)e);
                }
            } else {
                LOGGER.info("Using default AsyncWaitStrategy factory.");
            }
            return new DisruptorConfiguration(null, this.configuration);
        }
    }
}

