/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.tests.codecs.cranky;

import java.io.IOException;
import java.util.Random;
import org.apache.lucene.codecs.DocValuesConsumer;
import org.apache.lucene.codecs.DocValuesFormat;
import org.apache.lucene.codecs.DocValuesProducer;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.index.SegmentWriteState;

class CrankyDocValuesFormat
extends DocValuesFormat {
    final DocValuesFormat delegate;
    final Random random;

    CrankyDocValuesFormat(DocValuesFormat delegate, Random random) {
        super(delegate.getName());
        this.delegate = delegate;
        this.random = random;
    }

    public DocValuesConsumer fieldsConsumer(SegmentWriteState state) throws IOException {
        if (this.random.nextInt(100) == 0) {
            throw new IOException("Fake IOException from DocValuesFormat.fieldsConsumer()");
        }
        return new CrankyDocValuesConsumer(this.delegate.fieldsConsumer(state), this.random);
    }

    public DocValuesProducer fieldsProducer(SegmentReadState state) throws IOException {
        return this.delegate.fieldsProducer(state);
    }

    static class CrankyDocValuesConsumer
    extends DocValuesConsumer {
        final DocValuesConsumer delegate;
        final Random random;

        CrankyDocValuesConsumer(DocValuesConsumer delegate, Random random) {
            this.delegate = delegate;
            this.random = random;
        }

        public void close() throws IOException {
            this.delegate.close();
            if (this.random.nextInt(100) == 0) {
                throw new IOException("Fake IOException from DocValuesConsumer.close()");
            }
        }

        public void addNumericField(FieldInfo field, DocValuesProducer valuesProducer) throws IOException {
            if (this.random.nextInt(100) == 0) {
                throw new IOException("Fake IOException from DocValuesConsumer.addNumericField()");
            }
            this.delegate.addNumericField(field, valuesProducer);
        }

        public void addBinaryField(FieldInfo field, DocValuesProducer valuesProducer) throws IOException {
            if (this.random.nextInt(100) == 0) {
                throw new IOException("Fake IOException from DocValuesConsumer.addBinaryField()");
            }
            this.delegate.addBinaryField(field, valuesProducer);
        }

        public void addSortedField(FieldInfo field, DocValuesProducer valuesProducer) throws IOException {
            if (this.random.nextInt(100) == 0) {
                throw new IOException("Fake IOException from DocValuesConsumer.addSortedField()");
            }
            this.delegate.addSortedField(field, valuesProducer);
        }

        public void addSortedNumericField(FieldInfo field, DocValuesProducer valuesProducer) throws IOException {
            if (this.random.nextInt(100) == 0) {
                throw new IOException("Fake IOException from DocValuesConsumer.addSortedNumericField()");
            }
            this.delegate.addSortedNumericField(field, valuesProducer);
        }

        public void addSortedSetField(FieldInfo field, DocValuesProducer valuesProducer) throws IOException {
            if (this.random.nextInt(100) == 0) {
                throw new IOException("Fake IOException from DocValuesConsumer.addSortedSetField()");
            }
            this.delegate.addSortedSetField(field, valuesProducer);
        }
    }
}

