/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.client.bindings.spi.browser;

import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.util.List;
import java.util.Map;
import org.apache.chemistry.opencmis.client.bindings.spi.BindingSession;
import org.apache.chemistry.opencmis.client.bindings.spi.browser.AbstractBrowserBindingService;
import org.apache.chemistry.opencmis.client.bindings.spi.browser.FormDataWriter;
import org.apache.chemistry.opencmis.client.bindings.spi.http.Output;
import org.apache.chemistry.opencmis.client.bindings.spi.http.Response;
import org.apache.chemistry.opencmis.commons.data.ExtensionsData;
import org.apache.chemistry.opencmis.commons.data.RepositoryInfo;
import org.apache.chemistry.opencmis.commons.definitions.TypeDefinition;
import org.apache.chemistry.opencmis.commons.definitions.TypeDefinitionContainer;
import org.apache.chemistry.opencmis.commons.definitions.TypeDefinitionList;
import org.apache.chemistry.opencmis.commons.exceptions.CmisObjectNotFoundException;
import org.apache.chemistry.opencmis.commons.impl.JSONConverter;
import org.apache.chemistry.opencmis.commons.impl.UrlBuilder;
import org.apache.chemistry.opencmis.commons.spi.RepositoryService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RepositoryServiceImpl
extends AbstractBrowserBindingService
implements RepositoryService {
    public RepositoryServiceImpl(BindingSession session) {
        this.setSession(session);
    }

    public List<RepositoryInfo> getRepositoryInfos(ExtensionsData extension) {
        return this.getRepositoriesInternal(null);
    }

    public RepositoryInfo getRepositoryInfo(String repositoryId, ExtensionsData extension) {
        List<RepositoryInfo> repositoryInfos = this.getRepositoriesInternal(repositoryId);
        if (repositoryInfos.size() == 0) {
            throw new CmisObjectNotFoundException("Repository '" + repositoryId + "'not found!");
        }
        if (repositoryInfos.size() == 1) {
            return repositoryInfos.get(0);
        }
        for (RepositoryInfo info : repositoryInfos) {
            if (info.getId() == null || !info.getId().equals(repositoryId)) continue;
            return info;
        }
        throw new CmisObjectNotFoundException("Repository '" + repositoryId + "'not found!");
    }

    public TypeDefinition getTypeDefinition(String repositoryId, String typeId, ExtensionsData extension) {
        return this.getTypeDefinitionInternal(repositoryId, typeId);
    }

    public TypeDefinitionList getTypeChildren(String repositoryId, String typeId, Boolean includePropertyDefinitions, BigInteger maxItems, BigInteger skipCount, ExtensionsData extension) {
        UrlBuilder url = this.getRepositoryUrl(repositoryId, "typeChildren");
        url.addParameter("typeId", (Object)typeId);
        url.addParameter("includePropertyDefinitions", (Object)includePropertyDefinitions);
        url.addParameter("maxItems", (Object)maxItems);
        url.addParameter("skipCount", (Object)skipCount);
        Response resp = this.read(url);
        Map<String, Object> json = this.parseObject(resp.getStream(), resp.getCharset());
        return JSONConverter.convertTypeChildren(json);
    }

    public List<TypeDefinitionContainer> getTypeDescendants(String repositoryId, String typeId, BigInteger depth, Boolean includePropertyDefinitions, ExtensionsData extension) {
        UrlBuilder url = this.getRepositoryUrl(repositoryId, "typeDescendants");
        url.addParameter("typeId", (Object)typeId);
        url.addParameter("depth", (Object)depth);
        url.addParameter("includePropertyDefinitions", (Object)includePropertyDefinitions);
        Response resp = this.read(url);
        List<Object> json = this.parseArray(resp.getStream(), resp.getCharset());
        return JSONConverter.convertTypeDescendants(json);
    }

    public TypeDefinition createType(String repositoryId, TypeDefinition type, ExtensionsData extension) {
        UrlBuilder url = this.getRepositoryUrl(repositoryId);
        final FormDataWriter formData = new FormDataWriter("createType");
        if (type != null) {
            formData.addParameter("type", JSONConverter.convert((TypeDefinition)type).toJSONString());
        }
        Response resp = this.post(url, formData.getContentType(), new Output(){

            public void write(OutputStream out) throws IOException {
                formData.write(out);
            }
        });
        Map<String, Object> json = this.parseObject(resp.getStream(), resp.getCharset());
        return JSONConverter.convertTypeDefinition(json);
    }

    public TypeDefinition updateType(String repositoryId, TypeDefinition type, ExtensionsData extension) {
        UrlBuilder url = this.getRepositoryUrl(repositoryId);
        final FormDataWriter formData = new FormDataWriter("updateType");
        if (type != null) {
            formData.addParameter("type", JSONConverter.convert((TypeDefinition)type).toJSONString());
        }
        Response resp = this.post(url, formData.getContentType(), new Output(){

            public void write(OutputStream out) throws IOException {
                formData.write(out);
            }
        });
        Map<String, Object> json = this.parseObject(resp.getStream(), resp.getCharset());
        return JSONConverter.convertTypeDefinition(json);
    }

    public void deleteType(String repositoryId, String typeId, ExtensionsData extension) {
        UrlBuilder url = this.getRepositoryUrl(repositoryId);
        final FormDataWriter formData = new FormDataWriter("deleteType");
        formData.addParameter("typeId", typeId);
        this.postAndConsume(url, formData.getContentType(), new Output(){

            public void write(OutputStream out) throws IOException {
                formData.write(out);
            }
        });
    }
}

