/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.maven.settings.validation;

import org.apache.maven.settings.Settings;
import org.apache.maven.settings.building.SettingsProblemCollector;

/**
 * Validate a model settings
 *
 * @deprecated since 4.0.0, use {@code org.apache.maven.impl.DefaultSettingsValidator} instead
 */
@Deprecated(since = "4.0.0")
public interface SettingsValidator {

    /**
     * Validate the specified settings.
     *
     * @param settings The settings to validate, must not be {@code null}.
     * @param problems The container used to collect problems that were encountered, must not be {@code null}.
     */
    void validate(Settings settings, SettingsProblemCollector problems);

    /**
     * Validate the specified settings.
     *
     * @param settings The settings to validate, must not be {@code null}.
     * @param isProjectSettings Boolean indicating if the validation is for project settings or user / global settings.
     * @param problems The container used to collect problems that were encountered, must not be {@code null}.
     */
    default void validate(Settings settings, boolean isProjectSettings, SettingsProblemCollector problems) {
        validate(settings, problems);
    }
}
