/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.maven.plugin.coreit;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;

import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

/**
 */
@Mojo(name = "touch", defaultPhase = LifecyclePhase.PROCESS_RESOURCES)
public class TouchMojo extends AbstractMojo {

    static final String FINAL_NAME = "coreitified";

    @Parameter(defaultValue = "${project}")
    private MavenProject project;

    @Parameter(defaultValue = "${project.build.directory}", required = true)
    private File outputDirectory;

    public void execute() throws MojoExecutionException {
        getLog().info("[MAVEN-CORE-IT-LOG] Project build directory "
                + project.getBuild().getDirectory());

        touch(new File(project.getBuild().getDirectory()), "touch.log");

        getLog().info("[MAVEN-CORE-IT-LOG] Using output directory " + outputDirectory);

        touch(outputDirectory, "touch.txt");

        project.getBuild().setFinalName(FINAL_NAME);
    }

    static void touch(File dir, String file) throws MojoExecutionException {
        try {
            if (!dir.exists()) {
                dir.mkdirs();
            }

            File touch = new File(dir, file);

            // NOTE: Using append mode to track execution count
            OutputStreamWriter w = new OutputStreamWriter(new FileOutputStream(touch, true), "UTF-8");

            w.write(file);
            w.write("\n");

            w.close();
        } catch (IOException e) {
            throw new MojoExecutionException("Error touching file", e);
        }
    }
}
