/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.sftp.client.impl;

import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.sshd.client.channel.ClientChannel;
import org.apache.sshd.client.subsystem.AbstractSubsystemClient;
import org.apache.sshd.common.Property;
import org.apache.sshd.common.PropertyResolver;
import org.apache.sshd.common.SshConstants;
import org.apache.sshd.common.SshException;
import org.apache.sshd.common.channel.Channel;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.common.util.buffer.ByteArrayBuffer;
import org.apache.sshd.sftp.SftpModuleProperties;
import org.apache.sshd.sftp.client.FullAccessSftpClient;
import org.apache.sshd.sftp.client.SftpClient;
import org.apache.sshd.sftp.client.SftpErrorDataHandler;
import org.apache.sshd.sftp.client.extensions.BuiltinSftpClientExtensions;
import org.apache.sshd.sftp.client.extensions.SftpClientExtension;
import org.apache.sshd.sftp.client.extensions.SftpClientExtensionFactory;
import org.apache.sshd.sftp.client.impl.DefaultCloseableHandle;
import org.apache.sshd.sftp.client.impl.SftpAckData;
import org.apache.sshd.sftp.client.impl.SftpInputStreamAsync;
import org.apache.sshd.sftp.client.impl.SftpIterableDirEntry;
import org.apache.sshd.sftp.client.impl.SftpOutputStreamAsync;
import org.apache.sshd.sftp.client.impl.SftpRemotePathChannel;
import org.apache.sshd.sftp.client.impl.SftpResponse;
import org.apache.sshd.sftp.client.impl.SftpStatus;
import org.apache.sshd.sftp.client.impl.StfpIterableDirHandle;
import org.apache.sshd.sftp.common.SftpConstants;
import org.apache.sshd.sftp.common.SftpException;
import org.apache.sshd.sftp.common.SftpHelper;
import org.apache.sshd.sftp.common.extensions.ParserUtils;

public abstract class AbstractSftpClient
extends AbstractSubsystemClient
implements FullAccessSftpClient,
SftpErrorDataHandler {
    public static final int INIT_COMMAND_SIZE = 5;
    public static final Property<Duration> SFTP_CLIENT_CMD_TIMEOUT = Property.duration((String)"sftp-client-cmd-timeout", (Duration)Duration.ofSeconds(30L));
    protected final SftpErrorDataHandler errorDataHandler;
    private final SftpClient.Attributes fileOpenAttributes = new SftpClient.Attributes();
    private final AtomicReference<Map<String, Object>> parsedExtensionsHolder = new AtomicReference<Object>(null);

    protected AbstractSftpClient(SftpErrorDataHandler delegateHandler) {
        this.errorDataHandler = delegateHandler == null ? SftpErrorDataHandler.EMPTY : delegateHandler;
        this.fileOpenAttributes.setType(1);
    }

    public Channel getChannel() {
        return this.getClientChannel();
    }

    @Override
    public <E extends SftpClientExtension> E getExtension(Class<? extends E> extensionType) {
        SftpClientExtension instance = this.getExtension(BuiltinSftpClientExtensions.fromType(extensionType));
        if (instance == null) {
            return null;
        }
        return (E)((SftpClientExtension)extensionType.cast(instance));
    }

    @Override
    public SftpClientExtension getExtension(SftpClientExtensionFactory factory) {
        if (factory == null) {
            return null;
        }
        NavigableMap extensions = this.getServerExtensions();
        Map<String, Object> parsed = this.getParsedServerExtensions(extensions);
        return factory.create(this, this, extensions, parsed);
    }

    protected Map<String, Object> getParsedServerExtensions() {
        return this.getParsedServerExtensions(this.getServerExtensions());
    }

    protected Map<String, Object> getParsedServerExtensions(Map<String, byte[]> extensions) {
        Map<String, Object> parsed = this.parsedExtensionsHolder.get();
        if (parsed == null) {
            parsed = ParserUtils.parse(extensions);
            if (parsed == null) {
                parsed = Collections.emptyMap();
            }
            this.parsedExtensionsHolder.set(parsed);
        }
        return parsed;
    }

    protected String getReferencedName(int cmd, Buffer buf, int nameIndex) {
        Charset cs = this.getNameDecodingCharset();
        return buf.getString(cs);
    }

    protected <B extends Buffer> B putReferencedName(int cmd, B buf, String name, int nameIndex) {
        Charset cs = this.getNameDecodingCharset();
        buf.putString(name, cs);
        return buf;
    }

    protected SftpResponse rpc(int cmd, Buffer request) throws IOException {
        int reqId = this.send(cmd, request);
        return this.response(cmd, reqId);
    }

    protected SftpResponse response(int cmd, int requestId) throws IOException {
        SftpResponse result = SftpResponse.parse(cmd, this.receive(requestId));
        if (this.log.isDebugEnabled()) {
            switch (result.getType()) {
                case 101: {
                    Buffer buffer = result.getBuffer();
                    if (buffer.available() < 4) break;
                    int rpos = buffer.rpos();
                    int status = buffer.getInt();
                    buffer.rpos(rpos);
                    if (status == 0 && cmd == 6) {
                        if (!this.log.isTraceEnabled()) break;
                        this.log.trace("response({}): received {}({}) for command {} (id={})", new Object[]{this.getClientChannel(), SftpConstants.getCommandMessageName(result.getType()), SftpConstants.getStatusName(status), SftpConstants.getCommandMessageName(cmd), result.getId()});
                        break;
                    }
                    this.log.debug("response({}): received {}({}) for command {} (id={})", new Object[]{this.getClientChannel(), SftpConstants.getCommandMessageName(result.getType()), SftpConstants.getStatusName(status), SftpConstants.getCommandMessageName(cmd), result.getId()});
                    break;
                }
                case 103: {
                    if (!this.log.isTraceEnabled()) break;
                    this.log.debug("response({}): received {} for command {} (id={})", new Object[]{this.getClientChannel(), SftpConstants.getCommandMessageName(result.getType()), SftpConstants.getCommandMessageName(cmd), result.getId()});
                    break;
                }
                default: {
                    this.log.debug("response({}): received {} for command {} (id={})", new Object[]{this.getClientChannel(), SftpConstants.getCommandMessageName(result.getType()), SftpConstants.getCommandMessageName(cmd), result.getId()});
                }
            }
        }
        return result;
    }

    protected void checkCommandStatus(int cmd, Buffer request) throws IOException {
        this.checkResponseStatus(this.rpc(cmd, request));
    }

    protected void checkResponseStatus(SftpResponse response) throws IOException {
        if (response.getType() == 101) {
            this.checkResponseStatus(response.getCmd(), response.getId(), SftpStatus.parse(response));
        } else {
            IOException err = this.handleUnexpectedPacket(101, response);
            if (err != null) {
                throw err;
            }
        }
    }

    protected void checkResponseStatus(int cmd, int id, SftpStatus status) throws IOException {
        if (!status.isOk()) {
            this.throwStatusException(cmd, id, status);
        }
    }

    protected void throwStatusException(int cmd, int id, SftpStatus status) throws IOException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("throwStatusException({})[id={}] cmd={} status={}", new Object[]{this.getClientChannel(), id, SftpConstants.getCommandMessageName(cmd), status});
        }
        throw new SftpException(status.getStatusCode(), status.getMessage());
    }

    protected byte[] checkHandle(int cmd, Buffer request) throws IOException {
        return this.checkHandleResponse(this.rpc(cmd, request));
    }

    protected byte[] checkHandleResponse(SftpResponse response) throws IOException {
        switch (response.getType()) {
            case 102: {
                return ValidateUtils.checkNotNullAndNotEmpty((byte[])response.getBuffer().getBytes(), (String)"Null/empty handle in buffer", (Object[])GenericUtils.EMPTY_OBJECT_ARRAY);
            }
            case 101: {
                this.throwStatusException(response.getCmd(), response.getId(), SftpStatus.parse(response));
                return null;
            }
        }
        return this.handleUnexpectedHandlePacket(response);
    }

    protected byte[] handleUnexpectedHandlePacket(SftpResponse response) throws IOException {
        IOException err = this.handleUnexpectedPacket(102, response);
        if (err != null) {
            throw err;
        }
        throw new SshException("No handling for unexpected handle packet id=" + response.getId() + ", type=" + SftpConstants.getCommandMessageName(response.getType()) + ", length=" + response.getLength());
    }

    protected SftpClient.Attributes checkAttributes(int cmd, Buffer request) throws IOException {
        return this.checkAttributesResponse(this.rpc(cmd, request));
    }

    protected SftpClient.Attributes checkAttributesResponse(SftpResponse response) throws IOException {
        switch (response.getType()) {
            case 105: {
                return this.readAttributes(response.getCmd(), response.getBuffer(), new AtomicInteger(0));
            }
            case 101: {
                this.throwStatusException(response.getCmd(), response.getId(), SftpStatus.parse(response));
                return null;
            }
        }
        return this.handleUnexpectedAttributesPacket(response);
    }

    protected SftpClient.Attributes handleUnexpectedAttributesPacket(SftpResponse response) throws IOException {
        IOException err = this.handleUnexpectedPacket(105, response);
        if (err != null) {
            throw err;
        }
        return null;
    }

    protected String checkOneName(int cmd, Buffer request) throws IOException {
        return this.checkOneNameResponse(this.rpc(cmd, request));
    }

    protected String checkOneNameResponse(SftpResponse response) throws IOException {
        switch (response.getType()) {
            case 104: {
                Buffer buffer = response.getBuffer();
                int cmd = response.getCmd();
                int len = buffer.getInt();
                if (len != 1) {
                    throw new SshException("SFTP error: received " + len + " names instead of 1");
                }
                AtomicInteger nameIndex = new AtomicInteger(0);
                String name = this.getReferencedName(cmd, buffer, nameIndex.getAndIncrement());
                String longName = null;
                int version = this.getVersion();
                if (version == 3) {
                    longName = this.getReferencedName(cmd, buffer, nameIndex.getAndIncrement());
                }
                SftpClient.Attributes attrs = SftpHelper.complete(this.readAttributes(cmd, buffer, nameIndex), longName);
                Boolean indicator = SftpHelper.getEndOfListIndicatorValue(buffer, version);
                if (this.log.isTraceEnabled()) {
                    this.log.trace("checkOneNameResponse({})[id={}] {} ({})[{}] eol={}: {}", new Object[]{this.getClientChannel(), response.getId(), SftpConstants.getCommandMessageName(cmd), name, longName, indicator, attrs});
                }
                return name;
            }
            case 101: {
                this.throwStatusException(response.getCmd(), response.getId(), SftpStatus.parse(response));
                return null;
            }
        }
        return this.handleUnknownOneNamePacket(response);
    }

    protected String handleUnknownOneNamePacket(SftpResponse response) throws IOException {
        IOException err = this.handleUnexpectedPacket(104, response);
        if (err != null) {
            throw err;
        }
        return null;
    }

    protected SftpClient.Attributes readAttributes(int cmd, Buffer buffer, AtomicInteger nameIndex) throws IOException {
        SftpClient.Attributes attrs = new SftpClient.Attributes();
        int flags = buffer.getInt();
        int version = this.getVersion();
        if (version == 3) {
            if ((flags & 1) != 0) {
                attrs.setSize(buffer.getLong());
            }
            if ((flags & 2) != 0) {
                attrs.owner(buffer.getInt(), buffer.getInt());
            }
            if ((flags & 4) != 0) {
                int perms = buffer.getInt();
                attrs.setPermissions(perms);
                attrs.setType(SftpHelper.permissionsToFileType(perms));
            }
            if ((flags & 8) != 0) {
                attrs.setAccessTime(SftpHelper.readTime(buffer, version, flags));
                attrs.setModifyTime(SftpHelper.readTime(buffer, version, flags));
            }
        } else if (version >= 4) {
            Object object;
            ValidateUtils.checkTrue(((flags & 2) == 0 ? 1 : 0) != 0, (String)"SFTP v%d server sent invalid SSH_FXP_ATTRS flags 0x%X; flag 0x2 must not be set", (Object[])new Object[]{version, flags});
            attrs.setType(buffer.getUByte());
            if ((flags & 1) != 0) {
                attrs.setSize(buffer.getLong());
            }
            if (version >= 6 && (flags & 0x400) != 0) {
                long perms = buffer.getLong();
            }
            if ((flags & 0x80) != 0) {
                attrs.setOwner(buffer.getString());
                attrs.setGroup(buffer.getString());
            }
            if ((flags & 4) != 0) {
                attrs.setPermissions(buffer.getInt());
            }
            int perms = attrs.getPermissions();
            attrs.setPermissions(perms |= SftpHelper.fileTypeToPermission(attrs.getType()));
            if ((flags & 8) != 0) {
                attrs.setAccessTime(SftpHelper.readTime(buffer, version, flags));
            }
            if ((flags & 0x10) != 0) {
                attrs.setCreateTime(SftpHelper.readTime(buffer, version, flags));
            }
            if ((flags & 0x20) != 0) {
                attrs.setModifyTime(SftpHelper.readTime(buffer, version, flags));
            }
            if (version >= 6 && (flags & 0x8000) != 0) {
                object = SftpHelper.readTime(buffer, version, flags);
            }
            if ((flags & 0x40) != 0) {
                attrs.setAcl(SftpHelper.readACLs(buffer, version));
            }
            if ((flags & 0x200) != 0) {
                int bits = buffer.getInt();
                int valid = -1;
                if (version >= 6) {
                    valid = buffer.getInt();
                }
            }
            if (version >= 6) {
                if ((flags & 0x800) != 0) {
                    boolean bl = buffer.getBoolean();
                }
                if ((flags & 0x1000) != 0) {
                    object = buffer.getString();
                }
                if ((flags & 0x2000) != 0) {
                    int n = buffer.getInt();
                }
                if ((flags & 0x4000) != 0) {
                    String string = this.getReferencedName(cmd, buffer, nameIndex.getAndIncrement());
                }
            }
        } else {
            throw new IllegalStateException("readAttributes - unsupported version: " + version);
        }
        if ((flags & Integer.MIN_VALUE) != 0) {
            attrs.setExtensions(SftpHelper.readExtensions(buffer));
        }
        return attrs;
    }

    protected <B extends Buffer> B writeAttributes(int cmd, B buffer, SftpClient.Attributes attributes) {
        return SftpHelper.writeAttributes(buffer, attributes, this.getVersion());
    }

    @Override
    public SftpClient.CloseableHandle open(String path, Collection<SftpClient.OpenMode> options) throws IOException {
        if (!this.isOpen()) {
            throw new IOException("open(" + path + ")[" + options + "] client is closed");
        }
        if (GenericUtils.isEmpty(options)) {
            options = EnumSet.of(SftpClient.OpenMode.Read);
        }
        ByteArrayBuffer buffer = new ByteArrayBuffer(path.length() + 64, false);
        buffer = this.putReferencedName(3, buffer, path, 0);
        int version = this.getVersion();
        int mode = 0;
        if (version < 5) {
            for (SftpClient.OpenMode m : options) {
                switch (m) {
                    case Read: {
                        mode |= 1;
                        break;
                    }
                    case Write: {
                        mode |= 2;
                        break;
                    }
                    case Append: {
                        mode |= 4;
                        break;
                    }
                    case Create: {
                        mode |= 8;
                        break;
                    }
                    case Truncate: {
                        mode |= 0x10;
                        break;
                    }
                    case Exclusive: {
                        mode |= 0x20;
                        break;
                    }
                }
            }
        } else {
            int access = 0;
            if (options.contains((Object)SftpClient.OpenMode.Read)) {
                access |= 0x81;
            }
            if (options.contains((Object)SftpClient.OpenMode.Write)) {
                access |= 0x102;
            }
            if (options.contains((Object)SftpClient.OpenMode.Append)) {
                access |= 4;
                mode |= 8;
            }
            buffer.putInt((long)access);
            mode = options.contains((Object)SftpClient.OpenMode.Create) && options.contains((Object)SftpClient.OpenMode.Exclusive) ? (mode |= 0) : (options.contains((Object)SftpClient.OpenMode.Create) && options.contains((Object)SftpClient.OpenMode.Truncate) ? (mode |= 1) : (options.contains((Object)SftpClient.OpenMode.Create) ? (mode |= 3) : (options.contains((Object)SftpClient.OpenMode.Truncate) ? (mode |= 4) : (mode |= 2))));
        }
        buffer.putInt((long)mode);
        buffer = this.writeAttributes(3, buffer, this.fileOpenAttributes);
        if (this.log.isDebugEnabled()) {
            this.log.debug("open({}): send SSH_FXP_OPEN {} mode={}", new Object[]{this.getClientChannel(), path, String.format("0x%04x", mode)});
        }
        DefaultCloseableHandle handle = new DefaultCloseableHandle(this, path, this.checkHandle(3, (Buffer)buffer));
        if (this.log.isTraceEnabled()) {
            this.log.trace("open({})[{}] options={}: {}", new Object[]{this.getClientChannel(), path, options, handle});
        }
        return handle;
    }

    @Override
    public void close(SftpClient.Handle handle) throws IOException {
        if (!this.isOpen()) {
            throw new IOException("close(" + handle + ") client is closed");
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace("close({}) {}", (Object)this.getClientChannel(), (Object)handle);
        }
        byte[] id = Objects.requireNonNull(handle, "No handle").getIdentifier();
        ByteArrayBuffer buffer = new ByteArrayBuffer(id.length + 64, false);
        buffer.putBytes(id);
        if (this.log.isDebugEnabled()) {
            this.log.debug("open({})[{}]: send SSH_FXP_CLOSE", (Object)this.getClientChannel(), (Object)handle);
        }
        this.checkCommandStatus(4, (Buffer)buffer);
    }

    @Override
    public void remove(String path) throws IOException {
        if (!this.isOpen()) {
            throw new IOException("remove(" + path + ") client is closed");
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("remove({}) {}", (Object)this.getClientChannel(), (Object)path);
        }
        ByteArrayBuffer buffer = new ByteArrayBuffer(path.length() + 64, false);
        buffer = this.putReferencedName(13, buffer, path, 0);
        this.checkCommandStatus(13, (Buffer)buffer);
    }

    @Override
    public void rename(String oldPath, String newPath, Collection<SftpClient.CopyMode> options) throws IOException {
        if (!this.isOpen()) {
            throw new IOException("rename(" + oldPath + " => " + newPath + ")[" + options + "] client is closed");
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("rename({}) {} => {}", new Object[]{this.getClientChannel(), oldPath, newPath});
        }
        ByteArrayBuffer buffer = new ByteArrayBuffer(oldPath.length() + newPath.length() + 64, false);
        buffer = this.putReferencedName(18, buffer, oldPath, 0);
        buffer = this.putReferencedName(18, buffer, newPath, 1);
        int numOptions = GenericUtils.size(options);
        int version = this.getVersion();
        if (version >= 5) {
            int opts = 0;
            if (numOptions > 0) {
                for (SftpClient.CopyMode opt : options) {
                    switch (opt) {
                        case Atomic: {
                            opts |= 2;
                            break;
                        }
                        case Overwrite: {
                            opts |= 1;
                            break;
                        }
                    }
                }
            }
            buffer.putInt((long)opts);
        } else if (numOptions > 0) {
            throw new UnsupportedOperationException("rename(" + oldPath + " => " + newPath + ") - copy options can not be used with this SFTP version: " + options);
        }
        this.checkCommandStatus(18, (Buffer)buffer);
    }

    @Override
    public int read(SftpClient.Handle handle, long fileOffset, byte[] dst, int dstOffset, int len, AtomicReference<Boolean> eofSignalled) throws IOException {
        if (!this.isOpen()) {
            throw new IOException("read(" + handle + "/" + fileOffset + ")[" + dstOffset + "/" + len + "] client is closed");
        }
        byte[] id = Objects.requireNonNull(handle, "No handle").getIdentifier();
        ByteArrayBuffer buffer = new ByteArrayBuffer(id.length + 64, false);
        buffer.putBytes(id);
        buffer.putLong(fileOffset);
        buffer.putUInt((long)len);
        int reqId = this.send(5, (Buffer)buffer);
        SftpAckData ack = new SftpAckData(reqId, fileOffset, len);
        SftpResponse response = this.response(5, reqId);
        buffer = this.checkDataResponse(ack, response, eofSignalled);
        if (buffer == null) {
            return -1;
        }
        if (buffer.available() <= 0) {
            if (eofSignalled != null) {
                Boolean eof = eofSignalled.get();
                return eof != null && eof != false ? -1 : 0;
            }
            return 0;
        }
        int bytesRead = buffer.available();
        buffer.getRawBytes(dst, dstOffset, bytesRead);
        return bytesRead;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Buffer checkDataResponse(SftpAckData ack, SftpResponse response, AtomicReference<Boolean> eofSignalled) throws IOException {
        if (eofSignalled != null) {
            eofSignalled.set(null);
        }
        switch (response.getType()) {
            case 103: {
                Buffer buffer = response.getBuffer();
                int dlen = buffer.getInt();
                ValidateUtils.checkTrue((dlen >= 0 && dlen <= buffer.available() ? 1 : 0) != 0, (String)"Invalid response data len: %d", (long)dlen);
                if (dlen > ack.length) {
                    buffer.wpos(buffer.rpos() + ack.length);
                    boolean dropExcessData = (Boolean)SftpModuleProperties.TOLERATE_EXCESS_DATA.getRequired((PropertyResolver)this.getClientChannel());
                    if (!dropExcessData) throw new SshException("SFTP protocol violation: requested at most " + ack.length + " bytes but got " + dlen + " bytes");
                    this.log.warn("checkDataResponse({}][id={}] {} offset={}, len={} SFTP protocol violation: server returned more data than requested, excess data dropped (requested len={})", new Object[]{this.getClientChannel(), SftpConstants.getCommandMessageName(response.getCmd()), response.getId(), ack.offset, dlen, ack.length});
                    return buffer;
                } else {
                    int rpos = buffer.rpos();
                    buffer.rpos(rpos + dlen);
                    Boolean indicator = SftpHelper.getEndOfFileIndicatorValue(buffer, this.getVersion());
                    if (this.log.isTraceEnabled()) {
                        this.log.trace("checkDataResponse({}][id={}] {} offset={}, len={}, EOF={}", new Object[]{this.getClientChannel(), SftpConstants.getCommandMessageName(response.getCmd()), response.getId(), ack.offset, dlen, indicator});
                    }
                    if (eofSignalled != null) {
                        eofSignalled.set(indicator);
                    }
                    buffer.rpos(rpos);
                    buffer.wpos(buffer.rpos() + dlen);
                }
                return buffer;
            }
            case 101: {
                SftpStatus status = SftpStatus.parse(response);
                if (status.getStatusCode() == 1) {
                    if (this.log.isTraceEnabled()) {
                        this.log.trace("checkDataResponse({})[id={}] {} status: {}", new Object[]{this.getClientChannel(), response.getId(), SftpConstants.getCommandMessageName(response.getCmd()), status});
                    }
                    if (eofSignalled == null) return null;
                    eofSignalled.set(Boolean.TRUE);
                    return null;
                }
                this.checkResponseStatus(5, response.getId(), status);
                return new ByteArrayBuffer(new byte[0]);
            }
        }
        this.handleUnknownDataPacket(response);
        return new ByteArrayBuffer(new byte[0]);
    }

    protected int handleUnknownDataPacket(SftpResponse response) throws IOException {
        IOException err = this.handleUnexpectedPacket(103, response);
        if (err != null) {
            throw err;
        }
        return 0;
    }

    @Override
    public void errorData(byte[] buf, int start, int len) throws IOException {
        if (this.errorDataHandler != null) {
            this.errorDataHandler.errorData(buf, start, len);
        }
    }

    @Override
    public void write(SftpClient.Handle handle, long fileOffset, byte[] src, int srcOffset, int len) throws IOException {
        int writeSize;
        if (fileOffset < 0L || srcOffset < 0 || len < 0) {
            throw new IllegalArgumentException("write(" + handle + ") please ensure all parameters  are non-negative values: file-offset=" + fileOffset + ", src-offset=" + srcOffset + ", len=" + len);
        }
        if (srcOffset + len > src.length) {
            throw new IllegalArgumentException("write(" + handle + ") cannot read bytes " + srcOffset + " to " + (srcOffset + len) + " when array is only of length " + src.length);
        }
        if (!this.isOpen()) {
            throw new IOException("write(" + handle + "/" + fileOffset + ")[" + srcOffset + "/" + len + "] client is closed");
        }
        boolean traceEnabled = this.log.isTraceEnabled();
        ClientChannel clientChannel = this.getClientChannel();
        int chunkSize = (Integer)SftpModuleProperties.WRITE_CHUNK_SIZE.getRequired((PropertyResolver)clientChannel);
        ValidateUtils.checkState((chunkSize > 256 ? 1 : 0) != 0, (String)"Write chunk size too small: %d", (long)chunkSize);
        byte[] id = Objects.requireNonNull(handle, "No handle").getIdentifier();
        int remLen = len;
        do {
            writeSize = Math.min(remLen, chunkSize);
            ByteArrayBuffer buffer = new ByteArrayBuffer(id.length + writeSize + 64, false);
            buffer.putBytes(id);
            buffer.putLong(fileOffset);
            buffer.putBytes(src, srcOffset, writeSize);
            if (traceEnabled) {
                this.log.trace("write({}) handle={}, file-offset={}, buf-offset={}, writeSize={}, remLen={}", new Object[]{clientChannel, handle, fileOffset, srcOffset, writeSize, remLen - writeSize});
            }
            this.checkCommandStatus(6, (Buffer)buffer);
            fileOffset += (long)writeSize;
            srcOffset += writeSize;
        } while ((remLen -= writeSize) > 0);
    }

    @Override
    public void mkdir(String path) throws IOException {
        if (!this.isOpen()) {
            throw new IOException("mkdir(" + path + ") client is closed");
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("mkdir({}): send SSH_FXP_MKDIR {}", (Object)this.getClientChannel(), (Object)path);
        }
        ByteArrayBuffer buffer = new ByteArrayBuffer(path.length() + 64, false);
        buffer = this.putReferencedName(14, buffer, path, 0);
        buffer.putUInt(0L);
        int version = this.getVersion();
        if (version != 3) {
            buffer.putByte((byte)0);
        }
        this.checkCommandStatus(14, (Buffer)buffer);
    }

    @Override
    public void rmdir(String path) throws IOException {
        if (!this.isOpen()) {
            throw new IOException("rmdir(" + path + ") client is closed");
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("rmdir({}): send SSH_FXP_RMDIR {}", (Object)this.getClientChannel(), (Object)path);
        }
        ByteArrayBuffer buffer = new ByteArrayBuffer(path.length() + 64, false);
        buffer = this.putReferencedName(15, buffer, path, 0);
        this.checkCommandStatus(15, (Buffer)buffer);
    }

    @Override
    public SftpClient.CloseableHandle openDir(String path) throws IOException {
        if (!this.isOpen()) {
            throw new IOException("openDir(" + path + ") client is closed");
        }
        ByteArrayBuffer buffer = new ByteArrayBuffer(path.length() + 64, false);
        buffer = this.putReferencedName(11, buffer, path, 0);
        if (this.log.isDebugEnabled()) {
            this.log.debug("openDir({}): send SSH_FXP_OPENDIR {}", (Object)this.getClientChannel(), (Object)path);
        }
        DefaultCloseableHandle handle = new DefaultCloseableHandle(this, path, this.checkHandle(11, (Buffer)buffer));
        if (this.log.isTraceEnabled()) {
            this.log.trace("openDir({})[{}]: {}", new Object[]{this.getClientChannel(), path, handle});
        }
        return handle;
    }

    @Override
    public List<SftpClient.DirEntry> readDir(SftpClient.Handle handle, AtomicReference<Boolean> eolIndicator) throws IOException {
        if (eolIndicator != null) {
            eolIndicator.set(null);
        }
        if (!this.isOpen()) {
            throw new IOException("readDir(" + handle + ") client is closed");
        }
        byte[] id = Objects.requireNonNull(handle, "No handle").getIdentifier();
        ByteArrayBuffer buffer = new ByteArrayBuffer(id.length + 8, false);
        buffer.putBytes(id);
        if (this.log.isDebugEnabled()) {
            this.log.debug("readDir({})[{}]: send SSH_FXP_READDIR", (Object)this.getClientChannel(), (Object)handle);
        }
        return this.checkDirResponse(this.rpc(12, (Buffer)buffer), eolIndicator);
    }

    protected List<SftpClient.DirEntry> checkDirResponse(SftpResponse response, AtomicReference<Boolean> eolIndicator) throws IOException {
        if (eolIndicator != null) {
            eolIndicator.set(null);
        }
        boolean traceEnabled = this.log.isTraceEnabled();
        switch (response.getType()) {
            case 104: {
                ClientChannel channel = this.getClientChannel();
                Buffer buffer = response.getBuffer();
                int cmd = response.getCmd();
                int count = buffer.getInt();
                int version = this.getVersion();
                if (count < 0 || count > 32768) {
                    this.log.error("checkDirResponse({})[id={}] illogical dir entries count: {}", new Object[]{channel, response.getId(), count});
                    throw new SshException("Illogical dir entries count: " + count);
                }
                boolean debugEnabled = this.log.isDebugEnabled();
                if (debugEnabled) {
                    this.log.debug("checkDirResponse({})[id={}] reading {} entries", new Object[]{channel, response.getId(), count});
                }
                ArrayList<SftpClient.DirEntry> entries = new ArrayList<SftpClient.DirEntry>(count);
                AtomicInteger nameIndex = new AtomicInteger(0);
                for (int index = 1; index <= count; ++index) {
                    String name = this.getReferencedName(cmd, buffer, nameIndex.getAndIncrement());
                    String longName = null;
                    if (version == 3) {
                        longName = this.getReferencedName(cmd, buffer, nameIndex.getAndIncrement());
                    }
                    SftpClient.Attributes attrs = SftpHelper.complete(this.readAttributes(cmd, buffer, nameIndex), longName);
                    if (traceEnabled) {
                        this.log.trace("checkDirResponse({})[id={}][{}/{}] ({})[{}]: {}", new Object[]{channel, response.getId(), index, count, name, longName, attrs});
                    }
                    entries.add(new SftpClient.DirEntry(name, longName, attrs));
                }
                Boolean indicator = SftpHelper.getEndOfListIndicatorValue(buffer, version);
                if (eolIndicator != null) {
                    eolIndicator.set(indicator);
                }
                if (debugEnabled) {
                    this.log.debug("checkDirResponse({})[id={}] read count={}, eol={}", new Object[]{channel, response.getId(), entries.size(), indicator});
                }
                return entries;
            }
            case 101: {
                SftpStatus status = SftpStatus.parse(response);
                if (status.getStatusCode() != 1) {
                    this.throwStatusException(response.getCmd(), response.getId(), status);
                } else if (traceEnabled) {
                    this.log.trace("checkDirResponse({})[id={}] - status: {}", new Object[]{this.getClientChannel(), response.getId(), status});
                }
                return null;
            }
        }
        return this.handleUnknownDirListingPacket(response);
    }

    protected List<SftpClient.DirEntry> handleUnknownDirListingPacket(SftpResponse response) throws IOException {
        IOException err = this.handleUnexpectedPacket(104, response);
        if (err != null) {
            throw err;
        }
        return Collections.emptyList();
    }

    protected IOException handleUnexpectedPacket(int expected, SftpResponse response) throws IOException {
        return new SshException("Unexpected SFTP packet received while awaiting " + SftpConstants.getCommandMessageName(expected) + " response to " + SftpConstants.getCommandMessageName(response.getCmd()) + ": type=" + SftpConstants.getCommandMessageName(response.getType()) + ", id=" + response.getId() + ", length=" + response.getLength());
    }

    @Override
    public String canonicalPath(String path) throws IOException {
        if (!this.isOpen()) {
            throw new IOException("canonicalPath(" + path + ") client is closed");
        }
        ByteArrayBuffer buffer = new ByteArrayBuffer(path.length() + 64, false);
        buffer = this.putReferencedName(16, buffer, path, 0);
        if (this.log.isDebugEnabled()) {
            this.log.debug("canonicalPath({}): send SSH_FXP_REALPATH {}", (Object)this.getClientChannel(), (Object)path);
        }
        return this.checkOneName(16, (Buffer)buffer);
    }

    @Override
    public SftpClient.Attributes stat(String path) throws IOException {
        if (!this.isOpen()) {
            throw new IOException("stat(" + path + ") client is closed");
        }
        ByteArrayBuffer buffer = new ByteArrayBuffer(path.length() + 64, false);
        buffer = this.putReferencedName(17, buffer, path, 0);
        int version = this.getVersion();
        if (version >= 4) {
            buffer.putInt(65533L);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("stat({}): send SSH_FXP_STAT {}", (Object)this.getClientChannel(), (Object)path);
        }
        return this.checkAttributes(17, (Buffer)buffer);
    }

    @Override
    public SftpClient.Attributes lstat(String path) throws IOException {
        if (!this.isOpen()) {
            throw new IOException("lstat(" + path + ") client is closed");
        }
        ByteArrayBuffer buffer = new ByteArrayBuffer(path.length() + 64, false);
        buffer = this.putReferencedName(7, buffer, path, 0);
        int version = this.getVersion();
        if (version >= 4) {
            buffer.putInt(65533L);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("stat({}): send SSH_FXP_LSTAT {}", (Object)this.getClientChannel(), (Object)path);
        }
        return this.checkAttributes(7, (Buffer)buffer);
    }

    @Override
    public SftpClient.Attributes stat(SftpClient.Handle handle) throws IOException {
        if (!this.isOpen()) {
            throw new IOException("stat(" + handle + ") client is closed");
        }
        byte[] id = Objects.requireNonNull(handle, "No handle").getIdentifier();
        ByteArrayBuffer buffer = new ByteArrayBuffer(id.length + 8, false);
        buffer.putBytes(id);
        int version = this.getVersion();
        if (version >= 4) {
            buffer.putInt(65533L);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("stat({}): send SSH_FXP_FSTAT {}", (Object)this.getClientChannel(), (Object)handle);
        }
        return this.checkAttributes(8, (Buffer)buffer);
    }

    @Override
    public void setStat(String path, SftpClient.Attributes attributes) throws IOException {
        if (!this.isOpen()) {
            throw new IOException("setStat(" + path + ")[" + attributes + "] client is closed");
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("setStat({})[{}]: {}", new Object[]{this.getClientChannel(), path, attributes});
        }
        ByteArrayBuffer buffer = new ByteArrayBuffer();
        buffer = this.putReferencedName(9, buffer, path, 0);
        buffer = this.writeAttributes(9, buffer, attributes);
        if (this.log.isDebugEnabled()) {
            this.log.debug("setStat({}): send SSH_FXP_SETSTAT {}", (Object)this.getClientChannel(), (Object)path);
        }
        this.checkCommandStatus(9, (Buffer)buffer);
    }

    @Override
    public void setStat(SftpClient.Handle handle, SftpClient.Attributes attributes) throws IOException {
        if (!this.isOpen()) {
            throw new IOException("setStat(" + handle + ")[" + attributes + "] client is closed");
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("setStat({})[{}]: {}", new Object[]{this.getClientChannel(), handle, attributes});
        }
        byte[] id = Objects.requireNonNull(handle, "No handle").getIdentifier();
        ByteArrayBuffer buffer = new ByteArrayBuffer(id.length + 128, false);
        buffer.putBytes(id);
        buffer = this.writeAttributes(10, buffer, attributes);
        if (this.log.isDebugEnabled()) {
            this.log.debug("setStat({}): send SSH_FXP_FSETSTAT {}", (Object)this.getClientChannel(), (Object)handle);
        }
        this.checkCommandStatus(10, (Buffer)buffer);
    }

    @Override
    public String readLink(String path) throws IOException {
        if (!this.isOpen()) {
            throw new IOException("readLink(" + path + ") client is closed");
        }
        ByteArrayBuffer buffer = new ByteArrayBuffer(path.length() + 64, false);
        buffer = this.putReferencedName(19, buffer, path, 0);
        if (this.log.isDebugEnabled()) {
            this.log.debug("readLink({}): send SSH_FXP_READLINK {}", (Object)this.getClientChannel(), (Object)path);
        }
        return this.checkOneName(19, (Buffer)buffer);
    }

    @Override
    public void link(String linkPath, String targetPath, boolean symbolic) throws IOException {
        int cmd;
        if (!this.isOpen()) {
            throw new IOException("link(" + linkPath + " => " + targetPath + ")[symbolic=" + symbolic + "] client is closed");
        }
        int version = this.getVersion();
        int n = cmd = version < 6 ? 20 : 21;
        if (this.log.isDebugEnabled()) {
            this.log.debug("link({})[symbolic={}] send {} {} => {}", new Object[]{this.getClientChannel(), symbolic, SshConstants.getCommandMessageName((int)cmd), linkPath, targetPath});
        }
        ByteArrayBuffer buffer = new ByteArrayBuffer(linkPath.length() + targetPath.length() + 64, false);
        if (version < 6) {
            if (!symbolic) {
                throw new UnsupportedOperationException("Hard links are not supported in sftp v" + version + ", need SFTPv6");
            }
            buffer = this.putReferencedName(cmd, buffer, targetPath, 0);
            buffer = this.putReferencedName(cmd, buffer, linkPath, 1);
        } else {
            buffer = this.putReferencedName(cmd, buffer, targetPath, 0);
            buffer = this.putReferencedName(cmd, buffer, linkPath, 1);
            buffer.putBoolean(symbolic);
        }
        this.checkCommandStatus(cmd, (Buffer)buffer);
    }

    @Override
    public void lock(SftpClient.Handle handle, long offset, long length, int mask) throws IOException {
        if (!this.isOpen()) {
            throw new IOException("lock(" + handle + ")[offset=" + offset + ", length=" + length + ", mask=0x" + Integer.toHexString(mask) + "] client is closed");
        }
        int version = this.getVersion();
        if (version < 6) {
            throw new UnsupportedOperationException("File locks are not supported in sftp v" + version + ", need SFTPv6");
        }
        byte[] id = Objects.requireNonNull(handle, "No handle").getIdentifier();
        ByteArrayBuffer buffer = new ByteArrayBuffer(id.length + 64, false);
        buffer.putBytes(id);
        buffer.putLong(offset);
        buffer.putLong(length);
        buffer.putInt((long)mask);
        if (this.log.isDebugEnabled()) {
            this.log.debug("lock({})[{}] send SSH_FXP_BLOCK offset={}, length={}, mask=0x{}", new Object[]{this.getClientChannel(), handle, offset, length, Integer.toHexString(mask)});
        }
        this.checkCommandStatus(22, (Buffer)buffer);
    }

    @Override
    public void unlock(SftpClient.Handle handle, long offset, long length) throws IOException {
        if (!this.isOpen()) {
            throw new IOException("unlock" + handle + ")[offset=" + offset + ", length=" + length + "] client is closed");
        }
        int version = this.getVersion();
        if (version < 6) {
            throw new UnsupportedOperationException("File locks are not supported in sftp v" + version + ", need SFTPv6");
        }
        byte[] id = Objects.requireNonNull(handle, "No handle").getIdentifier();
        ByteArrayBuffer buffer = new ByteArrayBuffer(id.length + 64, false);
        buffer.putBytes(id);
        buffer.putLong(offset);
        buffer.putLong(length);
        if (this.log.isDebugEnabled()) {
            this.log.debug("unlock({})[{}] send SSH_FXP_UNBLOCK offset={}, length={}", new Object[]{this.getClientChannel(), handle, offset, length});
        }
        this.checkCommandStatus(23, (Buffer)buffer);
    }

    @Override
    public Iterable<SftpClient.DirEntry> readDir(String path) throws IOException {
        if (!this.isOpen()) {
            throw new IOException("readDir(" + path + ") client is closed");
        }
        return new SftpIterableDirEntry(this, path);
    }

    @Override
    public Iterable<SftpClient.DirEntry> listDir(SftpClient.Handle handle) throws IOException {
        if (!this.isOpen()) {
            throw new IOException("listDir(" + handle + ") client is closed");
        }
        return new StfpIterableDirHandle(this, handle);
    }

    @Override
    public FileChannel openRemoteFileChannel(String path, Collection<SftpClient.OpenMode> modes) throws IOException {
        return new SftpRemotePathChannel(path, this, false, (Collection<SftpClient.OpenMode>)(GenericUtils.isEmpty(modes) ? DEFAULT_CHANNEL_MODES : modes));
    }

    @Override
    public InputStream read(String path, int bufferSize, Collection<SftpClient.OpenMode> mode) throws IOException {
        if (bufferSize <= 0) {
            bufferSize = this.getReadBufferSize();
        }
        if (bufferSize < 256) {
            throw new IllegalArgumentException("Insufficient read buffer size: " + bufferSize + ", min.=" + 256);
        }
        if (!this.isOpen()) {
            throw new IOException("write(" + path + ")[" + mode + "] size=" + bufferSize + ": client is closed");
        }
        return new SftpInputStreamAsync(this, bufferSize, path, mode);
    }

    public SftpOutputStreamAsync write(String path, int bufferSize, Collection<SftpClient.OpenMode> mode) throws IOException {
        if (bufferSize != 0 && bufferSize < 256) {
            throw new IllegalArgumentException("Insufficient write buffer size: " + bufferSize + ", min.=" + 256);
        }
        if (!this.isOpen()) {
            throw new IOException("write(" + path + ")[" + mode + "] size=" + bufferSize + ": client is closed");
        }
        if (this.getVersion() <= 3 && mode.contains((Object)SftpClient.OpenMode.Append)) {
            SftpClient.Attributes attrs = this.safeStat(path);
            long fileSize = attrs == null ? 0L : attrs.getSize();
            SftpOutputStreamAsync stream = new SftpOutputStreamAsync(this, bufferSize, path, mode);
            if (fileSize > 0L) {
                stream.setOffset(fileSize);
            }
            return stream;
        }
        return new SftpOutputStreamAsync(this, bufferSize, path, mode);
    }

    private SftpClient.Attributes safeStat(String path) throws IOException {
        try {
            return this.stat(path);
        }
        catch (SftpException e) {
            if (e.getStatus() == 2) {
                return null;
            }
            throw e;
        }
    }

    @Override
    public void put(InputStream stream, int bufferSize, String path, Collection<SftpClient.OpenMode> modes) throws IOException {
        try (SftpOutputStreamAsync out = this.write(path, bufferSize, modes);){
            out.transferFrom(stream);
        }
    }

    protected int getReadBufferSize() {
        return (int)this.getClientChannel().getLocalWindow().getPacketSize() - 13;
    }

    protected int getWriteBufferSize() {
        return (int)this.getClientChannel().getRemoteWindow().getPacketSize() - 13;
    }
}

