/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.bootstrap.command.io;

import java.util.Arrays;
import java.util.Optional;
import org.apache.nifi.bootstrap.command.io.BootstrapArgument;
import org.apache.nifi.bootstrap.command.io.BootstrapArgumentParser;

public class StandardBootstrapArgumentParser
implements BootstrapArgumentParser {
    private static final char HYPHEN = '-';
    private static final char UNDERSCORE = '_';

    @Override
    public Optional<BootstrapArgument> getBootstrapArgument(String[] arguments) {
        Optional<BootstrapArgument> bootstrapArgumentFound;
        if (arguments == null || arguments.length == 0) {
            bootstrapArgumentFound = Optional.empty();
        } else {
            String firstArgument = arguments[0];
            String formattedArgument = this.getFormattedArgument(firstArgument);
            bootstrapArgumentFound = Arrays.stream(BootstrapArgument.values()).filter(bootstrapArgument -> bootstrapArgument.name().equals(formattedArgument)).findFirst();
        }
        return bootstrapArgumentFound;
    }

    private String getFormattedArgument(String argument) {
        String upperCased = argument.toUpperCase();
        return upperCased.replace('-', '_');
    }
}

