/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.registry.extension.component;

import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.ws.rs.core.Link;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import org.apache.nifi.extension.manifest.DeprecationNotice;
import org.apache.nifi.extension.manifest.ExtensionType;
import org.apache.nifi.extension.manifest.ProvidedServiceAPI;
import org.apache.nifi.extension.manifest.Restricted;
import org.apache.nifi.registry.extension.bundle.BundleInfo;
import org.apache.nifi.registry.link.LinkAdapter;
import org.apache.nifi.registry.link.LinkableDocs;
import org.apache.nifi.registry.link.LinkableEntity;

public class ExtensionMetadata
extends LinkableEntity
implements LinkableDocs,
Comparable<ExtensionMetadata> {
    private String name;
    private String displayName;
    private ExtensionType type;
    private String description;
    private DeprecationNotice deprecationNotice;
    private List<String> tags;
    private Restricted restricted;
    private List<ProvidedServiceAPI> providedServiceAPIs;
    private BundleInfo bundleInfo;
    private boolean hasAdditionalDetails;
    private Link linkDocs;

    @Schema(description="The name of the extension")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Schema(description="The display name of the extension")
    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    @Schema(description="The type of the extension")
    public ExtensionType getType() {
        return this.type;
    }

    public void setType(ExtensionType type) {
        this.type = type;
    }

    @Schema(description="The description of the extension")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Schema(description="The deprecation notice of the extension")
    public DeprecationNotice getDeprecationNotice() {
        return this.deprecationNotice;
    }

    public void setDeprecationNotice(DeprecationNotice deprecationNotice) {
        this.deprecationNotice = deprecationNotice;
    }

    @Schema(description="The tags of the extension")
    public List<String> getTags() {
        return this.tags;
    }

    public void setTags(List<String> tags) {
        this.tags = tags;
    }

    @Schema(description="The restrictions of the extension")
    public Restricted getRestricted() {
        return this.restricted;
    }

    public void setRestricted(Restricted restricted) {
        this.restricted = restricted;
    }

    @Schema(description="The service APIs provided by the extension")
    public List<ProvidedServiceAPI> getProvidedServiceAPIs() {
        return this.providedServiceAPIs;
    }

    public void setProvidedServiceAPIs(List<ProvidedServiceAPI> providedServiceAPIs) {
        this.providedServiceAPIs = providedServiceAPIs;
    }

    @Schema(description="The information for the bundle where this extension is located")
    public BundleInfo getBundleInfo() {
        return this.bundleInfo;
    }

    public void setBundleInfo(BundleInfo bundleInfo) {
        this.bundleInfo = bundleInfo;
    }

    @Schema(description="Whether or not the extension has additional detail documentation")
    public boolean getHasAdditionalDetails() {
        return this.hasAdditionalDetails;
    }

    public void setHasAdditionalDetails(boolean hasAdditionalDetails) {
        this.hasAdditionalDetails = hasAdditionalDetails;
    }

    @Override
    @XmlElement
    @XmlJavaTypeAdapter(value=LinkAdapter.class)
    @Schema(description="A WebLink to the documentation for this extension.", type="org.apache.nifi.registry.link.JaxbLink", accessMode=Schema.AccessMode.READ_ONLY)
    public Link getLinkDocs() {
        return this.linkDocs;
    }

    @Override
    public void setLinkDocs(Link link) {
        this.linkDocs = link;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExtensionMetadata extension = (ExtensionMetadata)o;
        return Objects.equals(this.name, extension.name);
    }

    public int hashCode() {
        return Objects.hash(this.name);
    }

    @Override
    public int compareTo(ExtensionMetadata o) {
        return Comparator.comparing(ExtensionMetadata::getDisplayName).compare(this, o);
    }
}

