/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp.api;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.bouncycastle.bcpg.ArmoredOutputStream;
import org.bouncycastle.bcpg.S2K;
import org.bouncycastle.bcpg.sig.PreferredAEADCiphersuites;
import org.bouncycastle.crypto.CryptoServicesRegistrar;
import org.bouncycastle.openpgp.PGPCompressedDataGenerator;
import org.bouncycastle.openpgp.PGPEncryptedDataGenerator;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPLiteralData;
import org.bouncycastle.openpgp.PGPLiteralDataGenerator;
import org.bouncycastle.openpgp.PGPOnePassSignature;
import org.bouncycastle.openpgp.PGPPadding;
import org.bouncycastle.openpgp.PGPSignatureGenerator;
import org.bouncycastle.openpgp.api.AbstractOpenPGPDocumentSignatureGenerator;
import org.bouncycastle.openpgp.api.EncryptedDataPacketType;
import org.bouncycastle.openpgp.api.MessageEncryptionMechanism;
import org.bouncycastle.openpgp.api.OpenPGPCertificate;
import org.bouncycastle.openpgp.api.OpenPGPEncryptionNegotiator;
import org.bouncycastle.openpgp.api.OpenPGPImplementation;
import org.bouncycastle.openpgp.api.OpenPGPMessageOutputStream;
import org.bouncycastle.openpgp.api.OpenPGPPolicy;
import org.bouncycastle.openpgp.api.SubkeySelector;
import org.bouncycastle.openpgp.api.exception.InvalidEncryptionKeyException;
import org.bouncycastle.openpgp.operator.PBEKeyEncryptionMethodGenerator;
import org.bouncycastle.openpgp.operator.PGPDataEncryptorBuilder;
import org.bouncycastle.openpgp.operator.PGPKeyEncryptionMethodGenerator;

public class OpenPGPMessageGenerator
extends AbstractOpenPGPDocumentSignatureGenerator<OpenPGPMessageGenerator> {
    public static final int BUFFER_SIZE = 1024;
    private boolean isArmored = true;
    public boolean isAllowPadding = true;
    private final List<OpenPGPCertificate.OpenPGPComponentKey> encryptionKeys = new ArrayList<OpenPGPCertificate.OpenPGPComponentKey>();
    private final List<char[]> messagePassphrases = new ArrayList<char[]>();
    private Date fileModificationDate = null;
    private String filename = null;
    private char format = (char)98;
    private PGPEncryptedDataGenerator.SessionKeyExtractionCallback sessionKeyExtractionCallback;
    private ArmoredOutputStreamFactory armorStreamFactory = new ArmoredOutputStreamFactory(){

        @Override
        public ArmoredOutputStream get(OutputStream outputStream) {
            return ArmoredOutputStream.builder().clearHeaders().enableCRC(false).build(outputStream);
        }
    };
    private SubkeySelector encryptionKeySelector = new SubkeySelector(){

        @Override
        public List<OpenPGPCertificate.OpenPGPComponentKey> select(OpenPGPCertificate openPGPCertificate, OpenPGPPolicy openPGPPolicy) {
            ArrayList<OpenPGPCertificate.OpenPGPComponentKey> arrayList = new ArrayList<OpenPGPCertificate.OpenPGPComponentKey>();
            for (OpenPGPCertificate.OpenPGPComponentKey openPGPComponentKey : openPGPCertificate.getEncryptionKeys()) {
                if (!openPGPPolicy.isAcceptablePublicKey(openPGPComponentKey.getPGPPublicKey())) continue;
                arrayList.add(openPGPComponentKey);
            }
            return arrayList;
        }
    };
    private OpenPGPEncryptionNegotiator passwordBasedEncryptionNegotiator = new OpenPGPEncryptionNegotiator(){

        @Override
        public MessageEncryptionMechanism negotiateEncryption(OpenPGPMessageGenerator openPGPMessageGenerator) {
            return MessageEncryptionMechanism.aead(9, 2);
        }
    };
    private OpenPGPEncryptionNegotiator publicKeyBasedEncryptionNegotiator = new OpenPGPEncryptionNegotiator(){

        @Override
        public MessageEncryptionMechanism negotiateEncryption(OpenPGPMessageGenerator openPGPMessageGenerator) {
            ArrayList<OpenPGPCertificate> arrayList = new ArrayList<OpenPGPCertificate>();
            HashSet<OpenPGPCertificate> hashSet = new HashSet<OpenPGPCertificate>();
            Object object = OpenPGPMessageGenerator.this.encryptionKeys.iterator();
            while (object.hasNext()) {
                OpenPGPCertificate openPGPCertificate = ((OpenPGPCertificate.OpenPGPComponentKey)object.next()).getCertificate();
                if (!hashSet.add(openPGPCertificate)) continue;
                arrayList.add(openPGPCertificate);
            }
            if (OpenPGPEncryptionNegotiator.allRecipientsSupportSeipd2(arrayList)) {
                object = OpenPGPEncryptionNegotiator.negotiateAEADCiphersuite(arrayList, OpenPGPMessageGenerator.this.policy);
                return MessageEncryptionMechanism.aead(((PreferredAEADCiphersuites)object).getAlgorithms()[0]);
            }
            if (OpenPGPEncryptionNegotiator.allRecipientsSupportLibrePGPOED(arrayList)) {
                return MessageEncryptionMechanism.librePgp(OpenPGPEncryptionNegotiator.bestOEDEncryptionModeByWeight(arrayList, OpenPGPMessageGenerator.this.policy));
            }
            return MessageEncryptionMechanism.integrityProtected(OpenPGPEncryptionNegotiator.bestSymmetricKeyAlgorithmByWeight(arrayList, OpenPGPMessageGenerator.this.policy));
        }
    };
    private final OpenPGPEncryptionNegotiator encryptionNegotiator = new OpenPGPEncryptionNegotiator(){

        @Override
        public MessageEncryptionMechanism negotiateEncryption(OpenPGPMessageGenerator openPGPMessageGenerator) {
            if (OpenPGPMessageGenerator.this.encryptionKeys.isEmpty() && OpenPGPMessageGenerator.this.messagePassphrases.isEmpty()) {
                return MessageEncryptionMechanism.unencrypted();
            }
            if (OpenPGPMessageGenerator.this.encryptionKeys.isEmpty()) {
                return OpenPGPMessageGenerator.this.passwordBasedEncryptionNegotiator.negotiateEncryption(openPGPMessageGenerator);
            }
            return OpenPGPMessageGenerator.this.publicKeyBasedEncryptionNegotiator.negotiateEncryption(openPGPMessageGenerator);
        }
    };
    private CompressionNegotiator compressionNegotiator = new CompressionNegotiator(){

        @Override
        public int negotiateCompression(OpenPGPMessageGenerator openPGPMessageGenerator, OpenPGPPolicy openPGPPolicy) {
            return 0;
        }
    };

    public OpenPGPMessageGenerator() {
        this(OpenPGPImplementation.getInstance());
    }

    public OpenPGPMessageGenerator(OpenPGPImplementation openPGPImplementation) {
        this(openPGPImplementation, openPGPImplementation.policy());
    }

    public OpenPGPMessageGenerator(OpenPGPImplementation openPGPImplementation, OpenPGPPolicy openPGPPolicy) {
        super(openPGPImplementation, openPGPPolicy);
    }

    public OpenPGPMessageGenerator addEncryptionCertificate(OpenPGPCertificate openPGPCertificate) throws InvalidEncryptionKeyException {
        return this.addEncryptionCertificate(openPGPCertificate, this.encryptionKeySelector);
    }

    public OpenPGPMessageGenerator addEncryptionCertificate(OpenPGPCertificate openPGPCertificate, SubkeySelector subkeySelector) throws InvalidEncryptionKeyException {
        List<OpenPGPCertificate.OpenPGPComponentKey> list = subkeySelector.select(openPGPCertificate, this.policy);
        if (list.isEmpty()) {
            throw new InvalidEncryptionKeyException(openPGPCertificate);
        }
        this.encryptionKeys.addAll(list);
        return this;
    }

    public OpenPGPMessageGenerator addEncryptionCertificate(OpenPGPCertificate.OpenPGPComponentKey openPGPComponentKey) throws InvalidEncryptionKeyException {
        if (!openPGPComponentKey.isEncryptionKey()) {
            throw new InvalidEncryptionKeyException(openPGPComponentKey);
        }
        this.encryptionKeys.add(openPGPComponentKey);
        return this;
    }

    public OpenPGPMessageGenerator addEncryptionPassphrase(char[] cArray) {
        this.messagePassphrases.add(cArray);
        return this;
    }

    public OpenPGPMessageGenerator setArmored(boolean bl) {
        this.isArmored = bl;
        return this;
    }

    public OpenPGPMessageGenerator setAllowPadding(boolean bl) {
        this.isAllowPadding = bl;
        return this;
    }

    public OpenPGPMessageGenerator setFileMetadata(File file) {
        this.filename = file.getName();
        this.fileModificationDate = new Date(file.lastModified());
        this.format = (char)98;
        return this;
    }

    public OpenPGPMessageGenerator setSessionKeyExtractionCallback(PGPEncryptedDataGenerator.SessionKeyExtractionCallback sessionKeyExtractionCallback) {
        this.sessionKeyExtractionCallback = sessionKeyExtractionCallback;
        return this;
    }

    public OpenPGPMessageOutputStream open(OutputStream outputStream) throws PGPException, IOException {
        OpenPGPMessageOutputStream.Builder builder = OpenPGPMessageOutputStream.builder();
        this.applyOptionalAsciiArmor(builder);
        this.applyOptionalEncryption(builder, this.sessionKeyExtractionCallback);
        this.applySignatures(builder);
        this.applyOptionalCompression(builder);
        this.applyLiteralDataWrap(builder);
        return builder.build(outputStream);
    }

    private void applyOptionalAsciiArmor(OpenPGPMessageOutputStream.Builder builder) {
        if (this.isArmored) {
            builder.armor(this.armorStreamFactory);
        }
    }

    private void applyOptionalEncryption(OpenPGPMessageOutputStream.Builder builder, PGPEncryptedDataGenerator.SessionKeyExtractionCallback sessionKeyExtractionCallback) {
        PGPKeyEncryptionMethodGenerator pGPKeyEncryptionMethodGenerator;
        MessageEncryptionMechanism messageEncryptionMechanism = this.encryptionNegotiator.negotiateEncryption(this);
        if (!messageEncryptionMechanism.isEncrypted()) {
            return;
        }
        PGPDataEncryptorBuilder pGPDataEncryptorBuilder = this.implementation.pgpDataEncryptorBuilder(messageEncryptionMechanism.getSymmetricKeyAlgorithm());
        switch (messageEncryptionMechanism.getMode()) {
            case SEIPDv1: {
                pGPDataEncryptorBuilder.setWithIntegrityPacket(true);
                break;
            }
            case SEIPDv2: {
                pGPDataEncryptorBuilder.setWithAEAD(messageEncryptionMechanism.getAeadAlgorithm(), 6);
                pGPDataEncryptorBuilder.setUseV6AEAD();
                break;
            }
            case LIBREPGP_OED: {
                pGPDataEncryptorBuilder.setWithAEAD(messageEncryptionMechanism.getAeadAlgorithm(), 6);
                pGPDataEncryptorBuilder.setUseV5AEAD();
            }
        }
        final PGPEncryptedDataGenerator pGPEncryptedDataGenerator = new PGPEncryptedDataGenerator(pGPDataEncryptorBuilder);
        pGPEncryptedDataGenerator.setForceSessionKey(true);
        pGPEncryptedDataGenerator.setSessionKeyExtractionCallback(sessionKeyExtractionCallback);
        for (OpenPGPCertificate.OpenPGPComponentKey object : this.encryptionKeys) {
            pGPKeyEncryptionMethodGenerator = this.implementation.publicKeyKeyEncryptionMethodGenerator(object.getPGPPublicKey());
            pGPEncryptedDataGenerator.addMethod(pGPKeyEncryptionMethodGenerator);
        }
        block10: for (char[] cArray : this.messagePassphrases) {
            switch (messageEncryptionMechanism.getMode()) {
                case SEIPDv1: 
                case LIBREPGP_OED: {
                    pGPKeyEncryptionMethodGenerator = this.implementation.pbeKeyEncryptionMethodGenerator(cArray);
                    break;
                }
                case SEIPDv2: {
                    pGPKeyEncryptionMethodGenerator = this.implementation.pbeKeyEncryptionMethodGenerator(cArray, S2K.Argon2Params.memoryConstrainedParameters());
                    break;
                }
                default: {
                    continue block10;
                }
            }
            ((PBEKeyEncryptionMethodGenerator)pGPKeyEncryptionMethodGenerator).setSecureRandom(CryptoServicesRegistrar.getSecureRandom());
            pGPEncryptedDataGenerator.addMethod(pGPKeyEncryptionMethodGenerator);
        }
        builder.encrypt(new OpenPGPMessageOutputStream.OutputStreamFactory(){
            final /* synthetic */ OpenPGPMessageGenerator this$0;
            {
                this.this$0 = openPGPMessageGenerator;
            }

            @Override
            public OutputStream get(OutputStream outputStream) throws PGPException, IOException {
                try {
                    return pGPEncryptedDataGenerator.open(outputStream, new byte[1024]);
                }
                catch (IOException iOException) {
                    throw new PGPException("Could not open encryptor OutputStream", iOException);
                }
            }
        });
        if (messageEncryptionMechanism.getMode() == EncryptedDataPacketType.SEIPDv2 && this.isAllowPadding) {
            builder.padding(new OpenPGPMessageOutputStream.OutputStreamFactory(){

                @Override
                public OutputStream get(OutputStream outputStream) {
                    return new OpenPGPMessageOutputStream.PaddingPacketAppenderOutputStream(outputStream, new OpenPGPMessageOutputStream.PaddingPacketFactory(){

                        @Override
                        public PGPPadding providePaddingPacket() {
                            return new PGPPadding();
                        }
                    });
                }
            });
        }
    }

    private void applySignatures(OpenPGPMessageOutputStream.Builder builder) {
        builder.sign(new OpenPGPMessageOutputStream.OutputStreamFactory(){

            @Override
            public OutputStream get(OutputStream outputStream) throws PGPException, IOException {
                OpenPGPMessageGenerator.this.addSignToGenerator();
                Iterator iterator = OpenPGPMessageGenerator.this.signatureGenerators.iterator();
                while (iterator.hasNext()) {
                    PGPSignatureGenerator pGPSignatureGenerator = (PGPSignatureGenerator)iterator.next();
                    PGPOnePassSignature pGPOnePassSignature = pGPSignatureGenerator.generateOnePassVersion(iterator.hasNext());
                    pGPOnePassSignature.encode(outputStream);
                }
                return new OpenPGPMessageOutputStream.SignatureGeneratorOutputStream(outputStream, OpenPGPMessageGenerator.this.signatureGenerators);
            }
        });
    }

    private void applyOptionalCompression(OpenPGPMessageOutputStream.Builder builder) {
        int n = this.compressionNegotiator.negotiateCompression(this, this.policy);
        if (n == 0) {
            return;
        }
        final PGPCompressedDataGenerator pGPCompressedDataGenerator = new PGPCompressedDataGenerator(n);
        builder.compress(new OpenPGPMessageOutputStream.OutputStreamFactory(){
            final /* synthetic */ OpenPGPMessageGenerator this$0;
            {
                this.this$0 = openPGPMessageGenerator;
            }

            @Override
            public OutputStream get(OutputStream outputStream) throws PGPException, IOException {
                try {
                    return pGPCompressedDataGenerator.open(outputStream, new byte[1024]);
                }
                catch (IOException iOException) {
                    throw new PGPException("Could not apply compression", iOException);
                }
            }
        });
    }

    private void applyLiteralDataWrap(OpenPGPMessageOutputStream.Builder builder) {
        final PGPLiteralDataGenerator pGPLiteralDataGenerator = new PGPLiteralDataGenerator();
        builder.literalData(new OpenPGPMessageOutputStream.OutputStreamFactory(){
            final /* synthetic */ OpenPGPMessageGenerator this$0;
            {
                this.this$0 = openPGPMessageGenerator;
            }

            @Override
            public OutputStream get(OutputStream outputStream) throws PGPException, IOException {
                try {
                    return pGPLiteralDataGenerator.open(outputStream, this.this$0.format, this.this$0.filename != null ? this.this$0.filename : "", this.this$0.fileModificationDate != null ? this.this$0.fileModificationDate : PGPLiteralData.NOW, new byte[1024]);
                }
                catch (IOException iOException) {
                    throw new PGPException("Could not apply literal data wrapping", iOException);
                }
            }
        });
    }

    public OpenPGPMessageGenerator setPasswordBasedEncryptionNegotiator(OpenPGPEncryptionNegotiator openPGPEncryptionNegotiator) {
        if (openPGPEncryptionNegotiator == null) {
            throw new NullPointerException();
        }
        this.passwordBasedEncryptionNegotiator = openPGPEncryptionNegotiator;
        return this;
    }

    public OpenPGPMessageGenerator setPublicKeyBasedEncryptionNegotiator(OpenPGPEncryptionNegotiator openPGPEncryptionNegotiator) {
        if (openPGPEncryptionNegotiator == null) {
            throw new NullPointerException();
        }
        this.publicKeyBasedEncryptionNegotiator = openPGPEncryptionNegotiator;
        return this;
    }

    public OpenPGPMessageGenerator setEncryptionKeySelector(SubkeySelector subkeySelector) {
        if (subkeySelector == null) {
            throw new NullPointerException();
        }
        this.encryptionKeySelector = subkeySelector;
        return this;
    }

    public OpenPGPMessageGenerator setCompressionNegotiator(CompressionNegotiator compressionNegotiator) {
        if (compressionNegotiator == null) {
            throw new NullPointerException();
        }
        this.compressionNegotiator = compressionNegotiator;
        return this;
    }

    public OpenPGPMessageGenerator setArmorStreamFactory(ArmoredOutputStreamFactory armoredOutputStreamFactory) {
        if (armoredOutputStreamFactory == null) {
            throw new NullPointerException();
        }
        this.armorStreamFactory = armoredOutputStreamFactory;
        return this;
    }

    public static interface ArmoredOutputStreamFactory
    extends OpenPGPMessageOutputStream.OutputStreamFactory {
        @Override
        public ArmoredOutputStream get(OutputStream var1);
    }

    public static interface CompressionNegotiator {
        public int negotiateCompression(OpenPGPMessageGenerator var1, OpenPGPPolicy var2);
    }
}

