/****************************************************************************
 * arch/renesas/include/rx65n/irq.h
 *
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.  The
 * ASF licenses this file to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 *
 ****************************************************************************/

#ifndef __ARCH_RENESAS_INCLUDE_RX65N_IRQ_H
#define __ARCH_RENESAS_INCLUDE_RX65N_IRQ_H

/* SCI */

#define RX_RXI_IRQ_OFFSET       (0)   /* RxIn */
#define RX_TXI_IRQ_OFFSET       (1)   /* TxIn */
#define RX_ERI_IRQ_OFFSET       (2)   /* ERIn */
#define RX_TEI_IRQ_OFFSET       (3)   /* TEIn */
#define RX_SCI_NIRQS            (4)

#define RX65N_TRAP_IRQBASE   (0)
#define RX65N_TRAP0_IRQ      (RX65N_TRAP_IRQBASE)
#define RX65N_TRAP1_IRQ      (RX65N_TRAP_IRQBASE+1)
#define RX65N_TRAP2_IRQ      (RX65N_TRAP_IRQBASE+2)
#define RX65N_TRAP3_IRQ      (RX65N_TRAP_IRQBASE+3)
#define RX65N_TRAP4_IRQ      (RX65N_TRAP_IRQBASE+4)
#define RX65N_TRAP5_IRQ      (RX65N_TRAP_IRQBASE+5)
#define RX65N_TRAP6_IRQ      (RX65N_TRAP_IRQBASE+6)
#define RX65N_TRAP7_IRQ      (RX65N_TRAP_IRQBASE+7)
#define RX65N_TRAP8_IRQ      (RX65N_TRAP_IRQBASE+8)
#define RX65N_TRAP9_IRQ      (RX65N_TRAP_IRQBASE+9)
#define RX65N_TRAP10_IRQ     (RX65N_TRAP_IRQBASE+10)
#define RX65N_TRAP11_IRQ     (RX65N_TRAP_IRQBASE+11)
#define RX65N_TRAP12_IRQ     (RX65N_TRAP_IRQBASE+12)
#define RX65N_TRAP13_IRQ     (RX65N_TRAP_IRQBASE+13)
#define RX65N_TRAP14_IRQ     (RX65N_TRAP_IRQBASE+14)
#define RX65N_TRAP15_IRQ     (RX65N_TRAP_IRQBASE+15)
#define RX65N_BUSERR_IRQBASE (RX65N_TRAP_IRQBASE+16)

#if defined(CONFIG_BSC) || defined(CONFIG_RX65N_BSC)
# define RX65N_BUSERR_IRQ     (RX65N_BUSERR_IRQBASE)
# define RX65N_RAMERR_IRQBASE (RX65N_BUSERR_IRQBASE + 1)
#else
# define RX65N_RAMERR_IRQBASE (RX65N_BUSERR_IRQBASE)
#endif

#if defined(CONFIG_RAM) || defined(CONFIG_RX65N_RAM)
# define RX65N_RAMERR_IRQ     (RX65N_RAMERR_IRQBASE)
# define RX65N_FIFERR_IRQBASE (RX65N_RAMERR_IRQBASE + 1)
#else
# define RX65N_FIFERR_IRQBASE (RX65N_RAMERR_IRQBASE)
#endif

#if defined(CONFIG_FIFERR) || defined(CONFIG_RX65N_FIFERR)
# define RX65N_FIFERR_IRQ     (RX65N_FIFERR_IRQBASE)
# define RX65N_FRDYI_IRQBASE  (RX65N_FIFERR_IRQBASE + 1)
#else
# define RX65N_FRDYI_IRQBASE  (RX65N_FIFERR_IRQBASE)
#endif

#if defined(CONFIG_FRDYI) || defined(CONFIG_RX65N_FRDYI)
# define RX65N_FRDYI_IRQ        (RX65N_FRDYI_IRQBASE)
# define RX65N_SWINT2_IRQBASE   (RX65N_FRDYI_IRQBASE + 1)
#else
# define RX65N_SWINT2_IRQBASE   (RX65N_FRDYI_IRQBASE)
#endif

# define RX65N_SWINT2_IRQ       (RX65N_SWINT2_IRQBASE)
# define RX65N_SWINT_IRQBASE    (RX65N_SWINT2_IRQBASE + 1)

# define RX65N_SWINT_IRQ        (RX65N_SWINT_IRQBASE)
# define RX65N_CMT0_IRQBASE     (RX65N_SWINT_IRQBASE+1)

#define RX65N_CMI0_IRQ          (RX65N_CMT0_IRQBASE)
#define RX65N_CMT1_IRQBASE      (RX65N_CMT0_IRQBASE + 1)

#ifdef CONFIG_RX65N_CMT1
#  define RX65N_CMI1_IRQ        (RX65N_CMT1_IRQBASE)
#  define RX65N_CMTW0_IRQBASE   (RX65N_CMT1_IRQBASE + 1)
#else
#  define RX65N_CMTW0_IRQBASE   (RX65N_CMT1_IRQBASE)
#endif

#ifdef CONFIG_RX65N_CMTW0
#  define RX65N_CMWI0_IRQ      (RX65N_CMTW0_IRQBASE)
#  define RX65N_CMTW1_IRQBASE  (RX65N_CMTW0_IRQBASE + 1)
#else
#  define RX65N_CMTW1_IRQBASE  (RX65N_CMTW0_IRQBASE)
#endif

#ifdef CONFIG_RX65N_CMTW1
#  define RX65N_CMWI1_IRQ      (RX65N_CMTW1_IRQBASE)
#  define RX65N_USB0_IRQBASE   (RX65N_CMTW1_IRQBASE + 1)
#else
#  define RX65N_USB0_IRQBASE   (RX65N_CMTW1_IRQBASE)
#endif

#ifdef CONFIG_RX65N_USB0
#  define RX65N_D0FIFO0_IRQ    (RX65N_USB0_IRQBASE)
#  define RX65N_D1FIFO0_IRQ    (RX65N_USB0_IRQBASE + 1)
#  define RX65N_RSPI0_IRQBASE  (RX65N_USB0_IRQBASE + 2)
#else
#  define RX65N_RSPI0_IRQBASE  (RX65N_USB0_IRQBASE)
#endif
#ifdef CONFIG_RX65N_RSPI0
#  define RX65N_SPRI0_IRQ      (RX65N_RSPI0_IRQBASE)
#  define RX65N_SPTI0_IRQ      (RX65N_RSPI0_IRQBASE + 1)
#  define RX65N_RSPI1_IRQBASE  (RX65N_RSPI0_IRQBASE + 2)
#else
#  define RX65N_RSPI1_IRQBASE  (RX65N_RSPI0_IRQBASE)
#endif

#ifdef CONFIG_RX65N_RSPI1
#  define RX65N_SPRI1_IRQ       (RX65N_RSPI1_IRQBASE)
#  define RX65N_SPTI1_IRQ       (RX65N_RSPI1_IRQBASE + 1)
#  define RX65N_QSPI_IRQBASE    (RX65N_RSPI1_IRQBASE + 2)
#else
#  define RX65N_QSPI_IRQBASE    (RX65N_RSPI1_IRQBASE)
#endif

#ifdef CONFIG_RX65N_QSPI
#  define RX65N_SPRI_IRQ        (RX65N_QSPI_IRQBASE)
#  define RX65N_SPTI_IRQ        (RX65N_QSPI_IRQBASE + 1)
#  define RX65N_SDHI_IRQBASE    (RX65N_QSPI_IRQBASE + 2)
#else
#  define RX65N_SDHI_IRQBASE    (RX65N_QSPI_IRQBASE)
#endif

#ifdef CONFIG_RX65N_SDHI
#  define RX65N_SBFAI_IRQ        (RX65N_SDHI_IRQBASE)
#  define RX65N_MMCIF_IRQBASE    (RX65N_SDHI_IRQBASE + 1)
#else
#  define RX65N_MMCIF_IRQBASE    (RX65N_SDHI_IRQBASE)
#endif

#ifdef CONFIG_RX65N_MMCIF
#  define RX65N_MBFAI_IRQ        (RX65N_MMCIF_IRQBASE)
#  define RX65N_RIIC1_IRQBASE    (RX65N_MMCIF_IRQBASE + 1)
#else
#  define RX65N_RIIC1_IRQBASE    (RX65N_MMCIF_IRQBASE)
#endif

#ifdef CONFIG_RX65N_RIIC1
#  define RX65N_RIIC1_RXI1_IRQ  (RX65N_RIIC1_IRQBASE + RX_RXI_IRQ_OFFSET)
#  define RX65N_RIIC1_TXI1_IRQ  (RX65N_RIIC1_IRQBASE + RX_TXI_IRQ_OFFSET)
#  define RX65N_RIIC0_IRQBASE   (RX65N_RIIC1_IRQBASE + RX_SCI_NIRQS)
#else
#  define RX65N_RIIC0_IRQBASE   (RX65N_RIIC1_IRQBASE)
#endif

#ifdef CONFIG_RX65N_RIIC0
#  define RX65N_RIIC0_RXI0_IRQ  (RX65N_RIIC0_IRQBASE + RX_RXI_IRQ_OFFSET)
#  define RX65N_RIIC0_TXI0_IRQ  (RX65N_RIIC0_IRQBASE + RX_TXI_IRQ_OFFSET)
#  define RX65N_RIIC2_IRQBASE   (RX65N_RIIC0_IRQBASE + RX_SCI_NIRQS)
#else
#  define RX65N_RIIC2_IRQBASE   (RX65N_RIIC0_IRQBASE)
#endif

#ifdef CONFIG_RX65N_RIIC2
#  define RX65N_RIIC2_RXI2_IRQ  (RX65N_RIIC2_IRQBASE + RX_RXI_IRQ_OFFSET)
#  define RX65N_RIIC2_TXI2_IRQ  (RX65N_RIIC2_IRQBASE + RX_TXI_IRQ_OFFSET)
#  define RX65N_SCI0_IRQBASE    (RX65N_RIIC2_IRQBASE + RX_SCI_NIRQS)
#else
#  define RX65N_SCI0_IRQBASE    (RX65N_RIIC2_IRQBASE)
#endif

#ifdef CONFIG_RX65N_SCI0
#  define RX65N_RXI0_IRQ        (RX65N_SCI0_IRQBASE + RX_RXI_IRQ_OFFSET)
#  define RX65N_TXI0_IRQ        (RX65N_SCI0_IRQBASE + RX_TXI_IRQ_OFFSET)
#  define RX65N_ERI0_IRQ        (RX65N_SCI0_IRQBASE + RX_ERI_IRQ_OFFSET)
#  define RX65N_TEI0_IRQ        (RX65N_SCI0_IRQBASE + RX_TEI_IRQ_OFFSET)
#  define RX65N_SCI1_IRQBASE    (RX65N_SCI0_IRQBASE + RX_SCI_NIRQS)
#else
#  define RX65N_SCI1_IRQBASE    (RX65N_SCI0_IRQBASE)
#endif

#ifdef CONFIG_RX65N_SCI1
#  define RX65N_RXI1_IRQ        (RX65N_SCI1_IRQBASE + RX_RXI_IRQ_OFFSET)
#  define RX65N_TXI1_IRQ        (RX65N_SCI1_IRQBASE + RX_TXI_IRQ_OFFSET)
#  define RX65N_ERI1_IRQ        (RX65N_SCI1_IRQBASE + RX_ERI_IRQ_OFFSET)
#  define RX65N_TEI1_IRQ        (RX65N_SCI1_IRQBASE + RX_TEI_IRQ_OFFSET)
#  define RX65N_SCI2_IRQBASE    (RX65N_SCI1_IRQBASE + RX_SCI_NIRQS)
#else
#  define RX65N_SCI2_IRQBASE    (RX65N_SCI1_IRQBASE)
#endif

#ifdef CONFIG_RX65N_SCI2
#  define RX65N_RXI2_IRQ        (RX65N_SCI2_IRQBASE + RX_RXI_IRQ_OFFSET)
#  define RX65N_TXI2_IRQ        (RX65N_SCI2_IRQBASE + RX_TXI_IRQ_OFFSET)
#  define RX65N_ERI2_IRQ        (RX65N_SCI2_IRQBASE + RX_ERI_IRQ_OFFSET)
#  define RX65N_TEI2_IRQ        (RX65N_SCI2_IRQBASE + RX_TEI_IRQ_OFFSET)
#  define RX65N_ICU_IRQ_IRQBASE (RX65N_SCI2_IRQBASE + RX_SCI_NIRQS)
#else
#  define RX65N_ICU_IRQ_IRQBASE (RX65N_SCI2_IRQBASE)
#endif

#if defined(CONFIG_ICU) || defined(CONFIG_RX65N_ICU)
#  define RX65N_IRQ0_IRQ      (RX65N_ICU_IRQ_IRQBASE)
#  define RX65N_IRQ1_IRQ      (RX65N_ICU_IRQ_IRQBASE+1)
#  define RX65N_IRQ2_IRQ      (RX65N_ICU_IRQ_IRQBASE+2)
#  define RX65N_IRQ3_IRQ      (RX65N_ICU_IRQ_IRQBASE+3)
#  define RX65N_IRQ4_IRQ      (RX65N_ICU_IRQ_IRQBASE+4)
#  define RX65N_IRQ5_IRQ      (RX65N_ICU_IRQ_IRQBASE+5)
#  define RX65N_IRQ6_IRQ      (RX65N_ICU_IRQ_IRQBASE+6)
#  define RX65N_IRQ7_IRQ      (RX65N_ICU_IRQ_IRQBASE+7)
#  define RX65N_IRQ8_IRQ      (RX65N_ICU_IRQ_IRQBASE+8)
#  define RX65N_IRQ9_IRQ      (RX65N_ICU_IRQ_IRQBASE+9)
#  define RX65N_IRQ10_IRQ     (RX65N_ICU_IRQ_IRQBASE+10)
#  define RX65N_IRQ11_IRQ     (RX65N_ICU_IRQ_IRQBASE+11)
#  define RX65N_IRQ12_IRQ     (RX65N_ICU_IRQ_IRQBASE+12)
#  define RX65N_IRQ13_IRQ     (RX65N_ICU_IRQ_IRQBASE+13)
#  define RX65N_IRQ14_IRQ     (RX65N_ICU_IRQ_IRQBASE+14)
#  define RX65N_IRQ15_IRQ     (RX65N_ICU_IRQ_IRQBASE+15)
#  define RX65N_SCI3_IRQBASE  (RX65N_ICU_IRQ_IRQBASE+16)
#else
#  define RX65N_SCI3_IRQBASE  (RX65N_ICU_IRQ_IRQBASE)
#endif

#ifdef CONFIG_RX65N_SCI3
#  define RX65N_RXI3_IRQ        (RX65N_SCI3_IRQBASE + RX_RXI_IRQ_OFFSET)
#  define RX65N_TXI3_IRQ        (RX65N_SCI3_IRQBASE + RX_TXI_IRQ_OFFSET)
#  define RX65N_ERI3_IRQ        (RX65N_SCI3_IRQBASE + RX_ERI_IRQ_OFFSET)
#  define RX65N_TEI3_IRQ        (RX65N_SCI3_IRQBASE + RX_TEI_IRQ_OFFSET)
#  define RX65N_SCI4_IRQBASE    (RX65N_SCI3_IRQBASE + RX_SCI_NIRQS)
#else
#  define RX65N_SCI4_IRQBASE    (RX65N_SCI3_IRQBASE)
#endif

#ifdef CONFIG_RX65N_SCI4
#  define RX65N_RXI4_IRQ        (RX65N_SCI4_IRQBASE + RX_RXI_IRQ_OFFSET)
#  define RX65N_TXI4_IRQ        (RX65N_SCI4_IRQBASE + RX_TXI_IRQ_OFFSET)
#  define RX65N_ERI4_IRQ        (RX65N_SCI4_IRQBASE + RX_ERI_IRQ_OFFSET)
#  define RX65N_TEI4_IRQ        (RX65N_SCI4_IRQBASE + RX_TEI_IRQ_OFFSET)
#  define RX65N_SCI5_IRQBASE    (RX65N_SCI4_IRQBASE + RX_SCI_NIRQS)
#else
#  define RX65N_SCI5_IRQBASE    (RX65N_SCI4_IRQBASE)
#endif

#ifdef CONFIG_RX65N_SCI5
#  define RX65N_RXI5_IRQ        (RX65N_SCI5_IRQBASE + RX_RXI_IRQ_OFFSET)
#  define RX65N_TXI5_IRQ        (RX65N_SCI5_IRQBASE + RX_TXI_IRQ_OFFSET)
#  define RX65N_ERI5_IRQ        (RX65N_SCI5_IRQBASE + RX_ERI_IRQ_OFFSET)
#  define RX65N_TEI5_IRQ        (RX65N_SCI5_IRQBASE + RX_TEI_IRQ_OFFSET)
#  define RX65N_SCI6_IRQBASE    (RX65N_SCI5_IRQBASE + RX_SCI_NIRQS)
#else
#  define RX65N_SCI6_IRQBASE    (RX65N_SCI5_IRQBASE)
#endif

#ifdef CONFIG_RX65N_SCI6
#  define RX65N_RXI6_IRQ        (RX65N_SCI6_IRQBASE + RX_RXI_IRQ_OFFSET)
#  define RX65N_TXI6_IRQ        (RX65N_SCI6_IRQBASE + RX_TXI_IRQ_OFFSET)
#  define RX65N_ERI6_IRQ        (RX65N_SCI6_IRQBASE + RX_ERI_IRQ_OFFSET)
#  define RX65N_TEI6_IRQ        (RX65N_SCI6_IRQBASE + RX_TEI_IRQ_OFFSET)
#  define RX65N_LVD1_IRQBASE    (RX65N_SCI6_IRQBASE + RX_SCI_NIRQS)
#else
#  define RX65N_LVD1_IRQBASE    (RX65N_SCI6_IRQBASE)
#endif

#ifdef CONFIG_RX65N_LVD1
#  define RX65N_LVD1_IRQ        (RX65N_LVD1_IRQBASE)
#  define RX65N_LVD2_IRQBASE    (RX65N_LVD1_IRQBASE + 1)
#else
#  define RX65N_LVD2_IRQBASE    (RX65N_LVD1_IRQBASE)
#endif

#ifdef CONFIG_RX65N_LVD2
#  define RX65N_LVD2_IRQ           (RX65N_LVD2_IRQBASE)
#  define RX65N_USB0_R0_IRQBASE    (RX65N_LVD2_IRQBASE + 1)
#else
#  define RX65N_USB0_R0_IRQBASE    (RX65N_LVD2_IRQBASE)
#endif

#ifdef CONFIG_RX65N_USB0_R0
#  define RX65N_USBR0_IRQ       (RX65N_USB0_R0_IRQBASE)
#  define RX65N_RTC_IRQBASE     (RX65N_USB0_R0_IRQBASE)
#else
#  define RX65N_RTC_IRQBASE     (RX65N_USB0_R0_IRQBASE)
#endif

#ifdef CONFIG_RX65N_RTC
#  define RX65N_ALM_IRQ         (RX65N_RTC_IRQBASE)
#  define RX65N_PRD_IRQ         (RX65N_RTC_IRQBASE + 1)
#  define RX65N_IWDT_IRQBASE    (RX65N_RTC_IRQBASE + 2)
#else
#  define RX65N_IWDT_IRQBASE    (RX65N_RTC_IRQBASE)
#endif

#ifdef CONFIG_RX65N_IWDT
#  define RX65N_IWUNI_IRQ        (RX65N_IWDT_IRQBASE)
#  define RX65N_WDT_IRQBASE      (RX65N_IWDT_IRQBASE + 1)
#else
#  define RX65N_WDT_IRQBASE      (RX65N_IWDT_IRQBASE)
#endif

#ifdef CONFIG_RX65N_WDT
#  define RX65N_WUNI_IRQ        (RX65N_WDT_IRQBASE)
#  define RX65N_PDC_IRQBASE     (RX65N_WDT_IRQBASE + 1)
#else
#  define RX65N_PDC_IRQBASE     (RX65N_WDT_IRQBASE)
#endif

#ifdef CONFIG_RX65N_PDC
#  define RX65N_PCDFI_IRQ       (RX65N_PDC_IRQBASE)
#  define RX65N_SCI7_IRQBASE    (RX65N_PDC_IRQBASE + 1)
#else
#  define RX65N_SCI7_IRQBASE    (RX65N_PDC_IRQBASE)
#endif

#ifdef CONFIG_RX65N_SCI7
#  define RX65N_RXI7_IRQ        (RX65N_SCI7_IRQBASE + RX_RXI_IRQ_OFFSET)
#  define RX65N_TXI7_IRQ        (RX65N_SCI7_IRQBASE + RX_TXI_IRQ_OFFSET)
#  define RX65N_ERI7_IRQ        (RX65N_SCI7_IRQBASE + RX_ERI_IRQ_OFFSET)
#  define RX65N_TEI7_IRQ        (RX65N_SCI7_IRQBASE + RX_TEI_IRQ_OFFSET)
#  define RX65N_SCI8_IRQBASE    (RX65N_SCI7_IRQBASE + RX_SCI_NIRQS)
#else
#  define RX65N_SCI8_IRQBASE    (RX65N_SCI7_IRQBASE)
#endif

#ifdef CONFIG_RX65N_SCI8
#  define RX65N_RXI8_IRQ        (RX65N_SCI8_IRQBASE + RX_RXI_IRQ_OFFSET)
#  define RX65N_TXI8_IRQ        (RX65N_SCI8_IRQBASE + RX_TXI_IRQ_OFFSET)
#  define RX65N_ERI8_IRQ        (RX65N_SCI8_IRQBASE + RX_ERI_IRQ_OFFSET)
#  define RX65N_TEI8_IRQ        (RX65N_SCI8_IRQBASE + RX_TEI_IRQ_OFFSET)
#  define RX65N_SCI9_IRQBASE    (RX65N_SCI8_IRQBASE + RX_SCI_NIRQS)
#else
#  define RX65N_SCI9_IRQBASE    (RX65N_SCI8_IRQBASE)
#endif

#ifdef CONFIG_RX65N_SCI9
#  define RX65N_RXI9_IRQ        (RX65N_SCI9_IRQBASE + RX_RXI_IRQ_OFFSET)
#  define RX65N_TXI9_IRQ        (RX65N_SCI9_IRQBASE + RX_TXI_IRQ_OFFSET)
#  define RX65N_ERI9_IRQ        (RX65N_SCI9_IRQBASE + RX_ERI_IRQ_OFFSET)
#  define RX65N_TEI9_IRQ        (RX65N_SCI9_IRQBASE + RX_TEI_IRQ_OFFSET)
#  define RX65N_SCI10_IRQBASE   (RX65N_SCI9_IRQBASE + RX_SCI_NIRQS)
#else
#  define RX65N_SCI10_IRQBASE   (RX65N_SCI9_IRQBASE)
#endif

#ifdef CONFIG_RX65N_SCI10
#  define RX65N_RXI10_IRQ           (RX65N_SCI10_IRQBASE + RX_RXI_IRQ_OFFSET)
#  define RX65N_TXI10_IRQ           (RX65N_SCI10_IRQBASE + RX_TXI_IRQ_OFFSET)
#  define RX65N_ERI10_IRQ           (RX65N_SCI10_IRQBASE + RX_ERI_IRQ_OFFSET)
#  define RX65N_TEI10_IRQ           (RX65N_SCI10_IRQBASE + RX_TEI_IRQ_OFFSET)
#  define RX65N_IRQ_GROUPB_IRQBASE  (RX65N_SCI10_IRQBASE + RX_SCI_NIRQS)
#else
#  define RX65N_IRQ_GROUPB_IRQBASE  (RX65N_SCI10_IRQBASE)
#endif

#ifdef CONFIG_RX65N_IRQ_GROUP
#  define RX65N_GROUPBE0_IRQ  (RX65N_IRQ_GROUPB_IRQBASE)
#  define RX65N_GROUPBL2_IRQ  (RX65N_IRQ_GROUPB_IRQBASE + 1)
#  define RX65N_RSPI2_IRQBASE (RX65N_IRQ_GROUPB_IRQBASE + 2)
#else
#  define RX65N_RSPI2_IRQBASE (RX65N_IRQ_GROUPB_IRQBASE)
#endif

#ifdef CONFIG_RX65N_RSPI2
#  define RX65N_SPRI2_IRQ               (RX65N_RSPI2_IRQBASE)
#  define RX65N_SPTI2_IRQ               (RX65N_RSPI2_IRQBASE + 1)
#  define RX65N_IRQ_GROUPBL_IRQBASE     (RX65N_RSPI2_IRQBASE + 2)
#else
#  define RX65N_IRQ_GROUPBL_IRQBASE     (RX65N_RSPI2_IRQBASE)
#endif

#ifdef CONFIG_RX65N_IRQ_GROUP
#  define RX65N_GROUPBL0_IRQ  (RX65N_IRQ_GROUPBL_IRQBASE)
#  define RX65N_GROUPBL1_IRQ  (RX65N_IRQ_GROUPBL_IRQBASE + 1)
#  define RX65N_GROUPAL0_IRQ  (RX65N_IRQ_GROUPBL_IRQBASE + 2)
#  define RX65N_GROUPAL1_IRQ  (RX65N_IRQ_GROUPBL_IRQBASE + 3)
#  define RX65N_ETH_IRQBASE (RX65N_IRQ_GROUPBL_IRQBASE + 4)
#else
#  define RX65N_ETH_IRQBASE (RX65N_IRQ_GROUPBL_IRQBASE)
#endif

#ifdef CONFIG_RX65N_EMAC0
#  define RX65N_ETH_IRQ RX65N_ETH_IRQBASE
#  define RX65N_SCI11_IRQBASE (RX65N_ETH_IRQBASE + 1)
#else
#  define RX65N_SCI11_IRQBASE (RX65N_ETH_IRQBASE)
#endif

#ifdef CONFIG_RX65N_SCI11
#  define RX65N_RXI11_IRQ        (RX65N_SCI11_IRQBASE + RX_RXI_IRQ_OFFSET)
#  define RX65N_TXI11_IRQ        (RX65N_SCI11_IRQBASE + RX_TXI_IRQ_OFFSET)
#  define RX65N_ERI11_IRQ        (RX65N_SCI11_IRQBASE + RX_ERI_IRQ_OFFSET)
#  define RX65N_TEI11_IRQ        (RX65N_SCI11_IRQBASE + RX_TEI_IRQ_OFFSET)
#  define RX65N_SCI12_IRQBASE    (RX65N_SCI11_IRQBASE + RX_SCI_NIRQS)
#else
#  define RX65N_SCI12_IRQBASE    (RX65N_SCI11_IRQBASE)
#endif

#ifdef CONFIG_RX65N_SCI12
#  define RX65N_RXI12_IRQ        (RX65N_SCI12_IRQBASE + RX_RXI_IRQ_OFFSET)
#  define RX65N_TXI12_IRQ        (RX65N_SCI12_IRQBASE + RX_TXI_IRQ_OFFSET)
#  define RX65N_ERI12_IRQ        (RX65N_SCI12_IRQBASE + RX_ERI_IRQ_OFFSET)
#  define RX65N_TEI12_IRQ        (RX65N_SCI12_IRQBASE + RX_TEI_IRQ_OFFSET)
#  define RX65N_DMAC_IRQBASE     (RX65N_SCI12_IRQBASE + RX_SCI_NIRQS)
#else
#  define RX65N_DMAC_IRQBASE     (RX65N_SCI12_IRQBASE)
#endif

#ifdef CONFIG_RX65N_DMAC
#  define RX65N_DMAC0I_IRQ        (RX65N_DMAC_IRQBASE)
#  define RX65N_DMAC1I_IRQ        (RX65N_DMAC_IRQBASE + 1)
#  define RX65N_DMAC2I_IRQ        (RX65N_DMAC_IRQBASE + 2)
#  define RX65N_DMAC3I_IRQ        (RX65N_DMAC_IRQBASE + 3)
#  define RX65N_DMAC74I_IRQ       (RX65N_DMAC_IRQBASE + 4)
#  define RX65N_OST_IRQBASE       (RX65N_DMAC_IRQBASE + 5)
#else
#  define RX65N_OST_IRQBASE       (RX65N_DMAC_IRQBASE)
#endif

#ifdef CONFIG_RX65N_OST
#  define RX65N_OSTD1_IRQ         (RX65N_OST_IRQBASE)
#  define RX65N_EXDMAC_IRQBASE    (RX65N_OST_IRQBASE + 1)
#else
#  define RX65N_EXDMAC_IRQBASE    (RX65N_OST_IRQBASE)
#endif

#ifdef CONFIG_RX65N_EXDMAC
#  define RX65N_EXDMAC0I_IRQ         (RX65N_EXDMAC_IRQBASE)
#  define RX65N_EXDMAC1I_IRQ         (RX65N_EXDMAC_IRQBASE + 1)
#  define RX65N_PERIB_IRQBASE        (RX65N_EXDMAC_IRQBASE + 2)
#else
#  define RX65N_PERIB_IRQBASE        (RX65N_EXDMAC_IRQBASE)
#endif

#  ifdef CONFIG_RX65N_PERIB
#  define RX65N_INTB128_IRQ          (RX65N_PERIB_IRQBASE)
#  define RX65N_INTB129_IRQ          (RX65N_PERIB_IRQBASE + 1)
#  define RX65N_INTB130_IRQ          (RX65N_PERIB_IRQBASE + 2)
#  define RX65N_INTB131_IRQ          (RX65N_PERIB_IRQBASE + 3)
#  define RX65N_INTB132_IRQ          (RX65N_PERIB_IRQBASE + 4)
#  define RX65N_INTB133_IRQ          (RX65N_PERIB_IRQBASE + 5)
#  define RX65N_INTB134_IRQ          (RX65N_PERIB_IRQBASE + 6)
#  define RX65N_INTB135_IRQ          (RX65N_PERIB_IRQBASE + 7)
#  define RX65N_INTB136_IRQ          (RX65N_PERIB_IRQBASE + 8)
#  define RX65N_INTB137_IRQ          (RX65N_PERIB_IRQBASE + 9)
#  define RX65N_INTB138_IRQ          (RX65N_PERIB_IRQBASE + 10)
#  define RX65N_INTB139_IRQ          (RX65N_PERIB_IRQBASE + 11)
#  define RX65N_INTB140_IRQ          (RX65N_PERIB_IRQBASE + 12)
#  define RX65N_INTB141_IRQ          (RX65N_PERIB_IRQBASE + 13)
#  define RX65N_INTB142_IRQ          (RX65N_PERIB_IRQBASE + 14)
#  define RX65N_INTB143_IRQ          (RX65N_PERIB_IRQBASE + 15)
#  define RX65N_INTB144_IRQ          (RX65N_PERIB_IRQBASE + 16)
#  define RX65N_INTB145_IRQ          (RX65N_PERIB_IRQBASE + 17)
#  define RX65N_INTB146_IRQ          (RX65N_PERIB_IRQBASE + 18)
#  define RX65N_INTB147_IRQ          (RX65N_PERIB_IRQBASE + 19)
#  define RX65N_INTB148_IRQ          (RX65N_PERIB_IRQBASE + 20)
#  define RX65N_INTB149_IRQ          (RX65N_PERIB_IRQBASE + 21)
#  define RX65N_INTB150_IRQ          (RX65N_PERIB_IRQBASE + 22)
#  define RX65N_INTB151_IRQ          (RX65N_PERIB_IRQBASE + 23)
#  define RX65N_INTB152_IRQ          (RX65N_PERIB_IRQBASE + 24)
#  define RX65N_INTB153_IRQ          (RX65N_PERIB_IRQBASE + 25)
#  define RX65N_INTB154_IRQ          (RX65N_PERIB_IRQBASE + 26)
#  define RX65N_INTB155_IRQ          (RX65N_PERIB_IRQBASE + 27)
#  define RX65N_INTB156_IRQ          (RX65N_PERIB_IRQBASE + 28)
#  define RX65N_INTB157_IRQ          (RX65N_PERIB_IRQBASE + 29)
#  define RX65N_INTB158_IRQ          (RX65N_PERIB_IRQBASE + 30)
#  define RX65N_INTB159_IRQ          (RX65N_PERIB_IRQBASE + 31)
#  define RX65N_INTB160_IRQ          (RX65N_PERIB_IRQBASE + 32)
#  define RX65N_INTB161_IRQ          (RX65N_PERIB_IRQBASE + 33)
#  define RX65N_INTB162_IRQ          (RX65N_PERIB_IRQBASE + 34)
#  define RX65N_INTB163_IRQ          (RX65N_PERIB_IRQBASE + 35)
#  define RX65N_INTB164_IRQ          (RX65N_PERIB_IRQBASE + 36)
#  define RX65N_INTB165_IRQ          (RX65N_PERIB_IRQBASE + 37)
#  define RX65N_INTB166_IRQ          (RX65N_PERIB_IRQBASE + 38)
#  define RX65N_INTB167_IRQ          (RX65N_PERIB_IRQBASE + 39)
#  define RX65N_INTB168_IRQ          (RX65N_PERIB_IRQBASE + 40)
#  define RX65N_INTB169_IRQ          (RX65N_PERIB_IRQBASE + 41)

/* using for CONFIG_RX65N_CMTW0 */

#  define RX65N_INTB170_IRQ          (RX65N_PERIB_IRQBASE + 42)

/* using for CONFIG_RX65N_CMTW1 */

#  define RX65N_INTB171_IRQ          (RX65N_PERIB_IRQBASE + 43)
#  define RX65N_INTB172_IRQ          (RX65N_PERIB_IRQBASE + 44)
#  define RX65N_INTB173_IRQ          (RX65N_PERIB_IRQBASE + 45)
#  define RX65N_INTB174_IRQ          (RX65N_PERIB_IRQBASE + 46)
#  define RX65N_INTB175_IRQ          (RX65N_PERIB_IRQBASE + 47)
#  define RX65N_INTB176_IRQ          (RX65N_PERIB_IRQBASE + 48)
#  define RX65N_INTB177_IRQ          (RX65N_PERIB_IRQBASE + 49)
#  define RX65N_INTB178_IRQ          (RX65N_PERIB_IRQBASE + 50)
#  define RX65N_INTB179_IRQ          (RX65N_PERIB_IRQBASE + 51)
#  define RX65N_INTB180_IRQ          (RX65N_PERIB_IRQBASE + 52)
#  define RX65N_INTB181_IRQ          (RX65N_PERIB_IRQBASE + 53)
#  define RX65N_INTB182_IRQ          (RX65N_PERIB_IRQBASE + 54)
#  define RX65N_INTB183_IRQ          (RX65N_PERIB_IRQBASE + 55)
#  define RX65N_INTB184_IRQ          (RX65N_PERIB_IRQBASE + 56)
#  define RX65N_INTB185_IRQ          (RX65N_PERIB_IRQBASE + 57)
#  define RX65N_INTB186_IRQ          (RX65N_PERIB_IRQBASE + 58)
#  define RX65N_INTB187_IRQ          (RX65N_PERIB_IRQBASE + 59)
#  define RX65N_INTB188_IRQ          (RX65N_PERIB_IRQBASE + 60)
#  define RX65N_INTB189_IRQ          (RX65N_PERIB_IRQBASE + 61)
#  define RX65N_INTB190_IRQ          (RX65N_PERIB_IRQBASE + 62)
#  define RX65N_INTB191_IRQ          (RX65N_PERIB_IRQBASE + 63)
#  define RX65N_INTB192_IRQ          (RX65N_PERIB_IRQBASE + 64)
#  define RX65N_INTB193_IRQ          (RX65N_PERIB_IRQBASE + 65)
#  define RX65N_INTB194_IRQ          (RX65N_PERIB_IRQBASE + 66)
#  define RX65N_INTB195_IRQ          (RX65N_PERIB_IRQBASE + 67)
#  define RX65N_INTB196_IRQ          (RX65N_PERIB_IRQBASE + 68)
#  define RX65N_INTB197_IRQ          (RX65N_PERIB_IRQBASE + 69)
#  define RX65N_INTB198_IRQ          (RX65N_PERIB_IRQBASE + 70)
#  define RX65N_INTB199_IRQ          (RX65N_PERIB_IRQBASE + 71)
#  define RX65N_INTB200_IRQ          (RX65N_PERIB_IRQBASE + 72)
#  define RX65N_INTB201_IRQ          (RX65N_PERIB_IRQBASE + 73)
#  define RX65N_INTB202_IRQ          (RX65N_PERIB_IRQBASE + 74)
#  define RX65N_INTB203_IRQ          (RX65N_PERIB_IRQBASE + 75)
#  define RX65N_INTB204_IRQ          (RX65N_PERIB_IRQBASE + 76)
#  define RX65N_INTB205_IRQ          (RX65N_PERIB_IRQBASE + 77)
#  define RX65N_INTB206_IRQ          (RX65N_PERIB_IRQBASE + 78)
#  define RX65N_INTB207_IRQ          (RX65N_PERIB_IRQBASE + 79)
#  define RX65N_PERIA_IRQBASE        (RX65N_PERIB_IRQBASE + 80)
#else
#  define RX65N_PERIA_IRQBASE        (RX65N_PERIB_IRQBASE)
#endif

#ifdef CONFIG_RX65N_PERIA
#  define RX65N_INTA208_IRQ          (RX65N_PERIA_IRQBASE)
#  define RX65N_INTA209_IRQ          (RX65N_PERIA_IRQBASE + 1)
#  define RX65N_INTA210_IRQ          (RX65N_PERIA_IRQBASE + 2)
#  define RX65N_INTA211_IRQ          (RX65N_PERIA_IRQBASE + 3)
#  define RX65N_INTA212_IRQ          (RX65N_PERIA_IRQBASE + 4)
#  define RX65N_INTA213_IRQ          (RX65N_PERIA_IRQBASE + 5)
#  define RX65N_INTA214_IRQ          (RX65N_PERIA_IRQBASE + 6)
#  define RX65N_INTA215_IRQ          (RX65N_PERIA_IRQBASE + 7)
#  define RX65N_INTA216_IRQ          (RX65N_PERIA_IRQBASE + 8)
#  define RX65N_INTA217_IRQ          (RX65N_PERIA_IRQBASE + 9)
#  define RX65N_INTA218_IRQ          (RX65N_PERIA_IRQBASE + 10)
#  define RX65N_INTA219_IRQ          (RX65N_PERIA_IRQBASE + 11)
#  define RX65N_INTA220_IRQ          (RX65N_PERIA_IRQBASE + 12)
#  define RX65N_INTA221_IRQ          (RX65N_PERIA_IRQBASE + 13)
#  define RX65N_INTA222_IRQ          (RX65N_PERIA_IRQBASE + 14)
#  define RX65N_INTA223_IRQ          (RX65N_PERIA_IRQBASE + 15)
#  define RX65N_INTA224_IRQ          (RX65N_PERIA_IRQBASE + 16)
#  define RX65N_INTA225_IRQ          (RX65N_PERIA_IRQBASE + 17)
#  define RX65N_INTA226_IRQ          (RX65N_PERIA_IRQBASE + 18)
#  define RX65N_INTA227_IRQ          (RX65N_PERIA_IRQBASE + 19)
#  define RX65N_INTA228_IRQ          (RX65N_PERIA_IRQBASE + 20)
#  define RX65N_INTA229_IRQ          (RX65N_PERIA_IRQBASE + 21)
#  define RX65N_INTA230_IRQ          (RX65N_PERIA_IRQBASE + 22)
#  define RX65N_INTA231_IRQ          (RX65N_PERIA_IRQBASE + 23)
#  define RX65N_INTA232_IRQ          (RX65N_PERIA_IRQBASE + 24)
#  define RX65N_INTA233_IRQ          (RX65N_PERIA_IRQBASE + 25)
#  define RX65N_INTA234_IRQ          (RX65N_PERIA_IRQBASE + 26)
#  define RX65N_INTA235_IRQ          (RX65N_PERIA_IRQBASE + 27)
#  define RX65N_INTA236_IRQ          (RX65N_PERIA_IRQBASE + 28)
#  define RX65N_INTA237_IRQ          (RX65N_PERIA_IRQBASE + 29)
#  define RX65N_INTA238_IRQ          (RX65N_PERIA_IRQBASE + 30)
#  define RX65N_INTA239_IRQ          (RX65N_PERIA_IRQBASE + 31)
#  define RX65N_INTA240_IRQ          (RX65N_PERIA_IRQBASE + 32)
#  define RX65N_INTA241_IRQ          (RX65N_PERIA_IRQBASE + 33)
#  define RX65N_INTA242_IRQ          (RX65N_PERIA_IRQBASE + 34)
#  define RX65N_INTA243_IRQ          (RX65N_PERIA_IRQBASE + 35)
#  define RX65N_INTA244_IRQ          (RX65N_PERIA_IRQBASE + 36)
#  define RX65N_INTA245_IRQ          (RX65N_PERIA_IRQBASE + 37)
#  define RX65N_INTA246_IRQ          (RX65N_PERIA_IRQBASE + 38)
#  define RX65N_INTA247_IRQ          (RX65N_PERIA_IRQBASE + 39)
#  define RX65N_INTA248_IRQ          (RX65N_PERIA_IRQBASE + 40)
#  define RX65N_INTA249_IRQ          (RX65N_PERIA_IRQBASE + 41)
#  define RX65N_INTA250_IRQ          (RX65N_PERIA_IRQBASE + 42)
#  define RX65N_INTA251_IRQ          (RX65N_PERIA_IRQBASE + 43)
#  define RX65N_INTA252_IRQ          (RX65N_PERIA_IRQBASE + 44)
#  define RX65N_INTA253_IRQ          (RX65N_PERIA_IRQBASE + 45)
#  define RX65N_INTA254_IRQ          (RX65N_PERIA_IRQBASE + 46)
#  define RX65N_INTA255_IRQ          (RX65N_PERIA_IRQBASE + 47)
#  define NR_IRQS                    (RX65N_PERIA_IRQBASE + 48)
#else
#  define NR_IRQS                    (RX65N_PERIA_IRQBASE)
#endif

/* IRQ Stack Frame Format.  The RX65N has a push down stack.  The PC
 * and SR are pushed by hardware at the time an IRQ is taken.
 */

/* Saved to the stacked by up_vector */

/* Vector table offsets */

/* Trap instruction */

#define RX65N_TRAP_VNDX      (0)
#define RX65N_TRAP0_VNDX     (RX65N_TRAP_VNDX)
#define RX65N_TRAP1_VNDX     (RX65N_TRAP_VNDX +  1)
#define RX65N_TRAP2_VNDX     (RX65N_TRAP_VNDX +  2)
#define RX65N_TRAP3_VNDX     (RX65N_TRAP_VNDX +  3)
#define RX65N_TRAP4_VNDX     (RX65N_TRAP_VNDX +  4)
#define RX65N_TRAP5_VNDX     (RX65N_TRAP_VNDX +  5)
#define RX65N_TRAP6_VNDX     (RX65N_TRAP_VNDX +  6)
#define RX65N_TRAP7_VNDX     (RX65N_TRAP_VNDX +  7)
#define RX65N_TRAP8_VNDX     (RX65N_TRAP_VNDX +  8)
#define RX65N_TRAP9_VNDX     (RX65N_TRAP_VNDX +  9)
#define RX65N_TRAP10_VNDX    (RX65N_TRAP_VNDX + 10)
#define RX65N_TRAP11_VNDX    (RX65N_TRAP_VNDX + 11)
#define RX65N_TRAP12_VNDX    (RX65N_TRAP_VNDX + 12)
#define RX65N_TRAP13_VNDX    (RX65N_TRAP_VNDX + 13)
#define RX65N_TRAP14_VNDX    (RX65N_TRAP_VNDX + 14)
#define RX65N_TRAP15_VNDX    (RX65N_TRAP_VNDX + 15)

/* Bus Error */

#  define RX65N_BUSERR_VNDX    (VECT_BSC_BUSERR)

/* RAM Error */

#define RX65N_RAMERR_VNDX    (VECT_RAM_RAMERR)

/* FIFERR Error */

#define RX65N_FIFERR_VNDX     (VECT_FCU_FIFERR)

/* FRDYI */

#define RX65N_FRDYI_VNDX      (VECT_FCU_FRDYI)

/* ICU Interrupts */

#define RX65N_SWINT2_VNDX     (VECT_ICU_SWINT2)
#define RX65N_SWINT_VNDX      (VECT_ICU_SWINT)
#define RX65N_IRQ0_VNDX       (VECT_ICU_IRQ0)
#define RX65N_IRQ1_VNDX       (VECT_ICU_IRQ1)
#define RX65N_IRQ2_VNDX       (VECT_ICU_IRQ2)
#define RX65N_IRQ3_VNDX       (VECT_ICU_IRQ3)
#define RX65N_IRQ4_VNDX       (VECT_ICU_IRQ4)
#define RX65N_IRQ5_VNDX       (VECT_ICU_IRQ5)
#define RX65N_IRQ6_VNDX       (VECT_ICU_IRQ6)
#define RX65N_IRQ7_VNDX       (VECT_ICU_IRQ7)
#define RX65N_IRQ8_VNDX       (VECT_ICU_IRQ8)
#define RX65N_IRQ9_VNDX       (VECT_ICU_IRQ9)
#define RX65N_IRQ10_VNDX      (VECT_ICU_IRQ10)
#define RX65N_IRQ11_VNDX      (VECT_ICU_IRQ11)
#define RX65N_IRQ12_VNDX      (VECT_ICU_IRQ12)
#define RX65N_IRQ13_VNDX      (VECT_ICU_IRQ13)
#define RX65N_IRQ14_VNDX      (VECT_ICU_IRQ14)
#define RX65N_IRQ15_VNDX      (VECT_ICU_IRQ15)
#define RX65N_GROUPBE0_VNDX   (VECT_ICU_GROUPBE0)
#define RX65N_GROUPBL0_VNDX   (VECT_ICU_GROUPBL0)
#define RX65N_GROUPBL1_VNDX   (VECT_ICU_GROUPBL1)
#define RX65N_GROUPBL2_VNDX   (VECT_ICU_GROUPBL2)
#define RX65N_GROUPAL0_VNDX   (VECT_ICU_GROUPAL0)
#define RX65N_GROUPAL1_VNDX   (VECT_ICU_GROUPAL1)

/* CMT Interrupts */

#define  RX65N_CMI0_VNDX      (VECT_CMT0_CMI0)
#define  RX65N_CMI1_VNDX      (VECT_CMT0_CMI1)
#define  RX65N_CMWI0_VNDX     (VECT_CMT0_CMWI0)
#define  RX65N_CMWI1_VNDX     (VECT_CMT0_CMWI1)

/* USB Interrupts */

#define RX65N_D0FIFO0_VNDX    (VECT_USB0_D0FIFO0)
#define RX65N_D1FIFO0_VNDX    (VECT_USB0_D1FIFO0)
#define RX65N_USBR0_VNDX      (VECT_USB0_USBR0)

/* RSPI Interrupts */

#define RX65N_SPRI0_VNDX      (VECT_RSPI0_SPRI0)
#define RX65N_SPTI0_VNDX      (VECT_RSPI0_SPTI0)
#define RX65N_SPRI1_VNDX      (VECT_RSPI1_SPRI1)
#define RX65N_SPTI1_VNDX      (VECT_RSPI1_SPTI1)
#define RX65N_SPRI2_VNDX      (VECT_RSPI2_SPRI2)
#define RX65N_SPTI2_VNDX      (VECT_RSPI2_SPTI2)

/* QSPI Interrupts */

#define RX65N_SPRI_VNDX       (VECT_QSPI_SPRI)
#define RX65N_SPTI_VNDX       (VECT_QSPI_SPTI)

/* SDHI MMC Interrupts */

#define RX65N_SBFAI_VNDX      (VECT_SDHI_SBFAI)
#define RX65N_MBFAI_VNDX      (VECT_MMCIF_MBFAI)

/* RIIC Interrupts */

#define RX65N_RIIC0_EEI0_VNDX       (VECT_ICU_GROUPBL1)
#define RX65N_RIIC0_RXI0_VNDX       (VECT_RIIC0_RXI0)
#define RX65N_RIIC0_TXI0_VNDX       (VECT_RIIC0_TXI0)
#define RX65N_RIIC0_TEI0_VNDX       (VECT_ICU_GROUPBL1)

#define RX65N_RIIC1_EEI1_VNDX       (VECT_ICU_GROUPBL1)
#define RX65N_RIIC1_RXI1_VNDX       (VECT_RIIC1_RXI1)
#define RX65N_RIIC1_TXI1_VNDX       (VECT_RIIC1_TXI1)
#define RX65N_RIIC1_TEI1_VNDX       (VECT_ICU_GROUPBL1)

#define RX65N_RIIC2_EEI2_VNDX       (VECT_ICU_GROUPBL1)
#define RX65N_RIIC2_RXI2_VNDX       (VECT_RIIC2_RXI2)
#define RX65N_RIIC2_TXI2_VNDX       (VECT_RIIC2_TXI2)
#define RX65N_RIIC2_TEI2_VNDX       (VECT_ICU_GROUPBL1)

/* SCI Interrupts */

#define RX65N_ERI0_VNDX       (VECT_ICU_GROUPBL0)
#define RX65N_RXI0_VNDX       (VECT_SCI0_RXI0)
#define RX65N_TXI0_VNDX       (VECT_SCI0_TXI0)
#define RX65N_TEI0_VNDX       (VECT_ICU_GROUPBL0)

#define RX65N_ERI1_VNDX       (VECT_ICU_GROUPBL0)
#define RX65N_RXI1_VNDX       (VECT_SCI1_RXI1)
#define RX65N_TXI1_VNDX       (VECT_SCI1_TXI1)
#define RX65N_TEI1_VNDX       (VECT_ICU_GROUPBL0)

#define RX65N_ERI2_VNDX       (VECT_ICU_GROUPBL0)
#define RX65N_RXI2_VNDX       (VECT_SCI2_RXI2)
#define RX65N_TXI2_VNDX       (VECT_SCI2_TXI2)
#define RX65N_TEI2_VNDX       (VECT_ICU_GROUPBL0)

#define RX65N_ERI3_VNDX       (VECT_ICU_GROUPBL0)
#define RX65N_RXI3_VNDX       (VECT_SCI3_RXI3)
#define RX65N_TXI3_VNDX       (VECT_SCI3_TXI3)
#define RX65N_TEI3_VNDX       (VECT_ICU_GROUPBL0)

#define RX65N_ERI4_VNDX       (VECT_ICU_GROUPBL0)
#define RX65N_RXI4_VNDX       (VECT_SCI4_RXI4)
#define RX65N_TXI4_VNDX       (VECT_SCI4_TXI4)
#define RX65N_TEI4_VNDX       (VECT_ICU_GROUPBL0)

#define RX65N_ERI5_VNDX       (VECT_ICU_GROUPBL0)
#define RX65N_RXI5_VNDX       (VECT_SCI5_RXI5)
#define RX65N_TXI5_VNDX       (VECT_SCI5_TXI5)
#define RX65N_TEI5_VNDX       (VECT_ICU_GROUPBL0)

#define RX65N_ERI6_VNDX       (VECT_ICU_GROUPBL0)
#define RX65N_RXI6_VNDX       (VECT_SCI6_RXI6)
#define RX65N_TXI6_VNDX       (VECT_SCI6_TXI6)
#define RX65N_TEI6_VNDX       (VECT_ICU_GROUPBL0)

#define RX65N_ERI7_VNDX       (VECT_ICU_GROUPBL0)
#define RX65N_RXI7_VNDX       (VECT_SCI7_RXI7)
#define RX65N_TXI7_VNDX       (VECT_SCI7_TXI7)
#define RX65N_TEI7_VNDX       (VECT_ICU_GROUPBL0)

#define RX65N_ERI8_VNDX       (VECT_ICU_GROUPBL1)
#define RX65N_RXI8_VNDX       (VECT_SCI8_RXI8)
#define RX65N_TXI8_VNDX       (VECT_SCI8_TXI8)
#define RX65N_TEI8_VNDX       (VECT_ICU_GROUPBL1)

#define RX65N_ERI9_VNDX       (VECT_ICU_GROUPBL1)
#define RX65N_RXI9_VNDX       (VECT_SCI9_RXI9)
#define RX65N_TXI9_VNDX       (VECT_SCI9_TXI9)
#define RX65N_TEI9_VNDX       (VECT_ICU_GROUPBL1)

#define RX65N_ERI10_VNDX       (VECT_ICU_GROUPAL0)
#define RX65N_RXI10_VNDX       (VECT_SCI10_RXI10)
#define RX65N_TXI10_VNDX       (VECT_SCI10_TXI10)
#define RX65N_TEI10_VNDX       (VECT_ICU_GROUPAL0)

#define RX65N_ERI11_VNDX       (VECT_ICU_GROUPAL0)
#define RX65N_RXI11_VNDX       (VECT_SCI11_RXI11)
#define RX65N_TXI11_VNDX       (VECT_SCI11_TXI11)
#define RX65N_TEI11_VNDX       (VECT_ICU_GROUPAL0)

#define RX65N_ERI12_VNDX       (VECT_ICU_GROUPBL0)
#define RX65N_RXI12_VNDX       (VECT_SCI12_RXI12)
#define RX65N_TXI12_VNDX       (VECT_SCI12_TXI12)
#define RX65N_TEI12_VNDX       (VECT_ICU_GROUPBL0)

/* LVD Interrupts */

#define RX65N_LVD1_VNDX        (VECT_LVD1_LVD1)
#define RX65N_LVD2_VNDX        (VECT_LVD2_LVD2)

/* RTC Interrupts */

#define RX65N_ALM_VNDX         (VECT_RTC_ALM)
#define RX65N_PRD_VNDX         (VECT_RTC_PRD)

/* WDT Interrupts */

#define RX65N_IWUNI_VNDX        (VECT_IWDT_IWUNI)
#define RX65N_WUNI_VNDX         (VECT_WDT_WUNI)

/* PDC Interrupts */

#define RX65N_PCDFI_VNDX        (VECT_PDC_PCDFI)

/* DMAC Interrupts */

#define RX65N_DMAC0I_VNDX       (VECT_DMAC_DMAC0I)
#define RX65N_DMAC1I_VNDX       (VECT_DMAC_DMAC1I)
#define RX65N_DMAC2I_VNDX       (VECT_DMAC_DMAC2I)
#define RX65N_DMAC3I_VNDX       (VECT_DMAC_DMAC3I)
#define RX65N_DMAC74I_VNDX      (VECT_DMAC_DMAC74I)

/* OST Interrupts */

#define RX65N_OSTDI_VNDX           (VECT_OST_OSTDI)

/* EXDMAC Interrupts */

#define RX65N_EXDMAC0I_VNDX        (VECT_EXDMAC_EXDMAC0I)
#define RX65N_EXDMAC1I_VNDX        (VECT_EXDMAC_EXDMAC1I)

/* PERIB Interrupts */

#define RX65N_INTB128_VNDX         (VECT_PERIB_INTB128)
#define RX65N_INTB129_VNDX         (VECT_PERIB_INTB129)
#define RX65N_INTB130_VNDX         (VECT_PERIB_INTB130)
#define RX65N_INTB131_VNDX         (VECT_PERIB_INTB131)
#define RX65N_INTB132_VNDX         (VECT_PERIB_INTB132)
#define RX65N_INTB133_VNDX         (VECT_PERIB_INTB133)
#define RX65N_INTB134_VNDX         (VECT_PERIB_INTB134)
#define RX65N_INTB135_VNDX         (VECT_PERIB_INTB135)
#define RX65N_INTB136_VNDX         (VECT_PERIB_INTB136)
#define RX65N_INTB137_VNDX         (VECT_PERIB_INTB137)
#define RX65N_INTB138_VNDX         (VECT_PERIB_INTB138)
#define RX65N_INTB139_VNDX         (VECT_PERIB_INTB139)
#define RX65N_INTB140_VNDX         (VECT_PERIB_INTB140)
#define RX65N_INTB141_VNDX         (VECT_PERIB_INTB141)
#define RX65N_INTB142_VNDX         (VECT_PERIB_INTB142)
#define RX65N_INTB143_VNDX         (VECT_PERIB_INTB143)
#define RX65N_INTB144_VNDX         (VECT_PERIB_INTB144)
#define RX65N_INTB145_VNDX         (VECT_PERIB_INTB145)
#define RX65N_INTB146_VNDX         (VECT_PERIB_INTB146)
#define RX65N_INTB147_VNDX         (VECT_PERIB_INTB147)
#define RX65N_INTB148_VNDX         (VECT_PERIB_INTB148)
#define RX65N_INTB149_VNDX         (VECT_PERIB_INTB149)
#define RX65N_INTB150_VNDX         (VECT_PERIB_INTB150)
#define RX65N_INTB151_VNDX         (VECT_PERIB_INTB151)
#define RX65N_INTB152_VNDX         (VECT_PERIB_INTB152)
#define RX65N_INTB153_VNDX         (VECT_PERIB_INTB153)
#define RX65N_INTB154_VNDX         (VECT_PERIB_INTB154)
#define RX65N_INTB155_VNDX         (VECT_PERIB_INTB155)
#define RX65N_INTB156_VNDX         (VECT_PERIB_INTB156)
#define RX65N_INTB157_VNDX         (VECT_PERIB_INTB157)
#define RX65N_INTB158_VNDX         (VECT_PERIB_INTB158)
#define RX65N_INTB159_VNDX         (VECT_PERIB_INTB159)
#define RX65N_INTB160_VNDX         (VECT_PERIB_INTB160)
#define RX65N_INTB161_VNDX         (VECT_PERIB_INTB161)
#define RX65N_INTB162_VNDX         (VECT_PERIB_INTB162)
#define RX65N_INTB163_VNDX         (VECT_PERIB_INTB163)
#define RX65N_INTB164_VNDX         (VECT_PERIB_INTB164)
#define RX65N_INTB165_VNDX         (VECT_PERIB_INTB165)
#define RX65N_INTB166_VNDX         (VECT_PERIB_INTB166)
#define RX65N_INTB167_VNDX         (VECT_PERIB_INTB167)
#define RX65N_INTB168_VNDX         (VECT_PERIB_INTB168)
#define RX65N_INTB169_VNDX         (VECT_PERIB_INTB169)
#define RX65N_INTB170_VNDX         (VECT_PERIB_INTB170)
#define RX65N_INTB171_VNDX         (VECT_PERIB_INTB171)
#define RX65N_INTB172_VNDX         (VECT_PERIB_INTB172)
#define RX65N_INTB173_VNDX         (VECT_PERIB_INTB173)
#define RX65N_INTB174_VNDX         (VECT_PERIB_INTB174)
#define RX65N_INTB175_VNDX         (VECT_PERIB_INTB175)
#define RX65N_INTB176_VNDX         (VECT_PERIB_INTB176)
#define RX65N_INTB177_VNDX         (VECT_PERIB_INTB177)
#define RX65N_INTB178_VNDX         (VECT_PERIB_INTB178)
#define RX65N_INTB179_VNDX         (VECT_PERIB_INTB179)
#define RX65N_INTB180_VNDX         (VECT_PERIB_INTB180)
#define RX65N_INTB181_VNDX         (VECT_PERIB_INTB181)
#define RX65N_INTB182_VNDX         (VECT_PERIB_INTB182)
#define RX65N_INTB183_VNDX         (VECT_PERIB_INTB183)
#define RX65N_INTB184_VNDX         (VECT_PERIB_INTB184)
#define RX65N_INTB185_VNDX         (VECT_PERIB_INTB185)
#define RX65N_INTB186_VNDX         (VECT_PERIB_INTB186)
#define RX65N_INTB187_VNDX         (VECT_PERIB_INTB187)
#define RX65N_INTB188_VNDX         (VECT_PERIB_INTB188)
#define RX65N_INTB189_VNDX         (VECT_PERIB_INTB189)
#define RX65N_INTB190_VNDX         (VECT_PERIB_INTB190)
#define RX65N_INTB191_VNDX         (VECT_PERIB_INTB191)
#define RX65N_INTB192_VNDX         (VECT_PERIB_INTB192)
#define RX65N_INTB193_VNDX         (VECT_PERIB_INTB193)
#define RX65N_INTB194_VNDX         (VECT_PERIB_INTB194)
#define RX65N_INTB195_VNDX         (VECT_PERIB_INTB195)
#define RX65N_INTB196_VNDX         (VECT_PERIB_INTB196)
#define RX65N_INTB197_VNDX         (VECT_PERIB_INTB197)
#define RX65N_INTB198_VNDX         (VECT_PERIB_INTB198)
#define RX65N_INTB199_VNDX         (VECT_PERIB_INTB199)
#define RX65N_INTB200_VNDX         (VECT_PERIB_INTB200)
#define RX65N_INTB201_VNDX         (VECT_PERIB_INTB201)
#define RX65N_INTB202_VNDX         (VECT_PERIB_INTB202)
#define RX65N_INTB203_VNDX         (VECT_PERIB_INTB203)
#define RX65N_INTB204_VNDX         (VECT_PERIB_INTB204)
#define RX65N_INTB205_VNDX         (VECT_PERIB_INTB205)
#define RX65N_INTB206_VNDX         (VECT_PERIB_INTB206)
#define RX65N_INTB207_VNDX         (VECT_PERIB_INTB207)

/* PERIA Interrupts */

#define RX65N_INTA208_VNDX         (VECT_PERIA_INTA208)
#define RX65N_INTA209_VNDX         (VECT_PERIA_INTA209)
#define RX65N_INTA210_VNDX         (VECT_PERIA_INTA210)
#define RX65N_INTA211_VNDX         (VECT_PERIA_INTA211)
#define RX65N_INTA212_VNDX         (VECT_PERIA_INTA212)
#define RX65N_INTA213_VNDX         (VECT_PERIA_INTA213)
#define RX65N_INTA214_VNDX         (VECT_PERIA_INTA214)
#define RX65N_INTA215_VNDX         (VECT_PERIA_INTA215)
#define RX65N_INTA216_VNDX         (VECT_PERIA_INTA216)
#define RX65N_INTA217_VNDX         (VECT_PERIA_INTA217)
#define RX65N_INTA218_VNDX         (VECT_PERIA_INTA218)
#define RX65N_INTA219_VNDX         (VECT_PERIA_INTA219)
#define RX65N_INTA220_VNDX         (VECT_PERIA_INTA220)
#define RX65N_INTA221_VNDX         (VECT_PERIA_INTA221)
#define RX65N_INTA222_VNDX         (VECT_PERIA_INTA222)
#define RX65N_INTA223_VNDX         (VECT_PERIA_INTA223)
#define RX65N_INTA224_VNDX         (VECT_PERIA_INTA224)
#define RX65N_INTA225_VNDX         (VECT_PERIA_INTA225)
#define RX65N_INTA226_VNDX         (VECT_PERIA_INTA226)
#define RX65N_INTA227_VNDX         (VECT_PERIA_INTA227)
#define RX65N_INTA228_VNDX         (VECT_PERIA_INTA228)
#define RX65N_INTA229_VNDX         (VECT_PERIA_INTA229)
#define RX65N_INTA230_VNDX         (VECT_PERIA_INTA230)
#define RX65N_INTA231_VNDX         (VECT_PERIA_INTA231)
#define RX65N_INTA232_VNDX         (VECT_PERIA_INTA232)
#define RX65N_INTA233_VNDX         (VECT_PERIA_INTA233)
#define RX65N_INTA234_VNDX         (VECT_PERIA_INTA234)
#define RX65N_INTA235_VNDX         (VECT_PERIA_INTA235)
#define RX65N_INTA236_VNDX         (VECT_PERIA_INTA236)
#define RX65N_INTA237_VNDX         (VECT_PERIA_INTA237)
#define RX65N_INTA238_VNDX         (VECT_PERIA_INTA238)
#define RX65N_INTA239_VNDX         (VECT_PERIA_INTA239)
#define RX65N_INTA240_VNDX         (VECT_PERIA_INTA240)
#define RX65N_INTA241_VNDX         (VECT_PERIA_INTA241)
#define RX65N_INTA242_VNDX         (VECT_PERIA_INTA242)
#define RX65N_INTA243_VNDX         (VECT_PERIA_INTA243)
#define RX65N_INTA244_VNDX         (VECT_PERIA_INTA244)
#define RX65N_INTA245_VNDX         (VECT_PERIA_INTA245)
#define RX65N_INTA246_VNDX         (VECT_PERIA_INTA246)
#define RX65N_INTA247_VNDX         (VECT_PERIA_INTA247)
#define RX65N_INTA248_VNDX         (VECT_PERIA_INTA248)
#define RX65N_INTA249_VNDX         (VECT_PERIA_INTA249)
#define RX65N_INTA250_VNDX         (VECT_PERIA_INTA250)
#define RX65N_INTA251_VNDX         (VECT_PERIA_INTA251)
#define RX65N_INTA252_VNDX         (VECT_PERIA_INTA252)
#define RX65N_INTA253_VNDX         (VECT_PERIA_INTA253)
#define RX65N_INTA254_VNDX         (VECT_PERIA_INTA254)
#define RX65N_INTA255_VNDX         (VECT_PERIA_INTA255)

#define RX65N_NVECTORS             (256)

/* Register information */

#define REG_SP                  ( 0)
#define REG_ACC0LO              ( 1)
#define REG_ACC0HI              ( 2)
#define REG_ACC0GU              ( 3)
#define REG_ACC1LO              ( 4)
#define REG_ACC1HI              ( 5)
#define REG_ACC1GU              ( 6)
#define REG_FPSW                ( 7)
#define REG_R1                  ( 8)
#define REG_R2                  ( 9)
#define REG_R3                  (10)
#define REG_R4                  (11)
#define REG_R5                  (12)
#define REG_R6                  (13)
#define REG_R7                  (14)
#define REG_R8                  (15)
#define REG_R9                  (16)
#define REG_R10                 (17)
#define REG_R11                 (18)
#define REG_R12                 (19)
#define REG_R13                 (20)
#define REG_R14                 (21)
#define REG_R15                 (22)
#define REG_PC                  (23)
#define REG_PSW                 (24)
#define XCPTCONTEXT_REGS        (25)
#define XCPTCONTEXT_SIZE        (4 * XCPTCONTEXT_REGS)

#ifndef __ASSEMBLY__
struct xcptcontext
{
  /* The following function pointer is non-zero if there are pending signals
   * to be processed.
   */

  void *sigdeliver; /* Actual type is sig_deliver_t */

  /* These are saved copies of LR and SR used during signal processing. */

  uint32_t saved_pc;
  uint32_t saved_sr;

  /* Register save area */

  uint32_t regs[XCPTCONTEXT_REGS];
};

/* Name: up_irq_save, up_irq_restore, and friends.
 *
 * NOTE: This function should never be called from application code and,
 * as a general rule unless you really know what you are doing, this
 * function should not be called directly from operation system code either:
 * Typically, the wrapper functions, enter_critical_section() and
 * leave_critical section(), are probably what you really want.
 */

#define RX65N_PSW_INTERRUPT  (0x00010000)

/* Return the current interrupt enable state and disable IRQs */

/* Get the current value of the SR */

static inline irqstate_t __getsr(void)
{
  irqstate_t flags;
  __asm__ __volatile__("mvfc psw, %0":"=r"(flags));
  return flags;
}

/* Set the new value of the SR */

static inline void __setsr(irqstate_t psw)
{
  __asm__ __volatile__("mvtc %0, psw": :"r"(psw));
}

/* Disable interrupts */

static inline void up_irq_disable(void)
{
  __asm__ __volatile__("CLRPSW I");
}

/* Enable interrupts */

static inline void up_irq_enable(void)
{
  __asm__ __volatile__("SETPSW I");
}

/* Return the current interrupt enable state and disable interrupts */

static inline irqstate_t up_irq_save(void)
{
  irqstate_t flags = __getsr();
  up_irq_disable();
  return flags;
}

/* Restore saved interrupt state */

static inline void up_irq_restore(irqstate_t flags)
{
  if (RX65N_PSW_INTERRUPT == (flags & RX65N_PSW_INTERRUPT))
  {
    up_irq_enable();
  }
  else
  {
    up_irq_disable();
  }
}

#endif /* __ASSEMBLY__ */

#endif /* __ARCH_RENESAS_INCLUDE_RX65N_IRQ_H */
