/****************************************************************************
 * drivers/video/isx012_reg.h
 *
 *   Copyright 2018 Sony Semiconductor Solutions Corporation
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 * 3. Neither the name of Sony Semiconductor Solutions Corporation nor
 *    the names of its contributors may be used to endorse or promote
 *    products derived from this software without specific prior written
 *    permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
 * COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS
 * OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED
 * AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN
 * ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 ****************************************************************************/

/****************************************************************************
 * Included Files
 ****************************************************************************/

#ifndef __DRIVERS_VIDEO_ISX012_REG_H
#define __DRIVERS_VIDEO_ISX012_REG_H

#define ISX012_I2C_SLV_ADDR         (0x1A)

/* I2C BASE ADDRESS */

#define USERCTRL_BASE               (0x0000)
#define POST_VIF_BASE               (0x1E00)
#define CPUCONF_BASE                (0x5000)
#define CTRL_BASE                   (0x5200)
#define SENSMIPI_BASE               (0x5C00)
#define AE_BASE                     (0x5E00)
#define AWB_BASE                    (0x6200)
#define AF_BASE                     (0x6600)
#define ADJ_BASE                    (0x6800)
#define MODE_BASE                   (0x6A00)
#define PICT_BASE                   (0x6C00)
#define GAMMA_BASE                  (0x7000)
#define JPEG_BASE                   (0x7800)
#define AUTOCOM_BASE                (0x7C00)
#define VFRMPARA_BASE               (0x8800)
#define SOUT_BASE                   (0x8A00)
#define PICT_GAIN0_BASE             (0x9200)
#define CXC_DATA_BASE               (0xEB00)
#define SHD_DATA_BASE               (0xED00)

/* USERCTRL OFFSET */

#define ROM_VERSION                 (USERCTRL_BASE+0x0000)
#define PARAM_VERSION               (USERCTRL_BASE+0x0002)
#define I2C_ADR_SEL                 (USERCTRL_BASE+0x0004)
#define CHIPSTNBY                   (USERCTRL_BASE+0x0005)
#define INCK_SET                    (USERCTRL_BASE+0x0006)
#define PLL_CKSEL                   (USERCTRL_BASE+0x0007)
#define SRCCK_DIV                   (USERCTRL_BASE+0x0008)
#define AF_EXT                      (USERCTRL_BASE+0x000B)
#define DRIVABILITY                 (USERCTRL_BASE+0x000C)
#define PULLCNT                     (USERCTRL_BASE+0x000D)
#define INTSTS0                     (USERCTRL_BASE+0x000E)
#define INTEN0                      (USERCTRL_BASE+0x0010)
#define INTCLR0                     (USERCTRL_BASE+0x0012)
#define DEVICESTS                   (USERCTRL_BASE+0x0014)
#define GPIO_DATA                   (USERCTRL_BASE+0x0015)
#define GPIO_FUNCSEL                (USERCTRL_BASE+0x0016)
#define GPIO_SEL                    (USERCTRL_BASE+0x0018)
#define GPIO_STS                    (USERCTRL_BASE+0x0019)
#define PWMCK_DIV                   (USERCTRL_BASE+0x0034)
#define PREFLASH                    (USERCTRL_BASE+0x0037)
#define OTP_CHIPID_L                (USERCTRL_BASE+0x0038)
#define OTP_CHIPID_H                (USERCTRL_BASE+0x003C)
#define OTP0_A0                     (USERCTRL_BASE+0x0040)
#define OTP0_A1                     (USERCTRL_BASE+0x0041)
#define OTP0_A2                     (USERCTRL_BASE+0x0042)
#define OTP0_A3                     (USERCTRL_BASE+0x0043)
#define OTP0_A4                     (USERCTRL_BASE+0x0044)
#define OTP0_B0                     (USERCTRL_BASE+0x0045)
#define OTP0_B1                     (USERCTRL_BASE+0x0046)
#define OTP0_B2                     (USERCTRL_BASE+0x0047)
#define OTP0_B3                     (USERCTRL_BASE+0x0048)
#define OTP0_B4                     (USERCTRL_BASE+0x0049)
#define OTP0_C0                     (USERCTRL_BASE+0x004A)
#define OTP0_C1                     (USERCTRL_BASE+0x004B)
#define OTP0_C2                     (USERCTRL_BASE+0x004C)
#define OTP0_C3                     (USERCTRL_BASE+0x004D)
#define OTP0_C4                     (USERCTRL_BASE+0x004E)
#define OTP1_A0                     (USERCTRL_BASE+0x004F)
#define OTP1_A1                     (USERCTRL_BASE+0x0050)
#define OTP1_A2                     (USERCTRL_BASE+0x0051)
#define OTP1_A3                     (USERCTRL_BASE+0x0052)
#define OTP1_A4                     (USERCTRL_BASE+0x0053)
#define OTP1_B0                     (USERCTRL_BASE+0x0054)
#define OTP1_B1                     (USERCTRL_BASE+0x0055)
#define OTP1_B2                     (USERCTRL_BASE+0x0056)
#define OTP1_B3                     (USERCTRL_BASE+0x0057)
#define OTP1_B4                     (USERCTRL_BASE+0x0058)
#define OTP1_C0                     (USERCTRL_BASE+0x0059)
#define OTP1_C1                     (USERCTRL_BASE+0x005A)
#define OTP1_C2                     (USERCTRL_BASE+0x005B)
#define OTP1_C3                     (USERCTRL_BASE+0x005C)
#define OTP1_C4                     (USERCTRL_BASE+0x005D)
#define OTP_FLG                     (USERCTRL_BASE+0x0060)
#define OTP_CTRL                    (USERCTRL_BASE+0x0061)
#define OTP_CLOCK                   (USERCTRL_BASE+0x0062)
#define OTPSTS                      (USERCTRL_BASE+0x0063)
#define OTP_WRITE_A0                (USERCTRL_BASE+0x0064)
#define OTP_WRITE_A1                (USERCTRL_BASE+0x0065)
#define OTP_WRITE_A2                (USERCTRL_BASE+0x0066)
#define OTP_WRITE_A3                (USERCTRL_BASE+0x0067)
#define OTP_WRITE_A4                (USERCTRL_BASE+0x0068)
#define OTP_WRITE_B0                (USERCTRL_BASE+0x0069)
#define OTP_WRITE_B1                (USERCTRL_BASE+0x006A)
#define OTP_WRITE_B2                (USERCTRL_BASE+0x006B)
#define OTP_WRITE_B3                (USERCTRL_BASE+0x006C)
#define OTP_WRITE_B4                (USERCTRL_BASE+0x006D)
#define OTP_WRITE_C0                (USERCTRL_BASE+0x006E)
#define OTP_WRITE_C1                (USERCTRL_BASE+0x006F)
#define OTP_WRITE_C2                (USERCTRL_BASE+0x0070)
#define OTP_WRITE_C3                (USERCTRL_BASE+0x0071)
#define OTP_WRITE_C4                (USERCTRL_BASE+0x0072)
#define MODESEL_FIX                 (USERCTRL_BASE+0x0080)
#define MODESEL                     (USERCTRL_BASE+0x0081)
#define MONI_REFRESH                (USERCTRL_BASE+0x0082)
#define SENSMODE_MONI               (USERCTRL_BASE+0x0083)
#define SENSMODE_CAP                (USERCTRL_BASE+0x0084)
#define SENSMODE_MOVIE              (USERCTRL_BASE+0x0085)
#define FPSTYPE_MONI                (USERCTRL_BASE+0x0086)
#define FPSTYPE_CAP                 (USERCTRL_BASE+0x0087)
#define FPSTYPE_MOVIE               (USERCTRL_BASE+0x0088)
#define OUTFMT_MONI                 (USERCTRL_BASE+0x0089)
#define OUTFMT_CAP                  (USERCTRL_BASE+0x008A)
#define OUTFMT_MOVIE                (USERCTRL_BASE+0x008B)
#define READVECT_MONI               (USERCTRL_BASE+0x008C)
#define READVECT_CAP                (USERCTRL_BASE+0x008D)
#define READVECT_MOVIE              (USERCTRL_BASE+0x008E)
#define HSIZE_MONI                  (USERCTRL_BASE+0x0090)
#define HSIZE_CAP                   (USERCTRL_BASE+0x0092)
#define HSIZE_MOVIE                 (USERCTRL_BASE+0x0094)
#define VSIZE_MONI                  (USERCTRL_BASE+0x0096)
#define VSIZE_CAP                   (USERCTRL_BASE+0x0098)
#define VSIZE_MOVIE                 (USERCTRL_BASE+0x009A)
#define HSIZE_TN                    (USERCTRL_BASE+0x009C)
#define VSIZE_TN                    (USERCTRL_BASE+0x009E)
#define VEXPAND_SEL                 (USERCTRL_BASE+0x00A0)
#define HVFREEZOOM                  (USERCTRL_BASE+0x00A1)
#define EZOOM_MAG                   (USERCTRL_BASE+0x00A2)
#define EZOOM_HMAG                  (USERCTRL_BASE+0x00A4)
#define EZOOM_VMAG                  (USERCTRL_BASE+0x00A6)
#define OFFSET_X                    (USERCTRL_BASE+0x00A8)
#define OFFSET_Y                    (USERCTRL_BASE+0x00AA)
#define PLL_CHG_SEL                 (USERCTRL_BASE+0x00AC)
#define EXT_MODE_SEL                (USERCTRL_BASE+0x00AD)
#define VADD_MODE                   (USERCTRL_BASE+0x00AE)
#define HSENS_MODE_SEL              (USERCTRL_BASE+0x00AF)
#define CLP_HADD_SEL                (USERCTRL_BASE+0x00B0)
#define AF_RESTART_F                (USERCTRL_BASE+0x00B1)
#define AFMODE_MONI                 (USERCTRL_BASE+0x00B2)
#define AFMODE_HREL                 (USERCTRL_BASE+0x00B3)
#define AFMODE_MOVIE                (USERCTRL_BASE+0x00B4)
#define CAP_CARRY_OVER_F            (USERCTRL_BASE+0x00B5)
#define CAPNUM                      (USERCTRL_BASE+0x00B6)
#define LED_ON                      (USERCTRL_BASE+0x00B7)
#define VIFOUTMASK                  (USERCTRL_BASE+0x00C0)
#define VIFCONFIG                   (USERCTRL_BASE+0x00C2)
#define VIF_CLKCONFIG1              (USERCTRL_BASE+0x00C4)
#define VIF_CLKCONFIG2              (USERCTRL_BASE+0x00C5)
#define VIF_CLKCONFIG3              (USERCTRL_BASE+0x00C6)
#define VIF_CLKCONFIG4              (USERCTRL_BASE+0x00C7)
#define VIF_CLKCONFIG5              (USERCTRL_BASE+0x00C8)
#define VIF_CLKCONFIG6              (USERCTRL_BASE+0x00C9)
#define VIF_CLKCONFIG7              (USERCTRL_BASE+0x00CA)
#define VIF_CLKCONFIG8              (USERCTRL_BASE+0x00CB)
#define VIF_CLKCONFIG9              (USERCTRL_BASE+0x00CC)
#define VIF_CLKCONFIG10             (USERCTRL_BASE+0x00CD)
#define VIF_CLKCONFIG11             (USERCTRL_BASE+0x00CE)
#define VIF_CLKCONFIG12             (USERCTRL_BASE+0x00CF)
#define VIF_CLKCONFIG_EXIT1         (USERCTRL_BASE+0x00D0)
#define VIF_CLKCONFIG_EXIT2         (USERCTRL_BASE+0x00D1)
#define VIF_CLKCONFIG_EXIT3         (USERCTRL_BASE+0x00D2)
#define VIF_CLKCONFIG_EXIT4         (USERCTRL_BASE+0x00D3)
#define VIF_CLKCONFIG_EXIT5         (USERCTRL_BASE+0x00D4)
#define VIF_CLKCONFIG_EXIT6         (USERCTRL_BASE+0x00D5)
#define VIF_CLKCONFIG_EXIT7         (USERCTRL_BASE+0x00D6)
#define VIF_CLKCONFIG_EXIT8         (USERCTRL_BASE+0x00D7)
#define VIF_CLKCONFIG_EXIT9         (USERCTRL_BASE+0x00D8)
#define VIF_CLKCONFIG_EXIT10        (USERCTRL_BASE+0x00D9)
#define VIF_CLKCONFIG_EXIT11        (USERCTRL_BASE+0x00DA)
#define VIF_CLKCONFIG_EXIT12        (USERCTRL_BASE+0x00DB)
#define PICT_OUT_INFO_NOW           (USERCTRL_BASE+0x00DC)
#define PICT_OUT_INFO_PRE           (USERCTRL_BASE+0x00DD)
#define YUVCONFIG                   (USERCTRL_BASE+0x00DE)
#define YUVCONFIG_TN                (USERCTRL_BASE+0x00E0)
#define JPEGMAXMODE                 (USERCTRL_BASE+0x00E3)
#define JPEGMAXMODE_FIX             (USERCTRL_BASE+0x00E4)
#define SIZE_HOLD_EN                (USERCTRL_BASE+0x00E5)
#define SIZE_HOLD_EN_FIX            (USERCTRL_BASE+0x00E6)
#define SIZE_HOLD_HOUT              (USERCTRL_BASE+0x00E8)
#define SIZE_HOLD_HOUT_FIX          (USERCTRL_BASE+0x00EA)
#define SIZE_HOLD_VOUT              (USERCTRL_BASE+0x00EC)
#define SIZE_HOLD_VOUT_FIX          (USERCTRL_BASE+0x00EE)
#define JPG_CODE                    (USERCTRL_BASE+0x00F0)
#define JPGBUF_LINEFIX_F            (USERCTRL_BASE+0x00F1)
#define VIF_PDDT                    (USERCTRL_BASE+0x00F2)
#define JPG_DRI                     (USERCTRL_BASE+0x00F4)
#define JPG_QLTY                    (USERCTRL_BASE+0x00F6)
#define INT_QLTY0                   (USERCTRL_BASE+0x00F7)
#define INT_QLTY1                   (USERCTRL_BASE+0x00F8)
#define INT_QLTY2                   (USERCTRL_BASE+0x00F9)
#define UPPER_SIZE_LIMIT0           (USERCTRL_BASE+0x00FC)
#define UPPER_SIZE_LIMIT1           (USERCTRL_BASE+0x00FE)
#define UPPER_SIZE_LIMIT2           (USERCTRL_BASE+0x0100)
#define SCENE_SELECT                (USERCTRL_BASE+0x0280)
#define LOWER_SIZE_LIMIT0           (USERCTRL_BASE+0x0102)
#define LOWER_SIZE_LIMIT1           (USERCTRL_BASE+0x0104)
#define LOWER_SIZE_LIMIT2           (USERCTRL_BASE+0x0106)
#define MIN_QLTY0                   (USERCTRL_BASE+0x0108)
#define MIN_QLTY1                   (USERCTRL_BASE+0x0109)
#define MIN_QLTY2                   (USERCTRL_BASE+0x010A)
#define PRED_SIZE_COEF              (USERCTRL_BASE+0x010C)
#define PRED_UPPER_SIZE_LIMIT0      (USERCTRL_BASE+0x010E)
#define PRED_UPPER_SIZE_LIMIT1      (USERCTRL_BASE+0x0110)
#define PRED_UPPER_SIZE_LIMIT2      (USERCTRL_BASE+0x0112)
#define PRED_LOWER_SIZE_LIMIT0      (USERCTRL_BASE+0x0114)
#define PRED_LOWER_SIZE_LIMIT1      (USERCTRL_BASE+0x0116)
#define PRED_LOWER_SIZE_LIMIT2      (USERCTRL_BASE+0x0118)
#define JPEG_PRED_MODE              (USERCTRL_BASE+0x011A)
#define JPEG_PRED_STS               (USERCTRL_BASE+0x011B)
#define JPEG_PRED_RESTART           (USERCTRL_BASE+0x011C)
#define JPEG_PRED_ERRLEVEL_COUNT    (USERCTRL_BASE+0x011D)
#define JPEG_PRED_ERRLEVEL_ABS_DIFF (USERCTRL_BASE+0x011E)
#define JPEG_PRED_SEL               (USERCTRL_BASE+0x011F)
#define JPEG_PRED_MAX               (USERCTRL_BASE+0x0120)
#define JPEG_PRED_SIZELIMIT         (USERCTRL_BASE+0x0122)
#define JPG_STS                     (USERCTRL_BASE+0x0126)
#define JPG_HSMODE                  (USERCTRL_BASE+0x0127)
#define HS_JPG_STS                  (USERCTRL_BASE+0x0128)
#define HS_JPG_QLTY_VAL             (USERCTRL_BASE+0x0129)
#define HS_JPG_DATA                 (USERCTRL_BASE+0x012C)
#define HS_SHT_TIME_L               (USERCTRL_BASE+0x0130)
#define HS_SHT_TIME_H               (USERCTRL_BASE+0x0132)
#define HS_ISOSENS                  (USERCTRL_BASE+0x0134)
#define VIF_ILMODESEL               (USERCTRL_BASE+0x0136)
#define VIFADRDUMP_MODE             (USERCTRL_BASE+0x0137)
#define VIFADRDUMP_CODE             (USERCTRL_BASE+0x0138)
#define ILCODELEN                   (USERCTRL_BASE+0x013A)
#define VIFIL                       (USERCTRL_BASE+0x013C)
#define VIFMDATAID                  (USERCTRL_BASE+0x013E)
#define VIFMDATAIDIL                (USERCTRL_BASE+0x013F)
#define VIFMCTRL1                   (USERCTRL_BASE+0x0140)
#define VIFMFRMCLR                  (USERCTRL_BASE+0x0141)
#define VIFMFRMMAX1                 (USERCTRL_BASE+0x0142)
#define VIFFRMMAX2                  (USERCTRL_BASE+0x0143)
#define VIFMIPICORERG01             (USERCTRL_BASE+0x0144)
#define RAW_SYSTEM                  (USERCTRL_BASE+0x0145)
#define RAW_SENS_HOLD_F             (USERCTRL_BASE+0x0146)
#define RAW_SHT_LINE                (USERCTRL_BASE+0x0148)
#define RAW_AGC_STEP                (USERCTRL_BASE+0x014A)
#define RAW_GAIN_R                  (USERCTRL_BASE+0x014C)
#define RAW_GAIN_GR                 (USERCTRL_BASE+0x014E)
#define RAW_GAIN_GB                 (USERCTRL_BASE+0x0150)
#define RAW_GAIN_B                  (USERCTRL_BASE+0x0152)
#define RAW_HBLL_OFFSET             (USERCTRL_BASE+0x0154)
#define RAW_HBLR_OFFSET             (USERCTRL_BASE+0x0155)
#define RAW_SENS_DELAY_1_1          (USERCTRL_BASE+0x0156)
#define RAW_SENS_DELAY_1_2          (USERCTRL_BASE+0x0158)
#define RAW_SENS_DELAY_1_4          (USERCTRL_BASE+0x015A)
#define RAW_SENS_DELAY_1_8          (USERCTRL_BASE+0x015C)
#define RAW_SENS_DELAY_HD_1_1       (USERCTRL_BASE+0x015E)
#define RAW_SENS_DELAY_HD_1_2       (USERCTRL_BASE+0x0160)
#define EVSEL                       (USERCTRL_BASE+0x0180)
#define CAP_HALF_AE_CTRL            (USERCTRL_BASE+0x0181)
#define CAP_SHT                     (USERCTRL_BASE+0x0182)
#define CAP_AGC                     (USERCTRL_BASE+0x0184)
#define CAP_GAINOFFSET              (USERCTRL_BASE+0x0186)
#define VADJ_SENS_1_1               (USERCTRL_BASE+0x018C)
#define VADJ_SENS_1_2               (USERCTRL_BASE+0x018E)
#define VADJ_SENS_1_4               (USERCTRL_BASE+0x0190)
#define VADJ_SENS_1_8               (USERCTRL_BASE+0x0192)
#define VADJ_SENS_HD_1_1            (USERCTRL_BASE+0x0194)
#define VADJ_SENS_HD_1_2            (USERCTRL_BASE+0x0196)
#define ISOSENS_OUT                 (USERCTRL_BASE+0x019A)
#define SHT_TIME_OUT_L              (USERCTRL_BASE+0x019C)
#define SHT_TIME_OUT_H              (USERCTRL_BASE+0x019E)
#define SHT_TIME_AUTO_L             (USERCTRL_BASE+0x01A0)
#define SHT_TIME_AUTO_H             (USERCTRL_BASE+0x01A2)
#define USER_GAIN_LEVEL_AUTO        (USERCTRL_BASE+0x01A4)
#define USER_GAIN_LEVEL_NOW         (USERCTRL_BASE+0x01A5)
#define ERRLEVEL_AUTO               (USERCTRL_BASE+0x01A8)
#define ERRLEVEL_NOW                (USERCTRL_BASE+0x01A9)
#define CAP_AWB_CTRL                (USERCTRL_BASE+0x01AF)
#define HALF_MOVE_STS               (USERCTRL_BASE+0x01B0)
#define RATIO_R_AUTO                (USERCTRL_BASE+0x01B2)
#define RATIO_B_AUTO                (USERCTRL_BASE+0x01B4)
#define RATIO_R_NOW                 (USERCTRL_BASE+0x01B6)
#define RATIO_B_NOW                 (USERCTRL_BASE+0x01B8)
#define AWB_STS_AUTO                (USERCTRL_BASE+0x01BA)
#define AWB_STS_NOW                 (USERCTRL_BASE+0x01BB)
#define SHD_EN                      (USERCTRL_BASE+0x01BC)
#define SHD_CAP_R2_WAIGHT           (USERCTRL_BASE+0x01BE)
#define SHD_CAP_GAIN_WAIGHT         (USERCTRL_BASE+0x01C0)
#define SHD_CAP_RB_WAIGHT           (USERCTRL_BASE+0x01C2)
#define FMODE                       (USERCTRL_BASE+0x01C5)
#define UIBRIGHTNESS                (USERCTRL_BASE+0x01C6)
#define UICONTRAST                  (USERCTRL_BASE+0x01C7)
#define ERRSCL_AUTO                 (USERCTRL_BASE+0x01CA)
#define ERRSCL_NOW                  (USERCTRL_BASE+0x01CC)
#define USER_AESCL_AUTO             (USERCTRL_BASE+0x01CE)
#define USER_AESCL_NOW              (USERCTRL_BASE+0x01D0)
#define SCENE_SELECT_FIX            (USERCTRL_BASE+0x0281)
#define AWB_SN1                     (USERCTRL_BASE+0x0282)
#define AWB_SN2                     (USERCTRL_BASE+0x0283)
#define AWB_SN3                     (USERCTRL_BASE+0x0284)
#define AWB_SN4                     (USERCTRL_BASE+0x0285)
#define AWB_SN5                     (USERCTRL_BASE+0x0286)
#define AWB_SN6                     (USERCTRL_BASE+0x0287)
#define AWB_SN7                     (USERCTRL_BASE+0x0288)
#define AWB_SN8                     (USERCTRL_BASE+0x0289)
#define AWB_SN9                     (USERCTRL_BASE+0x028A)
#define AWB_SN10                    (USERCTRL_BASE+0x028B)
#define AWB_SN11                    (USERCTRL_BASE+0x028C)
#define HALF_AWB_CTRL               (USERCTRL_BASE+0x01AE)
#define AWB_SN12                    (USERCTRL_BASE+0x028D)
#define AF_SN1_2                    (USERCTRL_BASE+0x028E)
#define AF_SN3_4                    (USERCTRL_BASE+0x028F)
#define AF_SN5_6                    (USERCTRL_BASE+0x0290)
#define AF_SN7_8                    (USERCTRL_BASE+0x0291)
#define AF_SN9_10                   (USERCTRL_BASE+0x0292)
#define AF_SN11_12                  (USERCTRL_BASE+0x0293)
#define AE_SN1                      (USERCTRL_BASE+0x0294)
#define AE_SN2                      (USERCTRL_BASE+0x0295)
#define AE_SN3                      (USERCTRL_BASE+0x0296)
#define AE_SN4                      (USERCTRL_BASE+0x0297)
#define AE_SN5                      (USERCTRL_BASE+0x0298)
#define AE_SN6                      (USERCTRL_BASE+0x0299)
#define AE_SN7                      (USERCTRL_BASE+0x029A)
#define AE_SN8                      (USERCTRL_BASE+0x029B)
#define AE_SN9                      (USERCTRL_BASE+0x029C)
#define AE_SN10                     (USERCTRL_BASE+0x029D)
#define AE_SN11                     (USERCTRL_BASE+0x029E)
#define AE_SN12                     (USERCTRL_BASE+0x029F)
#define SHT_PREMODE_TYPE1           (USERCTRL_BASE+0x02A0)
#define SHT_PREMODE_TYPE2           (USERCTRL_BASE+0x02A2)
#define SHT_PREMODE_TYPE3           (USERCTRL_BASE+0x02A4)
#define SHT_PREMODE_TYPE4           (USERCTRL_BASE+0x02A6)
#define ISO_TYPE1                   (USERCTRL_BASE+0x02A8)
#define ISO_TYPE2                   (USERCTRL_BASE+0x02A9)
#define ISO_TYPE3                   (USERCTRL_BASE+0x02AA)
#define ISO_TYPE4                   (USERCTRL_BASE+0x02AB)
#define AE_SUB_SN1                  (USERCTRL_BASE+0x02AC)
#define AE_SUB_SN2                  (USERCTRL_BASE+0x02AD)
#define AE_SUB_SN3                  (USERCTRL_BASE+0x02AE)
#define AE_SUB_SN4                  (USERCTRL_BASE+0x02AF)
#define AE_SUB_SN5                  (USERCTRL_BASE+0x02B0)
#define AE_SUB_SN6                  (USERCTRL_BASE+0x02B1)
#define AE_SUB_SN7                  (USERCTRL_BASE+0x02B2)
#define AE_SUB_SN8                  (USERCTRL_BASE+0x02B3)
#define AE_SUB_SN9                  (USERCTRL_BASE+0x02B4)
#define AE_SUB_SN10                 (USERCTRL_BASE+0x02B5)
#define AE_SUB_SN11                 (USERCTRL_BASE+0x02B6)
#define AE_SUB_SN12                 (USERCTRL_BASE+0x02B7)
#define AE_OPD_WIDTH_TYPE1          (USERCTRL_BASE+0x02B8)
#define AE_OPD_HEIGHT_TYPE1         (USERCTRL_BASE+0x02BA)
#define AE_OPD_WIDTH_TYPE2          (USERCTRL_BASE+0x02BC)
#define AE_OPD_HEIGHT_TYPE2         (USERCTRL_BASE+0x02BE)
#define AE_OPD_WIDTH_TYPE3          (USERCTRL_BASE+0x02C0)
#define AE_OPD_HEIGHT_TYPE3         (USERCTRL_BASE+0x02C2)
#define AE_OPD_WIDTH_TYPE4          (USERCTRL_BASE+0x02C4)
#define AE_OPD_HEIGHT_TYPE4         (USERCTRL_BASE+0x02C6)
#define FRM_FIX_SN1_2               (USERCTRL_BASE+0x02C8)
#define FRM_FIX_SN3_4               (USERCTRL_BASE+0x02C9)
#define FRM_FIX_SN5_6               (USERCTRL_BASE+0x02CA)
#define FRM_FIX_SN7_8               (USERCTRL_BASE+0x02CB)
#define FRM_FIX_SN9_10              (USERCTRL_BASE+0x02CC)
#define FRM_FIX_SN11_12             (USERCTRL_BASE+0x02CD)
#define FRMFIX_AGCLIMIT_SN1         (USERCTRL_BASE+0x02CF)
#define FRMFIX_AGCLIMIT_SN2         (USERCTRL_BASE+0x02D0)
#define FRMFIX_AGCLIMIT_SN3         (USERCTRL_BASE+0x02D1)
#define FRMFIX_AGCLIMIT_SN4         (USERCTRL_BASE+0x02D2)
#define FRMFIX_AGCLIMIT_SN5         (USERCTRL_BASE+0x02D3)
#define FRMFIX_AGCLIMIT_SN6         (USERCTRL_BASE+0x02D4)
#define FRMFIX_AGCLIMIT_SN7         (USERCTRL_BASE+0x02D5)
#define FRMFIX_AGCLIMIT_SN8         (USERCTRL_BASE+0x02D6)
#define FRMFIX_AGCLIMIT_SN9         (USERCTRL_BASE+0x02D7)
#define FRMFIX_AGCLIMIT_SN10        (USERCTRL_BASE+0x02D8)
#define FRMFIX_AGCLIMIT_SN11        (USERCTRL_BASE+0x02D9)
#define FRMFIX_AGCLIMIT_SN12        (USERCTRL_BASE+0x02DA)
#define VADD_SHTGAIN_CTRL_SN1_2     (USERCTRL_BASE+0x02DB)
#define VADD_SHTGAIN_CTRL_SN3_4     (USERCTRL_BASE+0x02DC)
#define VADD_SHTGAIN_CTRL_SN5_6     (USERCTRL_BASE+0x02DD)
#define VADD_SHTGAIN_CTRL_SN7_8     (USERCTRL_BASE+0x02DE)
#define VADD_SHTGAIN_CTRL_SN9_10    (USERCTRL_BASE+0x02DF)
#define VADD_SHTGAIN_CTRL_SN11_12   (USERCTRL_BASE+0x02E0)
#define HADD_SHTGAIN_CTRL_SN1_2     (USERCTRL_BASE+0x02E1)
#define HADD_SHTGAIN_CTRL_SN3_4     (USERCTRL_BASE+0x02E2)
#define HADD_SHTGAIN_CTRL_SN5_6     (USERCTRL_BASE+0x02E3)
#define HADD_SHTGAIN_CTRL_SN7_8     (USERCTRL_BASE+0x02E4)
#define HADD_SHTGAIN_CTRL_SN9_10    (USERCTRL_BASE+0x02E5)
#define HADD_SHTGAIN_CTRL_SN11_12   (USERCTRL_BASE+0x02E6)
#define EVREF_CTRL_SEL              (USERCTRL_BASE+0x02E8)
#define EVREF_MONI_SN1_2            (USERCTRL_BASE+0x02EA)
#define EVREF_MONI_SN3_4            (USERCTRL_BASE+0x02EB)
#define EVREF_MONI_SN5_6            (USERCTRL_BASE+0x02EC)
#define EVREF_MONI_SN7_8            (USERCTRL_BASE+0x02ED)
#define EVREF_MONI_SN9_10           (USERCTRL_BASE+0x02EE)
#define EVREF_MONI_SN11_12          (USERCTRL_BASE+0x02EF)
#define EVREF_CAP_SN1_2             (USERCTRL_BASE+0x02F0)
#define EVREF_CAP_SN3_4             (USERCTRL_BASE+0x02F1)
#define EVREF_CAP_SN5_6             (USERCTRL_BASE+0x02F2)
#define EVREF_CAP_SN7_8             (USERCTRL_BASE+0x02F3)
#define EVREF_CAP_SN9_10            (USERCTRL_BASE+0x02F4)
#define EVREF_CAP_SN11_12           (USERCTRL_BASE+0x02F5)
#define EVREF_MOVIE_SN1_2           (USERCTRL_BASE+0x02F6)
#define EVREF_MOVIE_SN3_4           (USERCTRL_BASE+0x02F7)
#define EVREF_MOVIE_SN5_6           (USERCTRL_BASE+0x02F8)
#define EVREF_MOVIE_SN7_8           (USERCTRL_BASE+0x02F9)
#define EVREF_MOVIE_SN9_10          (USERCTRL_BASE+0x02FA)
#define EVREF_MOVIE_SN11_12         (USERCTRL_BASE+0x02FB)
#define EVREF_TYPE1                 (USERCTRL_BASE+0x02FC)
#define EVREF_TYPE2                 (USERCTRL_BASE+0x02FE)
#define EVREF_TYPE3                 (USERCTRL_BASE+0x0300)
#define EVREF_TYPE4                 (USERCTRL_BASE+0x0302)
#define EVREF_TYPE5                 (USERCTRL_BASE+0x0304)
#define EVREF_TYPE6                 (USERCTRL_BASE+0x0306)
#define AELINE_MONI_SN1_2           (USERCTRL_BASE+0x0308)
#define AELINE_MONI_SN3_4           (USERCTRL_BASE+0x0309)
#define AELINE_MONI_SN5_6           (USERCTRL_BASE+0x030A)
#define AELINE_MONI_SN7_8           (USERCTRL_BASE+0x030B)
#define AELINE_MONI_SN9_10          (USERCTRL_BASE+0x030C)
#define AELINE_MONI_SN11_12         (USERCTRL_BASE+0x030D)
#define AELINE_HALF_SN1_2           (USERCTRL_BASE+0x030E)
#define AELINE_HALF_SN3_4           (USERCTRL_BASE+0x030F)
#define AELINE_HALF_SN5_6           (USERCTRL_BASE+0x0310)
#define AELINE_HALF_SN7_8           (USERCTRL_BASE+0x0311)
#define AELINE_HALF_SN9_10          (USERCTRL_BASE+0x0312)
#define AELINE_HALF_SN11_12         (USERCTRL_BASE+0x0313)
#define AELINE_HALF_AFEND_SN1_2     (USERCTRL_BASE+0x0314)
#define AELINE_HALF_AFEND_SN3_4     (USERCTRL_BASE+0x0315)
#define AELINE_HALF_AFEND_SN5_6     (USERCTRL_BASE+0x0316)
#define AELINE_HALF_AFEND_SN7_8     (USERCTRL_BASE+0x0317)
#define AELINE_HALF_AFEND_SN9_10    (USERCTRL_BASE+0x0318)
#define AELINE_HALF_AFEND_SN11_12   (USERCTRL_BASE+0x0319)
#define AELINE_CAP_SN1_2            (USERCTRL_BASE+0x031A)
#define AELINE_CAP_SN3_4            (USERCTRL_BASE+0x031B)
#define AELINE_CAP_SN5_6            (USERCTRL_BASE+0x031C)
#define AELINE_CAP_SN7_8            (USERCTRL_BASE+0x031D)
#define AELINE_CAP_SN9_10           (USERCTRL_BASE+0x031E)
#define AELINE_CAP_SN11_12          (USERCTRL_BASE+0x031F)
#define AELINE_MOVIE_SN1_2          (USERCTRL_BASE+0x0320)
#define AELINE_MOVIE_SN3_4          (USERCTRL_BASE+0x0321)
#define AELINE_MOVIE_SN5_6          (USERCTRL_BASE+0x0322)
#define AELINE_MOVIE_SN7_8          (USERCTRL_BASE+0x0323)
#define AELINE_MOVIE_SN9_10         (USERCTRL_BASE+0x0324)
#define AELINE_MOVIE_SN11_12        (USERCTRL_BASE+0x0325)
#define SHCTRL_TIME1_TYPE1          (USERCTRL_BASE+0x0326)
#define AGCAIN1_TYPE1               (USERCTRL_BASE+0x0327)
#define SHCTRL_TIME2_TYPE1          (USERCTRL_BASE+0x0328)
#define AGCAIN2_TYPE1               (USERCTRL_BASE+0x0329)
#define SHCTRL_TIME3_TYPE1          (USERCTRL_BASE+0x032A)
#define AGCAIN3_TYPE1               (USERCTRL_BASE+0x032B)
#define SHCTRL_TIME1_TYPE2          (USERCTRL_BASE+0x032C)
#define AGCAIN1_TYPE2               (USERCTRL_BASE+0x032D)
#define SHCTRL_TIME2_TYPE2          (USERCTRL_BASE+0x032E)
#define AGCAIN2_TYPE2               (USERCTRL_BASE+0x032F)
#define SHCTRL_TIME3_TYPE2          (USERCTRL_BASE+0x0330)
#define AGCAIN3_TYPE2               (USERCTRL_BASE+0x0331)
#define SHCTRL_TIME1_TYPE3          (USERCTRL_BASE+0x0332)
#define AGCAIN1_TYPE3               (USERCTRL_BASE+0x0333)
#define SHCTRL_TIME2_TYPE3          (USERCTRL_BASE+0x0334)
#define AGCAIN2_TYPE3               (USERCTRL_BASE+0x0335)
#define SHCTRL_TIME3_TYPE3          (USERCTRL_BASE+0x0336)
#define AGCAIN3_TYPE3               (USERCTRL_BASE+0x0337)
#define SHCTRL_TIME1_TYPE4          (USERCTRL_BASE+0x0338)
#define AGCAIN1_TYPE4               (USERCTRL_BASE+0x0339)
#define SHCTRL_TIME2_TYPE4          (USERCTRL_BASE+0x033A)
#define AGCAIN2_TYPE4               (USERCTRL_BASE+0x033B)
#define SHCTRL_TIME3_TYPE4          (USERCTRL_BASE+0x033C)
#define AGCAIN3_TYPE4               (USERCTRL_BASE+0x033D)
#define SHCTRL_TIME1_TYPE5          (USERCTRL_BASE+0x033E)
#define AGCAIN1_TYPE5               (USERCTRL_BASE+0x033F)
#define SHCTRL_TIME2_TYPE5          (USERCTRL_BASE+0x0340)
#define AGCAIN2_TYPE5               (USERCTRL_BASE+0x0341)
#define SHCTRL_TIME3_TYPE5          (USERCTRL_BASE+0x0342)
#define AGCAIN3_TYPE5               (USERCTRL_BASE+0x0343)
#define SHCTRL_TIME1_TYPE6          (USERCTRL_BASE+0x0344)
#define AGCAIN1_TYPE6               (USERCTRL_BASE+0x0345)
#define SHCTRL_TIME2_TYPE6          (USERCTRL_BASE+0x0346)
#define AGCAIN2_TYPE6               (USERCTRL_BASE+0x0347)
#define SHCTRL_TIME3_TYPE6          (USERCTRL_BASE+0x0348)
#define AGCAIN3_TYPE6               (USERCTRL_BASE+0x0349)
#define SHCTRL_TIME1_TYPE7          (USERCTRL_BASE+0x034A)
#define AGCAIN1_TYPE7               (USERCTRL_BASE+0x034B)
#define SHCTRL_TIME2_TYPE7          (USERCTRL_BASE+0x034C)
#define AGCAIN2_TYPE7               (USERCTRL_BASE+0x034D)
#define SHCTRL_TIME3_TYPE7          (USERCTRL_BASE+0x034E)
#define AGCAIN3_TYPE7               (USERCTRL_BASE+0x034F)
#define SHCTRL_TIME1_TYPE8          (USERCTRL_BASE+0x0350)
#define AGCAIN1_TYPE8               (USERCTRL_BASE+0x0351)
#define SHCTRL_TIME2_TYPE8          (USERCTRL_BASE+0x0352)
#define AGCAIN2_TYPE8               (USERCTRL_BASE+0x0353)
#define SHCTRL_TIME3_TYPE8          (USERCTRL_BASE+0x0354)
#define AGCAIN3_TYPE8               (USERCTRL_BASE+0x0355)
#define SHCTRL_TIME1_TYPE9          (USERCTRL_BASE+0x0356)
#define AGCAIN1_TYPE9               (USERCTRL_BASE+0x0357)
#define SHCTRL_TIME2_TYPE9          (USERCTRL_BASE+0x0358)
#define AGCAIN2_TYPE9               (USERCTRL_BASE+0x0359)
#define SHCTRL_TIME3_TYPE9          (USERCTRL_BASE+0x035A)
#define AGCAIN3_TYPE9               (USERCTRL_BASE+0x035B)
#define SHCTRL_TIME1_TYPE10         (USERCTRL_BASE+0x035C)
#define AGCAIN1_TYPE10              (USERCTRL_BASE+0x035D)
#define SHCTRL_TIME2_TYPE10         (USERCTRL_BASE+0x035E)
#define AGCAIN2_TYPE10              (USERCTRL_BASE+0x035F)
#define SHCTRL_TIME3_TYPE10         (USERCTRL_BASE+0x0360)
#define AGCAIN3_TYPE10              (USERCTRL_BASE+0x0361)
#define PICT3_GAMMA_MONI0           (USERCTRL_BASE+0x0362)
#define PICT3_GAMMA_MONI1           (USERCTRL_BASE+0x0363)
#define PICT3_GAMMA_MONI2           (USERCTRL_BASE+0x0364)
#define PICT3_GAMMA_CAP0            (USERCTRL_BASE+0x0365)
#define PICT3_GAMMA_CAP1            (USERCTRL_BASE+0x0366)
#define PICT3_GAMMA_CAP2            (USERCTRL_BASE+0x0367)
#define PICT3_GAMMA_MOVIE0          (USERCTRL_BASE+0x0368)
#define PICT3_GAMMA_MOVIE1          (USERCTRL_BASE+0x0369)
#define PICT3_GAMMA_MOVIE2          (USERCTRL_BASE+0x036A)
#define LM_MODE_SN_1                (USERCTRL_BASE+0x036B)
#define LM_MODE_SN_2                (USERCTRL_BASE+0x036C)
#define LM_MODE_SN_3                (USERCTRL_BASE+0x036D)
#define LM_MODE_SN_4                (USERCTRL_BASE+0x036E)
#define LM_MODE_SN_5                (USERCTRL_BASE+0x036F)
#define LM_MODE_SN_6                (USERCTRL_BASE+0x0370)
#define LM_MODE_SN_7                (USERCTRL_BASE+0x0371)
#define LM_MODE_SN_8                (USERCTRL_BASE+0x0372)
#define LM_MODE_SN_9                (USERCTRL_BASE+0x0373)
#define LM_MODE_SN_10               (USERCTRL_BASE+0x0374)
#define LM_MODE_SN_11               (USERCTRL_BASE+0x0375)
#define LM_MODE_SN_12               (USERCTRL_BASE+0x0376)
#define HUEGAIN_MODE_SN_1           (USERCTRL_BASE+0x0377)
#define HUEGAIN_MODE_SN_2           (USERCTRL_BASE+0x0378)
#define HUEGAIN_MODE_SN_3           (USERCTRL_BASE+0x0379)
#define HUEGAIN_MODE_SN_4           (USERCTRL_BASE+0x037A)
#define HUEGAIN_MODE_SN_5           (USERCTRL_BASE+0x037B)
#define HUEGAIN_MODE_SN_6           (USERCTRL_BASE+0x037C)
#define HUEGAIN_MODE_SN_7           (USERCTRL_BASE+0x037D)
#define HUEGAIN_MODE_SN_8           (USERCTRL_BASE+0x037E)
#define HUEGAIN_MODE_SN_9           (USERCTRL_BASE+0x037F)
#define HUEGAIN_MODE_SN_10          (USERCTRL_BASE+0x0380)
#define HUEGAIN_MODE_SN_11          (USERCTRL_BASE+0x0381)
#define HUEGAIN_MODE_SN_12          (USERCTRL_BASE+0x0382)
#define MC3_MODE_SN_1               (USERCTRL_BASE+0x0383)
#define MC3_MODE_SN_2               (USERCTRL_BASE+0x0384)
#define MC3_MODE_SN_3               (USERCTRL_BASE+0x0385)
#define MC3_MODE_SN_4               (USERCTRL_BASE+0x0386)
#define MC3_MODE_SN_5               (USERCTRL_BASE+0x0387)
#define MC3_MODE_SN_6               (USERCTRL_BASE+0x0388)
#define MC3_MODE_SN_7               (USERCTRL_BASE+0x0389)
#define MC3_MODE_SN_8               (USERCTRL_BASE+0x038A)
#define MC3_MODE_SN_9               (USERCTRL_BASE+0x038B)
#define MC3_MODE_SN_10              (USERCTRL_BASE+0x038C)
#define MC3_MODE_SN_11              (USERCTRL_BASE+0x038D)
#define MC3_MODE_SN_12              (USERCTRL_BASE+0x038E)
#define PICT1_SN_1                  (USERCTRL_BASE+0x038F)
#define PICT1_SN_2                  (USERCTRL_BASE+0x0390)
#define PICT1_SN_3                  (USERCTRL_BASE+0x0391)
#define PICT1_SN_4                  (USERCTRL_BASE+0x0392)
#define PICT1_SN_5                  (USERCTRL_BASE+0x0393)
#define PICT1_SN_6                  (USERCTRL_BASE+0x0394)
#define PICT1_SN_7                  (USERCTRL_BASE+0x0395)
#define PICT1_SN_8                  (USERCTRL_BASE+0x0396)
#define PICT1_SN_9                  (USERCTRL_BASE+0x0397)
#define PICT1_SN_10                 (USERCTRL_BASE+0x0398)
#define PICT1_SN_11                 (USERCTRL_BASE+0x0399)
#define PICT1_SN_12                 (USERCTRL_BASE+0x039A)
#define UIHUE_TYPE1                 (USERCTRL_BASE+0x039B)
#define UIHUE_TYPE2                 (USERCTRL_BASE+0x039C)
#define UIHUE_TYPE3                 (USERCTRL_BASE+0x039D)
#define UISATURATION_TYPE1          (USERCTRL_BASE+0x039E)
#define UISATURATION_TYPE2          (USERCTRL_BASE+0x039F)
#define UISATURATION_TYPE3          (USERCTRL_BASE+0x03A0)
#define UISHARPNESS_POS_TYPE1       (USERCTRL_BASE+0x03A1)
#define UISHARPNESS_POS_TYPE2       (USERCTRL_BASE+0x03A2)
#define UISHARPNESS_POS_TYPE3       (USERCTRL_BASE+0x03A3)
#define UISHARPNESS_NEG_TYPE1       (USERCTRL_BASE+0x03A4)
#define UISHARPNESS_NEG_TYPE2       (USERCTRL_BASE+0x03A5)
#define UISHARPNESS_NEG_TYPE3       (USERCTRL_BASE+0x03A6)

/* POST VIF OFFSET */

#define VIFMODE                     (POST_VIF_BASE+0x0000)
#define VIFPOUTEN                   (POST_VIF_BASE+0x0004)
#define VIFRAW                      (POST_VIF_BASE+0x0008)
#define VIFYUV                      (POST_VIF_BASE+0x000C)
#define VIFRGB                      (POST_VIF_BASE+0x0010)
#define VIFJPEG                     (POST_VIF_BASE+0x0014)
#define VIFIL_VBASE                 (POST_VIF_BASE+0x0018)
#define VIFHSET1                    (POST_VIF_BASE+0x001C)
#define VIFHSET2                    (POST_VIF_BASE+0x0020)
#define VIFVSET1                    (POST_VIF_BASE+0x0024)
#define VIFVSET2                    (POST_VIF_BASE+0x0028)
#define VIFDLY                      (POST_VIF_BASE+0x002C)
#define VIFMDCLSET                  (POST_VIF_BASE+0x0030)
#define VIF_REG1                    (POST_VIF_BASE+0x0034)
#define VIF_REG2                    (POST_VIF_BASE+0x0038)
#define VIF_REG3                    (POST_VIF_BASE+0x003C)
#define VIFMIPICORERG0              (POST_VIF_BASE+0x0040)
#define VIFMIPICORERG1              (POST_VIF_BASE+0x0050)
#define VIFMIPICORERG2              (POST_VIF_BASE+0x0060)
#define VIFYUV2                     (POST_VIF_BASE+0x0064)
#define VIFADRDUMP                  (POST_VIF_BASE+0x0068)

/* CPUCONF OFFSET */

#define CPUEXT                      (CPUCONF_BASE+0x0000)
#define MUTECNT                     (CPUCONF_BASE+0x0001)
#define WDT_EN                      (CPUCONF_BASE+0x0002)
#define Z1_SEL1                     (CPUCONF_BASE+0x0003)
#define DM_SW2                      (CPUCONF_BASE+0x0006)
#define ENDIAN_SEL                  (CPUCONF_BASE+0x0008)
#define CPUSLEEP_EN                 (CPUCONF_BASE+0x0009)
#define FAST_MODECHG_EN             (CPUCONF_BASE+0x000A)
#define FAST_SHT_MODE_SEL           (CPUCONF_BASE+0x000B)
#define FAST_SHT_LIMIT_COUNT        (CPUCONF_BASE+0x000C)
#define SYSINT3_VDLY_1_2            (CPUCONF_BASE+0x0010)
#define SENS_REVERSE_CTRL           (CPUCONF_BASE+0x001A)
#define EEP_ADDRESS                 (CPUCONF_BASE+0x001B)
#define PG_SEL                      (CPUCONF_BASE+0x0020)
#define PG_GAIN_SEL                 (CPUCONF_BASE+0x0021)
#define PG_WIDTH_SEL                (CPUCONF_BASE+0x0022)
#define PG_MODE_SEL                 (CPUCONF_BASE+0x0023)
#define PG_LEVEL_SEL                (CPUCONF_BASE+0x0024)
#define PG_DATEN_OFF_SEL            (CPUCONF_BASE+0x0026)

/* CTRL OFFSET */

#define ROM_WAIT                    (CTRL_BASE+0x0000)
#define I2C_M_CTRL                  (CTRL_BASE+0x0001)
#define SENS_SEND_F                 (CTRL_BASE+0x0002)
#define INTMSK_HREL                 (CTRL_BASE+0x0004)
#define INTMSK_OTHER                (CTRL_BASE+0x0006)
#define INTMSK_BUF                  (CTRL_BASE+0x0008)
#define INTMSK_EXT                  (CTRL_BASE+0x000A)
#define WAKEUP_SENS_TRNS            (CTRL_BASE+0x000C)
#define MODE_SEL_SFT                (CTRL_BASE+0x000D)
#define GPIO_SNOOP                  (CTRL_BASE+0x000E)
#define STANDBY_DCK_EN              (CTRL_BASE+0x000F)

/* SENSMIPI OFFSET */

#define RGLANESEL                   (SENSMIPI_BASE+0x0001)
#define RGTLPX                      (SENSMIPI_BASE+0x0004)
#define RGTCLKPREPARE               (SENSMIPI_BASE+0x0005)
#define RGTCLKZERO                  (SENSMIPI_BASE+0x0006)
#define RGTCLKPRE                   (SENSMIPI_BASE+0x0007)
#define RGTCLKPOST                  (SENSMIPI_BASE+0x0008)
#define RGTCLKTRAIL                 (SENSMIPI_BASE+0x0009)
#define RGTHSEXIT                   (SENSMIPI_BASE+0x000A)
#define RGTHSPREPARE                (SENSMIPI_BASE+0x000B)
#define RGTHSZERO                   (SENSMIPI_BASE+0x000C)
#define RGTHSTRAIL                  (SENSMIPI_BASE+0x000D)
#define RGTLPXESC                   (SENSMIPI_BASE+0x000E)

/* AE OFFSET */

#define AE_INIT_MASK_CNT            (AE_BASE+0x002B)
#define AESPEED_INIT                (AE_BASE+0x0031)
#define AESPEED_FAST                (AE_BASE+0x0032)
#define FASTMOVE_TIMEOUT            (AE_BASE+0x003D)

/* AWB OFFSET */

#define ATW_INITMASK                (AWB_BASE+0x0004)
#define INIT_GAINS                  (AWB_BASE+0x0023)
#define INIT_SFTLMT                 (AWB_BASE+0x002C)

/* AF OFFSET */

#define AF_SYSTEM                   (AF_BASE+0x0005)
#define AF_OPDDATA_SAVE             (AF_BASE+0x001B)
#define CAP_AF_CANCEL_F             (AF_BASE+0x0075)

/* ADJ OFFSET */

#define NORMR                       (ADJ_BASE+0x0004)
#define NORMB                       (ADJ_BASE+0x0006)
#define AWBPRER                     (ADJ_BASE+0x0008)
#define AWBPREB                     (ADJ_BASE+0x000A)
#define SHD_NORMR_OFFSET_R2         (ADJ_BASE+0X0026)
#define SHD_PRER_OFFSET_R2          (ADJ_BASE+0X0028)
#define SHD_NORMR_OFFSET_RB         (ADJ_BASE+0X002A)
#define SHD_PRER_OFFSET_RB          (ADJ_BASE+0X002C)
#define SHD_NORMB_OFFSET_RB         (ADJ_BASE+0X002E)
#define SHD_PREB_OFFSET_RB          (ADJ_BASE+0X0030)

/* MODE OFFSET */

#define RO_MASK_NUM                 (MODE_BASE+0x0001)
#define VIF_CLKCONFIG13             (MODE_BASE+0x0012)
#define VIF_CLKCONFIG14             (MODE_BASE+0x0013)
#define VIF_CLKCONFIG15             (MODE_BASE+0x0014)
#define VIF_CLKCONFIG16             (MODE_BASE+0x0015)
#define FLC_OPD_HEIGHT_NORMAL_1_1   (MODE_BASE+0x0016)
#define FLC_OPD_HEIGHT_NORMAL_1_2   (MODE_BASE+0x0018)
#define FLC_OPD_HEIGHT_NORMAL_1_4   (MODE_BASE+0x001A)
#define FLC_OPD_HEIGHT_NORMAL_1_8   (MODE_BASE+0x001C)
#define FLC_OPD_HEIGHT_HD_1_1       (MODE_BASE+0x001E)
#define FLC_OPD_HEIGHT_HD_1_2       (MODE_BASE+0x0020)

#define AF_OPD0_HDELAY              (MODE_BASE+0x0030)
#define AF_OPD0_VDELAY              (MODE_BASE+0x0032)
#define AF_OPD0_HVALID              (MODE_BASE+0x0034)
#define AF_OPD0_VVALID              (MODE_BASE+0x0036)
#define AF_OPD1_HDELAY              (MODE_BASE+0x0038)
#define AF_OPD1_VDELAY              (MODE_BASE+0x003A)
#define AF_OPD1_HVALID              (MODE_BASE+0x003C)
#define AF_OPD1_VVALID              (MODE_BASE+0x003E)
#define AF_OPD2_HDELAY              (MODE_BASE+0x0040)
#define AF_OPD2_VDELAY              (MODE_BASE+0x0042)
#define AF_OPD2_HVALID              (MODE_BASE+0x0044)
#define AF_OPD2_VVALID              (MODE_BASE+0x0046)
#define AF_OPD3_HDELAY              (MODE_BASE+0x0048)
#define AF_OPD3_VDELAY              (MODE_BASE+0x004A)
#define AF_OPD3_HVALID              (MODE_BASE+0x004C)
#define AF_OPD3_VVALID              (MODE_BASE+0x004E)
#define AF_OPD4_HDELAY              (MODE_BASE+0x0050)
#define AF_OPD4_VDELAY              (MODE_BASE+0x0052)
#define AF_OPD4_HVALID              (MODE_BASE+0x0054)
#define AF_OPD4_VVALID              (MODE_BASE+0x0056)
#define AF_OPD5_HDELAY              (MODE_BASE+0x0058)
#define AF_OPD5_VDELAY              (MODE_BASE+0x005A)
#define AF_OPD5_HVALID              (MODE_BASE+0x005C)
#define AF_OPD5_VVALID              (MODE_BASE+0x005E)
#define AF_OPD6_HDELAY              (MODE_BASE+0x0060)
#define AF_OPD6_VDELAY              (MODE_BASE+0x0062)
#define AF_OPD6_HVALID              (MODE_BASE+0x0064)
#define AF_OPD6_VVALID              (MODE_BASE+0x0066)
#define AF_OPD7_HDELAY              (MODE_BASE+0x0068)
#define AF_OPD7_VDELAY              (MODE_BASE+0x006A)
#define AF_OPD7_HVALID              (MODE_BASE+0x006C)
#define AF_OPD7_VVALID              (MODE_BASE+0x006E)
#define AF_OPD8_HDELAY              (MODE_BASE+0x0070)
#define AF_OPD8_VDELAY              (MODE_BASE+0x0072)
#define AF_OPD8_HVALID              (MODE_BASE+0x0074)
#define AF_OPD8_VVALID              (MODE_BASE+0x0076)
#define AF_OPD9_HDELAY              (MODE_BASE+0x0078)
#define AF_OPD9_VDELAY              (MODE_BASE+0x007A)
#define AF_OPD9_HVALID              (MODE_BASE+0x007C)
#define AF_OPD9_VVALID              (MODE_BASE+0x007E)

#define VIF_REC601_Y                (MODE_BASE+0x008C)
#define VIF_REC601_C                (MODE_BASE+0x008E)

/* PICT OFFSET */

#define SHD_INP_TH_HB_H_R2          (PICT_BASE+0x0032)
#define SHD_INP_TH_HB_L_R2          (PICT_BASE+0x0034)
#define SHD_INP_TH_LB_H_R2          (PICT_BASE+0x0036)
#define SHD_INP_TH_LB_L_R2          (PICT_BASE+0x0038)
#define SHD_INP_TH_HB_H_RB          (PICT_BASE+0x003C)
#define SHD_INP_TH_HB_L_RB          (PICT_BASE+0x003E)
#define SHD_INP_TH_LB_H_RB          (PICT_BASE+0x0040)
#define SHD_INP_TH_LB_L_RB          (PICT_BASE+0x0042)
#define YGAMMA_MODE                 (PICT_BASE+0x0093)

/* GAMMA OFFSET */

#define G0_LOWGM_ON_R               (GAMMA_BASE+0x003A)
#define G0_0CLIP_R                  (GAMMA_BASE+0x003C)
#define G0_LOWGM_ON_G               (GAMMA_BASE+0x003E)
#define G0_0CLIP_G                  (GAMMA_BASE+0x0040)
#define G0_LOWGM_ON_B               (GAMMA_BASE+0x0042)
#define G0_0CLIP_B                  (GAMMA_BASE+0x0044)
#define G0_KNOT_GAINCTRL_TH_L       (GAMMA_BASE+0x0046)
#define G0_KNOT_GAINCTRL_TH_H       (GAMMA_BASE+0x0047)

/* JPEG OFFSET */

#define JPG_CTL                     (JPEG_BASE+0x0000)
#define JPG_FMT                     (JPEG_BASE+0x0002)
#define JPG_FIL                     (JPEG_BASE+0x0003)
#define JPG_FMT2                    (JPEG_BASE+0x0004)
#define JPG_CONV_CTRL               (JPEG_BASE+0x0005)
#define JPG_DATA                    (JPEG_BASE+0x000C)
#define QLTY_LIMIT                  (JPEG_BASE+0x0010)
#define JPG_CLK_SEL                 (JPEG_BASE+0x0011)
#define JPG_PRED_COUNT              (JPEG_BASE+0x0012)

/* AUTOCOM OFFSET */

#define MIPIOUT_EN                  (AUTOCOM_BASE+0x0031)

/* VFRMPARA OFFSET */

#define VPARA_TRG                   (VFRMPARA_BASE+0x0000)
#define VPARA1_ADRS0L               (VFRMPARA_BASE+0x0001)
#define VPARA1_ADRS0H               (VFRMPARA_BASE+0x0002)
#define VPARA1_DATA0                (VFRMPARA_BASE+0x0003)
#define VPARA1_ADRS1L               (VFRMPARA_BASE+0x0004)
#define VPARA1_ADRS1H               (VFRMPARA_BASE+0x0005)
#define VPARA1_DATA1                (VFRMPARA_BASE+0x0006)
#define VPARA1_ADRS2L               (VFRMPARA_BASE+0x0007)
#define VPARA1_ADRS2H               (VFRMPARA_BASE+0x0008)
#define VPARA1_DATA2                (VFRMPARA_BASE+0x0009)
#define VPARA1_ADRS3L               (VFRMPARA_BASE+0x000A)
#define VPARA1_ADRS3H               (VFRMPARA_BASE+0x000B)
#define VPARA1_DATA3                (VFRMPARA_BASE+0x000C)
#define VPARA1_ADRS4L               (VFRMPARA_BASE+0x000D)
#define VPARA1_ADRS4H               (VFRMPARA_BASE+0x000E)
#define VPARA1_DATA4                (VFRMPARA_BASE+0x000F)
#define VPARA1_ADRS5L               (VFRMPARA_BASE+0x0010)
#define VPARA1_ADRS5H               (VFRMPARA_BASE+0x0011)
#define VPARA1_DATA5                (VFRMPARA_BASE+0x0012)
#define VPARA1_ADRS6L               (VFRMPARA_BASE+0x0013)
#define VPARA1_ADRS6H               (VFRMPARA_BASE+0x0014)
#define VPARA1_DATA6                (VFRMPARA_BASE+0x0015)
#define VPARA1_ADRS7L               (VFRMPARA_BASE+0x0016)
#define VPARA1_ADRS7H               (VFRMPARA_BASE+0x0017)
#define VPARA1_DATA7                (VFRMPARA_BASE+0x0018)
#define VPARA1_ADRS8L               (VFRMPARA_BASE+0x0019)
#define VPARA1_ADRS8H               (VFRMPARA_BASE+0x001A)
#define VPARA1_DATA8                (VFRMPARA_BASE+0x001B)
#define VPARA1_ADRS9L               (VFRMPARA_BASE+0x001C)
#define VPARA1_ADRS9H               (VFRMPARA_BASE+0x001D)
#define VPARA1_DATA9                (VFRMPARA_BASE+0x001E)
#define VPARA1_ADRS10L              (VFRMPARA_BASE+0x001F)
#define VPARA1_ADRS10H              (VFRMPARA_BASE+0x0020)
#define VPARA1_DATA10               (VFRMPARA_BASE+0x0021)
#define VPARA1_ADRS11L              (VFRMPARA_BASE+0x0022)
#define VPARA1_ADRS11H              (VFRMPARA_BASE+0x0023)
#define VPARA1_DATA11               (VFRMPARA_BASE+0x0024)
#define VPARA1_ADRS12L              (VFRMPARA_BASE+0x0025)
#define VPARA1_ADRS12H              (VFRMPARA_BASE+0x0026)
#define VPARA1_DATA12               (VFRMPARA_BASE+0x0027)
#define VPARA1_ADRS13L              (VFRMPARA_BASE+0x0028)
#define VPARA1_ADRS13H              (VFRMPARA_BASE+0x0029)
#define VPARA1_DATA13               (VFRMPARA_BASE+0x002A)
#define VPARA1_ADRS14L              (VFRMPARA_BASE+0x002B)
#define VPARA1_ADRS14H              (VFRMPARA_BASE+0x002C)
#define VPARA1_DATA14               (VFRMPARA_BASE+0x002D)
#define VPARA1_ADRS15L              (VFRMPARA_BASE+0x002E)
#define VPARA1_ADRS15H              (VFRMPARA_BASE+0x002F)
#define VPARA1_DATA15               (VFRMPARA_BASE+0x0030)
#define VPARA1_ADRS16L              (VFRMPARA_BASE+0x0031)
#define VPARA1_ADRS16H              (VFRMPARA_BASE+0x0032)
#define VPARA1_DATA16               (VFRMPARA_BASE+0x0033)
#define VPARA1_ADRS17L              (VFRMPARA_BASE+0x0034)
#define VPARA1_ADRS17H              (VFRMPARA_BASE+0x0035)
#define VPARA1_DATA17               (VFRMPARA_BASE+0x0036)
#define VPARA1_ADRS18L              (VFRMPARA_BASE+0x0037)
#define VPARA1_ADRS18H              (VFRMPARA_BASE+0x0038)
#define VPARA1_DATA18               (VFRMPARA_BASE+0x0039)
#define VPARA1_ADRS19L              (VFRMPARA_BASE+0x003A)
#define VPARA1_ADRS19H              (VFRMPARA_BASE+0x003B)
#define VPARA1_DATA19               (VFRMPARA_BASE+0x003C)
#define VPARA1_ADRS20L              (VFRMPARA_BASE+0x003D)
#define VPARA1_ADRS20H              (VFRMPARA_BASE+0x003E)
#define VPARA1_DATA20               (VFRMPARA_BASE+0x003F)
#define VPARA1_ADRS21L              (VFRMPARA_BASE+0x0040)
#define VPARA1_ADRS21H              (VFRMPARA_BASE+0x0041)
#define VPARA1_DATA21               (VFRMPARA_BASE+0x0042)
#define VPARA1_ADRS22L              (VFRMPARA_BASE+0x0043)
#define VPARA1_ADRS22H              (VFRMPARA_BASE+0x0044)
#define VPARA1_DATA22               (VFRMPARA_BASE+0x0045)
#define VPARA1_ADRS23L              (VFRMPARA_BASE+0x0046)
#define VPARA1_ADRS23H              (VFRMPARA_BASE+0x0047)
#define VPARA1_DATA23               (VFRMPARA_BASE+0x0048)
#define VPARA1_ADRS24L              (VFRMPARA_BASE+0x0049)
#define VPARA1_ADRS24H              (VFRMPARA_BASE+0x004A)
#define VPARA1_DATA24               (VFRMPARA_BASE+0x004B)
#define VPARA1_ADRS25L              (VFRMPARA_BASE+0x004C)
#define VPARA1_ADRS25H              (VFRMPARA_BASE+0x004D)
#define VPARA1_DATA25               (VFRMPARA_BASE+0x004E)
#define VPARA1_ADRS26L              (VFRMPARA_BASE+0x004F)
#define VPARA1_ADRS26H              (VFRMPARA_BASE+0x0050)
#define VPARA1_DATA26               (VFRMPARA_BASE+0x0051)
#define VPARA1_ADRS27L              (VFRMPARA_BASE+0x0052)
#define VPARA1_ADRS27H              (VFRMPARA_BASE+0x0053)
#define VPARA1_DATA27               (VFRMPARA_BASE+0x0054)
#define VPARA1_ADRS28L              (VFRMPARA_BASE+0x0055)
#define VPARA1_ADRS28H              (VFRMPARA_BASE+0x0056)
#define VPARA1_DATA28               (VFRMPARA_BASE+0x0057)
#define VPARA1_ADRS29L              (VFRMPARA_BASE+0x0058)
#define VPARA1_ADRS29H              (VFRMPARA_BASE+0x0059)
#define VPARA1_DATA29               (VFRMPARA_BASE+0x005A)
#define VPARA1_ADRS30L              (VFRMPARA_BASE+0x005B)
#define VPARA1_ADRS30H              (VFRMPARA_BASE+0x005C)
#define VPARA1_DATA30               (VFRMPARA_BASE+0x005D)
#define VPARA1_ADRS31L              (VFRMPARA_BASE+0x005E)
#define VPARA1_ADRS31H              (VFRMPARA_BASE+0x005F)
#define VPARA1_DATA31               (VFRMPARA_BASE+0x0060)
#define VPARA1_ADRS32L              (VFRMPARA_BASE+0x0061)
#define VPARA1_ADRS32H              (VFRMPARA_BASE+0x0062)
#define VPARA1_DATA32               (VFRMPARA_BASE+0x0063)
#define VPARA1_ADRS33L              (VFRMPARA_BASE+0x0064)
#define VPARA1_ADRS33H              (VFRMPARA_BASE+0x0065)
#define VPARA1_DATA33               (VFRMPARA_BASE+0x0066)
#define VPARA1_ADRS34L              (VFRMPARA_BASE+0x0067)
#define VPARA1_ADRS34H              (VFRMPARA_BASE+0x0068)
#define VPARA1_DATA34               (VFRMPARA_BASE+0x0069)
#define VPARA1_ADRS35L              (VFRMPARA_BASE+0x006A)
#define VPARA1_ADRS35H              (VFRMPARA_BASE+0x006B)
#define VPARA1_DATA35               (VFRMPARA_BASE+0x006C)
#define VPARA1_ADRS36L              (VFRMPARA_BASE+0x006D)
#define VPARA1_ADRS36H              (VFRMPARA_BASE+0x006E)
#define VPARA1_DATA36               (VFRMPARA_BASE+0x006F)
#define VPARA1_ADRS37L              (VFRMPARA_BASE+0x0070)
#define VPARA1_ADRS37H              (VFRMPARA_BASE+0x0071)
#define VPARA1_DATA37               (VFRMPARA_BASE+0x0072)
#define VPARA1_ADRS38L              (VFRMPARA_BASE+0x0073)
#define VPARA1_ADRS38H              (VFRMPARA_BASE+0x0074)
#define VPARA1_DATA38               (VFRMPARA_BASE+0x0075)
#define VPARA1_ADRS39L              (VFRMPARA_BASE+0x0076)
#define VPARA1_ADRS39H              (VFRMPARA_BASE+0x0077)
#define VPARA1_DATA39               (VFRMPARA_BASE+0x0078)
#define VPARA1_ADRS40L              (VFRMPARA_BASE+0x0079)
#define VPARA1_ADRS40H              (VFRMPARA_BASE+0x007A)
#define VPARA1_DATA40               (VFRMPARA_BASE+0x007B)
#define VPARA1_ADRS41L              (VFRMPARA_BASE+0x007C)
#define VPARA1_ADRS41H              (VFRMPARA_BASE+0x007D)
#define VPARA1_DATA41               (VFRMPARA_BASE+0x007E)
#define VPARA1_ADRS42L              (VFRMPARA_BASE+0x007F)
#define VPARA1_ADRS42H              (VFRMPARA_BASE+0x0080)
#define VPARA1_DATA42               (VFRMPARA_BASE+0x0081)
#define VPARA1_ADRS43L              (VFRMPARA_BASE+0x0082)
#define VPARA1_ADRS43H              (VFRMPARA_BASE+0x0083)
#define VPARA1_DATA43               (VFRMPARA_BASE+0x0084)
#define VPARA1_ADRS44L              (VFRMPARA_BASE+0x0085)
#define VPARA1_ADRS44H              (VFRMPARA_BASE+0x0086)
#define VPARA1_DATA44               (VFRMPARA_BASE+0x0087)
#define VPARA1_ADRS45L              (VFRMPARA_BASE+0x0088)
#define VPARA1_ADRS45H              (VFRMPARA_BASE+0x0089)
#define VPARA1_DATA45               (VFRMPARA_BASE+0x008A)
#define VPARA1_ADRS46L              (VFRMPARA_BASE+0x008B)
#define VPARA1_ADRS46H              (VFRMPARA_BASE+0x008C)
#define VPARA1_DATA46               (VFRMPARA_BASE+0x008D)
#define VPARA1_ADRS47L              (VFRMPARA_BASE+0x008E)
#define VPARA1_ADRS47H              (VFRMPARA_BASE+0x008F)
#define VPARA1_DATA47               (VFRMPARA_BASE+0x0090)
#define VPARA1_ADRS48L              (VFRMPARA_BASE+0x0091)
#define VPARA1_ADRS48H              (VFRMPARA_BASE+0x0092)
#define VPARA1_DATA48               (VFRMPARA_BASE+0x0093)
#define VPARA1_ADRS49L              (VFRMPARA_BASE+0x0094)
#define VPARA1_ADRS49H              (VFRMPARA_BASE+0x0095)
#define VPARA1_DATA49               (VFRMPARA_BASE+0x0096)
#define VPARA1_ADRS50L              (VFRMPARA_BASE+0x0097)
#define VPARA1_ADRS50H              (VFRMPARA_BASE+0x0098)
#define VPARA1_DATA50               (VFRMPARA_BASE+0x0099)
#define VPARA1_ADRS51L              (VFRMPARA_BASE+0x009A)
#define VPARA1_ADRS51H              (VFRMPARA_BASE+0x009B)
#define VPARA1_DATA51               (VFRMPARA_BASE+0x009C)
#define VPARA1_ADRS52L              (VFRMPARA_BASE+0x009D)
#define VPARA1_ADRS52H              (VFRMPARA_BASE+0x009E)
#define VPARA1_DATA52               (VFRMPARA_BASE+0x009F)
#define VPARA1_ADRS53L              (VFRMPARA_BASE+0x00A0)
#define VPARA1_ADRS53H              (VFRMPARA_BASE+0x00A1)
#define VPARA1_DATA53               (VFRMPARA_BASE+0x00A2)
#define VPARA1_ADRS54L              (VFRMPARA_BASE+0x00A3)
#define VPARA1_ADRS54H              (VFRMPARA_BASE+0x00A4)
#define VPARA1_DATA54               (VFRMPARA_BASE+0x00A5)
#define VPARA1_ADRS55L              (VFRMPARA_BASE+0x00A6)
#define VPARA1_ADRS55H              (VFRMPARA_BASE+0x00A7)
#define VPARA1_DATA55               (VFRMPARA_BASE+0x00A8)
#define VPARA1_ADRS56L              (VFRMPARA_BASE+0x00A9)
#define VPARA1_ADRS56H              (VFRMPARA_BASE+0x00AA)
#define VPARA1_DATA56               (VFRMPARA_BASE+0x00AB)
#define VPARA1_ADRS57L              (VFRMPARA_BASE+0x00AC)
#define VPARA1_ADRS57H              (VFRMPARA_BASE+0x00AD)
#define VPARA1_DATA57               (VFRMPARA_BASE+0x00AE)
#define VPARA1_ADRS58L              (VFRMPARA_BASE+0x00AF)
#define VPARA1_ADRS58H              (VFRMPARA_BASE+0x00B0)
#define VPARA1_DATA58               (VFRMPARA_BASE+0x00B1)
#define VPARA1_ADRS59L              (VFRMPARA_BASE+0x00B2)
#define VPARA1_ADRS59H              (VFRMPARA_BASE+0x00B3)
#define VPARA1_DATA59               (VFRMPARA_BASE+0x00B4)
#define VPARA1_ADRS60L              (VFRMPARA_BASE+0x00B5)
#define VPARA1_ADRS60H              (VFRMPARA_BASE+0x00B6)
#define VPARA1_DATA60               (VFRMPARA_BASE+0x00B7)
#define VPARA1_ADRS61L              (VFRMPARA_BASE+0x00B8)
#define VPARA1_ADRS61H              (VFRMPARA_BASE+0x00B9)
#define VPARA1_DATA61               (VFRMPARA_BASE+0x00BA)
#define VPARA1_ADRS62L              (VFRMPARA_BASE+0x00BB)
#define VPARA1_ADRS62H              (VFRMPARA_BASE+0x00BC)
#define VPARA1_DATA62               (VFRMPARA_BASE+0x00BD)
#define VPARA1_ADRS63L              (VFRMPARA_BASE+0x00BE)
#define VPARA1_ADRS63H              (VFRMPARA_BASE+0x00BF)
#define VPARA1_DATA63               (VFRMPARA_BASE+0x00C0)
#define VPARA2_ADRS0L               (VFRMPARA_BASE+0x00C1)
#define VPARA2_ADRS0H               (VFRMPARA_BASE+0x00C2)
#define VPARA2_DATA0L               (VFRMPARA_BASE+0x00C3)
#define VPARA2_DATA0H               (VFRMPARA_BASE+0x00C4)
#define VPARA2_ADRS1L               (VFRMPARA_BASE+0x00C5)
#define VPARA2_ADRS1H               (VFRMPARA_BASE+0x00C6)
#define VPARA2_DATA1L               (VFRMPARA_BASE+0x00C7)
#define VPARA2_DATA1H               (VFRMPARA_BASE+0x00C8)
#define VPARA2_ADRS2L               (VFRMPARA_BASE+0x00C9)
#define VPARA2_ADRS2H               (VFRMPARA_BASE+0x00CA)
#define VPARA2_DATA2L               (VFRMPARA_BASE+0x00CB)
#define VPARA2_DATA2H               (VFRMPARA_BASE+0x00CC)
#define VPARA2_ADRS3L               (VFRMPARA_BASE+0x00CD)
#define VPARA2_ADRS3H               (VFRMPARA_BASE+0x00CE)
#define VPARA2_DATA3L               (VFRMPARA_BASE+0x00CF)
#define VPARA2_DATA3H               (VFRMPARA_BASE+0x00D0)
#define VPARA2_ADRS4L               (VFRMPARA_BASE+0x00D1)
#define VPARA2_ADRS4H               (VFRMPARA_BASE+0x00D2)
#define VPARA2_DATA4L               (VFRMPARA_BASE+0x00D3)
#define VPARA2_DATA4H               (VFRMPARA_BASE+0x00D4)
#define VPARA2_ADRS5L               (VFRMPARA_BASE+0x00D5)
#define VPARA2_ADRS5H               (VFRMPARA_BASE+0x00D6)
#define VPARA2_DATA5L               (VFRMPARA_BASE+0x00D7)
#define VPARA2_DATA5H               (VFRMPARA_BASE+0x00D8)
#define VPARA2_ADRS6L               (VFRMPARA_BASE+0x00D9)
#define VPARA2_ADRS6H               (VFRMPARA_BASE+0x00DA)
#define VPARA2_DATA6L               (VFRMPARA_BASE+0x00DB)
#define VPARA2_DATA6H               (VFRMPARA_BASE+0x00DC)
#define VPARA2_ADRS7L               (VFRMPARA_BASE+0x00DD)
#define VPARA2_ADRS7H               (VFRMPARA_BASE+0x00DE)
#define VPARA2_DATA7L               (VFRMPARA_BASE+0x00DF)
#define VPARA2_DATA7H               (VFRMPARA_BASE+0x00E0)
#define VPARA2_ADRS8L               (VFRMPARA_BASE+0x00E1)
#define VPARA2_ADRS8H               (VFRMPARA_BASE+0x00E2)
#define VPARA2_DATA8L               (VFRMPARA_BASE+0x00E3)
#define VPARA2_DATA8H               (VFRMPARA_BASE+0x00E4)
#define VPARA2_ADRS9L               (VFRMPARA_BASE+0x00E5)
#define VPARA2_ADRS9H               (VFRMPARA_BASE+0x00E6)
#define VPARA2_DATA9L               (VFRMPARA_BASE+0x00E7)
#define VPARA2_DATA9H               (VFRMPARA_BASE+0x00E8)
#define VPARA2_ADRS10L              (VFRMPARA_BASE+0x00E9)
#define VPARA2_ADRS10H              (VFRMPARA_BASE+0x00EA)
#define VPARA2_DATA10L              (VFRMPARA_BASE+0x00EB)
#define VPARA2_DATA10H              (VFRMPARA_BASE+0x00EC)
#define VPARA2_ADRS11L              (VFRMPARA_BASE+0x00ED)
#define VPARA2_ADRS11H              (VFRMPARA_BASE+0x00EE)
#define VPARA2_DATA11L              (VFRMPARA_BASE+0x00EF)
#define VPARA2_DATA11H              (VFRMPARA_BASE+0x00F0)
#define VPARA2_ADRS12L              (VFRMPARA_BASE+0x00F1)
#define VPARA2_ADRS12H              (VFRMPARA_BASE+0x00F2)
#define VPARA2_DATA12L              (VFRMPARA_BASE+0x00F3)
#define VPARA2_DATA12H              (VFRMPARA_BASE+0x00F4)
#define VPARA2_ADRS13L              (VFRMPARA_BASE+0x00F5)
#define VPARA2_ADRS13H              (VFRMPARA_BASE+0x00F6)
#define VPARA2_DATA13L              (VFRMPARA_BASE+0x00F7)
#define VPARA2_DATA13H              (VFRMPARA_BASE+0x00F8)
#define VPARA2_ADRS14L              (VFRMPARA_BASE+0x00F9)
#define VPARA2_ADRS14H              (VFRMPARA_BASE+0x00FA)
#define VPARA2_DATA14L              (VFRMPARA_BASE+0x00FB)
#define VPARA2_DATA14H              (VFRMPARA_BASE+0x00FC)
#define VPARA2_ADRS15L              (VFRMPARA_BASE+0x00FD)
#define VPARA2_ADRS15H              (VFRMPARA_BASE+0x00FE)
#define VPARA2_DATA15L              (VFRMPARA_BASE+0x00FF)
#define VPARA2_DATA15H              (VFRMPARA_BASE+0x0100)
#define VPARA2_ADRS16L              (VFRMPARA_BASE+0x0101)
#define VPARA2_ADRS16H              (VFRMPARA_BASE+0x0102)
#define VPARA2_DATA16L              (VFRMPARA_BASE+0x0103)
#define VPARA2_DATA16H              (VFRMPARA_BASE+0x0104)
#define VPARA2_ADRS17L              (VFRMPARA_BASE+0x0105)
#define VPARA2_ADRS17H              (VFRMPARA_BASE+0x0106)
#define VPARA2_DATA17L              (VFRMPARA_BASE+0x0107)
#define VPARA2_DATA17H              (VFRMPARA_BASE+0x0108)
#define VPARA2_ADRS18L              (VFRMPARA_BASE+0x0109)
#define VPARA2_ADRS18H              (VFRMPARA_BASE+0x010A)
#define VPARA2_DATA18L              (VFRMPARA_BASE+0x010B)
#define VPARA2_DATA18H              (VFRMPARA_BASE+0x010C)
#define VPARA2_ADRS19L              (VFRMPARA_BASE+0x010D)
#define VPARA2_ADRS19H              (VFRMPARA_BASE+0x010E)
#define VPARA2_DATA19L              (VFRMPARA_BASE+0x010F)
#define VPARA2_DATA19H              (VFRMPARA_BASE+0x0110)
#define VPARA2_ADRS20L              (VFRMPARA_BASE+0x0111)
#define VPARA2_ADRS20H              (VFRMPARA_BASE+0x0112)
#define VPARA2_DATA20L              (VFRMPARA_BASE+0x0113)
#define VPARA2_DATA20H              (VFRMPARA_BASE+0x0114)
#define VPARA2_ADRS21L              (VFRMPARA_BASE+0x0115)
#define VPARA2_ADRS21H              (VFRMPARA_BASE+0x0116)
#define VPARA2_DATA21L              (VFRMPARA_BASE+0x0117)
#define VPARA2_DATA21H              (VFRMPARA_BASE+0x0118)
#define VPARA2_ADRS22L              (VFRMPARA_BASE+0x0119)
#define VPARA2_ADRS22H              (VFRMPARA_BASE+0x011A)
#define VPARA2_DATA22L              (VFRMPARA_BASE+0x011B)
#define VPARA2_DATA22H              (VFRMPARA_BASE+0x011C)
#define VPARA2_ADRS23L              (VFRMPARA_BASE+0x011D)
#define VPARA2_ADRS23H              (VFRMPARA_BASE+0x011E)
#define VPARA2_DATA23L              (VFRMPARA_BASE+0x011F)
#define VPARA2_DATA23H              (VFRMPARA_BASE+0x0120)
#define VPARA2_ADRS24L              (VFRMPARA_BASE+0x0121)
#define VPARA2_ADRS24H              (VFRMPARA_BASE+0x0122)
#define VPARA2_DATA24L              (VFRMPARA_BASE+0x0123)
#define VPARA2_DATA24H              (VFRMPARA_BASE+0x0124)
#define VPARA2_ADRS25L              (VFRMPARA_BASE+0x0125)
#define VPARA2_ADRS25H              (VFRMPARA_BASE+0x0126)
#define VPARA2_DATA25L              (VFRMPARA_BASE+0x0127)
#define VPARA2_DATA25H              (VFRMPARA_BASE+0x0128)
#define VPARA2_ADRS26L              (VFRMPARA_BASE+0x0129)
#define VPARA2_ADRS26H              (VFRMPARA_BASE+0x012A)
#define VPARA2_DATA26L              (VFRMPARA_BASE+0x012B)
#define VPARA2_DATA26H              (VFRMPARA_BASE+0x012C)
#define VPARA2_ADRS27L              (VFRMPARA_BASE+0x012D)
#define VPARA2_ADRS27H              (VFRMPARA_BASE+0x012E)
#define VPARA2_DATA27L              (VFRMPARA_BASE+0x012F)
#define VPARA2_DATA27H              (VFRMPARA_BASE+0x0130)
#define VPARA2_ADRS28L              (VFRMPARA_BASE+0x0131)
#define VPARA2_ADRS28H              (VFRMPARA_BASE+0x0132)
#define VPARA2_DATA28L              (VFRMPARA_BASE+0x0133)
#define VPARA2_DATA28H              (VFRMPARA_BASE+0x0134)
#define VPARA2_ADRS29L              (VFRMPARA_BASE+0x0135)
#define VPARA2_ADRS29H              (VFRMPARA_BASE+0x0136)
#define VPARA2_DATA29L              (VFRMPARA_BASE+0x0137)
#define VPARA2_DATA29H              (VFRMPARA_BASE+0x0138)
#define VPARA2_ADRS30L              (VFRMPARA_BASE+0x0139)
#define VPARA2_ADRS30H              (VFRMPARA_BASE+0x013A)
#define VPARA2_DATA30L              (VFRMPARA_BASE+0x013B)
#define VPARA2_DATA30H              (VFRMPARA_BASE+0x013C)
#define VPARA2_ADRS31L              (VFRMPARA_BASE+0x013D)
#define VPARA2_ADRS31H              (VFRMPARA_BASE+0x013E)
#define VPARA2_DATA31L              (VFRMPARA_BASE+0x013F)
#define VPARA2_DATA31H              (VFRMPARA_BASE+0x0140)
#define VPARA2_ADRS32L              (VFRMPARA_BASE+0x0141)
#define VPARA2_ADRS32H              (VFRMPARA_BASE+0x0142)
#define VPARA2_DATA32L              (VFRMPARA_BASE+0x0143)
#define VPARA2_DATA32H              (VFRMPARA_BASE+0x0144)
#define VPARA2_ADRS33L              (VFRMPARA_BASE+0x0145)
#define VPARA2_ADRS33H              (VFRMPARA_BASE+0x0146)
#define VPARA2_DATA33L              (VFRMPARA_BASE+0x0147)
#define VPARA2_DATA33H              (VFRMPARA_BASE+0x0148)
#define VPARA2_ADRS34L              (VFRMPARA_BASE+0x0149)
#define VPARA2_ADRS34H              (VFRMPARA_BASE+0x014A)
#define VPARA2_DATA34L              (VFRMPARA_BASE+0x014B)
#define VPARA2_DATA34H              (VFRMPARA_BASE+0x014C)
#define VPARA2_ADRS35L              (VFRMPARA_BASE+0x014D)
#define VPARA2_ADRS35H              (VFRMPARA_BASE+0x014E)
#define VPARA2_DATA35L              (VFRMPARA_BASE+0x014F)
#define VPARA2_DATA35H              (VFRMPARA_BASE+0x0150)
#define VPARA2_ADRS36L              (VFRMPARA_BASE+0x0151)
#define VPARA2_ADRS36H              (VFRMPARA_BASE+0x0152)
#define VPARA2_DATA36L              (VFRMPARA_BASE+0x0153)
#define VPARA2_DATA36H              (VFRMPARA_BASE+0x0154)
#define VPARA2_ADRS37L              (VFRMPARA_BASE+0x0155)
#define VPARA2_ADRS37H              (VFRMPARA_BASE+0x0156)
#define VPARA2_DATA37L              (VFRMPARA_BASE+0x0157)
#define VPARA2_DATA37H              (VFRMPARA_BASE+0x0158)
#define VPARA2_ADRS38L              (VFRMPARA_BASE+0x0159)
#define VPARA2_ADRS38H              (VFRMPARA_BASE+0x015A)
#define VPARA2_DATA38L              (VFRMPARA_BASE+0x015B)
#define VPARA2_DATA38H              (VFRMPARA_BASE+0x015C)
#define VPARA2_ADRS39L              (VFRMPARA_BASE+0x015D)
#define VPARA2_ADRS39H              (VFRMPARA_BASE+0x015E)
#define VPARA2_DATA39L              (VFRMPARA_BASE+0x015F)
#define VPARA2_DATA39H              (VFRMPARA_BASE+0x0160)
#define VPARA2_ADRS40L              (VFRMPARA_BASE+0x0161)
#define VPARA2_ADRS40H              (VFRMPARA_BASE+0x0162)
#define VPARA2_DATA40L              (VFRMPARA_BASE+0x0163)
#define VPARA2_DATA40H              (VFRMPARA_BASE+0x0164)
#define VPARA2_ADRS41L              (VFRMPARA_BASE+0x0165)
#define VPARA2_ADRS41H              (VFRMPARA_BASE+0x0166)
#define VPARA2_DATA41L              (VFRMPARA_BASE+0x0167)
#define VPARA2_DATA41H              (VFRMPARA_BASE+0x0168)
#define VPARA2_ADRS42L              (VFRMPARA_BASE+0x0169)
#define VPARA2_ADRS42H              (VFRMPARA_BASE+0x016A)
#define VPARA2_DATA42L              (VFRMPARA_BASE+0x016B)
#define VPARA2_DATA42H              (VFRMPARA_BASE+0x016C)
#define VPARA2_ADRS43L              (VFRMPARA_BASE+0x016D)
#define VPARA2_ADRS43H              (VFRMPARA_BASE+0x016E)
#define VPARA2_DATA43L              (VFRMPARA_BASE+0x016F)
#define VPARA2_DATA43H              (VFRMPARA_BASE+0x0170)
#define VPARA2_ADRS44L              (VFRMPARA_BASE+0x0171)
#define VPARA2_ADRS44H              (VFRMPARA_BASE+0x0172)
#define VPARA2_DATA44L              (VFRMPARA_BASE+0x0173)
#define VPARA2_DATA44H              (VFRMPARA_BASE+0x0174)
#define VPARA2_ADRS45L              (VFRMPARA_BASE+0x0175)
#define VPARA2_ADRS45H              (VFRMPARA_BASE+0x0176)
#define VPARA2_DATA45L              (VFRMPARA_BASE+0x0177)
#define VPARA2_DATA45H              (VFRMPARA_BASE+0x0178)
#define VPARA2_ADRS46L              (VFRMPARA_BASE+0x0179)
#define VPARA2_ADRS46H              (VFRMPARA_BASE+0x017A)
#define VPARA2_DATA46L              (VFRMPARA_BASE+0x017B)
#define VPARA2_DATA46H              (VFRMPARA_BASE+0x017C)
#define VPARA2_ADRS47L              (VFRMPARA_BASE+0x017D)
#define VPARA2_ADRS47H              (VFRMPARA_BASE+0x017E)
#define VPARA2_DATA47L              (VFRMPARA_BASE+0x017F)
#define VPARA2_DATA47H              (VFRMPARA_BASE+0x0180)
#define VPARA2_ADRS48L              (VFRMPARA_BASE+0x0181)
#define VPARA2_ADRS48H              (VFRMPARA_BASE+0x0182)
#define VPARA2_DATA48L              (VFRMPARA_BASE+0x0183)
#define VPARA2_DATA48H              (VFRMPARA_BASE+0x0184)
#define VPARA2_ADRS49L              (VFRMPARA_BASE+0x0185)
#define VPARA2_ADRS49H              (VFRMPARA_BASE+0x0186)
#define VPARA2_DATA49L              (VFRMPARA_BASE+0x0187)
#define VPARA2_DATA49H              (VFRMPARA_BASE+0x0188)
#define VPARA2_ADRS50L              (VFRMPARA_BASE+0x0189)
#define VPARA2_ADRS50H              (VFRMPARA_BASE+0x018A)
#define VPARA2_DATA50L              (VFRMPARA_BASE+0x018B)
#define VPARA2_DATA50H              (VFRMPARA_BASE+0x018C)
#define VPARA2_ADRS51L              (VFRMPARA_BASE+0x018D)
#define VPARA2_ADRS51H              (VFRMPARA_BASE+0x018E)
#define VPARA2_DATA51L              (VFRMPARA_BASE+0x018F)
#define VPARA2_DATA51H              (VFRMPARA_BASE+0x0190)
#define VPARA2_ADRS52L              (VFRMPARA_BASE+0x0191)
#define VPARA2_ADRS52H              (VFRMPARA_BASE+0x0192)
#define VPARA2_DATA52L              (VFRMPARA_BASE+0x0193)
#define VPARA2_DATA52H              (VFRMPARA_BASE+0x0194)
#define VPARA2_ADRS53L              (VFRMPARA_BASE+0x0195)
#define VPARA2_ADRS53H              (VFRMPARA_BASE+0x0196)
#define VPARA2_DATA53L              (VFRMPARA_BASE+0x0197)
#define VPARA2_DATA53H              (VFRMPARA_BASE+0x0198)
#define VPARA2_ADRS54L              (VFRMPARA_BASE+0x0199)
#define VPARA2_ADRS54H              (VFRMPARA_BASE+0x019A)
#define VPARA2_DATA54L              (VFRMPARA_BASE+0x019B)
#define VPARA2_DATA54H              (VFRMPARA_BASE+0x019C)
#define VPARA2_ADRS55L              (VFRMPARA_BASE+0x019D)
#define VPARA2_ADRS55H              (VFRMPARA_BASE+0x019E)
#define VPARA2_DATA55L              (VFRMPARA_BASE+0x019F)
#define VPARA2_DATA55H              (VFRMPARA_BASE+0x01A0)
#define VPARA2_ADRS56L              (VFRMPARA_BASE+0x01A1)
#define VPARA2_ADRS56H              (VFRMPARA_BASE+0x01A2)
#define VPARA2_DATA56L              (VFRMPARA_BASE+0x01A3)
#define VPARA2_DATA56H              (VFRMPARA_BASE+0x01A4)
#define VPARA2_ADRS57L              (VFRMPARA_BASE+0x01A5)
#define VPARA2_ADRS57H              (VFRMPARA_BASE+0x01A6)
#define VPARA2_DATA57L              (VFRMPARA_BASE+0x01A7)
#define VPARA2_DATA57H              (VFRMPARA_BASE+0x01A8)
#define VPARA2_ADRS58L              (VFRMPARA_BASE+0x01A9)
#define VPARA2_ADRS58H              (VFRMPARA_BASE+0x01AA)
#define VPARA2_DATA58L              (VFRMPARA_BASE+0x01AB)
#define VPARA2_DATA58H              (VFRMPARA_BASE+0x01AC)
#define VPARA2_ADRS59L              (VFRMPARA_BASE+0x01AD)
#define VPARA2_ADRS59H              (VFRMPARA_BASE+0x01AE)
#define VPARA2_DATA59L              (VFRMPARA_BASE+0x01AF)
#define VPARA2_DATA59H              (VFRMPARA_BASE+0x01B0)
#define VPARA2_ADRS60L              (VFRMPARA_BASE+0x01B1)
#define VPARA2_ADRS60H              (VFRMPARA_BASE+0x01B2)
#define VPARA2_DATA60L              (VFRMPARA_BASE+0x01B3)
#define VPARA2_DATA60H              (VFRMPARA_BASE+0x01B4)
#define VPARA2_ADRS61L              (VFRMPARA_BASE+0x01B5)
#define VPARA2_ADRS61H              (VFRMPARA_BASE+0x01B6)
#define VPARA2_DATA61L              (VFRMPARA_BASE+0x01B7)
#define VPARA2_DATA61H              (VFRMPARA_BASE+0x01B8)
#define VPARA2_ADRS62L              (VFRMPARA_BASE+0x01B9)
#define VPARA2_ADRS62H              (VFRMPARA_BASE+0x01BA)
#define VPARA2_DATA62L              (VFRMPARA_BASE+0x01BB)
#define VPARA2_DATA62H              (VFRMPARA_BASE+0x01BC)
#define VPARA2_ADRS63L              (VFRMPARA_BASE+0x01BD)
#define VPARA2_ADRS63H              (VFRMPARA_BASE+0x01BE)
#define VPARA2_DATA63L              (VFRMPARA_BASE+0x01BF)
#define VPARA2_DATA63H              (VFRMPARA_BASE+0x01C0)

/* SOUT OFFSET */

#define CAP_END_F                   (SOUT_BASE+0x0078)
#define AF_STATE                    (SOUT_BASE+0x018A)
#define AF_RESULT                   (SOUT_BASE+0x018B)
#define AF_FOCUSED_WND              (SOUT_BASE+0x018C)
#define AF_LENSPOS                  (SOUT_BASE+0x018E)

/* PICT GAIN0 OFFSET */

#define INTERLOCK_TYPE0             (PICT_GAIN0_BASE+0x0000)
#define INTERLOCK_TYPE1             (PICT_GAIN0_BASE+0x0001)
#define INTERLOCK_TYPE2             (PICT_GAIN0_BASE+0x0002)
#define INTERLOCK_TYPE3             (PICT_GAIN0_BASE+0x0003)
#define INTERLOCK_TYPE4             (PICT_GAIN0_BASE+0x0004)
#define INTERLOCK_TYPE5             (PICT_GAIN0_BASE+0x0005)
#define INTERLOCK_TYPE6             (PICT_GAIN0_BASE+0x0006)
#define INTERLOCK_TYPE7             (PICT_GAIN0_BASE+0x0007)

/* CXC_DATA OFFSET */

#define CXC_VALID                   (CXC_DATA_BASE+0x0000)
#define CXC_RGB_UNIT(x, y)          (CXC_DATA_BASE+0x0002 + (((x) * 7) + (y)))
#define CXC_GRB_UNIT(x, y)          (CXC_DATA_BASE+0x00BF + (((x) * 7) + (y)))

/* SHD_DATA OFFSET */

#define SHD_VALID                   (SHD_DATA_BASE+0x0000)
#define SHD_RGB_UNIT(x,y)           (SHD_DATA_BASE+0x0002 + (((x) * 11) + (y)))
#define SHD_GRB_UNIT(x, y)          (SHD_DATA_BASE+0x012B + (((x) * 11) + (y)))
#define SHD_R1_UNIT(x, y)           (SHD_DATA_BASE+0x0254 + (((x) * 11) + (y)))
#define SHD_R2_UNIT(x, y)           (SHD_DATA_BASE+0x02EE + (((x) * 11) + (y)))
#define SHD_B2_UNIT(x, y)           (SHD_DATA_BASE+0x0388 + (((x) * 11) + (y)))

/* Status bit */

#define OM_CHANGED_STS              (1<<0)
#define CM_CHANGED_STS              (1<<1)
#define JPEG_UPDATE_STS             (1<<2)
#define CAPNUM_END_STS              (1<<3)
#define AF_LOCK_STS                 (1<<4)
#define VINT_STS                    (1<<5)

#define AF_EXT_AFRAMDRVFIN          (0x02)

/* Register set value */

#define REGVAL_VIFMODE_YUV_PARALLEL         (0x00000002)
#define REGVAL_VIFMODE_JPEG_PARALLEL        (0x0000000A)
#define REGVAL_VIFMODE_INTERLEAVE_PARALLEL  (0x0000000E)
#define REGVAL_VIFMODE_RGB_PARALLEL         (0x00000006)

#define REGVAL_OUTFMT_YUV           (0)
#define REGVAL_OUTFMT_RGB           (0x04)
#define REGVAL_OUTFMT_JPEG          (0x08)
#define REGVAL_OUTFMT_INTERLEAVE    (0x18)

#define REGVAL_CHIPSTNBY_ACT        (0)
#define REGVAL_CHIPSTNBY_STN        (1)

#define REGVAL_MODESEL_MON          (0)
#define REGVAL_MODESEL_HREL         (1)
#define REGVAL_MODESEL_CAP          (2)
#define REGVAL_MODESEL_MOV          (3)

#define REGVAL_SENSMODE_ALLPIX      (0)
#define REGVAL_SENSMODE_1_2         (1)
#define REGVAL_SENSMODE_1_4         (2)
#define REGVAL_SENSMODE_1_8         (3)

#define REGVAL_FPSTYPE_120FPS       (0)
#define REGVAL_FPSTYPE_60FPS        (1)
#define REGVAL_FPSTYPE_30FPS        (2)
#define REGVAL_FPSTYPE_15FPS        (3)
#define REGVAL_FPSTYPE_10FPS        (4)
#define REGVAL_FPSTYPE_7_5FPS       (5)
#define REGVAL_FPSTYPE_6FPS         (6)
#define REGVAL_FPSTYPE_5FPS         (7)

#define REGVAL_CPUEXT_BIT_AESTOP    (0x01)
#define REGVAL_CPUEXT_BIT_AWBSTOP   (0x02)

#define REGVAL_READVECT_BIT_V       (0x01)
#define REGVAL_READVECT_BIT_H       (0x02)

#define REGVAL_EFFECT_NONE          (0)
#define REGVAL_EFFECT_SOLARIZATION  (1)
#define REGVAL_EFFECT_NEGPOS        (2)
#define REGVAL_EFFECT_SEPIA         (3)
#define REGVAL_EFFECT_MONOTONE      (4)
#define REGVAL_EFFECT_PASTEL        (5)
#define REGVAL_EFFECT_SKETCH        (6)

#define REGVAL_AWB_ATM              (0x20)
#define REGVAL_AWB_CLEARWEATHER     (0x04)
#define REGVAL_AWB_SHADE            (0x05)
#define REGVAL_AWB_CLOUDYWEATHER    (0x06)
#define REGVAL_AWB_FLUORESCENTLIGHT (0x07)
#define REGVAL_AWB_LIGHTBULB        (0x08)

#define REGVAL_EXPOSURETIME_AUTO    (0)

#define REGVAL_PHOTOMETRY_AVERAGE      (0)
#define REGVAL_PHOTOMETRY_CENTERWEIGHT (1)
#define REGVAL_PHOTOMETRY_SPOT         (2)
#define REGVAL_PHOTOMETRY_MULTIPATTERN (3)

#define REGVAL_ISO_AUTO             (0)
#define REGVAL_ISO_25               (1)
#define REGVAL_ISO_32               (2)
#define REGVAL_ISO_40               (3)
#define REGVAL_ISO_50               (4)
#define REGVAL_ISO_64               (5)
#define REGVAL_ISO_80               (6)
#define REGVAL_ISO_100              (7)
#define REGVAL_ISO_125              (8)
#define REGVAL_ISO_160              (9)
#define REGVAL_ISO_200              (10)
#define REGVAL_ISO_250              (11)
#define REGVAL_ISO_320              (12)
#define REGVAL_ISO_400              (13)
#define REGVAL_ISO_500              (14)
#define REGVAL_ISO_640              (15)
#define REGVAL_ISO_800              (16)
#define REGVAL_ISO_1000             (17)
#define REGVAL_ISO_1250             (18)
#define REGVAL_ISO_1600             (19)

#define REGVAL_YGAMMA_AUTO          (0)
#define REGVAL_YGAMMA_OFF           (1)

#define REGVAL_INTCLR0_ALLCLEAR     (0x3F)

#endif /* __INCLUDE_NUTTX_VIDEO_ISX012_REG_H */
