/****************************************************************************
 * libs/libnx/nxfonts/nxfonts_sans28x37b.h
 *
 *   Copyright (C) 2011-2012 NX Engineering, S.A., All rights reserved.
 *   Author: Jose Pablo Carballo Gomez <jcarballo@nx-engineering.com>
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 * 3. Neither the name NuttX nor the names of its contributors may be
 *    used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
 * COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT}
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING}
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS
 * OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED
 * AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN
 * ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 ****************************************************************************/

#ifndef __LIBNX_NXFONTS_NXFONTS_SANS28X37B_H
#define __LIBNX_NXFONTS_NXFONTS_SANS28X37B_H

/****************************************************************************
 * Included Files
 ****************************************************************************/

/****************************************************************************
 * Pre-Processor Definitions
 ****************************************************************************/

/* Font ID */

#define NXFONT_ID         FONTID_SANS28X37B

/* Ranges of 7-bit and 8-bit fonts */

#define NXFONT_MIN7BIT    33
#define NXFONT_MAX7BIT    126

#define NXFONT_MIN8BIT    161
#define NXFONT_MAX8BIT    255

/* Maximum height and width of any glyph in the set */

#define NXFONT_MAXHEIGHT  37
#define NXFONT_MAXWIDTH   28

/* The width of a space */

#define NXFONT_SPACEWIDTH 6

/* exclam (33) */
#define NXFONT_METRICS_33 {1, 3, 19, 2, 10, 0}
#define NXFONT_BITMAP_33 {0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xc0, 0xc0, 0xc0, 0x0, 0x0, 0xe0, 0xe0, 0xe0}

/* quotedbl (34) */
#define NXFONT_METRICS_34 {1, 5, 6, 2, 10, 0}
#define NXFONT_BITMAP_34 {0xd8, 0xd8, 0xd8, 0xd8, 0xd8, 0x90}

/* numbersign (35) */
#define NXFONT_METRICS_35 {2, 12, 18, 1, 11, 0}
#define NXFONT_BITMAP_35 {0xc, 0xc0, 0xc, 0xc0, 0xc, 0xc0, 0xc, 0xc0, 0xc, 0xc0, 0x7f, 0xf0, 0x7f, 0xf0, 0x19, 0x80, 0x19, 0x80, 0x19, 0x80, 0x19, 0x80, 0xff, 0xe0, 0xff, 0xe0, 0x33, 0x0, 0x33, 0x0, 0x33, 0x0, 0x33, 0x0, 0x33, 0x0}

/* dollar (36) */
#define NXFONT_METRICS_36 {2, 12, 21, 0, 10, 0}
#define NXFONT_BITMAP_36 {0x6, 0x0, 0x3f, 0x80, 0x7f, 0xe0, 0xf6, 0xe0, 0xe6, 0x70, 0xe6, 0x70, 0xf6, 0x0, 0x7e, 0x0, 0x3e, 0x0, 0xf, 0x0, 0x7, 0xc0, 0x7, 0xe0, 0x6, 0xf0, 0xe6, 0x70, 0xe6, 0x70, 0xe6, 0x70, 0xf6, 0xf0, 0x7f, 0xe0, 0x1f, 0xc0, 0x6, 0x0, 0x6, 0x0}

/* percent (37) */
#define NXFONT_METRICS_37 {3, 21, 18, 0, 11, 0}
#define NXFONT_BITMAP_37 {0x0, 0x7, 0x0, 0x3e, 0x7, 0x0, 0x7f, 0xe, 0x0, 0xe3, 0x8e, 0x0, 0xc1, 0x9c, 0x0, 0xc1, 0x9c, 0x0, 0xe3, 0xb8, 0x0, 0x7f, 0x38, 0x0, 0x3e, 0x70, 0x0, 0x0, 0x70, 0x0, 0x0, 0xe3, 0xe0, 0x0, 0xe7, 0xf0, 0x1, 0xce, 0x38, 0x1, 0xcc, 0x18, 0x3, 0x8c, 0x18, 0x3, 0x8e, 0x38, 0x7, 0x7, 0xf0, 0x7, 0x3, 0xe0}

/* ampersand (38) */
#define NXFONT_METRICS_38 {2, 16, 18, 1, 11, 0}
#define NXFONT_BITMAP_38 {0xf, 0x80, 0x1f, 0xc0, 0x3d, 0xe0, 0x38, 0xe0, 0x38, 0xe0, 0x38, 0xe0, 0x1d, 0xc0, 0xf, 0x80, 0x1f, 0x0, 0x3f, 0x9c, 0x7b, 0xdc, 0x71, 0xfc, 0xe0, 0xf8, 0xe0, 0x70, 0xe0, 0xf8, 0xf1, 0xfc, 0x7f, 0xce, 0x1f, 0x87}

/* quotesingle (39) */
#define NXFONT_METRICS_39 {1, 2, 6, 2, 10, 0}
#define NXFONT_BITMAP_39 {0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0x80}

/* parenleft (40) */
#define NXFONT_METRICS_40 {1, 6, 24, 1, 10, 0}
#define NXFONT_BITMAP_40 {0xc, 0x1c, 0x38, 0x38, 0x70, 0x70, 0x60, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0x60, 0x70, 0x70, 0x38, 0x38, 0x1c, 0xc}

/* parenright (41) */
#define NXFONT_METRICS_41 {1, 6, 24, 1, 10, 0}
#define NXFONT_BITMAP_41 {0xc0, 0xe0, 0x70, 0x70, 0x38, 0x38, 0x18, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x18, 0x38, 0x38, 0x70, 0x70, 0xe0, 0xc0}

/* asterisk (42) */
#define NXFONT_METRICS_42 {1, 8, 7, 1, 10, 0}
#define NXFONT_BITMAP_42 {0x18, 0x18, 0xdb, 0xff, 0x3c, 0x66, 0x66}

/* plus (43) */
#define NXFONT_METRICS_43 {2, 12, 12, 1, 16, 0}
#define NXFONT_BITMAP_43 {0x6, 0x0, 0x6, 0x0, 0x6, 0x0, 0x6, 0x0, 0x6, 0x0, 0xff, 0xf0, 0xff, 0xf0, 0x6, 0x0, 0x6, 0x0, 0x6, 0x0, 0x6, 0x0, 0x6, 0x0}

/* comma (44) */
#define NXFONT_METRICS_44 {1, 3, 6, 2, 26, 0}
#define NXFONT_BITMAP_44 {0xe0, 0xe0, 0xe0, 0x60, 0x60, 0xc0}

/* hyphen (45) */
#define NXFONT_METRICS_45 {1, 7, 3, 0, 20, 0}
#define NXFONT_BITMAP_45 {0xfe, 0xfe, 0xfe}

/* period (46) */
#define NXFONT_METRICS_46 {1, 3, 3, 2, 26, 0}
#define NXFONT_BITMAP_46 {0xe0, 0xe0, 0xe0}

/* slash (47) */
#define NXFONT_METRICS_47 {1, 7, 19, 1, 10, 0}
#define NXFONT_BITMAP_47 {0x6, 0x6, 0x6, 0xc, 0xc, 0xc, 0x18, 0x18, 0x18, 0x18, 0x30, 0x30, 0x30, 0x60, 0x60, 0x60, 0xc0, 0xc0, 0xc0}

/* zero (48) */
#define NXFONT_METRICS_48 {2, 12, 18, 0, 11, 0}
#define NXFONT_BITMAP_48 {0x1f, 0x80, 0x3f, 0xc0, 0x79, 0xe0, 0x70, 0xe0, 0x70, 0xe0, 0xe0, 0x70, 0xe0, 0x70, 0xe0, 0x70, 0xe0, 0x70, 0xe0, 0x70, 0xe0, 0x70, 0xe0, 0x70, 0xe0, 0x70, 0x70, 0xe0, 0x70, 0xe0, 0x79, 0xe0, 0x3f, 0xc0, 0x1f, 0x80}

/* one (49) */
#define NXFONT_METRICS_49 {1, 7, 18, 2, 11, 0}
#define NXFONT_BITMAP_49 {0xe, 0xe, 0x1e, 0xfe, 0xfe, 0xe, 0xe, 0xe, 0xe, 0xe, 0xe, 0xe, 0xe, 0xe, 0xe, 0xe, 0xe, 0xe}

/* two (50) */
#define NXFONT_METRICS_50 {2, 12, 18, 0, 11, 0}
#define NXFONT_BITMAP_50 {0x1f, 0x0, 0x7f, 0xc0, 0x71, 0xe0, 0xe0, 0xe0, 0xe0, 0x70, 0xe0, 0x70, 0x0, 0x70, 0x0, 0xe0, 0x1, 0xe0, 0x3, 0xc0, 0x7, 0x80, 0x1f, 0x0, 0x3c, 0x0, 0x78, 0x0, 0xf0, 0x0, 0xe0, 0x0, 0xff, 0xf0, 0xff, 0xf0}

/* three (51) */
#define NXFONT_METRICS_51 {2, 12, 18, 0, 11, 0}
#define NXFONT_BITMAP_51 {0x1f, 0x0, 0x7f, 0xc0, 0x71, 0xc0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0x0, 0xe0, 0x1, 0xc0, 0xf, 0x80, 0xf, 0xe0, 0x0, 0xe0, 0x0, 0x70, 0x0, 0x70, 0xe0, 0x70, 0xe0, 0xf0, 0x71, 0xe0, 0x7f, 0xe0, 0x1f, 0x80}

/* four (52) */
#define NXFONT_METRICS_52 {2, 12, 18, 0, 11, 0}
#define NXFONT_BITMAP_52 {0x1, 0xc0, 0x3, 0xc0, 0x3, 0xc0, 0x7, 0xc0, 0x7, 0xc0, 0xd, 0xc0, 0x1d, 0xc0, 0x19, 0xc0, 0x31, 0xc0, 0x71, 0xc0, 0x61, 0xc0, 0xe1, 0xc0, 0xff, 0xf0, 0xff, 0xf0, 0x1, 0xc0, 0x1, 0xc0, 0x1, 0xc0, 0x1, 0xc0}

/* five (53) */
#define NXFONT_METRICS_53 {2, 12, 18, 0, 11, 0}
#define NXFONT_BITMAP_53 {0x7f, 0xe0, 0x7f, 0xe0, 0x70, 0x0, 0x70, 0x0, 0x70, 0x0, 0x70, 0x0, 0x7f, 0x80, 0x7f, 0xc0, 0x71, 0xe0, 0x0, 0xe0, 0x0, 0x70, 0x0, 0x70, 0x0, 0x70, 0xe0, 0x70, 0xe0, 0xf0, 0xf1, 0xe0, 0x7f, 0xc0, 0x1f, 0x80}

/* six (54) */
#define NXFONT_METRICS_54 {2, 12, 18, 0, 11, 0}
#define NXFONT_BITMAP_54 {0xf, 0x80, 0x3f, 0xe0, 0x78, 0xe0, 0x70, 0x70, 0xe0, 0x70, 0xe0, 0x0, 0xe0, 0x0, 0xef, 0x0, 0xff, 0xc0, 0xf9, 0xe0, 0xf0, 0xe0, 0xe0, 0x70, 0xe0, 0x70, 0xe0, 0x70, 0x70, 0xe0, 0x79, 0xe0, 0x3f, 0xc0, 0x1f, 0x80}

/* seven (55) */
#define NXFONT_METRICS_55 {2, 12, 18, 0, 11, 0}
#define NXFONT_BITMAP_55 {0xff, 0xf0, 0xff, 0xf0, 0x0, 0xf0, 0x0, 0xe0, 0x1, 0xc0, 0x1, 0xc0, 0x3, 0x80, 0x3, 0x80, 0x7, 0x0, 0x7, 0x0, 0xe, 0x0, 0xe, 0x0, 0x1e, 0x0, 0x1c, 0x0, 0x1c, 0x0, 0x3c, 0x0, 0x38, 0x0, 0x38, 0x0}

/* eight (56) */
#define NXFONT_METRICS_56 {2, 12, 18, 0, 11, 0}
#define NXFONT_BITMAP_56 {0xf, 0x0, 0x3f, 0xc0, 0x39, 0xc0, 0x70, 0xe0, 0x70, 0xe0, 0x70, 0xe0, 0x70, 0xe0, 0x39, 0xc0, 0x1f, 0x80, 0x3f, 0xc0, 0x70, 0xe0, 0xe0, 0x70, 0xe0, 0x70, 0xe0, 0x70, 0xe0, 0x70, 0x70, 0xe0, 0x7f, 0xe0, 0x1f, 0x80}

/* nine (57) */
#define NXFONT_METRICS_57 {2, 12, 18, 0, 11, 0}
#define NXFONT_BITMAP_57 {0x1f, 0x80, 0x7f, 0xc0, 0x79, 0xe0, 0xf0, 0xe0, 0xe0, 0x70, 0xe0, 0x70, 0xe0, 0x70, 0xe0, 0x70, 0xf0, 0xf0, 0x79, 0xf0, 0x7f, 0xf0, 0x1f, 0x70, 0x0, 0x70, 0x0, 0x70, 0xe0, 0xe0, 0xf3, 0xe0, 0x7f, 0xc0, 0x1f, 0x0}

/* colon (58) */
#define NXFONT_METRICS_58 {1, 3, 14, 2, 15, 0}
#define NXFONT_BITMAP_58 {0xe0, 0xe0, 0xe0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xe0, 0xe0, 0xe0}

/* semicolon (59) */
#define NXFONT_METRICS_59 {1, 3, 17, 2, 15, 0}
#define NXFONT_BITMAP_59 {0xe0, 0xe0, 0xe0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xe0, 0xe0, 0xe0, 0x60, 0x60, 0xc0}

/* less (60) */
#define NXFONT_METRICS_60 {2, 13, 12, 0, 16, 0}
#define NXFONT_BITMAP_60 {0x0, 0x38, 0x0, 0xf8, 0x3, 0xe0, 0xf, 0x80, 0x3e, 0x0, 0xf0, 0x0, 0xf0, 0x0, 0x3e, 0x0, 0xf, 0x80, 0x3, 0xe0, 0x0, 0xf8, 0x0, 0x38}

/* equal (61) */
#define NXFONT_METRICS_61 {2, 10, 5, 2, 19, 0}
#define NXFONT_BITMAP_61 {0xff, 0xc0, 0xff, 0xc0, 0x0, 0x0, 0xff, 0xc0, 0xff, 0xc0}

/* greater (62) */
#define NXFONT_METRICS_62 {2, 13, 12, 1, 16, 0}
#define NXFONT_BITMAP_62 {0xe0, 0x0, 0xf8, 0x0, 0x3e, 0x0, 0xf, 0x80, 0x3, 0xe0, 0x0, 0x78, 0x0, 0x78, 0x3, 0xe0, 0xf, 0x80, 0x3e, 0x0, 0xf8, 0x0, 0xe0, 0x0}

/* question (63) */
#define NXFONT_METRICS_63 {2, 11, 19, 2, 10, 0}
#define NXFONT_BITMAP_63 {0x1f, 0x80, 0x7f, 0xc0, 0x79, 0xe0, 0xf0, 0xe0, 0xe0, 0xe0, 0xe1, 0xe0, 0x1, 0xc0, 0x3, 0xc0, 0x7, 0x80, 0x7, 0x0, 0xe, 0x0, 0xe, 0x0, 0xe, 0x0, 0xe, 0x0, 0x0, 0x0, 0x0, 0x0, 0xe, 0x0, 0xe, 0x0, 0xe, 0x0}

/* at (64) */
#define NXFONT_METRICS_64 {3, 22, 22, 1, 11, 0}
#define NXFONT_BITMAP_64 {0x1, 0xff, 0x0, 0x7, 0xff, 0xc0, 0xf, 0x81, 0xf0, 0x1e, 0x0, 0x78, 0x3c, 0x0, 0x38, 0x78, 0x7d, 0x9c, 0x70, 0xff, 0x9c, 0xf1, 0xc7, 0x1c, 0xe3, 0x87, 0x1c, 0xe3, 0xe, 0x1c, 0xe7, 0xe, 0x38, 0xe7, 0xc, 0x38, 0xe7, 0x1c, 0x70, 0xe7, 0x1c, 0x70, 0xe3, 0x9d, 0xe0, 0xf3, 0xff, 0xc0, 0x71, 0xf7, 0x0, 0x78, 0x0, 0x0, 0x3c, 0x0, 0x0, 0x1f, 0x7, 0x0, 0xf, 0xff, 0x0, 0x3, 0xfc, 0x0}

/* A (65) */
#define NXFONT_METRICS_65 {2, 16, 19, 1, 10, 0}
#define NXFONT_BITMAP_65 {0x3, 0xc0, 0x3, 0xc0, 0x7, 0xe0, 0x7, 0xe0, 0xe, 0x60, 0xe, 0x70, 0xe, 0x70, 0x1c, 0x38, 0x1c, 0x38, 0x1c, 0x38, 0x38, 0x1c, 0x38, 0x1c, 0x3f, 0xfc, 0x7f, 0xfe, 0x70, 0xe, 0x70, 0xe, 0xe0, 0x7, 0xe0, 0x7, 0xe0, 0x7}

/* B (66) */
#define NXFONT_METRICS_66 {2, 15, 19, 2, 10, 0}
#define NXFONT_BITMAP_66 {0xff, 0xe0, 0xff, 0xf8, 0xe0, 0x78, 0xe0, 0x1c, 0xe0, 0x1c, 0xe0, 0x1c, 0xe0, 0x1c, 0xe0, 0x38, 0xff, 0xf0, 0xff, 0xf8, 0xe0, 0x1c, 0xe0, 0xe, 0xe0, 0xe, 0xe0, 0xe, 0xe0, 0xe, 0xe0, 0x1e, 0xe0, 0x7c, 0xff, 0xf8, 0xff, 0xe0}

/* C (67) */
#define NXFONT_METRICS_67 {2, 16, 19, 1, 10, 0}
#define NXFONT_BITMAP_67 {0x7, 0xf0, 0x1f, 0xfc, 0x3e, 0x3e, 0x78, 0xf, 0x70, 0x7, 0xf0, 0x0, 0xe0, 0x0, 0xe0, 0x0, 0xe0, 0x0, 0xe0, 0x0, 0xe0, 0x0, 0xe0, 0x0, 0xe0, 0x0, 0xf0, 0x7, 0x70, 0x7, 0x78, 0xf, 0x3e, 0x3e, 0x1f, 0xfc, 0x7, 0xf0}

/* D (68) */
#define NXFONT_METRICS_68 {2, 16, 19, 2, 10, 0}
#define NXFONT_BITMAP_68 {0xff, 0xe0, 0xff, 0xf8, 0xe0, 0x7c, 0xe0, 0x1e, 0xe0, 0xe, 0xe0, 0xf, 0xe0, 0x7, 0xe0, 0x7, 0xe0, 0x7, 0xe0, 0x7, 0xe0, 0x7, 0xe0, 0x7, 0xe0, 0x7, 0xe0, 0xf, 0xe0, 0xe, 0xe0, 0x1e, 0xe0, 0x7c, 0xff, 0xf8, 0xff, 0xe0}

/* E (69) */
#define NXFONT_METRICS_69 {2, 13, 19, 2, 10, 0}
#define NXFONT_BITMAP_69 {0xff, 0xf0, 0xff, 0xf0, 0xe0, 0x0, 0xe0, 0x0, 0xe0, 0x0, 0xe0, 0x0, 0xe0, 0x0, 0xe0, 0x0, 0xff, 0xe0, 0xff, 0xe0, 0xe0, 0x0, 0xe0, 0x0, 0xe0, 0x0, 0xe0, 0x0, 0xe0, 0x0, 0xe0, 0x0, 0xe0, 0x0, 0xff, 0xf8, 0xff, 0xf8}

/* F (70) */
#define NXFONT_METRICS_70 {2, 12, 19, 2, 10, 0}
#define NXFONT_BITMAP_70 {0xff, 0xf0, 0xff, 0xf0, 0xe0, 0x0, 0xe0, 0x0, 0xe0, 0x0, 0xe0, 0x0, 0xe0, 0x0, 0xe0, 0x0, 0xff, 0xe0, 0xff, 0xe0, 0xe0, 0x0, 0xe0, 0x0, 0xe0, 0x0, 0xe0, 0x0, 0xe0, 0x0, 0xe0, 0x0, 0xe0, 0x0, 0xe0, 0x0, 0xe0, 0x0}

/* G (71) */
#define NXFONT_METRICS_71 {3, 17, 19, 1, 10, 0}
#define NXFONT_BITMAP_71 {0x7, 0xf0, 0x0, 0x1f, 0xfc, 0x0, 0x3e, 0x3e, 0x0, 0x78, 0xf, 0x0, 0x70, 0x7, 0x0, 0xf0, 0x0, 0x0, 0xe0, 0x0, 0x0, 0xe0, 0x0, 0x0, 0xe0, 0x0, 0x0, 0xe0, 0x7f, 0x80, 0xe0, 0x7f, 0x80, 0xe0, 0x3, 0x80, 0xe0, 0x3, 0x80, 0xf0, 0x3, 0x80, 0x70, 0x7, 0x80, 0x78, 0xf, 0x80, 0x3e, 0x3f, 0x80, 0x1f, 0xfb, 0x80, 0x7, 0xf3, 0x80}

/* H (72) */
#define NXFONT_METRICS_72 {2, 15, 19, 2, 10, 0}
#define NXFONT_BITMAP_72 {0xe0, 0xe, 0xe0, 0xe, 0xe0, 0xe, 0xe0, 0xe, 0xe0, 0xe, 0xe0, 0xe, 0xe0, 0xe, 0xe0, 0xe, 0xff, 0xfe, 0xff, 0xfe, 0xe0, 0xe, 0xe0, 0xe, 0xe0, 0xe, 0xe0, 0xe, 0xe0, 0xe, 0xe0, 0xe, 0xe0, 0xe, 0xe0, 0xe, 0xe0, 0xe}

/* I (73) */
#define NXFONT_METRICS_73 {1, 3, 19, 2, 10, 0}
#define NXFONT_BITMAP_73 {0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0}

/* J (74) */
#define NXFONT_METRICS_74 {2, 11, 19, 1, 10, 0}
#define NXFONT_BITMAP_74 {0x0, 0xe0, 0x0, 0xe0, 0x0, 0xe0, 0x0, 0xe0, 0x0, 0xe0, 0x0, 0xe0, 0x0, 0xe0, 0x0, 0xe0, 0x0, 0xe0, 0x0, 0xe0, 0x0, 0xe0, 0x0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0x71, 0xe0, 0x7f, 0xc0, 0x3f, 0x80}

/* K (75) */
#define NXFONT_METRICS_75 {2, 14, 19, 2, 10, 0}
#define NXFONT_BITMAP_75 {0xe0, 0x3c, 0xe0, 0x78, 0xe0, 0xf0, 0xe1, 0xe0, 0xe3, 0xc0, 0xe7, 0x80, 0xef, 0x0, 0xfe, 0x0, 0xfe, 0x0, 0xff, 0x0, 0xf7, 0x80, 0xe3, 0x80, 0xe1, 0xc0, 0xe1, 0xe0, 0xe0, 0xe0, 0xe0, 0x70, 0xe0, 0x78, 0xe0, 0x38, 0xe0, 0x3c}

/* L (76) */
#define NXFONT_METRICS_76 {2, 12, 19, 2, 10, 0}
#define NXFONT_BITMAP_76 {0xe0, 0x0, 0xe0, 0x0, 0xe0, 0x0, 0xe0, 0x0, 0xe0, 0x0, 0xe0, 0x0, 0xe0, 0x0, 0xe0, 0x0, 0xe0, 0x0, 0xe0, 0x0, 0xe0, 0x0, 0xe0, 0x0, 0xe0, 0x0, 0xe0, 0x0, 0xe0, 0x0, 0xe0, 0x0, 0xe0, 0x0, 0xff, 0xf0, 0xff, 0xf0}

/* M (77) */
#define NXFONT_METRICS_77 {3, 19, 19, 2, 10, 0}
#define NXFONT_BITMAP_77 {0xe0, 0x0, 0xe0, 0xf0, 0x1, 0xe0, 0xf0, 0x1, 0xe0, 0xf8, 0x3, 0xe0, 0xf8, 0x3, 0xe0, 0xfc, 0x7, 0xe0, 0xec, 0x6, 0xe0, 0xee, 0xe, 0xe0, 0xe6, 0xc, 0xe0, 0xe7, 0x1c, 0xe0, 0xe7, 0x1c, 0xe0, 0xe3, 0x18, 0xe0, 0xe3, 0xb8, 0xe0, 0xe3, 0xb8, 0xe0, 0xe1, 0xf0, 0xe0, 0xe1, 0xf0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0}

/* N (78) */
#define NXFONT_METRICS_78 {2, 15, 19, 2, 10, 0}
#define NXFONT_BITMAP_78 {0xe0, 0xe, 0xf0, 0xe, 0xf0, 0xe, 0xf8, 0xe, 0xf8, 0xe, 0xfc, 0xe, 0xee, 0xe, 0xee, 0xe, 0xe7, 0xe, 0xe3, 0x8e, 0xe3, 0x8e, 0xe1, 0xce, 0xe0, 0xce, 0xe0, 0xee, 0xe0, 0x7e, 0xe0, 0x3e, 0xe0, 0x3e, 0xe0, 0x1e, 0xe0, 0xe}

/* O (79) */
#define NXFONT_METRICS_79 {3, 17, 19, 1, 10, 0}
#define NXFONT_BITMAP_79 {0x7, 0xf0, 0x0, 0x1f, 0xfc, 0x0, 0x3e, 0x3e, 0x0, 0x78, 0xf, 0x0, 0x70, 0x7, 0x0, 0xf0, 0x7, 0x80, 0xe0, 0x3, 0x80, 0xe0, 0x3, 0x80, 0xe0, 0x3, 0x80, 0xe0, 0x3, 0x80, 0xe0, 0x3, 0x80, 0xe0, 0x3, 0x80, 0xe0, 0x3, 0x80, 0xf0, 0x7, 0x80, 0x70, 0x7, 0x0, 0x78, 0xf, 0x0, 0x3e, 0x3e, 0x0, 0x1f, 0xfc, 0x0, 0x7, 0xf0, 0x0}

/* P (80) */
#define NXFONT_METRICS_80 {2, 14, 19, 2, 10, 0}
#define NXFONT_BITMAP_80 {0xff, 0xe0, 0xff, 0xf8, 0xe0, 0x38, 0xe0, 0x1c, 0xe0, 0x1c, 0xe0, 0x1c, 0xe0, 0x1c, 0xe0, 0x38, 0xff, 0xf8, 0xff, 0xf0, 0xe0, 0x0, 0xe0, 0x0, 0xe0, 0x0, 0xe0, 0x0, 0xe0, 0x0, 0xe0, 0x0, 0xe0, 0x0, 0xe0, 0x0, 0xe0, 0x0}

/* Q (81) */
#define NXFONT_METRICS_81 {3, 17, 20, 1, 10, 0}
#define NXFONT_BITMAP_81 {0x7, 0xf0, 0x0, 0x1f, 0xfc, 0x0, 0x3e, 0x3e, 0x0, 0x78, 0xf, 0x0, 0x70, 0x7, 0x0, 0xf0, 0x7, 0x80, 0xe0, 0x3, 0x80, 0xe0, 0x3, 0x80, 0xe0, 0x3, 0x80, 0xe0, 0x3, 0x80, 0xe0, 0x3, 0x80, 0xe0, 0x3, 0x80, 0xe0, 0x3, 0x80, 0xf0, 0x27, 0x80, 0x70, 0x77, 0x0, 0x78, 0x3f, 0x0, 0x3e, 0x1e, 0x0, 0x1f, 0xfe, 0x0, 0x7, 0xf7, 0x0, 0x0, 0x2, 0x0}

/* R (82) */
#define NXFONT_METRICS_82 {2, 14, 19, 2, 10, 0}
#define NXFONT_BITMAP_82 {0xff, 0xe0, 0xff, 0xf8, 0xe0, 0x38, 0xe0, 0x1c, 0xe0, 0x1c, 0xe0, 0x1c, 0xe0, 0x1c, 0xe0, 0x38, 0xff, 0xf8, 0xff, 0xf0, 0xe0, 0x78, 0xe0, 0x38, 0xe0, 0x1c, 0xe0, 0x1c, 0xe0, 0x1c, 0xe0, 0x1c, 0xe0, 0x1c, 0xe0, 0x1c, 0xe0, 0x1c}

/* S (83) */
#define NXFONT_METRICS_83 {2, 14, 19, 2, 10, 0}
#define NXFONT_BITMAP_83 {0xf, 0xc0, 0x3f, 0xf0, 0x78, 0xf8, 0xf0, 0x38, 0xe0, 0x38, 0xe0, 0x0, 0xf0, 0x0, 0x7c, 0x0, 0x3f, 0xc0, 0x7, 0xf0, 0x0, 0xf8, 0x0, 0x3c, 0x0, 0x1c, 0xe0, 0x1c, 0xe0, 0x1c, 0xe0, 0x3c, 0xf8, 0xf8, 0x7f, 0xf0, 0x1f, 0xc0}

/* T (84) */
#define NXFONT_METRICS_84 {2, 15, 19, 0, 10, 0}
#define NXFONT_BITMAP_84 {0xff, 0xfe, 0xff, 0xfe, 0x3, 0x80, 0x3, 0x80, 0x3, 0x80, 0x3, 0x80, 0x3, 0x80, 0x3, 0x80, 0x3, 0x80, 0x3, 0x80, 0x3, 0x80, 0x3, 0x80, 0x3, 0x80, 0x3, 0x80, 0x3, 0x80, 0x3, 0x80, 0x3, 0x80, 0x3, 0x80, 0x3, 0x80}

/* U (85) */
#define NXFONT_METRICS_85 {2, 15, 19, 2, 10, 0}
#define NXFONT_BITMAP_85 {0xe0, 0xe, 0xe0, 0xe, 0xe0, 0xe, 0xe0, 0xe, 0xe0, 0xe, 0xe0, 0xe, 0xe0, 0xe, 0xe0, 0xe, 0xe0, 0xe, 0xe0, 0xe, 0xe0, 0xe, 0xe0, 0xe, 0xe0, 0xe, 0xe0, 0xe, 0xf0, 0x1e, 0x70, 0x1c, 0x7c, 0x7c, 0x3f, 0xf8, 0xf, 0xe0}

/* V (86) */
#define NXFONT_METRICS_86 {2, 16, 19, 1, 10, 0}
#define NXFONT_BITMAP_86 {0xe0, 0x7, 0xe0, 0x7, 0xf0, 0xf, 0x70, 0xe, 0x78, 0x1e, 0x38, 0x1c, 0x38, 0x1c, 0x3c, 0x3c, 0x1c, 0x38, 0x1c, 0x38, 0x1e, 0x78, 0xe, 0x70, 0xe, 0x70, 0xe, 0x70, 0x7, 0xe0, 0x7, 0xe0, 0x3, 0xc0, 0x3, 0xc0, 0x3, 0xc0}

/* W (87) */
#define NXFONT_METRICS_87 {3, 21, 19, 1, 10, 0}
#define NXFONT_BITMAP_87 {0xe0, 0x70, 0x38, 0xe0, 0x70, 0x38, 0xe0, 0x70, 0x38, 0xe0, 0x70, 0x38, 0x70, 0xf8, 0x70, 0x70, 0xf8, 0x70, 0x70, 0xd8, 0x70, 0x71, 0xdc, 0x70, 0x31, 0xdc, 0x60, 0x39, 0xdc, 0xe0, 0x39, 0x8c, 0xe0, 0x3b, 0x8e, 0xe0, 0x1b, 0x8e, 0xc0, 0x1b, 0x8e, 0xc0, 0x1f, 0x7, 0xc0, 0x1f, 0x7, 0xc0, 0xe, 0x3, 0x80, 0xe, 0x3, 0x80, 0xe, 0x3, 0x80}

/* X (88) */
#define NXFONT_METRICS_88 {2, 16, 19, 1, 10, 0}
#define NXFONT_BITMAP_88 {0xe0, 0x7, 0xf0, 0xf, 0x78, 0x1e, 0x38, 0x1c, 0x1c, 0x38, 0xe, 0x70, 0xf, 0xf0, 0x7, 0xe0, 0x3, 0xc0, 0x3, 0xc0, 0x7, 0xe0, 0xf, 0xf0, 0xe, 0x70, 0x1c, 0x38, 0x3c, 0x3c, 0x38, 0x1c, 0x70, 0xe, 0xf0, 0xf, 0xe0, 0x7}

/* Y (89) */
#define NXFONT_METRICS_89 {2, 15, 19, 1, 10, 0}
#define NXFONT_BITMAP_89 {0xe0, 0xe, 0xf0, 0xe, 0x70, 0x1c, 0x78, 0x1c, 0x38, 0x38, 0x3c, 0x38, 0x1c, 0x70, 0x1c, 0x70, 0xe, 0xe0, 0xe, 0xe0, 0x7, 0xc0, 0x7, 0xc0, 0x3, 0x80, 0x3, 0x80, 0x3, 0x80, 0x3, 0x80, 0x3, 0x80, 0x3, 0x80, 0x3, 0x80}

/* Z (90) */
#define NXFONT_METRICS_90 {2, 14, 19, 1, 10, 0}
#define NXFONT_BITMAP_90 {0xff, 0xfc, 0xff, 0xfc, 0x0, 0x3c, 0x0, 0x78, 0x0, 0xf0, 0x1, 0xe0, 0x1, 0xe0, 0x3, 0xc0, 0x7, 0x80, 0x7, 0x80, 0xf, 0x0, 0x1e, 0x0, 0x1e, 0x0, 0x3c, 0x0, 0x38, 0x0, 0x78, 0x0, 0xf0, 0x0, 0xff, 0xfc, 0xff, 0xfc}

/* bracketleft (91) */
#define NXFONT_METRICS_91 {1, 5, 24, 1, 10, 0}
#define NXFONT_BITMAP_91 {0xf8, 0xf8, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xf8, 0xf8}

/* backslash (92) */
#define NXFONT_METRICS_92 {1, 7, 19, 0, 10, 0}
#define NXFONT_BITMAP_92 {0xc0, 0xc0, 0xc0, 0x60, 0x60, 0x60, 0x30, 0x30, 0x30, 0x30, 0x18, 0x18, 0x18, 0xc, 0xc, 0xc, 0x6, 0x6, 0x6}

/* bracketright (93) */
#define NXFONT_METRICS_93 {1, 5, 24, 2, 10, 0}
#define NXFONT_BITMAP_93 {0xf8, 0xf8, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0xf8, 0xf8}

/* asciicircum (94) */
#define NXFONT_METRICS_94 {2, 11, 9, 1, 10, 0}
#define NXFONT_BITMAP_94 {0xe, 0x0, 0xe, 0x0, 0x1f, 0x0, 0x1b, 0x0, 0x3b, 0x80, 0x71, 0xc0, 0x71, 0xc0, 0xe0, 0xe0, 0xe0, 0xe0}

/* underscore (95) */
#define NXFONT_METRICS_95 {2, 14, 2, 0, 32, 0}
#define NXFONT_BITMAP_95 {0xff, 0xfc, 0xff, 0xfc}

/* grave (96) */
#define NXFONT_METRICS_96 {1, 6, 4, 1, 10, 0}
#define NXFONT_BITMAP_96 {0xe0, 0x70, 0x38, 0x1c}

/* a (97) */
#define NXFONT_METRICS_97 {2, 12, 14, 1, 15, 0}
#define NXFONT_BITMAP_97 {0x1f, 0x80, 0x3f, 0xc0, 0x71, 0xe0, 0x70, 0xe0, 0x0, 0xe0, 0x7, 0xe0, 0x3f, 0xe0, 0x7c, 0xe0, 0xf0, 0xe0, 0xe0, 0xe0, 0xe1, 0xe0, 0xf3, 0xe0, 0x7f, 0xf0, 0x3e, 0x70}

/* b (98) */
#define NXFONT_METRICS_98 {2, 12, 19, 2, 10, 0}
#define NXFONT_BITMAP_98 {0xe0, 0x0, 0xe0, 0x0, 0xe0, 0x0, 0xe0, 0x0, 0xe0, 0x0, 0xef, 0x80, 0xff, 0xc0, 0xf9, 0xe0, 0xf0, 0xe0, 0xe0, 0x70, 0xe0, 0x70, 0xe0, 0x70, 0xe0, 0x70, 0xe0, 0x70, 0xe0, 0x70, 0xf0, 0xe0, 0xf9, 0xe0, 0xff, 0xc0, 0xef, 0x80}

/* c (99) */
#define NXFONT_METRICS_99 {2, 11, 14, 1, 15, 0}
#define NXFONT_BITMAP_99 {0x1f, 0x80, 0x3f, 0xc0, 0x79, 0xe0, 0x70, 0xe0, 0xe0, 0x0, 0xe0, 0x0, 0xe0, 0x0, 0xe0, 0x0, 0xe0, 0x0, 0xe0, 0x0, 0x70, 0xe0, 0x79, 0xe0, 0x3f, 0xc0, 0x1f, 0x80}

/* d (100) */
#define NXFONT_METRICS_100 {2, 12, 19, 1, 10, 0}
#define NXFONT_BITMAP_100 {0x0, 0x70, 0x0, 0x70, 0x0, 0x70, 0x0, 0x70, 0x0, 0x70, 0x1f, 0x70, 0x3f, 0xf0, 0x79, 0xf0, 0x70, 0xf0, 0xe0, 0x70, 0xe0, 0x70, 0xe0, 0x70, 0xe0, 0x70, 0xe0, 0x70, 0xe0, 0x70, 0x70, 0xf0, 0x79, 0xf0, 0x3f, 0xf0, 0x1f, 0x70}

/* e (101) */
#define NXFONT_METRICS_101 {2, 12, 14, 1, 15, 0}
#define NXFONT_BITMAP_101 {0xf, 0x0, 0x3f, 0xc0, 0x79, 0xe0, 0x70, 0xe0, 0xe0, 0x70, 0xe0, 0x70, 0xff, 0xf0, 0xff, 0xf0, 0xe0, 0x0, 0xe0, 0x0, 0x70, 0x70, 0x78, 0xf0, 0x3f, 0xe0, 0xf, 0x80}

/* f (102) */
#define NXFONT_METRICS_102 {1, 7, 19, 1, 10, 0}
#define NXFONT_BITMAP_102 {0x1e, 0x3e, 0x38, 0x38, 0x38, 0xfe, 0xfe, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38}

/* g (103) */
#define NXFONT_METRICS_103 {2, 12, 19, 1, 15, 0}
#define NXFONT_BITMAP_103 {0x1f, 0x70, 0x3f, 0xf0, 0x79, 0xf0, 0x70, 0xf0, 0xe0, 0x70, 0xe0, 0x70, 0xe0, 0x70, 0xe0, 0x70, 0xe0, 0x70, 0xe0, 0x70, 0x70, 0xf0, 0x79, 0xf0, 0x3f, 0xf0, 0x1f, 0x70, 0x0, 0x70, 0xe0, 0x70, 0xf0, 0xe0, 0x7f, 0xe0, 0x1f, 0x80}

/* h (104) */
#define NXFONT_METRICS_104 {2, 11, 19, 2, 10, 0}
#define NXFONT_BITMAP_104 {0xe0, 0x0, 0xe0, 0x0, 0xe0, 0x0, 0xe0, 0x0, 0xe0, 0x0, 0xef, 0x0, 0xff, 0xc0, 0xf1, 0xc0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0}

/* i (105) */
#define NXFONT_METRICS_105 {1, 3, 19, 2, 10, 0}
#define NXFONT_BITMAP_105 {0xe0, 0xe0, 0xe0, 0x0, 0x0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0}

/* j (106) */
#define NXFONT_METRICS_106 {1, 5, 24, 0, 10, 0}
#define NXFONT_BITMAP_106 {0x38, 0x38, 0x38, 0x0, 0x0, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0xf8, 0xf0}

/* k (107) */
#define NXFONT_METRICS_107 {2, 11, 19, 2, 10, 0}
#define NXFONT_BITMAP_107 {0xe0, 0x0, 0xe0, 0x0, 0xe0, 0x0, 0xe0, 0x0, 0xe0, 0x0, 0xe1, 0xc0, 0xe3, 0xc0, 0xe7, 0x80, 0xef, 0x0, 0xfe, 0x0, 0xfc, 0x0, 0xfe, 0x0, 0xef, 0x0, 0xe7, 0x0, 0xe7, 0x80, 0xe3, 0xc0, 0xe1, 0xc0, 0xe1, 0xe0, 0xe0, 0xe0}

/* l (108) */
#define NXFONT_METRICS_108 {1, 3, 19, 2, 10, 0}
#define NXFONT_BITMAP_108 {0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0}

/* m (109) */
#define NXFONT_METRICS_109 {3, 17, 14, 2, 15, 0}
#define NXFONT_BITMAP_109 {0xef, 0x3e, 0x0, 0xff, 0xff, 0x0, 0xf3, 0xe7, 0x80, 0xe1, 0xc3, 0x80, 0xe1, 0xc3, 0x80, 0xe1, 0xc3, 0x80, 0xe1, 0xc3, 0x80, 0xe1, 0xc3, 0x80, 0xe1, 0xc3, 0x80, 0xe1, 0xc3, 0x80, 0xe1, 0xc3, 0x80, 0xe1, 0xc3, 0x80, 0xe1, 0xc3, 0x80, 0xe1, 0xc3, 0x80}

/* n (110) */
#define NXFONT_METRICS_110 {2, 11, 14, 2, 15, 0}
#define NXFONT_BITMAP_110 {0xef, 0x80, 0xff, 0xc0, 0xf1, 0xc0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0}

/* o (111) */
#define NXFONT_METRICS_111 {2, 12, 14, 1, 15, 0}
#define NXFONT_BITMAP_111 {0xf, 0x0, 0x3f, 0xc0, 0x79, 0xe0, 0x70, 0xe0, 0xe0, 0x70, 0xe0, 0x70, 0xe0, 0x70, 0xe0, 0x70, 0xe0, 0x70, 0xe0, 0x70, 0x70, 0xe0, 0x79, 0xe0, 0x3f, 0xc0, 0xf, 0x0}

/* p (112) */
#define NXFONT_METRICS_112 {2, 12, 19, 2, 15, 0}
#define NXFONT_BITMAP_112 {0xef, 0x80, 0xff, 0xc0, 0xf9, 0xe0, 0xf0, 0xe0, 0xe0, 0x70, 0xe0, 0x70, 0xe0, 0x70, 0xe0, 0x70, 0xe0, 0x70, 0xe0, 0x70, 0xf0, 0xe0, 0xf9, 0xe0, 0xff, 0xc0, 0xef, 0x80, 0xe0, 0x0, 0xe0, 0x0, 0xe0, 0x0, 0xe0, 0x0, 0xe0, 0x0}

/* q (113) */
#define NXFONT_METRICS_113 {2, 12, 19, 1, 15, 0}
#define NXFONT_BITMAP_113 {0x1f, 0x70, 0x3f, 0xf0, 0x79, 0xf0, 0x70, 0xf0, 0xe0, 0x70, 0xe0, 0x70, 0xe0, 0x70, 0xe0, 0x70, 0xe0, 0x70, 0xe0, 0x70, 0x70, 0xf0, 0x79, 0xf0, 0x3f, 0xf0, 0x1f, 0x70, 0x0, 0x70, 0x0, 0x70, 0x0, 0x70, 0x0, 0x70, 0x0, 0x70}

/* r (114) */
#define NXFONT_METRICS_114 {1, 7, 14, 2, 15, 0}
#define NXFONT_BITMAP_114 {0xee, 0xfe, 0xfe, 0xf0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0}

/* s (115) */
#define NXFONT_METRICS_115 {2, 11, 14, 1, 15, 0}
#define NXFONT_BITMAP_115 {0x3f, 0x0, 0x7f, 0x80, 0xf3, 0xc0, 0xe1, 0xc0, 0xe0, 0x0, 0xfc, 0x0, 0x7f, 0x80, 0xf, 0xc0, 0x1, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xf1, 0xe0, 0x7f, 0xc0, 0x3f, 0x80}

/* t (116) */
#define NXFONT_METRICS_116 {1, 7, 18, 1, 11, 0}
#define NXFONT_BITMAP_116 {0x38, 0x38, 0x38, 0x38, 0xfe, 0xfe, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x3e, 0x1e}

/* u (117) */
#define NXFONT_METRICS_117 {2, 11, 14, 2, 15, 0}
#define NXFONT_BITMAP_117 {0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe1, 0xe0, 0x73, 0xe0, 0x7e, 0xe0, 0x1c, 0xe0}

/* v (118) */
#define NXFONT_METRICS_118 {2, 12, 14, 1, 15, 0}
#define NXFONT_BITMAP_118 {0xe0, 0x70, 0xe0, 0x70, 0xe0, 0x70, 0x70, 0xe0, 0x70, 0xe0, 0x70, 0xe0, 0x39, 0xc0, 0x39, 0xc0, 0x39, 0xc0, 0x1f, 0x80, 0x1f, 0x80, 0xf, 0x0, 0xf, 0x0, 0xf, 0x0}

/* w (119) */
#define NXFONT_METRICS_119 {3, 19, 14, 0, 15, 0}
#define NXFONT_BITMAP_119 {0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0x60, 0xe0, 0xc0, 0x71, 0xf1, 0xc0, 0x71, 0xf1, 0xc0, 0x31, 0xb1, 0x80, 0x33, 0xb9, 0x80, 0x3b, 0xbb, 0x80, 0x1b, 0x1b, 0x0, 0x1f, 0x1f, 0x0, 0x1f, 0x1f, 0x0, 0xe, 0xe, 0x0, 0xe, 0xe, 0x0, 0xe, 0xe, 0x0}

/* x (120) */
#define NXFONT_METRICS_120 {2, 11, 14, 1, 15, 0}
#define NXFONT_BITMAP_120 {0xe0, 0xe0, 0xf1, 0xe0, 0x71, 0xc0, 0x3b, 0x80, 0x3f, 0x80, 0x1f, 0x0, 0xe, 0x0, 0x1f, 0x0, 0x1f, 0x0, 0x3b, 0x80, 0x7b, 0xc0, 0x71, 0xc0, 0xf1, 0xe0, 0xe0, 0xe0}

/* y (121) */
#define NXFONT_METRICS_121 {2, 13, 19, 1, 15, 0}
#define NXFONT_BITMAP_121 {0xe0, 0x38, 0xe0, 0x38, 0x70, 0x38, 0x78, 0x70, 0x38, 0x70, 0x3c, 0xf0, 0x1c, 0xe0, 0x1c, 0xe0, 0xf, 0xc0, 0xf, 0xc0, 0x7, 0xc0, 0x7, 0x80, 0x3, 0x80, 0x3, 0x80, 0x7, 0x0, 0x7, 0x0, 0xe, 0x0, 0x3e, 0x0, 0x3c, 0x0}

/* z (122) */
#define NXFONT_METRICS_122 {2, 11, 14, 1, 15, 0}
#define NXFONT_BITMAP_122 {0xff, 0xe0, 0xff, 0xe0, 0x1, 0xc0, 0x3, 0x80, 0x7, 0x80, 0xf, 0x0, 0xe, 0x0, 0x1e, 0x0, 0x3c, 0x0, 0x38, 0x0, 0x70, 0x0, 0xf0, 0x0, 0xff, 0xe0, 0xff, 0xe0}

/* braceleft (123) */
#define NXFONT_METRICS_123 {1, 7, 24, 1, 10, 0}
#define NXFONT_BITMAP_123 {0xe, 0x1c, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x70, 0xe0, 0xe0, 0x70, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x1c, 0xe}

/* bar (124) */
#define NXFONT_METRICS_124 {1, 2, 24, 3, 10, 0}
#define NXFONT_BITMAP_124 {0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0}

/* braceright (125) */
#define NXFONT_METRICS_125 {1, 7, 24, 2, 10, 0}
#define NXFONT_BITMAP_125 {0xe0, 0x70, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x1c, 0xe, 0xe, 0x1c, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x70, 0xe0}

/* asciitilde (126) */
#define NXFONT_METRICS_126 {2, 11, 4, 1, 20, 0}
#define NXFONT_BITMAP_126 {0x78, 0xe0, 0xfe, 0xe0, 0xef, 0xe0, 0xe3, 0xc0}

/* exclamdown (161) */
#define NXFONT_METRICS_161 {1, 3, 19, 2, 15, 0}
#define NXFONT_BITMAP_161 {0xe0, 0xe0, 0xe0, 0x0, 0x0, 0x60, 0x60, 0x60, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0}

/* cent (162) */
#define NXFONT_METRICS_162 {2, 11, 18, 1, 13, 0}
#define NXFONT_BITMAP_162 {0x1, 0x80, 0x1, 0x80, 0x1f, 0x80, 0x3f, 0xc0, 0x7b, 0xe0, 0x73, 0x60, 0xe3, 0x0, 0xe6, 0x0, 0xe6, 0x0, 0xe6, 0x0, 0xe6, 0x0, 0xec, 0x0, 0xec, 0xe0, 0x7d, 0xe0, 0x7f, 0xc0, 0x3f, 0x80, 0x18, 0x0, 0x18, 0x0}

/* sterling (163) */
#define NXFONT_METRICS_163 {2, 13, 18, 1, 11, 0}
#define NXFONT_BITMAP_163 {0x1f, 0x80, 0x3f, 0xc0, 0x70, 0xe0, 0x70, 0xe0, 0x70, 0x0, 0x78, 0x0, 0x38, 0x0, 0x1c, 0x0, 0xff, 0xc0, 0xff, 0xc0, 0x1c, 0x0, 0x1c, 0x0, 0x1c, 0x0, 0x38, 0x0, 0x38, 0x0, 0x7f, 0x38, 0xff, 0xf8, 0xf1, 0xf0}

/* currency (164) */
#define NXFONT_METRICS_164 {2, 12, 12, 1, 14, 0}
#define NXFONT_BITMAP_164 {0xc0, 0x30, 0xef, 0x70, 0x7f, 0xe0, 0x39, 0xc0, 0x70, 0xe0, 0x70, 0xe0, 0x70, 0xe0, 0x70, 0xe0, 0x39, 0xc0, 0x7f, 0xe0, 0xef, 0x70, 0xc0, 0x30}

/* yen (165) */
#define NXFONT_METRICS_165 {2, 13, 18, 0, 11, 0}
#define NXFONT_BITMAP_165 {0xe0, 0x38, 0xe0, 0x38, 0x70, 0x70, 0x70, 0x70, 0x38, 0xe0, 0x38, 0xe0, 0x1d, 0xc0, 0x1d, 0xc0, 0x7f, 0xf0, 0x7f, 0xf0, 0x7, 0x0, 0x7f, 0xf0, 0x7f, 0xf0, 0x7, 0x0, 0x7, 0x0, 0x7, 0x0, 0x7, 0x0, 0x7, 0x0}

/* brokenbar (166) */
#define NXFONT_METRICS_166 {1, 2, 24, 3, 10, 0}
#define NXFONT_BITMAP_166 {0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0x0, 0x0, 0x0, 0x0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0}

/* section (167) */
#define NXFONT_METRICS_167 {2, 12, 24, 1, 10, 0}
#define NXFONT_BITMAP_167 {0x1f, 0x80, 0x3f, 0xc0, 0x79, 0xe0, 0x70, 0xe0, 0x78, 0xe0, 0x3c, 0x0, 0x1e, 0x0, 0x7f, 0x0, 0xf7, 0x80, 0xe3, 0xc0, 0xe1, 0xe0, 0xe0, 0xe0, 0x70, 0x70, 0x78, 0x70, 0x3c, 0x70, 0x1e, 0xe0, 0xf, 0xc0, 0x7, 0x80, 0x3, 0xc0, 0x71, 0xe0, 0x70, 0xe0, 0x79, 0xe0, 0x3f, 0xc0, 0x1f, 0x80}

/* dieresis (168) */
#define NXFONT_METRICS_168 {1, 7, 2, 1, 11, 0}
#define NXFONT_BITMAP_168 {0xee, 0xee}

/* copyright (169) */
#define NXFONT_METRICS_169 {3, 19, 19, 0, 10, 0}
#define NXFONT_BITMAP_169 {0x1, 0xf0, 0x0, 0xf, 0xfe, 0x0, 0x1e, 0xf, 0x0, 0x38, 0x3, 0x80, 0x70, 0x1, 0xc0, 0x61, 0xf0, 0xc0, 0xe3, 0xb8, 0xe0, 0xc6, 0xc, 0x60, 0xc6, 0x0, 0x60, 0xc6, 0x0, 0x60, 0xc6, 0x0, 0x60, 0xc6, 0xc, 0x60, 0xe3, 0xb8, 0xe0, 0x61, 0xf0, 0xc0, 0x70, 0x1, 0xc0, 0x38, 0x3, 0x80, 0x1e, 0xf, 0x0, 0xf, 0xfe, 0x0, 0x1, 0xf0, 0x0}

/* ordfeminine (170) */
#define NXFONT_METRICS_170 {1, 8, 12, 1, 10, 0}
#define NXFONT_BITMAP_170 {0x7c, 0xfe, 0xc6, 0x1e, 0x7e, 0xe6, 0xc6, 0xff, 0x7b, 0x0, 0xff, 0xff}

/* guillemotleft (171) */
#define NXFONT_METRICS_171 {2, 10, 8, 1, 18, 0}
#define NXFONT_BITMAP_171 {0x1d, 0xc0, 0x3b, 0x80, 0x77, 0x0, 0xee, 0x0, 0xee, 0x0, 0x77, 0x0, 0x3b, 0x80, 0x1d, 0xc0}

/* logicalnot (172) */
#define NXFONT_METRICS_172 {2, 12, 7, 1, 18, 0}
#define NXFONT_BITMAP_172 {0xff, 0xf0, 0xff, 0xf0, 0x0, 0x30, 0x0, 0x30, 0x0, 0x30, 0x0, 0x30, 0x0, 0x30}

/* hyphen (173) */
#define NXFONT_METRICS_173 {1, 7, 3, 0, 20, 0}
#define NXFONT_BITMAP_173 {0xfe, 0xfe, 0xfe}

/* registered (174) */
#define NXFONT_METRICS_174 {3, 19, 19, 0, 10, 0}
#define NXFONT_BITMAP_174 {0x3, 0xf8, 0x0, 0xf, 0xfe, 0x0, 0x1c, 0xf, 0x0, 0x38, 0x3, 0x80, 0x73, 0xf9, 0xc0, 0x63, 0x1c, 0xc0, 0xe3, 0xc, 0xe0, 0xc3, 0xc, 0x60, 0xc3, 0x18, 0x60, 0xc3, 0xf0, 0x60, 0xc3, 0x30, 0x60, 0xc3, 0x18, 0x60, 0xe3, 0x18, 0x60, 0x63, 0xc, 0xe0, 0x70, 0x0, 0xc0, 0x38, 0x1, 0xc0, 0x1e, 0x3, 0x80, 0xf, 0xfe, 0x0, 0x3, 0xf8, 0x0}

/* macron (175) */
#define NXFONT_METRICS_175 {1, 7, 2, 1, 10, 0}
#define NXFONT_BITMAP_175 {0xfe, 0xfe}

/* degree (176) */
#define NXFONT_METRICS_176 {1, 8, 7, 0, 11, 0}
#define NXFONT_BITMAP_176 {0x3c, 0x66, 0xc3, 0xc3, 0xc3, 0x66, 0x3c}

/* plusminus (177) */
#define NXFONT_METRICS_177 {2, 11, 13, 2, 16, 0}
#define NXFONT_BITMAP_177 {0xe, 0x0, 0xe, 0x0, 0xe, 0x0, 0xe, 0x0, 0xff, 0xe0, 0xff, 0xe0, 0xe, 0x0, 0xe, 0x0, 0xe, 0x0, 0xe, 0x0, 0x0, 0x0, 0xff, 0xe0, 0xff, 0xe0}

/* twosuperior (178) */
#define NXFONT_METRICS_178 {1, 6, 10, 0, 11, 0}
#define NXFONT_BITMAP_178 {0x78, 0xfc, 0xcc, 0xc, 0x1c, 0x78, 0xe0, 0xc0, 0xfc, 0xfc}

/* threesuperior (179) */
#define NXFONT_METRICS_179 {1, 6, 10, 0, 11, 0}
#define NXFONT_BITMAP_179 {0x78, 0xfc, 0xcc, 0xc, 0x38, 0x38, 0xc, 0xcc, 0xfc, 0x78}

/* acute (180) */
#define NXFONT_METRICS_180 {1, 6, 4, 1, 10, 0}
#define NXFONT_BITMAP_180 {0x1c, 0x38, 0x70, 0xe0}

/* mu (181) */
#define NXFONT_METRICS_181 {2, 11, 19, 2, 15, 0}
#define NXFONT_BITMAP_181 {0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe1, 0xe0, 0xf3, 0xe0, 0xfe, 0xe0, 0xec, 0xe0, 0xe0, 0x0, 0xe0, 0x0, 0xe0, 0x0, 0xe0, 0x0, 0xe0, 0x0}

/* paragraph (182) */
#define NXFONT_METRICS_182 {2, 11, 24, 1, 10, 0}
#define NXFONT_BITMAP_182 {0xf, 0xe0, 0x3f, 0xe0, 0x7c, 0xc0, 0x7c, 0xc0, 0xfc, 0xc0, 0xfc, 0xc0, 0xfc, 0xc0, 0xfc, 0xc0, 0xfc, 0xc0, 0x7c, 0xc0, 0x7c, 0xc0, 0x3c, 0xc0, 0x1c, 0xc0, 0xc, 0xc0, 0xc, 0xc0, 0xc, 0xc0, 0xc, 0xc0, 0xc, 0xc0, 0xc, 0xc0, 0xc, 0xc0, 0xc, 0xc0, 0xc, 0xc0, 0xc, 0xc0, 0xc, 0xc0}

/* periodcentered (183) */
#define NXFONT_METRICS_183 {1, 3, 3, 2, 20, 0}
#define NXFONT_BITMAP_183 {0xe0, 0xe0, 0xe0}

/* cedilla (184) */
#define NXFONT_METRICS_184 {1, 6, 6, 1, 28, 0}
#define NXFONT_BITMAP_184 {0x70, 0x78, 0x1c, 0x1c, 0xfc, 0x78}

/* onesuperior (185) */
#define NXFONT_METRICS_185 {1, 4, 10, 1, 11, 0}
#define NXFONT_BITMAP_185 {0x30, 0x30, 0xf0, 0xf0, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30}

/* ordmasculine (186) */
#define NXFONT_METRICS_186 {1, 8, 12, 1, 10, 0}
#define NXFONT_BITMAP_186 {0x3c, 0x7e, 0xe7, 0xc3, 0xc3, 0xc3, 0xe7, 0x7e, 0x3c, 0x0, 0xff, 0xff}

/* guillemotright (187) */
#define NXFONT_METRICS_187 {2, 10, 8, 1, 18, 0}
#define NXFONT_BITMAP_187 {0xee, 0x0, 0x77, 0x0, 0x3b, 0x80, 0x1d, 0xc0, 0x1d, 0xc0, 0x3b, 0x80, 0x77, 0x0, 0xee, 0x0}

/* onequarter (188) */
#define NXFONT_METRICS_188 {3, 17, 18, 1, 11, 0}
#define NXFONT_BITMAP_188 {0x30, 0x18, 0x0, 0x30, 0x18, 0x0, 0xf0, 0x30, 0x0, 0xf0, 0x30, 0x0, 0x30, 0x60, 0x0, 0x30, 0x60, 0x0, 0x30, 0xc0, 0x0, 0x30, 0xc0, 0x0, 0x31, 0x86, 0x0, 0x31, 0x8e, 0x0, 0x3, 0x1e, 0x0, 0x3, 0x1e, 0x0, 0x6, 0x36, 0x0, 0x6, 0x66, 0x0, 0xc, 0x7f, 0x80, 0xc, 0x7f, 0x80, 0x18, 0x6, 0x0, 0x18, 0x6, 0x0}

/* onehalf (189) */
#define NXFONT_METRICS_189 {2, 16, 18, 1, 11, 0}
#define NXFONT_BITMAP_189 {0x30, 0x18, 0x30, 0x18, 0xf0, 0x30, 0xf0, 0x30, 0x30, 0x60, 0x30, 0x60, 0x30, 0xc0, 0x30, 0xc0, 0x31, 0x9e, 0x31, 0xbf, 0x3, 0x33, 0x3, 0x3, 0x6, 0x7, 0x6, 0x1e, 0xc, 0x38, 0xc, 0x30, 0x18, 0x3f, 0x18, 0x3f}

/* threequarters (190) */
#define NXFONT_METRICS_190 {3, 17, 18, 1, 11, 0}
#define NXFONT_BITMAP_190 {0x78, 0x18, 0x0, 0xfc, 0x18, 0x0, 0xcc, 0x30, 0x0, 0xc, 0x30, 0x0, 0x38, 0x60, 0x0, 0x38, 0x60, 0x0, 0xc, 0xc0, 0x0, 0xcc, 0xc0, 0x0, 0xfd, 0x86, 0x0, 0x79, 0x8e, 0x0, 0x3, 0x1e, 0x0, 0x3, 0x1e, 0x0, 0x6, 0x36, 0x0, 0x6, 0x66, 0x0, 0xc, 0x7f, 0x80, 0xc, 0x7f, 0x80, 0x18, 0x6, 0x0, 0x18, 0x6, 0x0}

/* questiondown (191) */
#define NXFONT_METRICS_191 {2, 11, 19, 2, 15, 0}
#define NXFONT_BITMAP_191 {0xe, 0x0, 0xe, 0x0, 0xe, 0x0, 0x0, 0x0, 0x0, 0x0, 0xe, 0x0, 0xe, 0x0, 0xe, 0x0, 0xe, 0x0, 0x1c, 0x0, 0x3c, 0x0, 0x78, 0x0, 0x70, 0x0, 0xf0, 0xe0, 0xe0, 0xe0, 0xe1, 0xe0, 0xf3, 0xc0, 0x7f, 0xc0, 0x3f, 0x0}

/* Agrave (192) */
#define NXFONT_METRICS_192 {2, 16, 24, 1, 5, 0}
#define NXFONT_BITMAP_192 {0xe, 0x0, 0x7, 0x0, 0x3, 0x80, 0x1, 0xc0, 0x0, 0x0, 0x3, 0xc0, 0x3, 0xc0, 0x7, 0xe0, 0x7, 0xe0, 0xe, 0x60, 0xe, 0x70, 0xe, 0x70, 0x1c, 0x38, 0x1c, 0x38, 0x1c, 0x38, 0x38, 0x1c, 0x38, 0x1c, 0x3f, 0xfc, 0x7f, 0xfe, 0x70, 0xe, 0x70, 0xe, 0xe0, 0x7, 0xe0, 0x7, 0xe0, 0x7}

/* Aacute (193) */
#define NXFONT_METRICS_193 {2, 16, 24, 1, 5, 0}
#define NXFONT_BITMAP_193 {0x0, 0x70, 0x0, 0xe0, 0x1, 0xc0, 0x3, 0x80, 0x0, 0x0, 0x3, 0xc0, 0x3, 0xc0, 0x7, 0xe0, 0x7, 0xe0, 0xe, 0x60, 0xe, 0x70, 0xe, 0x70, 0x1c, 0x38, 0x1c, 0x38, 0x1c, 0x38, 0x38, 0x1c, 0x38, 0x1c, 0x3f, 0xfc, 0x7f, 0xfe, 0x70, 0xe, 0x70, 0xe, 0xe0, 0x7, 0xe0, 0x7, 0xe0, 0x7}

/* Acircumflex (194) */
#define NXFONT_METRICS_194 {2, 16, 24, 1, 5, 0}
#define NXFONT_BITMAP_194 {0x1, 0xc0, 0x3, 0xe0, 0x7, 0x70, 0xe, 0x38, 0x0, 0x0, 0x3, 0xc0, 0x3, 0xc0, 0x7, 0xe0, 0x7, 0xe0, 0xe, 0x60, 0xe, 0x70, 0xe, 0x70, 0x1c, 0x38, 0x1c, 0x38, 0x1c, 0x38, 0x38, 0x1c, 0x38, 0x1c, 0x3f, 0xfc, 0x7f, 0xfe, 0x70, 0xe, 0x70, 0xe, 0xe0, 0x7, 0xe0, 0x7, 0xe0, 0x7}

/* Atilde (195) */
#define NXFONT_METRICS_195 {2, 16, 23, 1, 6, 0}
#define NXFONT_BITMAP_195 {0x7, 0x98, 0xf, 0xf8, 0xc, 0xf0, 0x0, 0x0, 0x3, 0xc0, 0x3, 0xc0, 0x7, 0xe0, 0x7, 0xe0, 0xe, 0x60, 0xe, 0x70, 0xe, 0x70, 0x1c, 0x38, 0x1c, 0x38, 0x1c, 0x38, 0x38, 0x1c, 0x38, 0x1c, 0x3f, 0xfc, 0x7f, 0xfe, 0x70, 0xe, 0x70, 0xe, 0xe0, 0x7, 0xe0, 0x7, 0xe0, 0x7}

/* Adieresis (196) */
#define NXFONT_METRICS_196 {2, 16, 23, 1, 6, 0}
#define NXFONT_BITMAP_196 {0xe, 0x70, 0xe, 0x70, 0x0, 0x0, 0x0, 0x0, 0x3, 0xc0, 0x3, 0xc0, 0x7, 0xe0, 0x7, 0xe0, 0xe, 0x60, 0xe, 0x70, 0xe, 0x70, 0x1c, 0x38, 0x1c, 0x38, 0x1c, 0x38, 0x38, 0x1c, 0x38, 0x1c, 0x3f, 0xfc, 0x7f, 0xfe, 0x70, 0xe, 0x70, 0xe, 0xe0, 0x7, 0xe0, 0x7, 0xe0, 0x7}

/* Aring (197) */
#define NXFONT_METRICS_197 {2, 16, 24, 1, 5, 0}
#define NXFONT_BITMAP_197 {0x3, 0xc0, 0x6, 0x60, 0x4, 0x20, 0x6, 0x60, 0x3, 0xc0, 0x3, 0xc0, 0x3, 0xc0, 0x7, 0xe0, 0x7, 0xe0, 0xe, 0x60, 0xe, 0x70, 0xe, 0x70, 0x1c, 0x38, 0x1c, 0x38, 0x1c, 0x38, 0x38, 0x1c, 0x38, 0x1c, 0x3f, 0xfc, 0x7f, 0xfe, 0x70, 0xe, 0x70, 0xe, 0xe0, 0x7, 0xe0, 0x7, 0xe0, 0x7}

/* AE (198) */
#define NXFONT_METRICS_198 {3, 22, 19, 1, 10, 0}
#define NXFONT_BITMAP_198 {0x3, 0xff, 0xf8, 0x3, 0xff, 0xf8, 0x7, 0x70, 0x0, 0x7, 0x70, 0x0, 0xe, 0x70, 0x0, 0xe, 0x70, 0x0, 0xe, 0x70, 0x0, 0x1c, 0x70, 0x0, 0x1c, 0x7f, 0xf0, 0x1c, 0x7f, 0xf0, 0x38, 0x70, 0x0, 0x38, 0x70, 0x0, 0x3f, 0xf0, 0x0, 0x7f, 0xf0, 0x0, 0x70, 0x70, 0x0, 0x70, 0x70, 0x0, 0xe0, 0x70, 0x0, 0xe0, 0x7f, 0xfc, 0xe0, 0x7f, 0xfc}

/* Ccedilla (199) */
#define NXFONT_METRICS_199 {2, 16, 24, 1, 10, 0}
#define NXFONT_BITMAP_199 {0x7, 0xf0, 0x1f, 0xfc, 0x3e, 0x3e, 0x78, 0xf, 0x70, 0x7, 0xf0, 0x0, 0xe0, 0x0, 0xe0, 0x0, 0xe0, 0x0, 0xe0, 0x0, 0xe0, 0x0, 0xe0, 0x0, 0xe0, 0x0, 0xf0, 0x7, 0x70, 0x7, 0x78, 0xf, 0x3e, 0x3e, 0x1f, 0xfc, 0x7, 0xf0, 0x3, 0xc0, 0x0, 0xe0, 0x0, 0xe0, 0x7, 0xe0, 0x3, 0xc0}

/* Egrave (200) */
#define NXFONT_METRICS_200 {2, 13, 24, 2, 5, 0}
#define NXFONT_BITMAP_200 {0x38, 0x0, 0x1c, 0x0, 0xe, 0x0, 0x7, 0x0, 0x0, 0x0, 0xff, 0xf0, 0xff, 0xf0, 0xe0, 0x0, 0xe0, 0x0, 0xe0, 0x0, 0xe0, 0x0, 0xe0, 0x0, 0xe0, 0x0, 0xff, 0xe0, 0xff, 0xe0, 0xe0, 0x0, 0xe0, 0x0, 0xe0, 0x0, 0xe0, 0x0, 0xe0, 0x0, 0xe0, 0x0, 0xe0, 0x0, 0xff, 0xf8, 0xff, 0xf8}

/* Eacute (201) */
#define NXFONT_METRICS_201 {2, 13, 24, 2, 5, 0}
#define NXFONT_BITMAP_201 {0x1, 0xc0, 0x3, 0x80, 0x7, 0x0, 0xe, 0x0, 0x0, 0x0, 0xff, 0xf0, 0xff, 0xf0, 0xe0, 0x0, 0xe0, 0x0, 0xe0, 0x0, 0xe0, 0x0, 0xe0, 0x0, 0xe0, 0x0, 0xff, 0xe0, 0xff, 0xe0, 0xe0, 0x0, 0xe0, 0x0, 0xe0, 0x0, 0xe0, 0x0, 0xe0, 0x0, 0xe0, 0x0, 0xe0, 0x0, 0xff, 0xf8, 0xff, 0xf8}

/* Ecircumflex (202) */
#define NXFONT_METRICS_202 {2, 13, 24, 2, 5, 0}
#define NXFONT_BITMAP_202 {0x7, 0x0, 0xf, 0x80, 0x1d, 0xc0, 0x38, 0xe0, 0x0, 0x0, 0xff, 0xf0, 0xff, 0xf0, 0xe0, 0x0, 0xe0, 0x0, 0xe0, 0x0, 0xe0, 0x0, 0xe0, 0x0, 0xe0, 0x0, 0xff, 0xe0, 0xff, 0xe0, 0xe0, 0x0, 0xe0, 0x0, 0xe0, 0x0, 0xe0, 0x0, 0xe0, 0x0, 0xe0, 0x0, 0xe0, 0x0, 0xff, 0xf8, 0xff, 0xf8}

/* Edieresis (203) */
#define NXFONT_METRICS_203 {2, 13, 23, 2, 6, 0}
#define NXFONT_BITMAP_203 {0x38, 0xe0, 0x38, 0xe0, 0x0, 0x0, 0x0, 0x0, 0xff, 0xf0, 0xff, 0xf0, 0xe0, 0x0, 0xe0, 0x0, 0xe0, 0x0, 0xe0, 0x0, 0xe0, 0x0, 0xe0, 0x0, 0xff, 0xe0, 0xff, 0xe0, 0xe0, 0x0, 0xe0, 0x0, 0xe0, 0x0, 0xe0, 0x0, 0xe0, 0x0, 0xe0, 0x0, 0xe0, 0x0, 0xff, 0xf8, 0xff, 0xf8}

/* Igrave (204) */
#define NXFONT_METRICS_204 {1, 6, 24, 0, 5, 0}
#define NXFONT_BITMAP_204 {0xe0, 0x70, 0x38, 0x1c, 0x0, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38}

/* Iacute (205) */
#define NXFONT_METRICS_205 {1, 6, 24, 1, 5, 0}
#define NXFONT_BITMAP_205 {0x1c, 0x38, 0x70, 0xe0, 0x0, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70}

/* Icircumflex (206) - NOTE: Xoffset should be -1, not 0. */
#define NXFONT_METRICS_206 {2, 9, 24, 0, 5, 0}
#define NXFONT_BITMAP_206 {0x1c, 0x0, 0x3e, 0x0, 0x77, 0x0, 0xe3, 0x80, 0x0, 0x0, 0x1c, 0x0, 0x1c, 0x0, 0x1c, 0x0, 0x1c, 0x0, 0x1c, 0x0, 0x1c, 0x0, 0x1c, 0x0, 0x1c, 0x0, 0x1c, 0x0, 0x1c, 0x0, 0x1c, 0x0, 0x1c, 0x0, 0x1c, 0x0, 0x1c, 0x0, 0x1c, 0x0, 0x1c, 0x0, 0x1c, 0x0, 0x1c, 0x0, 0x1c, 0x0}

/* Idieresis (207) */
#define NXFONT_METRICS_207 {1, 7, 23, 0, 6, 0}
#define NXFONT_BITMAP_207 {0xee, 0xee, 0x0, 0x0, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38}

/* Eth (208) - NOTE: Xoffset should be -1, not 0. */
#define NXFONT_METRICS_208 {3, 19, 19, 0, 10, 0}
#define NXFONT_BITMAP_208 {0x1f, 0xfc, 0x0, 0x1f, 0xff, 0x0, 0x1c, 0xf, 0x80, 0x1c, 0x3, 0xc0, 0x1c, 0x1, 0xc0, 0x1c, 0x1, 0xe0, 0x1c, 0x0, 0xe0, 0x1c, 0x0, 0xe0, 0xff, 0xc0, 0xe0, 0xff, 0xc0, 0xe0, 0x1c, 0x0, 0xe0, 0x1c, 0x0, 0xe0, 0x1c, 0x0, 0xe0, 0x1c, 0x1, 0xe0, 0x1c, 0x1, 0xc0, 0x1c, 0x3, 0xc0, 0x1c, 0xf, 0x80, 0x1f, 0xff, 0x0, 0x1f, 0xfc, 0x0}

/* Ntilde (209) */
#define NXFONT_METRICS_209 {2, 15, 23, 2, 6, 0}
#define NXFONT_BITMAP_209 {0xf, 0x30, 0x1f, 0xf0, 0x19, 0xe0, 0x0, 0x0, 0xe0, 0xe, 0xf0, 0xe, 0xf0, 0xe, 0xf8, 0xe, 0xf8, 0xe, 0xfc, 0xe, 0xee, 0xe, 0xee, 0xe, 0xe7, 0xe, 0xe3, 0x8e, 0xe3, 0x8e, 0xe1, 0xce, 0xe0, 0xce, 0xe0, 0xee, 0xe0, 0x7e, 0xe0, 0x3e, 0xe0, 0x3e, 0xe0, 0x1e, 0xe0, 0xe}

/* Ograve (210) */
#define NXFONT_METRICS_210 {3, 17, 24, 1, 5, 0}
#define NXFONT_BITMAP_210 {0xe, 0x0, 0x0, 0x7, 0x0, 0x0, 0x3, 0x80, 0x0, 0x1, 0xc0, 0x0, 0x0, 0x0, 0x0, 0x7, 0xf0, 0x0, 0x1f, 0xfc, 0x0, 0x3e, 0x3e, 0x0, 0x78, 0xf, 0x0, 0x70, 0x7, 0x0, 0xf0, 0x7, 0x80, 0xe0, 0x3, 0x80, 0xe0, 0x3, 0x80, 0xe0, 0x3, 0x80, 0xe0, 0x3, 0x80, 0xe0, 0x3, 0x80, 0xe0, 0x3, 0x80, 0xe0, 0x3, 0x80, 0xf0, 0x7, 0x80, 0x70, 0x7, 0x0, 0x78, 0xf, 0x0, 0x3e, 0x3e, 0x0, 0x1f, 0xfc, 0x0, 0x7, 0xf0, 0x0}

/* Oacute (211) */
#define NXFONT_METRICS_211 {3, 17, 24, 1, 5, 0}
#define NXFONT_BITMAP_211 {0x0, 0x38, 0x0, 0x0, 0x70, 0x0, 0x0, 0xe0, 0x0, 0x1, 0xc0, 0x0, 0x0, 0x0, 0x0, 0x7, 0xf0, 0x0, 0x1f, 0xfc, 0x0, 0x3e, 0x3e, 0x0, 0x78, 0xf, 0x0, 0x70, 0x7, 0x0, 0xf0, 0x7, 0x80, 0xe0, 0x3, 0x80, 0xe0, 0x3, 0x80, 0xe0, 0x3, 0x80, 0xe0, 0x3, 0x80, 0xe0, 0x3, 0x80, 0xe0, 0x3, 0x80, 0xe0, 0x3, 0x80, 0xf0, 0x7, 0x80, 0x70, 0x7, 0x0, 0x78, 0xf, 0x0, 0x3e, 0x3e, 0x0, 0x1f, 0xfc, 0x0, 0x7, 0xf0, 0x0}

/* Ocircumflex (212) */
#define NXFONT_METRICS_212 {3, 17, 24, 1, 5, 0}
#define NXFONT_BITMAP_212 {0x1, 0xc0, 0x0, 0x3, 0xe0, 0x0, 0x7, 0x70, 0x0, 0xe, 0x38, 0x0, 0x0, 0x0, 0x0, 0x7, 0xf0, 0x0, 0x1f, 0xfc, 0x0, 0x3e, 0x3e, 0x0, 0x78, 0xf, 0x0, 0x70, 0x7, 0x0, 0xf0, 0x7, 0x80, 0xe0, 0x3, 0x80, 0xe0, 0x3, 0x80, 0xe0, 0x3, 0x80, 0xe0, 0x3, 0x80, 0xe0, 0x3, 0x80, 0xe0, 0x3, 0x80, 0xe0, 0x3, 0x80, 0xf0, 0x7, 0x80, 0x70, 0x7, 0x0, 0x78, 0xf, 0x0, 0x3e, 0x3e, 0x0, 0x1f, 0xfc, 0x0, 0x7, 0xf0, 0x0}

/* Otilde (213) */
#define NXFONT_METRICS_213 {3, 17, 23, 1, 6, 0}
#define NXFONT_BITMAP_213 {0x7, 0x98, 0x0, 0xf, 0xf8, 0x0, 0xc, 0xf0, 0x0, 0x0, 0x0, 0x0, 0x7, 0xf0, 0x0, 0x1f, 0xfc, 0x0, 0x3e, 0x3e, 0x0, 0x78, 0xf, 0x0, 0x70, 0x7, 0x0, 0xf0, 0x7, 0x80, 0xe0, 0x3, 0x80, 0xe0, 0x3, 0x80, 0xe0, 0x3, 0x80, 0xe0, 0x3, 0x80, 0xe0, 0x3, 0x80, 0xe0, 0x3, 0x80, 0xe0, 0x3, 0x80, 0xf0, 0x7, 0x80, 0x70, 0x7, 0x0, 0x78, 0xf, 0x0, 0x3e, 0x3e, 0x0, 0x1f, 0xfc, 0x0, 0x7, 0xf0, 0x0}

/* Odieresis (214) */
#define NXFONT_METRICS_214 {3, 17, 23, 1, 6, 0}
#define NXFONT_BITMAP_214 {0xe, 0x38, 0x0, 0xe, 0x38, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x7, 0xf0, 0x0, 0x1f, 0xfc, 0x0, 0x3e, 0x3e, 0x0, 0x78, 0xf, 0x0, 0x70, 0x7, 0x0, 0xf0, 0x7, 0x80, 0xe0, 0x3, 0x80, 0xe0, 0x3, 0x80, 0xe0, 0x3, 0x80, 0xe0, 0x3, 0x80, 0xe0, 0x3, 0x80, 0xe0, 0x3, 0x80, 0xe0, 0x3, 0x80, 0xf0, 0x7, 0x80, 0x70, 0x7, 0x0, 0x78, 0xf, 0x0, 0x3e, 0x3e, 0x0, 0x1f, 0xfc, 0x0, 0x7, 0xf0, 0x0}

/* multiply (215) */
#define NXFONT_METRICS_215 {2, 12, 12, 1, 16, 0}
#define NXFONT_BITMAP_215 {0x40, 0x20, 0xe0, 0x70, 0x70, 0xe0, 0x39, 0xc0, 0x1f, 0x80, 0xf, 0x0, 0xf, 0x0, 0x1f, 0x80, 0x39, 0xc0, 0x70, 0xe0, 0xe0, 0x70, 0x40, 0x20}

/* Oslash (216) */
#define NXFONT_METRICS_216 {3, 19, 19, 0, 10, 0}
#define NXFONT_BITMAP_216 {0x3, 0xf8, 0x60, 0xf, 0xfe, 0xe0, 0x1f, 0x1f, 0xc0, 0x3c, 0x3, 0x80, 0x38, 0x7, 0x80, 0x78, 0xf, 0xc0, 0x70, 0x1d, 0xc0, 0x70, 0x39, 0xc0, 0x70, 0x71, 0xc0, 0x70, 0xe1, 0xc0, 0x71, 0xc1, 0xc0, 0x73, 0x81, 0xc0, 0x77, 0x1, 0xc0, 0x7e, 0x3, 0xc0, 0x3c, 0x3, 0x80, 0x3c, 0x7, 0x80, 0x7f, 0x1f, 0x0, 0xef, 0xfe, 0x0, 0xc3, 0xf8, 0x0}

/* Ugrave (217) */
#define NXFONT_METRICS_217 {2, 15, 24, 2, 5, 0}
#define NXFONT_BITMAP_217 {0xe, 0x0, 0x7, 0x0, 0x3, 0x80, 0x1, 0xc0, 0x0, 0x0, 0xe0, 0xe, 0xe0, 0xe, 0xe0, 0xe, 0xe0, 0xe, 0xe0, 0xe, 0xe0, 0xe, 0xe0, 0xe, 0xe0, 0xe, 0xe0, 0xe, 0xe0, 0xe, 0xe0, 0xe, 0xe0, 0xe, 0xe0, 0xe, 0xe0, 0xe, 0xf0, 0x1e, 0x70, 0x1c, 0x7c, 0x7c, 0x3f, 0xf8, 0xf, 0xe0}

/* Uacute (218) */
#define NXFONT_METRICS_218 {2, 15, 24, 2, 5, 0}
#define NXFONT_BITMAP_218 {0x0, 0x70, 0x0, 0xe0, 0x1, 0xc0, 0x3, 0x80, 0x0, 0x0, 0xe0, 0xe, 0xe0, 0xe, 0xe0, 0xe, 0xe0, 0xe, 0xe0, 0xe, 0xe0, 0xe, 0xe0, 0xe, 0xe0, 0xe, 0xe0, 0xe, 0xe0, 0xe, 0xe0, 0xe, 0xe0, 0xe, 0xe0, 0xe, 0xe0, 0xe, 0xf0, 0x1e, 0x70, 0x1c, 0x7c, 0x7c, 0x3f, 0xf8, 0xf, 0xe0}

/* Ucircumflex (219) */
#define NXFONT_METRICS_219 {2, 15, 24, 2, 5, 0}
#define NXFONT_BITMAP_219 {0x3, 0x80, 0x7, 0xc0, 0xe, 0xe0, 0x1c, 0x70, 0x0, 0x0, 0xe0, 0xe, 0xe0, 0xe, 0xe0, 0xe, 0xe0, 0xe, 0xe0, 0xe, 0xe0, 0xe, 0xe0, 0xe, 0xe0, 0xe, 0xe0, 0xe, 0xe0, 0xe, 0xe0, 0xe, 0xe0, 0xe, 0xe0, 0xe, 0xe0, 0xe, 0xf0, 0x1e, 0x70, 0x1c, 0x7c, 0x7c, 0x3f, 0xf8, 0xf, 0xe0}

/* Udieresis (220) */
#define NXFONT_METRICS_220 {2, 15, 23, 2, 6, 0}
#define NXFONT_BITMAP_220 {0x1c, 0x70, 0x1c, 0x70, 0x0, 0x0, 0x0, 0x0, 0xe0, 0xe, 0xe0, 0xe, 0xe0, 0xe, 0xe0, 0xe, 0xe0, 0xe, 0xe0, 0xe, 0xe0, 0xe, 0xe0, 0xe, 0xe0, 0xe, 0xe0, 0xe, 0xe0, 0xe, 0xe0, 0xe, 0xe0, 0xe, 0xe0, 0xe, 0xf0, 0x1e, 0x70, 0x1c, 0x7c, 0x7c, 0x3f, 0xf8, 0xf, 0xe0}

/* Yacute (221) */
#define NXFONT_METRICS_221 {2, 15, 24, 1, 5, 0}
#define NXFONT_BITMAP_221 {0x0, 0x70, 0x0, 0xe0, 0x1, 0xc0, 0x3, 0x80, 0x0, 0x0, 0xe0, 0xe, 0xf0, 0x1e, 0x70, 0x1c, 0x78, 0x3c, 0x38, 0x38, 0x3c, 0x78, 0x1c, 0x70, 0x1e, 0xf0, 0xe, 0xe0, 0xf, 0xe0, 0x7, 0xc0, 0x7, 0xc0, 0x3, 0x80, 0x3, 0x80, 0x3, 0x80, 0x3, 0x80, 0x3, 0x80, 0x3, 0x80, 0x3, 0x80}

/* Thorn (222) */
#define NXFONT_METRICS_222 {2, 14, 19, 2, 10, 0}
#define NXFONT_BITMAP_222 {0xe0, 0x0, 0xe0, 0x0, 0xe0, 0x0, 0xe0, 0x0, 0xff, 0xe0, 0xff, 0xf8, 0xe0, 0x38, 0xe0, 0x1c, 0xe0, 0x1c, 0xe0, 0x1c, 0xe0, 0x1c, 0xe0, 0x38, 0xff, 0xf8, 0xff, 0xf0, 0xe0, 0x0, 0xe0, 0x0, 0xe0, 0x0, 0xe0, 0x0, 0xe0, 0x0}

/* germandbls (223) */
#define NXFONT_METRICS_223 {2, 11, 19, 2, 10, 0}
#define NXFONT_BITMAP_223 {0x1e, 0x0, 0x7f, 0x80, 0xf3, 0x80, 0xe1, 0xc0, 0xe1, 0xc0, 0xe1, 0xc0, 0xe1, 0xc0, 0xe3, 0x80, 0xef, 0x0, 0xef, 0x80, 0xe3, 0xc0, 0xe1, 0xc0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe1, 0xc0, 0xef, 0xc0, 0xef, 0x80}

/* agrave (224) */
#define NXFONT_METRICS_224 {2, 12, 19, 1, 10, 0}
#define NXFONT_BITMAP_224 {0x1c, 0x0, 0xe, 0x0, 0x7, 0x0, 0x3, 0x80, 0x0, 0x0, 0x1f, 0x80, 0x3f, 0xc0, 0x71, 0xe0, 0x70, 0xe0, 0x0, 0xe0, 0x7, 0xe0, 0x3f, 0xe0, 0x7c, 0xe0, 0xf0, 0xe0, 0xe0, 0xe0, 0xe1, 0xe0, 0xf3, 0xe0, 0x7f, 0xf0, 0x3e, 0x70}

/* aacute (225) */
#define NXFONT_METRICS_225 {2, 12, 19, 1, 10, 0}
#define NXFONT_BITMAP_225 {0x1, 0xc0, 0x3, 0x80, 0x7, 0x0, 0xe, 0x0, 0x0, 0x0, 0x1f, 0x80, 0x3f, 0xc0, 0x71, 0xe0, 0x70, 0xe0, 0x0, 0xe0, 0x7, 0xe0, 0x3f, 0xe0, 0x7c, 0xe0, 0xf0, 0xe0, 0xe0, 0xe0, 0xe1, 0xe0, 0xf3, 0xe0, 0x7f, 0xf0, 0x3e, 0x70}

/* acircumflex (226) */
#define NXFONT_METRICS_226 {2, 12, 19, 1, 10, 0}
#define NXFONT_BITMAP_226 {0x7, 0x0, 0xf, 0x80, 0x1d, 0xc0, 0x38, 0xe0, 0x0, 0x0, 0x1f, 0x80, 0x3f, 0xc0, 0x71, 0xe0, 0x70, 0xe0, 0x0, 0xe0, 0x7, 0xe0, 0x3f, 0xe0, 0x7c, 0xe0, 0xf0, 0xe0, 0xe0, 0xe0, 0xe1, 0xe0, 0xf3, 0xe0, 0x7f, 0xf0, 0x3e, 0x70}

/* atilde (227) */
#define NXFONT_METRICS_227 {2, 12, 19, 1, 10, 0}
#define NXFONT_BITMAP_227 {0x3c, 0xc0, 0x7f, 0xc0, 0x67, 0x80, 0x0, 0x0, 0x0, 0x0, 0x1f, 0x80, 0x3f, 0xc0, 0x71, 0xe0, 0x70, 0xe0, 0x0, 0xe0, 0x7, 0xe0, 0x3f, 0xe0, 0x7c, 0xe0, 0xf0, 0xe0, 0xe0, 0xe0, 0xe1, 0xe0, 0xf3, 0xe0, 0x7f, 0xf0, 0x3e, 0x70}

/* adieresis (228) */
#define NXFONT_METRICS_228 {2, 12, 18, 1, 11, 0}
#define NXFONT_BITMAP_228 {0x39, 0xc0, 0x39, 0xc0, 0x0, 0x0, 0x0, 0x0, 0x1f, 0x80, 0x3f, 0xc0, 0x71, 0xe0, 0x70, 0xe0, 0x0, 0xe0, 0x7, 0xe0, 0x3f, 0xe0, 0x7c, 0xe0, 0xf0, 0xe0, 0xe0, 0xe0, 0xe1, 0xe0, 0xf3, 0xe0, 0x7f, 0xf0, 0x3e, 0x70}

/* aring (229) */
#define NXFONT_METRICS_229 {2, 12, 19, 1, 10, 0}
#define NXFONT_BITMAP_229 {0x7, 0x0, 0xd, 0x80, 0x8, 0x80, 0xd, 0x80, 0x7, 0x0, 0x1f, 0x80, 0x3f, 0xc0, 0x71, 0xe0, 0x70, 0xe0, 0x0, 0xe0, 0x7, 0xe0, 0x3f, 0xe0, 0x7c, 0xe0, 0xf0, 0xe0, 0xe0, 0xe0, 0xe1, 0xe0, 0xf3, 0xe0, 0x7f, 0xf0, 0x3e, 0x70}

/* ae (230) */
#define NXFONT_METRICS_230 {3, 20, 14, 1, 15, 0}
#define NXFONT_BITMAP_230 {0x1f, 0x8f, 0x0, 0x3f, 0xff, 0xc0, 0x71, 0xf9, 0xe0, 0x70, 0xf0, 0xe0, 0x0, 0xe0, 0x70, 0x7, 0xe0, 0x70, 0x3f, 0xff, 0xf0, 0x7c, 0xff, 0xf0, 0xf0, 0xe0, 0x0, 0xe0, 0xe0, 0x0, 0xe1, 0xf0, 0x70, 0xf3, 0xf8, 0xf0, 0x7f, 0x3f, 0xe0, 0x3e, 0xf, 0x80}

/* ccedilla (231) */
#define NXFONT_METRICS_231 {2, 11, 19, 1, 15, 0}
#define NXFONT_BITMAP_231 {0x1f, 0x80, 0x3f, 0xc0, 0x79, 0xe0, 0x70, 0xe0, 0xe0, 0x0, 0xe0, 0x0, 0xe0, 0x0, 0xe0, 0x0, 0xe0, 0x0, 0xe0, 0x0, 0x70, 0xe0, 0x79, 0xe0, 0x3f, 0xc0, 0x1f, 0x80, 0x1e, 0x0, 0x7, 0x0, 0x7, 0x0, 0x3f, 0x0, 0x1e, 0x0}

/* egrave (232) */
#define NXFONT_METRICS_232 {2, 12, 19, 1, 10, 0}
#define NXFONT_BITMAP_232 {0x1c, 0x0, 0xe, 0x0, 0x7, 0x0, 0x3, 0x80, 0x0, 0x0, 0xf, 0x0, 0x3f, 0xc0, 0x79, 0xe0, 0x70, 0xe0, 0xe0, 0x70, 0xe0, 0x70, 0xff, 0xf0, 0xff, 0xf0, 0xe0, 0x0, 0xe0, 0x0, 0x70, 0x70, 0x78, 0xf0, 0x3f, 0xe0, 0xf, 0x80}

/* eacute (233) */
#define NXFONT_METRICS_233 {2, 12, 19, 1, 10, 0}
#define NXFONT_BITMAP_233 {0x3, 0x80, 0x7, 0x0, 0xe, 0x0, 0x1c, 0x0, 0x0, 0x0, 0xf, 0x0, 0x3f, 0xc0, 0x79, 0xe0, 0x70, 0xe0, 0xe0, 0x70, 0xe0, 0x70, 0xff, 0xf0, 0xff, 0xf0, 0xe0, 0x0, 0xe0, 0x0, 0x70, 0x70, 0x78, 0xf0, 0x3f, 0xe0, 0xf, 0x80}

/* ecircumflex (234) */
#define NXFONT_METRICS_234 {2, 12, 19, 1, 10, 0}
#define NXFONT_BITMAP_234 {0x7, 0x0, 0xf, 0x80, 0x1d, 0xc0, 0x38, 0xe0, 0x0, 0x0, 0xf, 0x0, 0x3f, 0xc0, 0x79, 0xe0, 0x70, 0xe0, 0xe0, 0x70, 0xe0, 0x70, 0xff, 0xf0, 0xff, 0xf0, 0xe0, 0x0, 0xe0, 0x0, 0x70, 0x70, 0x78, 0xf0, 0x3f, 0xe0, 0xf, 0x80}

/* edieresis (235) */
#define NXFONT_METRICS_235 {2, 12, 18, 1, 11, 0}
#define NXFONT_BITMAP_235 {0x39, 0xc0, 0x39, 0xc0, 0x0, 0x0, 0x0, 0x0, 0xf, 0x0, 0x3f, 0xc0, 0x79, 0xe0, 0x70, 0xe0, 0xe0, 0x70, 0xe0, 0x70, 0xff, 0xf0, 0xff, 0xf0, 0xe0, 0x0, 0xe0, 0x0, 0x70, 0x70, 0x78, 0xf0, 0x3f, 0xe0, 0xf, 0x80}

/* igrave (236) */
#define NXFONT_METRICS_236 {1, 6, 19, 0, 10, 0}
#define NXFONT_BITMAP_236 {0xe0, 0x70, 0x38, 0x1c, 0x0, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38}

/* iacute (237) */
#define NXFONT_METRICS_237 {1, 6, 19, 1, 10, 0}
#define NXFONT_BITMAP_237 {0x1c, 0x38, 0x70, 0xe0, 0x0, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70}

/* icircumflex (238) - NOTE: Xoffset should be -1, not 0. */
#define NXFONT_METRICS_238 {2, 9, 19, 0, 10, 0}
#define NXFONT_BITMAP_238 {0x1c, 0x0, 0x3e, 0x0, 0x77, 0x0, 0xe3, 0x80, 0x0, 0x0, 0x1c, 0x0, 0x1c, 0x0, 0x1c, 0x0, 0x1c, 0x0, 0x1c, 0x0, 0x1c, 0x0, 0x1c, 0x0, 0x1c, 0x0, 0x1c, 0x0, 0x1c, 0x0, 0x1c, 0x0, 0x1c, 0x0, 0x1c, 0x0, 0x1c, 0x0}

/* idieresis (239) */
#define NXFONT_METRICS_239 {1, 7, 18, 0, 11, 0}
#define NXFONT_BITMAP_239 {0xee, 0xee, 0x0, 0x0, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38}

/* eth (240) */
#define NXFONT_METRICS_240 {2, 12, 19, 1, 10, 0}
#define NXFONT_BITMAP_240 {0x70, 0x0, 0x1d, 0xc0, 0x7, 0x0, 0x1f, 0x0, 0x61, 0x80, 0xf, 0xc0, 0x3f, 0xc0, 0x79, 0xe0, 0x70, 0xe0, 0xe0, 0x70, 0xe0, 0x70, 0xe0, 0x70, 0xe0, 0x70, 0xe0, 0x70, 0xe0, 0x70, 0x70, 0xe0, 0x79, 0xe0, 0x3f, 0xc0, 0xf, 0x0}

/* ntilde (241) */
#define NXFONT_METRICS_241 {2, 11, 19, 2, 10, 0}
#define NXFONT_BITMAP_241 {0x3c, 0xc0, 0x7f, 0xc0, 0x67, 0x80, 0x0, 0x0, 0x0, 0x0, 0xef, 0x80, 0xff, 0xc0, 0xf1, 0xc0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0}

/* ograve (242) */
#define NXFONT_METRICS_242 {2, 12, 19, 1, 10, 0}
#define NXFONT_BITMAP_242 {0x1c, 0x0, 0xe, 0x0, 0x7, 0x0, 0x3, 0x80, 0x0, 0x0, 0xf, 0x0, 0x3f, 0xc0, 0x79, 0xe0, 0x70, 0xe0, 0xe0, 0x70, 0xe0, 0x70, 0xe0, 0x70, 0xe0, 0x70, 0xe0, 0x70, 0xe0, 0x70, 0x70, 0xe0, 0x79, 0xe0, 0x3f, 0xc0, 0xf, 0x0}

/* oacute (243) */
#define NXFONT_METRICS_243 {2, 12, 19, 1, 10, 0}
#define NXFONT_BITMAP_243 {0x3, 0x80, 0x7, 0x0, 0xe, 0x0, 0x1c, 0x0, 0x0, 0x0, 0xf, 0x0, 0x3f, 0xc0, 0x79, 0xe0, 0x70, 0xe0, 0xe0, 0x70, 0xe0, 0x70, 0xe0, 0x70, 0xe0, 0x70, 0xe0, 0x70, 0xe0, 0x70, 0x70, 0xe0, 0x79, 0xe0, 0x3f, 0xc0, 0xf, 0x0}

/* ocircumflex (244) */
#define NXFONT_METRICS_244 {2, 12, 19, 1, 10, 0}
#define NXFONT_BITMAP_244 {0xe, 0x0, 0x1f, 0x0, 0x3b, 0x80, 0x71, 0xc0, 0x0, 0x0, 0xf, 0x0, 0x3f, 0xc0, 0x79, 0xe0, 0x70, 0xe0, 0xe0, 0x70, 0xe0, 0x70, 0xe0, 0x70, 0xe0, 0x70, 0xe0, 0x70, 0xe0, 0x70, 0x70, 0xe0, 0x79, 0xe0, 0x3f, 0xc0, 0xf, 0x0}

/* otilde (245) */
#define NXFONT_METRICS_245 {2, 12, 19, 1, 10, 0}
#define NXFONT_BITMAP_245 {0x3c, 0xc0, 0x7f, 0xc0, 0x67, 0x80, 0x0, 0x0, 0x0, 0x0, 0xf, 0x0, 0x3f, 0xc0, 0x79, 0xe0, 0x70, 0xe0, 0xe0, 0x70, 0xe0, 0x70, 0xe0, 0x70, 0xe0, 0x70, 0xe0, 0x70, 0xe0, 0x70, 0x70, 0xe0, 0x79, 0xe0, 0x3f, 0xc0, 0xf, 0x0}

/* odieresis (246) */
#define NXFONT_METRICS_246 {2, 12, 18, 1, 11, 0}
#define NXFONT_BITMAP_246 {0x39, 0xc0, 0x39, 0xc0, 0x0, 0x0, 0x0, 0x0, 0xf, 0x0, 0x3f, 0xc0, 0x79, 0xe0, 0x70, 0xe0, 0xe0, 0x70, 0xe0, 0x70, 0xe0, 0x70, 0xe0, 0x70, 0xe0, 0x70, 0xe0, 0x70, 0x70, 0xe0, 0x79, 0xe0, 0x3f, 0xc0, 0xf, 0x0}

/* divide (247) */
#define NXFONT_METRICS_247 {2, 11, 12, 2, 16, 0}
#define NXFONT_BITMAP_247 {0xe, 0x0, 0xe, 0x0, 0xe, 0x0, 0x0, 0x0, 0x0, 0x0, 0xff, 0xe0, 0xff, 0xe0, 0x0, 0x0, 0x0, 0x0, 0xe, 0x0, 0xe, 0x0, 0xe, 0x0}

/* oslash (248) */
#define NXFONT_METRICS_248 {2, 14, 14, 0, 15, 0}
#define NXFONT_BITMAP_248 {0x7, 0x8c, 0x1f, 0xfc, 0x3c, 0xf8, 0x38, 0x70, 0x70, 0xf8, 0x71, 0xf8, 0x73, 0xb8, 0x77, 0x38, 0x7e, 0x38, 0x7c, 0x38, 0x38, 0x70, 0x7c, 0xf0, 0xff, 0xe0, 0xc7, 0x80}

/* ugrave (249) */
#define NXFONT_METRICS_249 {2, 11, 19, 2, 10, 0}
#define NXFONT_BITMAP_249 {0x38, 0x0, 0x1c, 0x0, 0xe, 0x0, 0x7, 0x0, 0x0, 0x0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe1, 0xe0, 0x73, 0xe0, 0x7e, 0xe0, 0x1c, 0xe0}

/* uacute (250) */
#define NXFONT_METRICS_250 {2, 11, 19, 2, 10, 0}
#define NXFONT_BITMAP_250 {0x3, 0x80, 0x7, 0x0, 0xe, 0x0, 0x1c, 0x0, 0x0, 0x0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe1, 0xe0, 0x73, 0xe0, 0x7e, 0xe0, 0x1c, 0xe0}

/* ucircumflex (251) */
#define NXFONT_METRICS_251 {2, 11, 19, 2, 10, 0}
#define NXFONT_BITMAP_251 {0xe, 0x0, 0x1f, 0x0, 0x3b, 0x80, 0x71, 0xc0, 0x0, 0x0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe1, 0xe0, 0x73, 0xe0, 0x7e, 0xe0, 0x1c, 0xe0}

/* udieresis (252) */
#define NXFONT_METRICS_252 {2, 11, 18, 2, 11, 0}
#define NXFONT_BITMAP_252 {0x39, 0xc0, 0x39, 0xc0, 0x0, 0x0, 0x0, 0x0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe1, 0xe0, 0x73, 0xe0, 0x7e, 0xe0, 0x1c, 0xe0}

/* yacute (253) */
#define NXFONT_METRICS_253 {2, 13, 24, 1, 10, 0}
#define NXFONT_BITMAP_253 {0x0, 0xe0, 0x1, 0xc0, 0x3, 0x80, 0x7, 0x0, 0x0, 0x0, 0xe0, 0x38, 0xe0, 0x38, 0x70, 0x38, 0x78, 0x70, 0x38, 0x70, 0x3c, 0xf0, 0x1c, 0xe0, 0x1c, 0xe0, 0xf, 0xc0, 0xf, 0xc0, 0x7, 0xc0, 0x7, 0x80, 0x3, 0x80, 0x3, 0x80, 0x7, 0x0, 0x7, 0x0, 0xe, 0x0, 0x3e, 0x0, 0x3c, 0x0}

/* thorn (254) */
#define NXFONT_METRICS_254 {2, 12, 24, 2, 10, 0}
#define NXFONT_BITMAP_254 {0xe0, 0x0, 0xe0, 0x0, 0xe0, 0x0, 0xe0, 0x0, 0xe0, 0x0, 0xef, 0x80, 0xff, 0xc0, 0xf9, 0xe0, 0xf0, 0xe0, 0xe0, 0x70, 0xe0, 0x70, 0xe0, 0x70, 0xe0, 0x70, 0xe0, 0x70, 0xe0, 0x70, 0xf0, 0xe0, 0xf9, 0xe0, 0xff, 0xc0, 0xef, 0x80, 0xe0, 0x0, 0xe0, 0x0, 0xe0, 0x0, 0xe0, 0x0, 0xe0, 0x0}

/* ydieresis (255) */
#define NXFONT_METRICS_255 {2, 13, 23, 1, 11, 0}
#define NXFONT_BITMAP_255 {0x1c, 0xe0, 0x1c, 0xe0, 0x0, 0x0, 0x0, 0x0, 0xe0, 0x38, 0xe0, 0x38, 0x70, 0x38, 0x78, 0x70, 0x38, 0x70, 0x3c, 0xf0, 0x1c, 0xe0, 0x1c, 0xe0, 0xf, 0xc0, 0xf, 0xc0, 0x7, 0xc0, 0x7, 0x80, 0x3, 0x80, 0x3, 0x80, 0x7, 0x0, 0x7, 0x0, 0xe, 0x0, 0x3e, 0x0, 0x3c, 0x0}

/****************************************************************************
 * Public Types
 ****************************************************************************/

/****************************************************************************
 * Public Data
 ****************************************************************************/

#undef EXTERN
#if defined(__cplusplus)
#define EXTERN extern "C"
extern "C" {
#else
#define EXTERN extern
#endif

/****************************************************************************
 * Public Functions
 ****************************************************************************/

#undef EXTERN
#if defined(__cplusplus)
}
#endif

#endif /* __LIBNX_NXFONTS_NXFONTS_SANS28X37B_H */
