/*
 * Decompiled with CFR 0.152.
 */
package org.asteriskjava.live.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import org.asteriskjava.live.AgentState;
import org.asteriskjava.live.AsteriskAgent;
import org.asteriskjava.live.ManagerCommunicationException;
import org.asteriskjava.live.internal.AsteriskAgentImpl;
import org.asteriskjava.live.internal.AsteriskServerImpl;
import org.asteriskjava.lock.LockableMap;
import org.asteriskjava.lock.Locker;
import org.asteriskjava.manager.ResponseEvents;
import org.asteriskjava.manager.action.AgentsAction;
import org.asteriskjava.manager.event.AgentCallbackLoginEvent;
import org.asteriskjava.manager.event.AgentCallbackLogoffEvent;
import org.asteriskjava.manager.event.AgentCalledEvent;
import org.asteriskjava.manager.event.AgentCompleteEvent;
import org.asteriskjava.manager.event.AgentConnectEvent;
import org.asteriskjava.manager.event.AgentLoginEvent;
import org.asteriskjava.manager.event.AgentLogoffEvent;
import org.asteriskjava.manager.event.AgentsEvent;
import org.asteriskjava.manager.event.ManagerEvent;
import org.asteriskjava.util.Log;
import org.asteriskjava.util.LogFactory;

public class AgentManager {
    private final Log logger = LogFactory.getLog(this.getClass());
    private final AsteriskServerImpl server;
    private final LockableMap<String, AsteriskAgentImpl> agents;
    private final LockableMap<String, AsteriskAgentImpl> ringingAgents;

    AgentManager(AsteriskServerImpl asteriskServerImpl) {
        this.server = asteriskServerImpl;
        this.agents = new LockableMap(new HashMap());
        this.ringingAgents = new LockableMap(new HashMap());
    }

    void initialize() throws ManagerCommunicationException {
        ResponseEvents re = this.server.sendEventGeneratingAction(new AgentsAction());
        for (ManagerEvent managerEvent : re.getEvents()) {
            if (!(managerEvent instanceof AgentsEvent)) continue;
            this.logger.info(managerEvent);
            this.handleAgentsEvent((AgentsEvent)managerEvent);
        }
    }

    void disconnected() {
        try (Locker.LockCloser closer = this.agents.withLock();){
            this.agents.clear();
        }
    }

    void handleAgentsEvent(AgentsEvent event) {
        AsteriskAgentImpl agent = new AsteriskAgentImpl(this.server, event.getName(), "Agent/" + event.getAgent(), AgentState.valueOf(event.getStatus()));
        this.logger.info("Adding agent " + agent.getName() + "(" + agent.getAgentId() + ")");
        this.addAgent(agent);
    }

    private void addAgent(AsteriskAgentImpl agent) {
        try (Locker.LockCloser closer = this.agents.withLock();){
            this.agents.put(agent.getAgentId(), agent);
        }
        this.server.fireNewAgent(agent);
    }

    AsteriskAgentImpl getAgentByAgentId(String agentId) {
        try (Locker.LockCloser closer = this.agents.withLock();){
            AsteriskAgentImpl asteriskAgentImpl = this.agents.get(agentId);
            return asteriskAgentImpl;
        }
    }

    void handleAgentCalledEvent(AgentCalledEvent event) {
        AsteriskAgentImpl agent = this.getAgentByAgentId(event.getAgentCalled());
        if (agent == null) {
            this.logger.error("Ignored AgentCalledEvent for unknown agent " + event.getAgentCalled());
            return;
        }
        this.updateRingingAgents(event.getChannelCalling(), agent);
        this.updateAgentState(agent, AgentState.AGENT_RINGING);
    }

    private void updateAgentState(AsteriskAgentImpl agent, AgentState newState) {
        this.logger.info("Set state of agent " + agent.getAgentId() + " to " + (Object)((Object)newState));
        try (Locker.LockCloser closer = agent.withLock();){
            agent.updateState(newState);
        }
    }

    private void updateRingingAgents(String channelCalling, AsteriskAgentImpl agent) {
        try (Locker.LockCloser closer = this.ringingAgents.withLock();){
            if (this.ringingAgents.containsKey(channelCalling)) {
                this.updateAgentState(this.ringingAgents.get(channelCalling), AgentState.AGENT_IDLE);
            }
            this.ringingAgents.put(channelCalling, agent);
        }
    }

    void handleAgentConnectEvent(AgentConnectEvent event) {
        AsteriskAgentImpl agent = this.getAgentByAgentId(event.getChannel());
        if (agent == null) {
            this.logger.error("Ignored AgentConnectEvent for unknown agent " + event.getChannel());
            return;
        }
        agent.updateState(AgentState.AGENT_ONCALL);
    }

    void handleAgentLoginEvent(AgentLoginEvent event) {
        AsteriskAgentImpl agent = this.getAgentByAgentId("Agent/" + event.getAgent());
        if (agent == null) {
            try (Locker.LockCloser closer = this.agents.withLock();){
                this.logger.error("Ignored AgentLoginEvent for unknown agent " + event.getAgent() + ". Agents: " + this.agents.values().toString());
            }
            return;
        }
        agent.updateState(AgentState.AGENT_IDLE);
    }

    void handleAgentLogoffEvent(AgentLogoffEvent event) {
        AsteriskAgentImpl agent = this.getAgentByAgentId("Agent/" + event.getAgent());
        if (agent == null) {
            this.logger.error("Ignored AgentLogoffEvent for unknown agent " + event.getAgent() + ". Agents: " + this.agents.values().toString());
            return;
        }
        agent.updateState(AgentState.AGENT_LOGGEDOFF);
    }

    void handleAgentCallbackLoginEvent(AgentCallbackLoginEvent event) {
        AsteriskAgentImpl agent = this.getAgentByAgentId("Agent/" + event.getAgent());
        if (agent == null) {
            try (Locker.LockCloser closer = this.agents.withLock();){
                this.logger.error("Ignored AgentCallbackLoginEvent for unknown agent " + event.getAgent() + ". Agents: " + this.agents.values().toString());
            }
            return;
        }
        agent.updateState(AgentState.AGENT_IDLE);
    }

    void handleAgentCallbackLogoffEvent(AgentCallbackLogoffEvent event) {
        AsteriskAgentImpl agent = this.getAgentByAgentId("Agent/" + event.getAgent());
        if (agent == null) {
            this.logger.error("Ignored AgentCallbackLogoffEvent for unknown agent " + event.getAgent() + ". Agents: " + this.agents.values().toString());
            return;
        }
        agent.updateState(AgentState.AGENT_LOGGEDOFF);
    }

    Collection<AsteriskAgent> getAgents() {
        ArrayList<AsteriskAgent> copy;
        try (Locker.LockCloser closer = this.agents.withLock();){
            copy = new ArrayList<AsteriskAgent>(this.agents.values());
        }
        return copy;
    }

    void handleAgentCompleteEvent(AgentCompleteEvent event) {
        AsteriskAgentImpl agent = this.getAgentByAgentId(event.getChannel());
        if (agent == null) {
            this.logger.error("Ignored AgentCompleteEvent for unknown agent " + event.getChannel());
            return;
        }
        agent.updateState(AgentState.AGENT_IDLE);
    }
}

