/*
 * Decompiled with CFR 0.152.
 */
package org.asteriskjava.pbx.internal.asterisk;

import org.asteriskjava.pbx.CallerID;
import org.asteriskjava.pbx.PBXFactory;

public class CallerIDImpl
implements CallerID {
    private final String number;
    private final String name;
    private boolean hideCallerID = false;

    public CallerIDImpl(String number, String name) {
        this.number = number == null ? "" : number.trim();
        this.name = name == null ? "" : name.trim();
    }

    @Override
    public String getNumber() {
        return this.number;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public static CallerID buildFromComponents(String firstname, String lastname, String number) {
        String name = "";
        if (firstname != null) {
            name = name + firstname.trim();
        }
        if (lastname != null) {
            if (name.length() > 0) {
                name = name + " ";
            }
            name = name + lastname.trim();
        }
        return PBXFactory.getActivePBX().buildCallerID(number, name);
    }

    public String formatted() {
        String callerID = "";
        if (this.name != null) {
            callerID = callerID + this.name;
        }
        if (this.number != null) {
            if (callerID.length() > 1) {
                callerID = callerID + " ";
            }
            callerID = callerID + "<" + this.number + ">";
        }
        return callerID;
    }

    @Override
    public void setHideCallerID(boolean hide) {
        this.hideCallerID = hide;
    }

    @Override
    public boolean isHideCallerID() {
        return this.hideCallerID;
    }

    public String toString() {
        return this.formatted();
    }

    @Override
    public boolean isUnknown() {
        return this.number.length() == 0 || this.number.compareToIgnoreCase("unknown") == 0;
    }
}

