/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.codec;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.builtin.FixedSizeTypesCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.StringCodec;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;

public final class MCForceCloseCPSessionCodec {
    public static final int REQUEST_MESSAGE_TYPE = 0x202400;
    public static final int RESPONSE_MESSAGE_TYPE = 2106369;
    private static final int REQUEST_SESSION_ID_FIELD_OFFSET = 16;
    private static final int REQUEST_INITIAL_FRAME_SIZE = 24;
    private static final int RESPONSE_RESULT_FIELD_OFFSET = 13;
    private static final int RESPONSE_INITIAL_FRAME_SIZE = 14;

    private MCForceCloseCPSessionCodec() {
    }

    public static ClientMessage encodeRequest(String groupName, long sessionId) {
        ClientMessage clientMessage = ClientMessage.createForEncode();
        clientMessage.setRetryable(false);
        clientMessage.setOperationName("MC.ForceCloseCPSession");
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[24], 49152);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 0, 0x202400);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 12, -1);
        FixedSizeTypesCodec.encodeLong(initialFrame.content, 16, sessionId);
        clientMessage.add(initialFrame);
        StringCodec.encode(clientMessage, groupName);
        return clientMessage;
    }

    public static RequestParameters decodeRequest(ClientMessage clientMessage) {
        ClientMessage.ForwardFrameIterator iterator = clientMessage.frameIterator();
        RequestParameters request = new RequestParameters();
        ClientMessage.Frame initialFrame = iterator.next();
        request.sessionId = FixedSizeTypesCodec.decodeLong(initialFrame.content, 16);
        request.groupName = StringCodec.decode(iterator);
        return request;
    }

    public static ClientMessage encodeResponse(boolean result) {
        ClientMessage clientMessage = ClientMessage.createForEncode();
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[14], 49152);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 0, 2106369);
        FixedSizeTypesCodec.encodeBoolean(initialFrame.content, 13, result);
        clientMessage.add(initialFrame);
        return clientMessage;
    }

    public static boolean decodeResponse(ClientMessage clientMessage) {
        ClientMessage.ForwardFrameIterator iterator = clientMessage.frameIterator();
        ClientMessage.Frame initialFrame = iterator.next();
        return FixedSizeTypesCodec.decodeBoolean(initialFrame.content, 13);
    }

    @SuppressFBWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"})
    public static class RequestParameters {
        public String groupName;
        public long sessionId;
    }
}

