/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.util.phonehome;

import com.hazelcast.instance.impl.Node;
import com.hazelcast.internal.util.ExceptionUtil;
import com.hazelcast.internal.util.ServiceLoader;
import com.hazelcast.internal.util.phonehome.MetricsCollectionContext;
import com.hazelcast.internal.util.phonehome.MetricsProvider;
import com.hazelcast.logging.ILogger;
import com.hazelcast.spi.properties.ClusterProperty;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public class PhoneHome {
    private static final String FALSE = "false";
    private static final String DEFAULT_BASE_PHONE_HOME_URL = "https://phonehome.hazelcast.com/ping";
    private static final String FACTORY_ID = MetricsProvider.class.getName();
    protected final Node node;
    volatile ScheduledFuture<?> phoneHomeFuture;
    private final ILogger logger;
    private final String basePhoneHomeUrl;
    private final List<MetricsProvider> metricsProviders = new ArrayList<MetricsProvider>();

    public PhoneHome(Node node) {
        this(node, DEFAULT_BASE_PHONE_HOME_URL);
    }

    PhoneHome(Node node, String basePhoneHomeUrl) {
        this.node = node;
        this.logger = node.getLogger(PhoneHome.class);
        this.basePhoneHomeUrl = basePhoneHomeUrl;
        try {
            ServiceLoader.iterator(MetricsProvider.class, FACTORY_ID, node.getConfigClassLoader()).forEachRemaining(this.metricsProviders::add);
        }
        catch (Exception e) {
            ExceptionUtil.sneakyThrow(e);
        }
    }

    public void start() {
        if (!PhoneHome.isPhoneHomeEnabled(this.node)) {
            return;
        }
        try {
            this.phoneHomeFuture = this.node.nodeEngine.getExecutionService().scheduleWithRepetition("PhoneHome", () -> this.phoneHome(false), 0L, 1L, TimeUnit.DAYS);
        }
        catch (RejectedExecutionException e) {
            this.logger.warning("Could not schedule phone home task! Most probably Hazelcast failed to start.");
        }
    }

    public void shutdown() {
        if (this.phoneHomeFuture != null) {
            this.phoneHomeFuture.cancel(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void postPhoneHomeData(String requestBody) {
        HttpURLConnection conn = null;
        OutputStreamWriter writer = null;
        try {
            URL url = URI.create(this.basePhoneHomeUrl).toURL();
            conn = (HttpURLConnection)url.openConnection();
            conn.setConnectTimeout(2000);
            conn.setReadTimeout(2000);
            conn.setRequestMethod("POST");
            conn.setDoOutput(true);
            conn.connect();
            writer = new OutputStreamWriter(conn.getOutputStream(), StandardCharsets.UTF_8);
            writer.write(requestBody);
            writer.flush();
            conn.getContent();
        }
        catch (Exception exception) {
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException iOException) {}
            }
            if (conn != null) {
                conn.disconnect();
            }
        }
    }

    public Map<String, String> phoneHome(boolean pretend) {
        MetricsCollectionContext context = new MetricsCollectionContext();
        this.collectMetrics(context);
        if (!pretend) {
            this.postPhoneHomeData(context.getQueryString());
        }
        return context.getParameters();
    }

    public void collectMetrics(MetricsCollectionContext context) {
        for (MetricsProvider metricsProvider : this.metricsProviders) {
            try {
                metricsProvider.provideMetrics(this.node, context);
            }
            catch (Exception e) {
                this.logger.warning("Some metrics were not recorded ", e);
            }
        }
    }

    public static boolean isPhoneHomeEnabled(Node node) {
        if (!node.getProperties().getBoolean(ClusterProperty.PHONE_HOME_ENABLED)) {
            return false;
        }
        return !FALSE.equals(System.getenv("HZ_PHONE_HOME_ENABLED"));
    }
}

