/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.recordstore;

import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.serialization.SerializableByConvention;
import com.hazelcast.internal.serialization.SerializationService;
import com.hazelcast.internal.util.SampleableConcurrentHashMap;
import com.hazelcast.map.impl.record.Record;
import com.hazelcast.map.impl.recordstore.LazyEvictableEntryView;
import com.hazelcast.map.impl.recordstore.expiry.ExpirySystem;

@SerializableByConvention
public class StorageSCHM<R extends Record>
extends SampleableConcurrentHashMap<Data, R> {
    private static final long serialVersionUID = -1133966339806826032L;
    private static final int DEFAULT_INITIAL_CAPACITY = 256;
    private final transient SerializationService serializationService;
    private final transient ExpirySystem expirySystem;

    public StorageSCHM(SerializationService serializationService, ExpirySystem expirySystem) {
        super(256);
        this.serializationService = serializationService;
        this.expirySystem = expirySystem;
    }

    @Override
    protected <E extends SampleableConcurrentHashMap.SamplingEntry> E createSamplingEntry(Data key, R record) {
        return (E)new LazyEvictableEntryView<R>(key, record, this.expirySystem.getExpiryMetadata(key), this.serializationService);
    }
}

