/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.org.roaringbitmap;

import java.util.Arrays;
import org.apache.pig.org.roaringbitmap.BitmapContainer;
import org.apache.pig.org.roaringbitmap.Container;
import org.apache.pig.org.roaringbitmap.RoaringArray;
import org.apache.pig.org.roaringbitmap.RoaringBitmap;
import org.apache.pig.org.roaringbitmap.Util;

public class OrderedWriter {
    private static final int WORD_COUNT = 1024;
    private final long[] bitmap;
    private final RoaringBitmap underlying;
    private short currentKey;
    private boolean dirty = false;

    public OrderedWriter(RoaringBitmap underlying) {
        this.underlying = underlying;
        this.bitmap = new long[1024];
    }

    public OrderedWriter() {
        this(new RoaringBitmap());
    }

    public RoaringBitmap getUnderlying() {
        return this.underlying;
    }

    public void add(int value) {
        short key = Util.highbits(value);
        short low = Util.lowbits(value);
        if (key != this.currentKey) {
            if (Util.compareUnsigned(key, this.currentKey) < 0) {
                throw new IllegalStateException("Must write in ascending key order");
            }
            this.flush();
        }
        int ulow = low & 0xFFFF;
        int n = ulow >>> 6;
        this.bitmap[n] = this.bitmap[n] | 1L << ulow;
        this.currentKey = key;
        this.dirty = true;
    }

    public void flush() {
        if (this.dirty) {
            short key;
            RoaringArray highLowContainer = this.underlying.highLowContainer;
            if (highLowContainer.size > 0 && Util.compareUnsigned(this.currentKey, key = highLowContainer.getKeyAtIndex(highLowContainer.size - 1)) <= 0) {
                throw new IllegalStateException("Cannot write " + this.currentKey + " after " + key);
            }
            highLowContainer.append(this.currentKey, this.chooseBestContainer());
            this.clearBitmap();
            this.dirty = false;
        }
    }

    private Container chooseBestContainer() {
        Container container = new BitmapContainer(this.bitmap, -1).repairAfterLazy().runOptimize();
        return container instanceof BitmapContainer ? container.clone() : container;
    }

    private void clearBitmap() {
        Arrays.fill(this.bitmap, 0L);
    }
}

