/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.orc;

import com.google.common.collect.ComparisonChain;
import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.hive.common.DiskRange;
import org.apache.hadoop.hive.common.DiskRangeList;
import org.apache.hadoop.hive.ql.io.orc.CompressionCodec;
import org.apache.hadoop.hive.ql.io.orc.DirectDecompressionCodec;
import org.apache.hadoop.hive.ql.io.orc.OrcProto;
import org.apache.hadoop.hive.ql.io.orc.RecordReaderImpl;
import org.apache.hadoop.hive.shims.HadoopShims;
import org.apache.hadoop.hive.shims.ShimLoader;

public class RecordReaderUtils {
    private static final HadoopShims SHIMS = ShimLoader.getHadoopShims();
    private static final int BYTE_STREAM_POSITIONS = 1;
    private static final int RUN_LENGTH_BYTE_POSITIONS = 2;
    private static final int BITFIELD_POSITIONS = 3;
    private static final int RUN_LENGTH_INT_POSITIONS = 2;
    static final int WORST_UNCOMPRESSED_SLOP = 4098;

    static boolean[] findPresentStreamsByColumn(List<OrcProto.Stream> streamList, List<OrcProto.Type> types) {
        boolean[] hasNull = new boolean[types.size()];
        for (OrcProto.Stream stream : streamList) {
            if (!stream.hasKind() || stream.getKind() != OrcProto.Stream.Kind.PRESENT) continue;
            hasNull[stream.getColumn()] = true;
        }
        return hasNull;
    }

    static boolean overlap(long leftA, long rightA, long leftB, long rightB) {
        if (leftA <= leftB) {
            return rightA >= leftB;
        }
        return rightB >= leftA;
    }

    static void addEntireStreamToRanges(long offset, long length, DiskRangeList.DiskRangeListCreateHelper list, boolean doMergeBuffers) {
        list.addOrMerge(offset, offset + length, doMergeBuffers, false);
    }

    static void addRgFilteredStreamToRanges(OrcProto.Stream stream, boolean[] includedRowGroups, boolean isCompressed, OrcProto.RowIndex index, OrcProto.ColumnEncoding encoding, OrcProto.Type type, int compressionSize, boolean hasNull, long offset, long length, DiskRangeList.DiskRangeListCreateHelper list, boolean doMergeBuffers) {
        for (int group = 0; group < includedRowGroups.length; ++group) {
            if (!includedRowGroups[group]) continue;
            int posn = RecordReaderUtils.getIndexPosition(encoding.getKind(), type.getKind(), stream.getKind(), isCompressed, hasNull);
            long start = index.getEntry(group).getPositions(posn);
            boolean isLast = group == includedRowGroups.length - 1;
            long nextGroupOffset = isLast ? length : index.getEntry(group + 1).getPositions(posn);
            long end = offset + RecordReaderUtils.estimateRgEndOffset(isCompressed, isLast, nextGroupOffset, length, compressionSize);
            list.addOrMerge(start += offset, end, doMergeBuffers, true);
        }
    }

    static long estimateRgEndOffset(boolean isCompressed, boolean isLast, long nextGroupOffset, long streamLength, int bufferSize) {
        long slop = isCompressed ? (long)(2 * (3 + bufferSize)) : 4098L;
        return isLast ? streamLength : Math.min(streamLength, nextGroupOffset + slop);
    }

    public static int getIndexPosition(OrcProto.ColumnEncoding.Kind columnEncoding, OrcProto.Type.Kind columnType, OrcProto.Stream.Kind streamType, boolean isCompressed, boolean hasNulls) {
        if (streamType == OrcProto.Stream.Kind.PRESENT) {
            return 0;
        }
        int compressionValue = isCompressed ? 1 : 0;
        int base = hasNulls ? 3 + compressionValue : 0;
        switch (columnType) {
            case BOOLEAN: 
            case BYTE: 
            case SHORT: 
            case INT: 
            case LONG: 
            case FLOAT: 
            case DOUBLE: 
            case DATE: 
            case STRUCT: 
            case MAP: 
            case LIST: 
            case UNION: {
                return base;
            }
            case CHAR: 
            case VARCHAR: 
            case STRING: {
                if (columnEncoding == OrcProto.ColumnEncoding.Kind.DICTIONARY || columnEncoding == OrcProto.ColumnEncoding.Kind.DICTIONARY_V2) {
                    return base;
                }
                if (streamType == OrcProto.Stream.Kind.DATA) {
                    return base;
                }
                return base + 1 + compressionValue;
            }
            case BINARY: {
                if (streamType == OrcProto.Stream.Kind.DATA) {
                    return base;
                }
                return base + 1 + compressionValue;
            }
            case DECIMAL: {
                if (streamType == OrcProto.Stream.Kind.DATA) {
                    return base;
                }
                return base + 1 + compressionValue;
            }
            case TIMESTAMP: {
                if (streamType == OrcProto.Stream.Kind.DATA) {
                    return base;
                }
                return base + 2 + compressionValue;
            }
        }
        throw new IllegalArgumentException("Unknown type " + (Object)((Object)columnType));
    }

    static boolean isDictionary(OrcProto.Stream.Kind kind, OrcProto.ColumnEncoding encoding) {
        assert (kind != OrcProto.Stream.Kind.DICTIONARY_COUNT);
        OrcProto.ColumnEncoding.Kind encodingKind = encoding.getKind();
        return kind == OrcProto.Stream.Kind.DICTIONARY_DATA || kind == OrcProto.Stream.Kind.LENGTH && (encodingKind == OrcProto.ColumnEncoding.Kind.DICTIONARY || encodingKind == OrcProto.ColumnEncoding.Kind.DICTIONARY_V2);
    }

    static String stringifyDiskRanges(DiskRangeList range) {
        StringBuilder buffer = new StringBuilder();
        buffer.append("[");
        boolean isFirst = true;
        while (range != null) {
            if (!isFirst) {
                buffer.append(", ");
            }
            isFirst = false;
            buffer.append(range.toString());
            range = range.next;
        }
        buffer.append("]");
        return buffer.toString();
    }

    static DiskRangeList readDiskRanges(FSDataInputStream file, HadoopShims.ZeroCopyReaderShim zcr, long base, DiskRangeList range, boolean doForceDirect) throws IOException {
        if (range == null) {
            return null;
        }
        DiskRangeList prev = range.prev;
        if (prev == null) {
            prev = new DiskRangeList.DiskRangeListMutateHelper(range);
        }
        while (range != null) {
            if (range.hasData()) {
                range = range.next;
                continue;
            }
            int len = (int)(range.getEnd() - range.getOffset());
            long off = range.getOffset();
            file.seek(base + off);
            if (zcr != null) {
                boolean hasReplaced = false;
                while (len > 0) {
                    ByteBuffer partial = zcr.readBuffer(len, false);
                    RecordReaderImpl.BufferChunk bc = new RecordReaderImpl.BufferChunk(partial, off);
                    if (!hasReplaced) {
                        range.replaceSelfWith((DiskRangeList)bc);
                        hasReplaced = true;
                    } else {
                        range.insertAfter((DiskRangeList)bc);
                    }
                    range = bc;
                    int read = partial.remaining();
                    len -= read;
                    off += (long)read;
                }
            } else if (doForceDirect) {
                ByteBuffer directBuf = ByteBuffer.allocateDirect(len);
                RecordReaderUtils.readDirect(file, len, directBuf);
                range = range.replaceSelfWith((DiskRangeList)new RecordReaderImpl.BufferChunk(directBuf, range.getOffset()));
            } else {
                byte[] buffer = new byte[len];
                file.readFully(buffer, 0, buffer.length);
                range = range.replaceSelfWith((DiskRangeList)new RecordReaderImpl.BufferChunk(ByteBuffer.wrap(buffer), range.getOffset()));
            }
            range = range.next;
        }
        return prev.next;
    }

    public static void readDirect(FSDataInputStream file, int len, ByteBuffer directBuf) throws IOException {
        int pos;
        int startPos = pos = directBuf.position();
        int endPos = pos + len;
        try {
            while (pos < endPos) {
                int count = SHIMS.readByteBuffer(file, directBuf);
                if (count < 0) {
                    throw new EOFException();
                }
                assert (count != 0) : "0-length read: " + (endPos - pos) + "@" + (pos - startPos);
                assert ((pos += count) <= endPos) : "Position " + pos + " > " + endPos + " after reading " + count;
                directBuf.position(pos);
            }
        }
        catch (UnsupportedOperationException ex) {
            assert (pos == startPos);
            RecordReaderImpl.LOG.error((Object)"Stream does not support direct read; we will copy.");
            byte[] buffer = new byte[len];
            file.readFully(buffer, 0, buffer.length);
            directBuf.put(buffer);
        }
        directBuf.position(startPos);
        directBuf.limit(startPos + len);
    }

    static List<DiskRange> getStreamBuffers(DiskRangeList range, long offset, long length) {
        ArrayList<DiskRange> buffers = new ArrayList<DiskRange>();
        if (length == 0L) {
            return buffers;
        }
        long streamEnd = offset + length;
        boolean inRange = false;
        while (range != null) {
            if (!inRange) {
                if (range.getEnd() <= offset) {
                    range = range.next;
                    continue;
                }
                inRange = true;
                if (range.getOffset() < offset) {
                    buffers.add(range.sliceAndShift(offset, Math.min(streamEnd, range.getEnd()), -offset));
                    if (range.getEnd() >= streamEnd) break;
                    range = range.next;
                    continue;
                }
            } else if (range.getOffset() >= streamEnd) break;
            if (range.getEnd() > streamEnd) {
                buffers.add(range.sliceAndShift(range.getOffset(), streamEnd, -offset));
                break;
            }
            buffers.add(range.sliceAndShift(range.getOffset(), range.getEnd(), -offset));
            if (range.getEnd() == streamEnd) break;
            range = range.next;
        }
        return buffers;
    }

    static HadoopShims.ZeroCopyReaderShim createZeroCopyShim(FSDataInputStream file, CompressionCodec codec, ByteBufferAllocatorPool pool) throws IOException {
        if (codec == null || codec instanceof DirectDecompressionCodec && ((DirectDecompressionCodec)codec).isAvailable()) {
            return ShimLoader.getHadoopShims().getZeroCopyReader(file, (HadoopShims.ByteBufferPoolShim)pool);
        }
        return null;
    }

    public static final class ByteBufferAllocatorPool
    implements HadoopShims.ByteBufferPoolShim {
        private final TreeMap<Key, ByteBuffer> buffers = new TreeMap();
        private final TreeMap<Key, ByteBuffer> directBuffers = new TreeMap();
        private long currentGeneration = 0L;

        private final TreeMap<Key, ByteBuffer> getBufferTree(boolean direct) {
            return direct ? this.directBuffers : this.buffers;
        }

        public void clear() {
            this.buffers.clear();
            this.directBuffers.clear();
        }

        public ByteBuffer getBuffer(boolean direct, int length) {
            TreeMap<Key, ByteBuffer> tree = this.getBufferTree(direct);
            Map.Entry<Key, ByteBuffer> entry = tree.ceilingEntry(new Key(length, 0L));
            if (entry == null) {
                return direct ? ByteBuffer.allocateDirect(length) : ByteBuffer.allocate(length);
            }
            tree.remove(entry.getKey());
            return entry.getValue();
        }

        public void putBuffer(ByteBuffer buffer) {
            Key key;
            TreeMap<Key, ByteBuffer> tree = this.getBufferTree(buffer.isDirect());
            while (tree.containsKey(key = new Key(buffer.capacity(), this.currentGeneration++))) {
            }
            tree.put(key, buffer);
        }

        private static final class Key
        implements Comparable<Key> {
            private final int capacity;
            private final long insertionGeneration;

            Key(int capacity, long insertionGeneration) {
                this.capacity = capacity;
                this.insertionGeneration = insertionGeneration;
            }

            @Override
            public int compareTo(Key other) {
                return ComparisonChain.start().compare(this.capacity, other.capacity).compare(this.insertionGeneration, other.insertionGeneration).result();
            }

            public boolean equals(Object rhs) {
                if (rhs == null) {
                    return false;
                }
                try {
                    Key o = (Key)rhs;
                    return this.compareTo(o) == 0;
                }
                catch (ClassCastException e) {
                    return false;
                }
            }

            public int hashCode() {
                return new HashCodeBuilder().append(this.capacity).append(this.insertionGeneration).toHashCode();
            }
        }
    }
}

