/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentLengthException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentTypeException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.serde2.objectinspector.ConstantObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.BinaryObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.VoidObjectInspector;

@Description(name="decode", value="_FUNC_(bin, str) - Decode the first argument using the second argument character set", extended="Possible options for the character set are 'US_ASCII', 'ISO-8859-1',\n'UTF-8', 'UTF-16BE', 'UTF-16LE', and 'UTF-16'. If either argument\nis null, the result will also be null")
public class GenericUDFDecode
extends GenericUDF {
    private transient CharsetDecoder decoder;
    private transient PrimitiveObjectInspector bytesOI;
    private transient PrimitiveObjectInspector charsetOI;

    @Override
    public ObjectInspector initialize(ObjectInspector[] arguments) throws UDFArgumentException {
        if (arguments.length != 2) {
            throw new UDFArgumentLengthException("Decode() requires exactly two arguments");
        }
        if (arguments[0].getCategory() != ObjectInspector.Category.PRIMITIVE) {
            throw new UDFArgumentTypeException(0, "The first argument to Decode() must be primitive");
        }
        PrimitiveObjectInspector.PrimitiveCategory category = ((PrimitiveObjectInspector)arguments[0]).getPrimitiveCategory();
        if (category == PrimitiveObjectInspector.PrimitiveCategory.BINARY) {
            this.bytesOI = (BinaryObjectInspector)arguments[0];
        } else if (category == PrimitiveObjectInspector.PrimitiveCategory.VOID) {
            this.bytesOI = (VoidObjectInspector)arguments[0];
        } else {
            throw new UDFArgumentTypeException(0, "The first argument to Decode() must be binary");
        }
        if (arguments[1].getCategory() != ObjectInspector.Category.PRIMITIVE) {
            throw new UDFArgumentTypeException(1, "The second argument to Decode() must be primitive");
        }
        this.charsetOI = (PrimitiveObjectInspector)arguments[1];
        if (PrimitiveObjectInspectorUtils.PrimitiveGrouping.STRING_GROUP != PrimitiveObjectInspectorUtils.getPrimitiveGrouping((PrimitiveObjectInspector.PrimitiveCategory)this.charsetOI.getPrimitiveCategory())) {
            throw new UDFArgumentTypeException(1, "The second argument to Decode() must be from string group");
        }
        if (arguments[1] instanceof ConstantObjectInspector) {
            String charSetName = ((ConstantObjectInspector)arguments[1]).getWritableConstantValue().toString();
            this.decoder = Charset.forName(charSetName).newDecoder().onMalformedInput(CodingErrorAction.REPORT).onUnmappableCharacter(CodingErrorAction.REPORT);
        }
        return PrimitiveObjectInspectorFactory.javaStringObjectInspector;
    }

    @Override
    public Object evaluate(GenericUDF.DeferredObject[] arguments) throws HiveException {
        CharBuffer decoded;
        Object value = this.bytesOI.getPrimitiveJavaObject(arguments[0].get());
        if (value == null) {
            return null;
        }
        ByteBuffer wrappedBytes = ByteBuffer.wrap((byte[])value);
        if (this.decoder != null) {
            try {
                decoded = this.decoder.decode(wrappedBytes);
            }
            catch (CharacterCodingException e) {
                throw new HiveException(e);
            }
        } else {
            String charSetName = PrimitiveObjectInspectorUtils.getString((Object)arguments[1].get(), (PrimitiveObjectInspector)this.charsetOI);
            decoded = Charset.forName(charSetName).decode(wrappedBytes);
        }
        return decoded.toString();
    }

    @Override
    public String getDisplayString(String[] children) {
        assert (children.length == 2);
        return this.getStandardDisplayString("decode", children, ",");
    }
}

