/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.client.impl;

import java.util.HashMap;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.BatchWriterConfig;
import org.apache.accumulo.core.client.Instance;
import org.apache.accumulo.core.client.MultiTableBatchWriter;
import org.apache.accumulo.core.client.MutationsRejectedException;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.client.TableOfflineException;
import org.apache.accumulo.core.client.impl.Tables;
import org.apache.accumulo.core.client.impl.TabletServerBatchWriter;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.master.state.tables.TableState;
import org.apache.accumulo.core.security.thrift.TCredentials;
import org.apache.accumulo.core.util.ArgumentChecker;
import org.apache.log4j.Logger;

public class MultiTableBatchWriterImpl
implements MultiTableBatchWriter {
    static final Logger log = Logger.getLogger(MultiTableBatchWriterImpl.class);
    private boolean closed;
    private TabletServerBatchWriter bw;
    private HashMap<String, BatchWriter> tableWriters;
    private Instance instance;

    public MultiTableBatchWriterImpl(Instance instance, TCredentials credentials, BatchWriterConfig config) {
        ArgumentChecker.notNull(instance, credentials);
        this.instance = instance;
        this.bw = new TabletServerBatchWriter(instance, credentials, config);
        this.tableWriters = new HashMap();
        this.closed = false;
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public void close() throws MutationsRejectedException {
        this.bw.close();
        this.closed = true;
    }

    protected void finalize() {
        if (!this.closed) {
            log.warn((Object)(MultiTableBatchWriterImpl.class.getSimpleName() + " not shutdown; did you forget to call close()?"));
            try {
                this.close();
            }
            catch (MutationsRejectedException mre) {
                log.error((Object)(MultiTableBatchWriterImpl.class.getSimpleName() + " internal error."), (Throwable)mre);
                throw new RuntimeException("Exception when closing " + MultiTableBatchWriterImpl.class.getSimpleName(), mre);
            }
        }
    }

    @Override
    public synchronized BatchWriter getBatchWriter(String tableName) throws AccumuloException, AccumuloSecurityException, TableNotFoundException {
        ArgumentChecker.notNull(tableName);
        String tableId = (String)Tables.getNameToIdMap(this.instance).get(tableName);
        if (tableId == null) {
            throw new TableNotFoundException(tableId, tableName, null);
        }
        if (Tables.getTableState(this.instance, tableId) == TableState.OFFLINE) {
            throw new TableOfflineException(this.instance, tableId);
        }
        BatchWriter tbw = this.tableWriters.get(tableId);
        if (tbw == null) {
            tbw = new TableBatchWriter(tableId);
            this.tableWriters.put(tableId, tbw);
        }
        return tbw;
    }

    @Override
    public void flush() throws MutationsRejectedException {
        this.bw.flush();
    }

    private class TableBatchWriter
    implements BatchWriter {
        private String table;

        TableBatchWriter(String table) {
            this.table = table;
        }

        @Override
        public void addMutation(Mutation m) throws MutationsRejectedException {
            ArgumentChecker.notNull(m);
            MultiTableBatchWriterImpl.this.bw.addMutation(this.table, m);
        }

        @Override
        public void addMutations(Iterable<Mutation> iterable) throws MutationsRejectedException {
            MultiTableBatchWriterImpl.this.bw.addMutation(this.table, iterable.iterator());
        }

        @Override
        public void close() {
            throw new UnsupportedOperationException("Must close all tables, can not close an individual table");
        }

        @Override
        public void flush() {
            throw new UnsupportedOperationException("Must flush all tables, can not flush an individual table");
        }
    }
}

