/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.client.mapreduce.lib.util;

import java.nio.charset.Charset;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.Instance;
import org.apache.accumulo.core.client.ZooKeeperInstance;
import org.apache.accumulo.core.client.mock.MockInstance;
import org.apache.accumulo.core.client.security.tokens.AuthenticationToken;
import org.apache.accumulo.core.security.CredentialHelper;
import org.apache.accumulo.core.util.ArgumentChecker;
import org.apache.commons.codec.binary.Base64;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.util.StringUtils;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public class ConfiguratorBase {
    protected static String enumToConfKey(Class<?> implementingClass, Enum<?> e) {
        return implementingClass.getSimpleName() + "." + e.getDeclaringClass().getSimpleName() + "." + StringUtils.camelize((String)e.name().toLowerCase());
    }

    public static void setConnectorInfo(Class<?> implementingClass, Configuration conf, String principal, AuthenticationToken token) throws AccumuloSecurityException {
        if (ConfiguratorBase.isConnectorInfoSet(implementingClass, conf).booleanValue()) {
            throw new IllegalStateException("Connector info for " + implementingClass.getSimpleName() + " can only be set once per job");
        }
        ArgumentChecker.notNull(principal, token);
        conf.setBoolean(ConfiguratorBase.enumToConfKey(implementingClass, ConnectorInfo.IS_CONFIGURED), true);
        conf.set(ConfiguratorBase.enumToConfKey(implementingClass, ConnectorInfo.PRINCIPAL), principal);
        conf.set(ConfiguratorBase.enumToConfKey(implementingClass, ConnectorInfo.TOKEN_CLASS), token.getClass().getCanonicalName());
        conf.set(ConfiguratorBase.enumToConfKey(implementingClass, ConnectorInfo.TOKEN), CredentialHelper.tokenAsBase64(token));
    }

    public static Boolean isConnectorInfoSet(Class<?> implementingClass, Configuration conf) {
        return conf.getBoolean(ConfiguratorBase.enumToConfKey(implementingClass, ConnectorInfo.IS_CONFIGURED), false);
    }

    public static String getPrincipal(Class<?> implementingClass, Configuration conf) {
        return conf.get(ConfiguratorBase.enumToConfKey(implementingClass, ConnectorInfo.PRINCIPAL));
    }

    public static String getTokenClass(Class<?> implementingClass, Configuration conf) {
        return conf.get(ConfiguratorBase.enumToConfKey(implementingClass, ConnectorInfo.TOKEN_CLASS));
    }

    public static byte[] getToken(Class<?> implementingClass, Configuration conf) {
        return Base64.decodeBase64((byte[])conf.get(ConfiguratorBase.enumToConfKey(implementingClass, ConnectorInfo.TOKEN), "").getBytes(Charset.forName("UTF-8")));
    }

    public static void setZooKeeperInstance(Class<?> implementingClass, Configuration conf, String instanceName, String zooKeepers) {
        String key = ConfiguratorBase.enumToConfKey(implementingClass, InstanceOpts.TYPE);
        if (!conf.get(key, "").isEmpty()) {
            throw new IllegalStateException("Instance info can only be set once per job; it has already been configured with " + conf.get(key));
        }
        conf.set(key, "ZooKeeperInstance");
        ArgumentChecker.notNull(instanceName, zooKeepers);
        conf.set(ConfiguratorBase.enumToConfKey(implementingClass, InstanceOpts.NAME), instanceName);
        conf.set(ConfiguratorBase.enumToConfKey(implementingClass, InstanceOpts.ZOO_KEEPERS), zooKeepers);
    }

    public static void setMockInstance(Class<?> implementingClass, Configuration conf, String instanceName) {
        String key = ConfiguratorBase.enumToConfKey(implementingClass, InstanceOpts.TYPE);
        if (!conf.get(key, "").isEmpty()) {
            throw new IllegalStateException("Instance info can only be set once per job; it has already been configured with " + conf.get(key));
        }
        conf.set(key, "MockInstance");
        ArgumentChecker.notNull(instanceName);
        conf.set(ConfiguratorBase.enumToConfKey(implementingClass, InstanceOpts.NAME), instanceName);
    }

    public static Instance getInstance(Class<?> implementingClass, Configuration conf) {
        String instanceType = conf.get(ConfiguratorBase.enumToConfKey(implementingClass, InstanceOpts.TYPE), "");
        if ("MockInstance".equals(instanceType)) {
            return new MockInstance(conf.get(ConfiguratorBase.enumToConfKey(implementingClass, InstanceOpts.NAME)));
        }
        if ("ZooKeeperInstance".equals(instanceType)) {
            return new ZooKeeperInstance(conf.get(ConfiguratorBase.enumToConfKey(implementingClass, InstanceOpts.NAME)), conf.get(ConfiguratorBase.enumToConfKey(implementingClass, InstanceOpts.ZOO_KEEPERS)));
        }
        if (instanceType.isEmpty()) {
            throw new IllegalStateException("Instance has not been configured for " + implementingClass.getSimpleName());
        }
        throw new IllegalStateException("Unrecognized instance type " + instanceType);
    }

    public static void setLogLevel(Class<?> implementingClass, Configuration conf, Level level) {
        ArgumentChecker.notNull(level);
        Logger.getLogger(implementingClass).setLevel(level);
        conf.setInt(ConfiguratorBase.enumToConfKey(implementingClass, GeneralOpts.LOG_LEVEL), level.toInt());
    }

    public static Level getLogLevel(Class<?> implementingClass, Configuration conf) {
        return Level.toLevel((int)conf.getInt(ConfiguratorBase.enumToConfKey(implementingClass, GeneralOpts.LOG_LEVEL), Level.INFO.toInt()));
    }

    protected static enum GeneralOpts {
        LOG_LEVEL;

    }

    protected static enum InstanceOpts {
        TYPE,
        NAME,
        ZOO_KEEPERS;

    }

    public static enum ConnectorInfo {
        IS_CONFIGURED,
        PRINCIPAL,
        TOKEN,
        TOKEN_CLASS;

    }
}

