/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.conf;

import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.ConfigSanityCheck;
import org.apache.accumulo.core.conf.Property;
import org.apache.hadoop.conf.Configuration;
import org.apache.log4j.Logger;

public class SiteConfiguration
extends AccumuloConfiguration {
    private static final Logger log = Logger.getLogger(SiteConfiguration.class);
    private static AccumuloConfiguration parent = null;
    private static SiteConfiguration instance = null;
    private static Configuration xmlConfig;

    private SiteConfiguration(AccumuloConfiguration parent) {
        SiteConfiguration.parent = parent;
    }

    public static synchronized SiteConfiguration getInstance(AccumuloConfiguration parent) {
        if (instance == null) {
            instance = new SiteConfiguration(parent);
            ConfigSanityCheck.validate(instance);
        }
        return instance;
    }

    private static synchronized Configuration getXmlConfig() {
        String configFile = System.getProperty("org.apache.accumulo.config.file", "accumulo-site.xml");
        if (xmlConfig == null) {
            xmlConfig = new Configuration(false);
            if (SiteConfiguration.class.getClassLoader().getResource(configFile) == null) {
                log.warn((Object)(configFile + " not found on classpath"));
            } else {
                xmlConfig.addResource(configFile);
            }
        }
        return xmlConfig;
    }

    @Override
    public String get(Property property) {
        String key = property.getKey();
        String value = SiteConfiguration.getXmlConfig().get(key);
        if (value == null || !property.getType().isValidFormat(value)) {
            if (value != null) {
                log.error((Object)("Using default value for " + key + " due to improperly formatted " + (Object)((Object)property.getType()) + ": " + value));
            }
            value = parent.get(property);
        }
        return value;
    }

    @Override
    public Iterator<Map.Entry<String, String>> iterator() {
        TreeMap<String, String> entries = new TreeMap<String, String>();
        for (Map.Entry<String, String> parentEntry : parent) {
            entries.put(parentEntry.getKey(), parentEntry.getValue());
        }
        for (Map.Entry siteEntry : SiteConfiguration.getXmlConfig()) {
            entries.put((String)siteEntry.getKey(), (String)siteEntry.getValue());
        }
        return entries.entrySet().iterator();
    }

    public void clear() {
        SiteConfiguration.getXmlConfig().clear();
    }

    public void set(Property property, String value) {
        this.set(property.getKey(), value);
    }

    public void set(String key, String value) {
        SiteConfiguration.getXmlConfig().set(key, value);
    }
}

