/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.file.blockfile.cache;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.util.HashMap;
import java.util.Map;
import org.apache.accumulo.core.file.blockfile.cache.BlockCache;
import org.apache.accumulo.core.file.blockfile.cache.CacheEntry;

public class SimpleBlockCache
implements BlockCache {
    private Map<String, Ref> cache = new HashMap<String, Ref>();
    private ReferenceQueue<SimpleCacheEntry> q = new ReferenceQueue();
    public int dumps = 0;

    void processQueue() {
        Ref r;
        while ((r = (Ref)this.q.poll()) != null) {
            this.cache.remove(r.blockId);
            ++this.dumps;
        }
    }

    public synchronized int size() {
        this.processQueue();
        return this.cache.size();
    }

    @Override
    public synchronized SimpleCacheEntry getBlock(String blockName) {
        this.processQueue();
        Ref ref = this.cache.get(blockName);
        if (ref == null) {
            return null;
        }
        return (SimpleCacheEntry)ref.get();
    }

    @Override
    public synchronized SimpleCacheEntry cacheBlock(String blockName, byte[] buf) {
        SimpleCacheEntry sce = new SimpleCacheEntry(buf);
        this.cache.put(blockName, new Ref(blockName, sce, this.q));
        return sce;
    }

    @Override
    public synchronized SimpleCacheEntry cacheBlock(String blockName, byte[] buf, boolean inMemory) {
        SimpleCacheEntry sce = new SimpleCacheEntry(buf);
        this.cache.put(blockName, new Ref(blockName, sce, this.q));
        return sce;
    }

    @Override
    public void shutdown() {
    }

    @Override
    public long getMaxSize() {
        return Long.MAX_VALUE;
    }

    private static class Ref
    extends SoftReference<SimpleCacheEntry> {
        public String blockId;

        public Ref(String blockId, SimpleCacheEntry sce, ReferenceQueue<SimpleCacheEntry> q) {
            super(sce, q);
            this.blockId = blockId;
        }
    }

    private static class SimpleCacheEntry
    implements CacheEntry {
        private byte[] buffer;
        private Object index;

        SimpleCacheEntry(byte[] buffer) {
            this.buffer = buffer;
        }

        @Override
        public byte[] getBuffer() {
            return this.buffer;
        }

        @Override
        public Object getIndex() {
            return this.index;
        }

        @Override
        public void setIndex(Object idx) {
            this.index = idx;
        }
    }
}

