/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.security.thrift;

import org.apache.thrift.TEnum;

public enum SecurityErrorCode implements TEnum
{
    DEFAULT_SECURITY_ERROR(0),
    BAD_CREDENTIALS(1),
    PERMISSION_DENIED(2),
    USER_DOESNT_EXIST(3),
    CONNECTION_ERROR(4),
    USER_EXISTS(5),
    GRANT_INVALID(6),
    BAD_AUTHORIZATIONS(7),
    INVALID_INSTANCEID(8),
    TABLE_DOESNT_EXIST(9),
    UNSUPPORTED_OPERATION(10),
    INVALID_TOKEN(11),
    AUTHENTICATOR_FAILED(12),
    AUTHORIZOR_FAILED(13),
    PERMISSIONHANDLER_FAILED(14),
    TOKEN_EXPIRED(15),
    SERIALIZATION_ERROR(16),
    INSUFFICIENT_PROPERTIES(17);

    private final int value;

    private SecurityErrorCode(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public static SecurityErrorCode findByValue(int value) {
        switch (value) {
            case 0: {
                return DEFAULT_SECURITY_ERROR;
            }
            case 1: {
                return BAD_CREDENTIALS;
            }
            case 2: {
                return PERMISSION_DENIED;
            }
            case 3: {
                return USER_DOESNT_EXIST;
            }
            case 4: {
                return CONNECTION_ERROR;
            }
            case 5: {
                return USER_EXISTS;
            }
            case 6: {
                return GRANT_INVALID;
            }
            case 7: {
                return BAD_AUTHORIZATIONS;
            }
            case 8: {
                return INVALID_INSTANCEID;
            }
            case 9: {
                return TABLE_DOESNT_EXIST;
            }
            case 10: {
                return UNSUPPORTED_OPERATION;
            }
            case 11: {
                return INVALID_TOKEN;
            }
            case 12: {
                return AUTHENTICATOR_FAILED;
            }
            case 13: {
                return AUTHORIZOR_FAILED;
            }
            case 14: {
                return PERMISSIONHANDLER_FAILED;
            }
            case 15: {
                return TOKEN_EXPIRED;
            }
            case 16: {
                return SERIALIZATION_ERROR;
            }
            case 17: {
                return INSUFFICIENT_PROPERTIES;
            }
        }
        return null;
    }
}

