/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.util.shell.commands;

import org.apache.accumulo.core.util.shell.Shell;
import org.apache.accumulo.core.util.shell.commands.TableOperation;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;

public class DeleteTableCommand
extends TableOperation {
    private Option forceOpt;

    @Override
    public int execute(String fullCommand, CommandLine cl, Shell shellState) throws Exception {
        if (cl.hasOption(this.forceOpt.getOpt())) {
            super.force();
        } else {
            super.noForce();
        }
        return super.execute(fullCommand, cl, shellState);
    }

    @Override
    public String description() {
        return "deletes a table";
    }

    @Override
    protected void doTableOp(Shell shellState, String tableName) throws Exception {
        shellState.getConnector().tableOperations().delete(tableName);
        shellState.getReader().printString("Table: [" + tableName + "] has been deleted. \n");
        if (shellState.getTableName().equals(tableName)) {
            shellState.setTableName("");
        }
    }

    @Override
    public Options getOptions() {
        this.forceOpt = new Option("f", "force", false, "force deletion without prompting");
        Options opts = super.getOptions();
        opts.addOption(this.forceOpt);
        return opts;
    }
}

