/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.util.shell.commands;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.iterators.IteratorUtil;
import org.apache.accumulo.core.iterators.SortedKeyValueIterator;
import org.apache.accumulo.core.util.shell.Shell;
import org.apache.accumulo.core.util.shell.ShellCommandException;
import org.apache.accumulo.core.util.shell.commands.SetIterCommand;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;

public class SetShellIterCommand
extends SetIterCommand {
    private Option profileOpt;

    @Override
    public int execute(String fullCommand, CommandLine cl, Shell shellState) throws AccumuloException, AccumuloSecurityException, TableNotFoundException, IOException, ShellCommandException {
        return super.execute(fullCommand, cl, shellState);
    }

    @Override
    protected void setTableProperties(CommandLine cl, Shell shellState, int priority, Map<String, String> options, String classname, String name) throws AccumuloException, AccumuloSecurityException, ShellCommandException, TableNotFoundException {
        Class<?> loadClass;
        String profile = cl.getOptionValue(this.profileOpt.getOpt());
        try {
            loadClass = this.getClass().getClassLoader().loadClass(classname);
        }
        catch (ClassNotFoundException e) {
            throw new ShellCommandException(ShellCommandException.ErrorCode.INITIALIZATION_FAILURE, "Unable to load " + classname);
        }
        try {
            loadClass.asSubclass(SortedKeyValueIterator.class);
        }
        catch (ClassCastException ex) {
            throw new ShellCommandException(ShellCommandException.ErrorCode.INITIALIZATION_FAILURE, "xUnable to load " + classname + " as type " + SortedKeyValueIterator.class.getName());
        }
        Iterator<Map.Entry<String, String>> i = options.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry<String, String> entry = i.next();
            if (entry.getValue() != null && !entry.getValue().isEmpty()) continue;
            i.remove();
        }
        List<IteratorSetting> tableScanIterators = shellState.iteratorProfiles.get(profile);
        if (tableScanIterators == null) {
            tableScanIterators = new ArrayList<IteratorSetting>();
            shellState.iteratorProfiles.put(profile, tableScanIterators);
        }
        IteratorSetting setting = new IteratorSetting(priority, name, classname);
        setting.addOptions(options);
        Iterator<IteratorSetting> iter = tableScanIterators.iterator();
        while (iter.hasNext()) {
            if (!iter.next().getName().equals(name)) continue;
            iter.remove();
        }
        tableScanIterators.add(setting);
    }

    @Override
    public String description() {
        return "adds an iterator to a profile for this shell session";
    }

    @Override
    public Options getOptions() {
        HashSet<OptionGroup> groups = new HashSet<OptionGroup>();
        Options parentOptions = super.getOptions();
        Options modifiedOptions = new Options();
        for (Option o : parentOptions.getOptions()) {
            if (IteratorUtil.IteratorScope.majc.name().equals(o.getOpt()) || IteratorUtil.IteratorScope.minc.name().equals(o.getOpt()) || IteratorUtil.IteratorScope.scan.name().equals(o.getOpt()) || "table".equals(o.getLongOpt())) continue;
            modifiedOptions.addOption(o);
            OptionGroup group = parentOptions.getOptionGroup(o);
            if (group == null) continue;
            groups.add(group);
        }
        for (OptionGroup group : groups) {
            modifiedOptions.addOptionGroup(group);
        }
        this.profileOpt = new Option("pn", "profile", true, "iterator profile name");
        this.profileOpt.setRequired(true);
        this.profileOpt.setArgName("profile");
        modifiedOptions.addOption(this.profileOpt);
        return modifiedOptions;
    }
}

