/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.executionengine.tez.plan.operator;

import java.io.IOException;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.pig.LoadFunc;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.PigMapReduce;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.PigSplit;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.Result;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POLoad;
import org.apache.pig.backend.hadoop.executionengine.tez.runtime.TezInput;
import org.apache.pig.backend.hadoop.executionengine.tez.runtime.TezTaskConfigurable;
import org.apache.pig.data.Tuple;
import org.apache.pig.impl.plan.OperatorKey;
import org.apache.pig.tools.pigstats.mapreduce.MRPigStatsUtil;
import org.apache.tez.common.counters.CounterGroup;
import org.apache.tez.common.counters.TezCounter;
import org.apache.tez.mapreduce.input.MRInput;
import org.apache.tez.mapreduce.lib.MRReader;
import org.apache.tez.runtime.api.LogicalInput;
import org.apache.tez.runtime.api.ProcessorContext;
import org.apache.tez.runtime.library.api.KeyValueReader;

public class POSimpleTezLoad
extends POLoad
implements TezInput,
TezTaskConfigurable {
    private static final long serialVersionUID = 1L;
    private String inputKey;
    private transient ProcessorContext processorContext;
    private transient MRInput input;
    private transient KeyValueReader reader;
    private transient Configuration conf;
    private transient boolean finished = false;
    private transient TezCounter inputRecordCounter;

    public POSimpleTezLoad(OperatorKey k, LoadFunc loader) {
        super(k, loader);
    }

    @Override
    public String[] getTezInputs() {
        return new String[]{this.inputKey};
    }

    @Override
    public void replaceInput(String oldInputKey, String newInputKey) {
        if (oldInputKey.equals(this.inputKey)) {
            this.inputKey = newInputKey;
        }
    }

    @Override
    public void initialize(ProcessorContext processorContext) throws ExecException {
        this.processorContext = processorContext;
    }

    @Override
    public void addInputsToSkip(Set<String> inputsToSkip) {
    }

    @Override
    public void attachInputs(Map<String, LogicalInput> inputs, Configuration conf) throws ExecException {
        this.conf = conf;
        LogicalInput logInput = inputs.get(this.inputKey);
        if (logInput == null || !(logInput instanceof MRInput)) {
            throw new ExecException("POSimpleTezLoad only accepts MRInputs");
        }
        this.input = (MRInput)logInput;
        try {
            this.reader = this.input.getReader();
            if (this.reader instanceof MRReader) {
                int splitIndex = ((PigSplit)((Object)((MRReader)this.reader).getSplit())).getSplitIndex();
                PigMapReduce.sJobContext.getConfiguration().setInt("pig.split.index", splitIndex);
            }
        }
        catch (IOException e) {
            throw new ExecException(e);
        }
        if (inputs.size() > 1) {
            String name;
            CounterGroup multiInputGroup = (CounterGroup)this.processorContext.getCounters().getGroup("MultiInputCounters");
            if (multiInputGroup == null) {
                this.processorContext.getCounters().addGroup("MultiInputCounters", "MultiInputCounters");
            }
            if ((name = MRPigStatsUtil.getMultiInputsCounterName(super.getLFile().getFileName(), 0)) != null) {
                this.inputRecordCounter = multiInputGroup.addCounter(name, name, 0L);
            }
        }
    }

    @Override
    public Result getNextTuple() throws ExecException {
        try {
            if (this.finished) {
                return RESULT_EOP;
            }
            if (!this.reader.next()) {
                if (Boolean.valueOf(this.conf.get("pig.invoke.close.in.map", "false")).booleanValue()) {
                    this.parentPlan.endOfAllInput = true;
                }
                this.finished = true;
                return RESULT_EOP;
            }
            Result res = new Result();
            Tuple next = (Tuple)this.reader.getCurrentValue();
            res.result = next;
            res.returnStatus = 0;
            if (this.inputRecordCounter != null) {
                this.inputRecordCounter.increment(1L);
            }
            return res;
        }
        catch (IOException e) {
            throw new ExecException(e);
        }
    }

    public void setInputKey(String inputKey) {
        this.inputKey = inputKey;
    }
}

