/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.executionengine.tez.plan.udf;

import java.io.IOException;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.PigMapReduce;
import org.apache.pig.backend.hadoop.executionengine.tez.runtime.PigProcessor;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.Tuple;
import org.apache.pig.impl.builtin.PartitionSkewedKeys;

public class PartitionSkewedKeysTez
extends PartitionSkewedKeys {
    private static final Log LOG = LogFactory.getLog(PartitionSkewedKeysTez.class);

    public PartitionSkewedKeysTez() {
    }

    public PartitionSkewedKeysTez(String[] args) {
        super(args);
    }

    @Override
    public Map<String, Object> exec(Tuple in) throws IOException {
        if (in == null || in.size() == 0) {
            return null;
        }
        int estimatedNumReducers = -1;
        boolean estimate_sample_quantile = ((Configuration)PigMapReduce.sJobConfInternal.get()).getBoolean("pig.exec.estimate.parallelism", false);
        if (estimate_sample_quantile) {
            int specifiedNumReducer = (Integer)in.get(0);
            DataBag samples = (DataBag)in.get(1);
            long totalSampleSize = 0L;
            long totalInputRows = 0L;
            for (Tuple t : samples) {
                totalInputRows += ((Long)t.get(t.size() - 1)).longValue();
                totalSampleSize += this.getMemorySize(t);
            }
            long totalSampleCount_ = samples.size();
            long estimatedInputSize = (long)((double)totalSampleSize / (double)totalSampleCount_ * (double)totalInputRows);
            long bytesPerTask = ((Configuration)PigMapReduce.sJobConfInternal.get()).getLong("pig.exec.reducers.bytes.per.reducer", 1000000000L);
            estimatedNumReducers = (int)Math.ceil((double)estimatedInputSize / (double)bytesPerTask);
            estimatedNumReducers = Math.min(estimatedNumReducers, 999);
            LOG.info((Object)("Estimating parallelism: estimatedInputSize is " + estimatedInputSize + ". bytesPerTask is " + bytesPerTask + ". estimatedNumReducers is " + estimatedNumReducers + "."));
            this.totalReducers_ = estimatedNumReducers;
            LOG.info((Object)("Use estimated reducer instead:" + estimatedNumReducers + ", orig: " + specifiedNumReducer));
        }
        Object result = super.exec(in);
        if (estimate_sample_quantile) {
            result.put("pig.exec.estimated.num.parallelism", this.totalReducers_);
        }
        PigProcessor.sampleMap = result;
        return result;
    }
}

