/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.tools;

import groovy.grape.Grape;
import groovy.lang.GroovyClassLoader;
import java.io.File;
import java.io.InputStream;
import java.net.URI;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.pig.PigServer;
import org.apache.pig.backend.hadoop.datastorage.ConfigurationUtil;
import org.apache.pig.parser.ParserException;

public class DownloadResolver {
    private static final String IVY_FILE_NAME = "ivysettings.xml";
    private static final Log LOG = LogFactory.getLog(DownloadResolver.class);
    private static DownloadResolver downloadResolver = new DownloadResolver();

    private DownloadResolver() {
        if (System.getProperty("grape.config") != null) {
            LOG.info((Object)("Using ivysettings file from " + System.getProperty("grape.config")));
        } else {
            ClassLoader classLoader;
            Map<String, String> envMap = System.getenv();
            File confFile = null;
            if (envMap.containsKey("PIG_CONF_DIR")) {
                confFile = new File(new File(envMap.get("PIG_CONF_DIR")).getPath(), IVY_FILE_NAME);
            }
            if (confFile == null || !confFile.exists()) {
                confFile = new File(new File(envMap.get("PIG_HOME"), "conf").getPath(), IVY_FILE_NAME);
            }
            if (!(confFile != null && confFile.exists() || (classLoader = Thread.currentThread().getContextClassLoader()).getResource(IVY_FILE_NAME) == null)) {
                LOG.info((Object)"Found ivysettings file in classpath");
                confFile = new File(classLoader.getResource(IVY_FILE_NAME).getFile());
                if (!confFile.exists()) {
                    try {
                        List ivyLines = IOUtils.readLines((InputStream)classLoader.getResourceAsStream(IVY_FILE_NAME));
                        confFile = File.createTempFile("ivysettings", ".xml");
                        confFile.deleteOnExit();
                        for (String str : ivyLines) {
                            FileUtils.writeStringToFile((File)confFile, (String)str, (boolean)true);
                        }
                    }
                    catch (Exception e) {
                        LOG.warn((Object)"Could not create an ivysettings file from resource");
                    }
                }
            }
            if (confFile != null && confFile.exists()) {
                LOG.info((Object)("Using ivysettings file from " + confFile.toString()));
                System.setProperty("grape.config", confFile.toString());
            } else {
                LOG.warn((Object)"Could not find custom ivysettings file in PIG_CONF_DIR or PIG_HOME or classpath.");
            }
        }
    }

    public static DownloadResolver getInstance() {
        return downloadResolver;
    }

    private Map<String, String> parseQueryString(URI uri) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        String queryString = uri.getQuery();
        if (queryString != null) {
            String[] queryParams;
            for (String param : queryParams = queryString.split("&")) {
                String[] parts = param.split("=");
                if (parts.length != 2) continue;
                String name = parts[0].toLowerCase();
                String value = parts[1];
                paramMap.put(name, value);
            }
        }
        return paramMap;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Map<String, Object> parseUri(URI uri) throws ParserException {
        HashMap<String, Object> uriMap = new HashMap<String, Object>();
        String authority = uri.getAuthority();
        if (authority == null) throw new ParserException("Invalid Artifact. Please specify organization, module and version");
        String[] tokens = authority.split(":", -1);
        if (tokens.length != 3) throw new ParserException("Invalid Artifact. Please specify organization, module and version");
        uriMap.put("org", tokens[0]);
        if (tokens[1].isEmpty()) {
            throw new ParserException("Please specify the artifact module.");
        }
        uriMap.put("module", tokens[1]);
        uriMap.put("version", tokens[2]);
        uriMap.putAll(this.parseQueryString(uri));
        if (uriMap.containsKey("transitive")) {
            uriMap.put("transitive", Boolean.parseBoolean(uriMap.get("transitive").toString()));
        }
        LinkedList excludeList = new LinkedList();
        if (uriMap.containsKey("exclude")) {
            for (String exclude : uriMap.get("exclude").toString().split(",")) {
                HashMap<String, String> excludeMap = new HashMap<String, String>();
                String[] parts = exclude.split(":", -1);
                if (parts.length != 2) {
                    throw new ParserException("Exclude must contain organization and module separated by a colon.");
                }
                excludeMap.put("group", parts[0]);
                excludeMap.put("module", parts[1]);
                excludeList.add(excludeMap);
            }
        }
        uriMap.put("excludes", excludeList);
        return uriMap;
    }

    public URI[] downloadArtifact(URI uri, PigServer pigServer) throws ParserException {
        Configuration conf = ConfigurationUtil.toConfiguration(pigServer.getPigContext().getProperties());
        String artDownloadLocation = conf.get("pig.artifacts.download.location");
        if (artDownloadLocation != null) {
            LOG.info((Object)("Artifacts will be downloaded to " + artDownloadLocation));
            System.setProperty("grape.root", artDownloadLocation);
        } else if (System.getProperty("grape.root") != null) {
            LOG.info((Object)("Artifacts will be downloaded to " + System.getProperty("grape.root")));
        } else {
            LOG.info((Object)"Artifacts will be downloaded to default location. Please check ~/.groovy/grapes");
        }
        Map<String, Object> uriMap = this.parseUri(uri);
        HashMap<String, Object> args = new HashMap<String, Object>();
        args.put("classLoader", new GroovyClassLoader());
        args.put("excludes", uriMap.get("excludes"));
        return Grape.resolve(args, (Map[])new Map[]{uriMap});
    }
}

