/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.tutorial;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.pig.EvalFunc;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.DefaultBagFactory;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.impl.logicalLayer.schema.Schema;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScoreGenerator
extends EvalFunc<DataBag> {
    private static double computeMean(List<Long> list) {
        int n = list.size();
        double d = 0.0;
        for (Long l : list) {
            d += (double)l.longValue() / (double)n;
        }
        return d;
    }

    private static double computeSD(List<Long> list, double d) {
        int n = list.size();
        double d2 = 0.0;
        for (Long l : list) {
            double d3 = (double)l.longValue() - d;
            d2 += d3 * d3 / (double)n;
        }
        return Math.sqrt(d2);
    }

    public DataBag exec(Tuple tuple) throws IOException {
        if (tuple == null || tuple.size() == 0) {
            return null;
        }
        try {
            DataBag dataBag = DefaultBagFactory.getInstance().newDefaultBag();
            DataBag dataBag2 = (DataBag)tuple.get(0);
            HashMap<String, Long> hashMap = new HashMap<String, Long>();
            ArrayList<Long> arrayList = new ArrayList<Long>();
            for (Tuple tuple2 : dataBag2) {
                String string = (String)tuple2.get(1);
                Long l = (Long)tuple2.get(2);
                hashMap.put(string, l);
                arrayList.add(l);
            }
            double d = ScoreGenerator.computeMean(arrayList);
            double d2 = ScoreGenerator.computeSD(arrayList, d);
            for (String string : hashMap.keySet()) {
                Long l = (Long)hashMap.get(string);
                if (!((double)l.longValue() > d)) continue;
                Tuple tuple3 = TupleFactory.getInstance().newTuple(4);
                tuple3.set(0, (Object)string);
                tuple3.set(1, (Object)(((double)l.longValue() - d) / d2));
                tuple3.set(2, (Object)l);
                tuple3.set(3, (Object)d);
                dataBag.add(tuple3);
            }
            return dataBag;
        }
        catch (Exception exception) {
            System.err.println("ScoreGenerator: failed to process input; error - " + exception.getMessage());
            return null;
        }
    }

    public Schema outputSchema(Schema schema) {
        Schema schema2 = new Schema();
        schema2.add(new Schema.FieldSchema("hour", 55));
        schema2.add(new Schema.FieldSchema("score", 25));
        schema2.add(new Schema.FieldSchema("count", 15));
        schema2.add(new Schema.FieldSchema("mean", 25));
        try {
            return new Schema(new Schema.FieldSchema(this.getSchemaName(((Object)((Object)this)).getClass().getName().toLowerCase(), schema), schema2, 120));
        }
        catch (FrontendException frontendException) {
            return null;
        }
    }
}

