/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.tutorial;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.pig.EvalFunc;
import org.apache.pig.FilterFunc;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.DefaultBagFactory;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;
import org.apache.pig.tutorial.ExtractHour;
import org.apache.pig.tutorial.NonURLDetector;
import org.apache.pig.tutorial.ScoreGenerator;
import org.apache.pig.tutorial.ToLower;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TutorialTest {
    private static Tuple[] getTuples(String[] stringArray) {
        Tuple[] tupleArray = new Tuple[stringArray.length];
        for (int i = 0; i < tupleArray.length; ++i) {
            tupleArray[i] = TupleFactory.getInstance().newTuple(1);
            try {
                tupleArray[i].set(0, (Object)stringArray[i]);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return tupleArray;
    }

    public static String[] testDataAtomEvals(EvalFunc<String> evalFunc, Tuple[] tupleArray) {
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            for (Tuple tuple : tupleArray) {
                String string = (String)evalFunc.exec(tuple);
                System.out.println("Converted: " + tuple + " to (" + string + ")");
                arrayList.add(string);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            System.exit(1);
        }
        System.out.println("===");
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public static DataBag[] testDataBagEvals(EvalFunc<DataBag> evalFunc, Tuple[] tupleArray) {
        ArrayList<DataBag> arrayList = new ArrayList<DataBag>();
        try {
            for (Tuple tuple : tupleArray) {
                DataBag dataBag = (DataBag)evalFunc.exec(tuple);
                System.out.println("Converted: " + tuple + " to (" + dataBag + ")");
                arrayList.add(dataBag);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            System.exit(1);
        }
        System.out.println("===");
        return arrayList.toArray(new DataBag[arrayList.size()]);
    }

    public static String[] testFilters(FilterFunc filterFunc, Tuple[] tupleArray) {
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            for (Tuple tuple : tupleArray) {
                if (((Boolean)filterFunc.exec(tuple)).booleanValue()) {
                    System.out.println("accepted: " + tuple);
                    arrayList.add((String)tuple.get(0));
                    continue;
                }
                System.out.println("rejected: " + tuple);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
        }
        System.out.println("===");
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public static void main(String[] stringArray) {
        String[] stringArray2 = new String[]{"http://www.yahoo.com/", "\"http://www.yahoo.com/\"", "   http;//www.yahoo.com/ ", "https://www.yahoo.com/", "www.yahoo.com/", "\"www.yahoo.com/\"", "a real nice query ", "an UPPER CASE query", "  ", " nude picture", " +XXX", "\" +porno \""};
        NonURLDetector nonURLDetector = new NonURLDetector();
        String[] stringArray3 = TutorialTest.testFilters(nonURLDetector, TutorialTest.getTuples(stringArray2));
        ToLower toLower = new ToLower();
        String[] stringArray4 = TutorialTest.testDataAtomEvals(toLower, TutorialTest.getTuples(stringArray3));
        String[] stringArray5 = new String[]{"970916072134", "970916072311", "970916123431"};
        ExtractHour extractHour = new ExtractHour();
        TutorialTest.testDataAtomEvals(extractHour, TutorialTest.getTuples(stringArray5));
        DataBag dataBag = DefaultBagFactory.getInstance().newDefaultBag();
        Tuple tuple = TupleFactory.getInstance().newTuple(3);
        try {
            tuple.set(0, (Object)"word");
            tuple.set(1, (Object)"02");
            tuple.set(2, (Object)2);
        }
        catch (Exception exception) {
            // empty catch block
        }
        dataBag.add(tuple);
        Tuple tuple2 = TupleFactory.getInstance().newTuple(3);
        try {
            tuple2.set(0, (Object)"word");
            tuple2.set(1, (Object)"05");
            tuple2.set(2, (Object)2);
        }
        catch (Exception exception) {
            // empty catch block
        }
        dataBag.add(tuple2);
        Tuple tuple3 = TupleFactory.getInstance().newTuple(3);
        try {
            tuple3.set(0, (Object)"word");
            tuple3.set(1, (Object)"04");
            tuple3.set(2, (Object)3);
        }
        catch (Exception exception) {
            // empty catch block
        }
        dataBag.add(tuple3);
        Tuple tuple4 = TupleFactory.getInstance().newTuple(3);
        try {
            tuple4.set(0, (Object)"word");
            tuple4.set(1, (Object)"06");
            tuple4.set(2, (Object)4);
        }
        catch (Exception exception) {
            // empty catch block
        }
        dataBag.add(tuple4);
        Tuple[] tupleArray = new Tuple[]{TupleFactory.getInstance().newTuple(1)};
        try {
            tupleArray[0].set(0, (Object)dataBag);
        }
        catch (Exception exception) {
            // empty catch block
        }
        ScoreGenerator scoreGenerator = new ScoreGenerator();
        TutorialTest.testDataBagEvals(scoreGenerator, tupleArray);
    }
}

