/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.executionengine.tez.plan;

import java.util.HashSet;
import java.util.Set;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.PhysicalOperator;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.plans.PhyPlanVisitor;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.plans.PhysicalPlan;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POStream;
import org.apache.pig.backend.hadoop.executionengine.tez.plan.TezOpPlanVisitor;
import org.apache.pig.backend.hadoop.executionengine.tez.plan.TezOperPlan;
import org.apache.pig.backend.hadoop.executionengine.tez.plan.TezOperator;
import org.apache.pig.impl.plan.DepthFirstWalker;
import org.apache.pig.impl.plan.PlanWalker;
import org.apache.pig.impl.plan.VisitorException;
import org.apache.pig.impl.streaming.StreamingCommand;

public class TezPOStreamVisitor
extends TezOpPlanVisitor {
    private Set<String> cacheFiles = new HashSet<String>();
    private Set<String> shipFiles = new HashSet<String>();

    public TezPOStreamVisitor(TezOperPlan plan) {
        super(plan, (PlanWalker<TezOperator, TezOperPlan>)new DepthFirstWalker<TezOperator, TezOperPlan>(plan));
    }

    @Override
    public void visitTezOp(TezOperator tezOp) throws VisitorException {
        if (!tezOp.plan.isEmpty()) {
            StreamFileVisitor streamFileVisitor = new StreamFileVisitor(tezOp.plan);
            streamFileVisitor.visit();
        }
    }

    public Set<String> getCacheFiles() {
        return this.cacheFiles;
    }

    public Set<String> getShipFiles() {
        return this.shipFiles;
    }

    class StreamFileVisitor
    extends PhyPlanVisitor {
        public StreamFileVisitor(PhysicalPlan plan) {
            super(plan, (PlanWalker<PhysicalOperator, PhysicalPlan>)new DepthFirstWalker<PhysicalOperator, PhysicalPlan>(plan));
        }

        @Override
        public void visitStream(POStream stream) throws VisitorException {
            StreamingCommand command = stream.getCommand();
            TezPOStreamVisitor.this.cacheFiles.addAll(command.getCacheSpecs());
            TezPOStreamVisitor.this.shipFiles.addAll(command.getShipSpecs());
        }
    }
}

